/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBillInvoiceEditBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceEditBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceEditBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscBillInvoiceEditBusiServiceImpl
implements FscBillInvoiceEditBusiService {
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    private static final String BUSI_NAME = "\u4e3b\u5355\u53d1\u7968\u4e0a\u4f20";
    private static final String ADD_FLAG_ADD = "1";
    private static final String SUBMIT_FLAG_SUBMIT = "1";

    @Override
    public FscBillInvoiceEditBusiRspBO editInvoice(FscBillInvoiceEditBusiReqBO reqBO) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (fscOrderPo == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u76f8\u5173\u4fe1\u606f!");
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getInvoiceBO())) {
            int i;
            Object fscInvoicePo = new FscInvoicePO();
            fscInvoicePo.setInvoiceId(reqBO.getInvoiceBO().getInvoiceId());
            FscInvoicePO fscInvoicePoCheck = this.fscInvoiceMapper.getModelBy((FscInvoicePO)fscInvoicePo);
            if (fscInvoicePoCheck == null) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u53d1\u7968\u76f8\u5173\u4fe1\u606f!");
            }
            BigDecimal totalAmt = this.fscInvoiceMapper.checkTotalAmt(reqBO.getFscOrderId(), reqBO.getInvoiceBO().getInvoiceId());
            BigDecimal bigDecimal = totalAmt = totalAmt == null ? BigDecimal.ZERO : totalAmt;
            if (fscOrderPo.getTotalCharge().compareTo(totalAmt.add(reqBO.getInvoiceBO().getAmt())) < 0) {
                throw new FscBusinessException("190000", "\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u7ed3\u7b97\u5355\u603b\u91d1\u989d\uff0c\u4e0d\u80fd\u4fdd\u5b58!");
            }
            FscInvoicePO fscInvoicePo1 = new FscInvoicePO();
            fscInvoicePo1.setFscOrderId(reqBO.getFscOrderId());
            fscInvoicePo1.setInvoiceNo(reqBO.getInvoiceBO().getInvoiceNo());
            List fscInvoicePo1List = this.fscInvoiceMapper.getList(fscInvoicePo1);
            if (!CollectionUtils.isEmpty((Collection)fscInvoicePo1List)) {
                if (fscInvoicePo1List.size() > 1) {
                    throw new FscBusinessException("190000", "\u5b58\u5728\u76f8\u540c\u53d1\u7968\u53f7\u7801\uff0c\u4e0d\u80fd\u4fdd\u5b58\uff01");
                }
                if (fscInvoicePo1List.size() == 1 && !((FscInvoicePO)fscInvoicePo1List.get(0)).getInvoiceId().equals(reqBO.getInvoiceBO().getInvoiceId())) {
                    throw new FscBusinessException("190000", "\u5b58\u5728\u76f8\u540c\u53d1\u7968\u53f7\u7801\uff0c\u4e0d\u80fd\u4fdd\u5b58\uff01");
                }
            }
            fscInvoicePo = (FscInvoicePO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO.getInvoiceBO()), FscInvoicePO.class);
            fscInvoicePo.setCreateCompanyId(reqBO.getCompanyId());
            fscInvoicePo.setCreateCompanyName(reqBO.getCompanyName());
            if (null != reqBO.getUserId()) {
                fscInvoicePo.setCreateOperId(reqBO.getUserId().toString());
            }
            fscInvoicePo.setCreateOrgId(reqBO.getOrgId());
            fscInvoicePo.setCreateOrgName(reqBO.getOrgName());
            fscInvoicePo.setStatus(FscConstants.FscInvoiceStatus.VALID);
            fscInvoicePo.setFscOrderId(reqBO.getFscOrderId());
            if (fscInvoicePoCheck.getMailId() == null) {
                fscInvoicePo.setMailId(Long.valueOf(Sequence.getInstance().nextId()));
            }
            if ((i = this.fscInvoiceMapper.updateById((FscInvoicePO)fscInvoicePo)) != 1) {
                throw new FscBusinessException("190000", "\u66f4\u65b0\u53d1\u7968\u4fe1\u606f\u5931\u8d25");
            }
            if (!StringUtils.isEmpty((Object)reqBO.getAddFlag()) && "1".equals(reqBO.getAddFlag())) {
                FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
                fscOrderInvoicePo.setFscOrderId(reqBO.getFscOrderId());
                fscOrderInvoicePo = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePo);
                FscInvoicePO invoicePo = new FscInvoicePO();
                invoicePo.setInvoiceId(Long.valueOf(Sequence.getInstance().nextId()));
                invoicePo.setFscOrderId(reqBO.getFscOrderId());
                invoicePo.setAmt(BigDecimal.ZERO);
                invoicePo.setInvoiceType(fscOrderInvoicePo.getInvoiceType());
                invoicePo.setCreateTime(new Date());
                invoicePo.setMailId(fscInvoicePoCheck.getMailId());
                invoicePo.setBuyName(fscOrderInvoicePo.getBuyName());
                invoicePo.setTaxNo(fscOrderInvoicePo.getTaxNo());
                invoicePo.setBank(fscOrderInvoicePo.getBank());
                invoicePo.setAccount(fscOrderInvoicePo.getAccount());
                invoicePo.setAddress(fscOrderInvoicePo.getAddress());
                invoicePo.setPhone(fscOrderInvoicePo.getPhone());
                this.fscInvoiceMapper.insert(invoicePo);
            }
        }
        if (!StringUtils.isEmpty((Object)reqBO.getSubmitFlag())) {
            if (!CollectionUtils.isEmpty(reqBO.getAttachmentList())) {
                for (AttachmentBO attachmentBO : reqBO.getAttachmentList()) {
                    AttachmentBO attachmentBo = new AttachmentBO();
                    attachmentBo.setAttachmentUrl(attachmentBO.getAttachmentUrl());
                    String end = attachmentBO.getAttachmentUrl().substring(attachmentBO.getAttachmentUrl().lastIndexOf("."));
                    attachmentBo.setAttachmentName(reqBO.getFscOrderId().toString() + "\u53d1\u7968\u9644\u4ef6" + (String)end);
                }
            }
            FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
            fscAttachmentPo.setFscOrderId(reqBO.getFscOrderId());
            fscAttachmentPo.setObjType(FscConstants.AttachmentObjType.INVOICE);
            ArrayList<FscAttachmentPO> fscAttachmentPOS = this.fscAttachmentMapper.getList(fscAttachmentPo);
            if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOS)) {
                this.fscAttachmentMapper.deleteBy(fscAttachmentPo);
            }
            ArrayList fscAttachmentPOList = new ArrayList();
            if (!CollectionUtils.isEmpty(reqBO.getAttachmentList())) {
                fscAttachmentPOS = new ArrayList<FscAttachmentPO>(reqBO.getAttachmentList().size());
                for (AttachmentBO attachmentBO : reqBO.getAttachmentList()) {
                    fscAttachmentPo = new FscAttachmentPO();
                    fscAttachmentPo.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                    fscAttachmentPo.setAttachmentUrl(attachmentBO.getAttachmentUrl());
                    fscAttachmentPo.setAttachmentName(attachmentBO.getAttachmentName());
                    fscAttachmentPo.setAttachmentType(FscConstants.AttachmentType.INVOICE);
                    fscAttachmentPo.setObjId(reqBO.getFscOrderId());
                    fscAttachmentPo.setObjType(FscConstants.AttachmentObjType.INVOICE);
                    fscAttachmentPo.setFscOrderId(reqBO.getFscOrderId());
                    fscAttachmentPOS.add(fscAttachmentPo);
                }
                fscAttachmentPOList.addAll(fscAttachmentPOS);
            }
            if (!CollectionUtils.isEmpty(fscAttachmentPOList)) {
                this.fscAttachmentMapper.insertBatch(fscAttachmentPOList);
            }
            if (reqBO.getRemark() != null) {
                FscOrderPO fscOrderPO = new FscOrderPO();
                fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
                fscOrderPO.setEditInvoiceRemark(reqBO.getRemark());
                this.fscOrderMapper.updateById(fscOrderPO);
            }
            if ("1".equals(reqBO.getSubmitFlag())) {
                List fscInvoicePOS = this.fscInvoiceMapper.checkBillDate(reqBO.getFscOrderId());
                if (!CollectionUtils.isEmpty((Collection)fscInvoicePOS)) {
                    throw new FscBusinessException("190000", "\u5b58\u5728\u5f00\u7968\u65e5\u671f\u4e3a\u7a7a\u53d1\u7968\uff0c\u4e0d\u80fd\u63d0\u4ea4");
                }
                BigDecimal totalAmt = this.fscInvoiceMapper.checkTotalAmt(reqBO.getFscOrderId(), null);
                BigDecimal bigDecimal = totalAmt = totalAmt == null ? BigDecimal.ZERO : totalAmt;
                if (fscOrderPo.getTotalCharge().compareTo(totalAmt) != 0) {
                    throw new FscBusinessException("190000", "\u5f00\u7968\u91d1\u989d\u548c\u7ed3\u7b97\u5355\u603b\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u63d0\u4ea4!");
                }
                FscInvoicePO invoicePO = new FscInvoicePO();
                invoicePO.setFscOrderId(reqBO.getFscOrderId());
                List fscInvoicePOList = this.fscInvoiceMapper.getList(invoicePO);
                if (!CollectionUtils.isEmpty((Collection)fscInvoicePOList)) {
                    for (FscInvoicePO po : fscInvoicePOList) {
                        if (po.getAmt() == null || po.getUntaxAmt() == null || po.getTaxAmt() == null || po.getAmt().compareTo(po.getTaxAmt().add(po.getUntaxAmt())) == 0) continue;
                        throw new FscBusinessException("190000", po.getInvoiceNo() + "\u6b64\u53d1\u7968\u53f7\u7801\u53d1\u7968\uff0c\u53d1\u7968\u91d1\u989d\u4e0d\u7b49\u4e8e\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0e\u7a0e\u989d\u4e4b\u548c\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4");
                    }
                }
                FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
                fscOrderStatusFlowAtomReqBO.setOrderId(reqBO.getFscOrderId());
                fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
                fscOrderStatusFlowAtomReqBO.setBusiCode("FSC");
                HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
                paramMap.put("skigFlag", FscConstants.BillOrderSkigFlag.SUPPLIER_UPLOAD);
                fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
                fscOrderStatusFlowAtomReqBO.setCurStatus(fscOrderPo.getOrderState());
                FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
                if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
                    throw new FscBusinessException("193007", fscOrderStatusFlowAtomRspBO.getRespDesc());
                }
                this.syncOrderStatus(reqBO.getFscOrderId());
            }
        }
        FscBillInvoiceEditBusiRspBO rspBO = new FscBillInvoiceEditBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void syncOrderStatus(Long fscOrderId) {
        FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
        fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
        fscUocOrderRelUpdateAtomReqBO.setRelState(FscConstants.FscRelStatus.BILLED);
        fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
        this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
    }
}

