/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bill.busi.api.FscBillInvoiceeditListQueryBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceEditListQueryBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceEditListQueryBusiRspBO;
import com.tydic.fsc.bo.InvoiceBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.po.FscInvoicePO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscBillInvoiceeditListQueryBusiServiceImpl
implements FscBillInvoiceeditListQueryBusiService {
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @Override
    public FscBillInvoiceEditListQueryBusiRspBO qryInvoiceList(FscBillInvoiceEditListQueryBusiReqBO reqBO) {
        FscBillInvoiceEditListQueryBusiRspBO rspBO = new FscBillInvoiceEditListQueryBusiRspBO();
        FscInvoicePO fscInvoicePO = (FscInvoicePO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscInvoicePO.class);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        String orderBy = "create_time, mail_id desc";
        fscInvoicePO.setOrderBy(orderBy);
        List fscInvoicePOS = this.fscInvoiceMapper.getListPage(fscInvoicePO, page);
        if (CollectionUtils.isEmpty((Collection)fscInvoicePOS)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        List invoiceBos = JSONArray.parseArray((String)JSON.toJSONString((Object)fscInvoicePOS), InvoiceBO.class);
        List lastInvoicePOS = this.fscInvoiceMapper.checkTheLast(reqBO.getFscOrderId());
        FscInvoicePO lastInvoicePO = (FscInvoicePO)lastInvoicePOS.get(lastInvoicePOS.size() - 1);
        Map InvoiceCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_CATEGORY");
        for (InvoiceBO invoiceBO : invoiceBos) {
            if (!StringUtils.isEmpty((Object)invoiceBO.getInvoiceCategory())) {
                invoiceBO.setInvoiceCategoryStr((String)InvoiceCategoryMap.get(String.valueOf(invoiceBO.getInvoiceCategory())));
            }
            if (invoiceBO.getAmt() != null) {
                invoiceBO.setAmt(invoiceBO.getAmt().setScale(2, 4));
            }
            if (invoiceBO.getTaxAmt() != null) {
                invoiceBO.setTaxAmt(invoiceBO.getTaxAmt().setScale(2, 4));
            }
            if (invoiceBO.getUntaxAmt() != null) {
                invoiceBO.setUntaxAmt(invoiceBO.getUntaxAmt().setScale(2, 4));
            }
            if (!invoiceBO.getInvoiceId().equals(lastInvoicePO.getInvoiceId())) continue;
            invoiceBO.setAddFlag("1");
        }
        BigDecimal totalAmt = this.fscInvoiceMapper.checkTotalAmt(reqBO.getFscOrderId(), null);
        totalAmt = totalAmt == null ? BigDecimal.ZERO : totalAmt;
        rspBO.setTotalAmt(totalAmt);
        rspBO.setRows(invoiceBos);
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

