/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscBillSendSaleFscOrderToYCAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillSendSaleFscOrderApplyAbilityReqBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderCreateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreateBusiRspBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscOrderItemReqBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.bo.SplitOrderBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.common.ability.enums.FscInvoiceValueTypeEnum;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscInvoiceRuleMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.enums.FscOrderSendStateEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscInvoiceRulePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.fsc.util.TaxUtils;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgNameListQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityRspBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderCreateBusiServiceImpl
implements FscBillOrderCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderCreateBusiServiceImpl.class);
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscInvoiceRuleMapper fscInvoiceRuleMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;
    @Value(value="${fsc.main.electricity.pro.org:100100}")
    private String electricityOrg;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    private static final String BUSI_NAME = "\u4e3b\u5355\u786e\u8ba4";
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private UmcEnterpriseOrgNameListQryAbilityService umcEnterpriseOrgNameListQryAbilityService;
    @Autowired
    private FscBillSendSaleFscOrderToYCAbilityService fscBillSendSaleFscOrderToYCAbilityService;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;

    @Override
    public FscBillOrderCreateBusiRspBO dealCreate(FscBillOrderCreateBusiReqBO reqBO) {
        ArrayList<Object> fscOrderPOS = new ArrayList<Object>();
        ArrayList<FscOrderRelationPO> fscOrderRelationPOS = new ArrayList<FscOrderRelationPO>();
        ArrayList<FscOrderItemPO> fscOrderItemPOS = new ArrayList<FscOrderItemPO>();
        ArrayList<FscOrderInvoicePO> fscOrderInvoicePOS = new ArrayList<FscOrderInvoicePO>();
        ArrayList<FscInvoiceRulePO> fscInvoiceRulePOS = new ArrayList<FscInvoiceRulePO>();
        ArrayList<FscPayLogPO> fscPayLogUpdateList = new ArrayList<FscPayLogPO>();
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        ArrayList<Long> acceptOrderIds = new ArrayList<Long>();
        ArrayList<Long> orderIds = new ArrayList<Long>();
        Integer elecFlag = FscConstants.FscInvoiceRuleElecFlag.NO;
        if (FscConstants.FscInvoiceCategory.ELEC.equals(reqBO.getInvoiceCategory())) {
            elecFlag = FscConstants.FscInvoiceRuleElecFlag.YES;
        }
        int num = 0;
        for (SplitOrderBO splitOrderBO : reqBO.getSplitOrderList()) {
            FscOrderPO fscOrderPo = (FscOrderPO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderPO.class);
            fscOrderPo.setFscOrderId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderPo.setCreateTime(new Date());
            fscOrderPo.setCreateOperId(reqBO.getUserId());
            fscOrderPo.setCreateOperName(reqBO.getName());
            fscOrderPo.setCreateOrgId(reqBO.getOrgId());
            fscOrderPo.setCreateOrgName(reqBO.getOrgName());
            fscOrderPo.setCreateCompanyId(reqBO.getCompanyId());
            fscOrderPo.setCreateCompanyName(reqBO.getCompanyName());
            fscOrderPo.setTotalCharge(splitOrderBO.getAmount().setScale(2, 4));
            fscOrderPo.setToPayAmount(splitOrderBO.getAmount().setScale(2, 4));
            fscOrderPo.setOrderNo(reqBO.getOrderNos().get(num));
            fscOrderPo.setBuildAction(FscConstants.FscOrderBuildAction.HAND);
            fscOrderPo.setShouldPayType(reqBO.getPayNodeRule());
            fscOrderPo.setAutoBill(reqBO.getAutoBill());
            fscOrderPo.setBuyName(reqBO.getBuyName());
            fscOrderPo.setOperationArea(reqBO.getOperationArea());
            fscOrderPo.setSettleType(reqBO.getSettleType());
            if (FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType()) || FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                fscOrderPo.setTradeMode(FscConstants.FscBusiModel.TRADE);
            } else {
                fscOrderPo.setTradeMode(FscConstants.FscBusiModel.MATCHING);
            }
            if (null != reqBO.getBuildAction()) {
                fscOrderPo.setBuildAction(reqBO.getBuildAction());
            }
            ++num;
            StringBuilder orderNos = new StringBuilder();
            BigDecimal[] totalCharge = new BigDecimal[]{BigDecimal.ZERO};
            HashMap<Long, FscOrderItemPO> invoiceItemMap = new HashMap<Long, FscOrderItemPO>(fscOrderItemPOS.size());
            for (RelOrderBO relOrderBO : splitOrderBO.getRelOrderList()) {
                List itemReqBOList = relOrderBO.getFscOrderItemBOList();
                Map<Object, Object> itemReqBOMap = CollectionUtils.isEmpty((Collection)itemReqBOList) ? new HashMap() : itemReqBOList.stream().collect(Collectors.toMap(FscOrderItemReqBO::getInspectionItemId, e -> e, (k1, k2) -> k1));
                FscOrderInfoBO fscOrderInfoBO = reqBO.getFscOrderInfoBoMap().get(relOrderBO.getAcceptOrderId());
                Integer settlePlatform = fscOrderInfoBO.getSettlePlatform();
                if (null == fscOrderInfoBO) {
                    throw new FscBusinessException("193008", "\u83b7\u53d6\u8ba2\u5355\u5bf9\u8c61\u4e3a\u7a7a");
                }
                FscOrderRelationPO fscOrderRelationPO = (FscOrderRelationPO)JSONObject.parseObject((String)JSON.toJSONString((Object)fscOrderInfoBO), FscOrderRelationPO.class);
                fscOrderRelationPO.setContractNo(fscOrderInfoBO.getModelContractNo());
                fscOrderRelationPO.setContractId(fscOrderInfoBO.getModelContractId());
                fscOrderRelationPO.setErpInspectionNo(fscOrderInfoBO.getErpInspectionVoucherCode());
                fscOrderRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscOrderRelationPO.setFscOrderId(fscOrderPo.getFscOrderId());
                acceptOrderIds.add(fscOrderRelationPO.getAcceptOrderId());
                orderIds.add(fscOrderRelationPO.getOrderId());
                List<FscOrderItemPO> orderItemPOS = JSONObject.parseArray((String)JSON.toJSONString((Object)fscOrderInfoBO.getFscOrderItemBOS()), FscOrderItemPO.class);
                BigDecimal[] settleAmt = new BigDecimal[]{BigDecimal.ZERO};
                ArrayList exOrderItemIds = new ArrayList();
                orderItemPOS.forEach(fscOrderItemPO -> {
                    if (Objects.nonNull(fscOrderInfoBO.getOrderType()) && PebExtConstant.OrderType.CX_AGR.equals(fscOrderInfoBO.getOrderType())) {
                        fscOrderItemPO.setSkuName(fscOrderItemPO.getSkuMaterialLongDesc());
                    }
                    fscOrderItemPO.setFscOrderId(fscOrderPo.getFscOrderId());
                    invoiceItemMap.put(fscOrderItemPO.getOrderItemId(), (FscOrderItemPO)fscOrderItemPO);
                    if (Objects.nonNull(itemReqBOMap.get(fscOrderItemPO.getOrderItemId()))) {
                        FscOrderItemReqBO fscOrderItemReqBO = (FscOrderItemReqBO)itemReqBOMap.get(fscOrderItemPO.getOrderItemId());
                        if (Objects.nonNull(fscOrderItemReqBO.getProductDescription()) || Objects.nonNull(fscOrderItemReqBO.getSpecificationsModel())) {
                            fscOrderItemPO.setProductDescription(fscOrderItemReqBO.getProductDescription());
                            fscOrderItemPO.setSpecificationsModel(fscOrderItemReqBO.getSpecificationsModel());
                        } else {
                            this.dealDescAndModel((FscOrderItemPO)fscOrderItemPO, reqBO);
                        }
                        if (fscOrderItemReqBO.getNum() != null && fscOrderItemReqBO.getNum().compareTo(BigDecimal.ZERO) > 0) {
                            fscOrderItemPO.setNum(fscOrderItemReqBO.getNum());
                            fscOrderItemPO.setAmt(fscOrderItemReqBO.getAmt());
                            fscOrderItemPO.setTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemPO.getAmt(), (BigDecimal)fscOrderItemPO.getTaxRate()));
                            fscOrderItemPO.setUntaxAmt(fscOrderItemPO.getAmt().subtract(fscOrderItemPO.getTaxAmt()));
                            fscOrderItemPO.setPurchaseAmt(fscOrderItemReqBO.getNum().multiply(fscOrderItemPO.getPurchasePrice()));
                            BigDecimal purchaseTaxAmt = TaxUtils.calTaxAmt((BigDecimal)fscOrderItemPO.getPurchaseAmt(), (BigDecimal)fscOrderItemPO.getTaxRate());
                            fscOrderItemPO.setPurchaseUntaxAmt(fscOrderItemPO.getPurchaseAmt().subtract(purchaseTaxAmt));
                            if (fscOrderItemPO.getSalesUnitRate() != null && fscOrderItemPO.getSalesUnitRate().compareTo(BigDecimal.ZERO) > 0) {
                                fscOrderItemPO.setSettlePrice(fscOrderItemPO.getPrice().divide(fscOrderItemPO.getSalesUnitRate(), 8, 4));
                                fscOrderItemPO.setSettleNum(fscOrderItemPO.getNum().multiply(fscOrderItemPO.getSalesUnitRate()));
                            }
                            if (fscOrderItemReqBO.getNum().multiply(fscOrderItemPO.getPrice()).setScale(2, 4).compareTo(fscOrderItemReqBO.getAmt()) != 0) {
                                throw new FscBusinessException("198888", "\u524d\u7aef\u63d0\u4ea4\u660e\u7ec6\u884c\u91d1\u989d\u4e0e\u540e\u7aef\u8ba1\u7b97\u4e0d\u4e00\u81f4\uff01");
                            }
                        } else if (fscOrderItemReqBO.getNum().compareTo(BigDecimal.ZERO) == 0) {
                            exOrderItemIds.add(fscOrderItemPO.getOrderItemId());
                            fscOrderItemPO.setNum(fscOrderItemReqBO.getNum());
                            fscOrderItemPO.setAmt(BigDecimal.ZERO);
                        }
                    } else {
                        this.dealDescAndModel((FscOrderItemPO)fscOrderItemPO, reqBO);
                    }
                    totalCharge[0] = totalCharge[0].add(fscOrderItemPO.getAmt());
                    settleAmt[0] = settleAmt[0].add(fscOrderItemPO.getAmt());
                });
                if (!CollectionUtils.isEmpty(exOrderItemIds) && CollectionUtils.isEmpty(orderItemPOS = orderItemPOS.stream().filter(e -> !exOrderItemIds.contains(e.getOrderItemId())).collect(Collectors.toList()))) continue;
                fscOrderItemPOS.addAll(orderItemPOS);
                fscOrderRelationPO.setSettleAmt(settleAmt[0]);
                if (!fscOrderPo.getPayType().equals(FscConstants.FscPayType.FSC_PAY_TYPE_STAGE)) {
                    fscOrderRelationPO.setAmount(settleAmt[0]);
                } else {
                    fscOrderRelationPO.setAmount(BigDecimal.ZERO);
                }
                if (FscConstants.SettleType.ORDER.equals(reqBO.getSettleType())) {
                    FscClaimDetailPO fscClaimDetailPO = new FscClaimDetailPO();
                    fscClaimDetailPO.setOrderId(fscOrderRelationPO.getOrderId());
                    BigDecimal claimAmt = this.fscClaimDetailMapper.getclaimAmtByOrderId(fscClaimDetailPO);
                    BigDecimal prePayAmt = this.fscShouldPayMapper.getPrePayAmtByOrderId(fscOrderRelationPO.getOrderId());
                    String[] preAmt = (claimAmt == null ? BigDecimal.ZERO : claimAmt).add(prePayAmt == null ? BigDecimal.ZERO : prePayAmt);
                    BigDecimal usedAmt = this.fscOrderRelationMapper.getUsedPreAmtByOrderId(fscOrderRelationPO.getOrderId());
                    BigDecimal leftAmt = preAmt.subtract(usedAmt == null ? BigDecimal.ZERO : usedAmt);
                    if (leftAmt.compareTo(BigDecimal.ZERO) <= 0) {
                        fscOrderRelationPO.setAmount(settleAmt[0]);
                    } else if (leftAmt.compareTo(settleAmt[0]) >= 0) {
                        fscOrderRelationPO.setAmount(BigDecimal.ZERO);
                    } else {
                        fscOrderRelationPO.setAmount(settleAmt[0].subtract(leftAmt));
                    }
                }
                fscOrderRelationPOS.add(fscOrderRelationPO);
                if (!org.springframework.util.StringUtils.isEmpty((Object)fscOrderInfoBO.getOperatorId())) {
                    fscOrderPo.setOperatorId(Long.valueOf(Long.parseLong(fscOrderInfoBO.getOperatorId())));
                }
                fscOrderPo.setSettlePlatform(settlePlatform);
                fscOrderPo.setOperatorName(fscOrderInfoBO.getOperatorName());
                fscOrderPo.setOperationNo(fscOrderInfoBO.getOperationNo());
                if (!org.springframework.util.StringUtils.isEmpty((Object)fscOrderInfoBO.getOperatorDeptId())) {
                    fscOrderPo.setOperatorDeptId(Long.valueOf(Long.parseLong(fscOrderInfoBO.getOperatorDeptId())));
                }
                fscOrderPo.setOperatorDeptName(fscOrderInfoBO.getOperatorDeptName());
                if ("0".equals(reqBO.getIsprofess())) {
                    if (fscOrderPo.getOperatorId() == null) {
                        fscOrderPo.setOperatorId(reqBO.getUserId());
                        fscOrderPo.setOperatorName(reqBO.getName());
                    }
                    if (fscOrderPo.getOperatorDeptId() == null) {
                        fscOrderPo.setOperatorId(reqBO.getDeptId());
                        fscOrderPo.setOperatorName(reqBO.getDeptName());
                    }
                    fscOrderPo.setOperationTime(new Date());
                    if (org.springframework.util.StringUtils.isEmpty((Object)fscOrderPo.getOperationNo())) {
                        String[] org = this.proOrg.split(",");
                        String[] pur = reqBO.getOrgPath().split("-");
                        String operationNo = String.valueOf(reqBO.getOrgId());
                        block2: for (String pro : org) {
                            for (String t : pur) {
                                if (!pro.equals(t)) continue;
                                operationNo = pro;
                                continue block2;
                            }
                        }
                        fscOrderPo.setOperationNo(operationNo);
                    }
                }
                if (org.springframework.util.StringUtils.isEmpty((Object)fscOrderPo.getOperationNo())) continue;
                UmcEnterpriseOrgNameListQryAbilityReqBO abilityReqBO = new UmcEnterpriseOrgNameListQryAbilityReqBO();
                ArrayList<Long> operationNos = new ArrayList<Long>();
                operationNos.add(Long.parseLong(fscOrderPo.getOperationNo()));
                abilityReqBO.setOrgIdList(operationNos);
                UmcEnterpriseOrgNameListQryAbilityRspBO rspBO = this.umcEnterpriseOrgNameListQryAbilityService.qryEnterpriseOrgNameList(abilityReqBO);
                if (rspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Map)rspBO.getOrgMap())) {
                    Map orgMap = rspBO.getOrgMap();
                    fscOrderPo.setOperationName(((UmcDycEnterpriseOrgBO)orgMap.get(Long.valueOf(fscOrderPo.getOperationNo()))).getOrgName());
                }
                if (!"1".equals(fscOrderPo.getOrderSource().toString())) continue;
                orderNos.append(fscOrderInfoBO.getOrderNo()).append(",");
            }
            FscPayLogPO fscPayLogPO = new FscPayLogPO();
            Set orderIdSet = fscOrderItemPOS.stream().map(FscOrderItemPO::getOrderId).collect(Collectors.toSet());
            fscPayLogPO.setBusiOrderIdList(orderIdSet);
            ArrayList<Integer> busiCategoryList = new ArrayList<Integer>();
            busiCategoryList.add(FscConstants.FscBusiCategory.ORDER_PAY);
            busiCategoryList.add(FscConstants.FscBusiCategory.ORDER_REFUND);
            busiCategoryList.add(FscConstants.FscBusiCategory.PERIOD_PAY);
            busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_PAY);
            busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_CHANGE);
            fscPayLogPO.setBusiCategoryList(busiCategoryList);
            fscPayLogPO.setPayeeId(this.operationOrgId);
            List fscPayLogPOList = this.fscPayLogMapper.getList(fscPayLogPO);
            if (!CollectionUtils.isEmpty((Collection)fscPayLogPOList)) {
                for (FscPayLogPO po : fscPayLogPOList) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)po.getFscOrderNo())) {
                        po.setFscOrderNo(fscOrderPo.getOrderNo());
                        fscPayLogUpdateList.add(po);
                        continue;
                    }
                    if (po.getFscOrderNo().contains(fscOrderPo.getOrderNo())) continue;
                    po.setFscOrderNo(po.getFscOrderNo() + "," + fscOrderPo.getOrderNo());
                    fscPayLogUpdateList.add(po);
                }
            }
            this.checkOrderBillNum(invoiceItemMap, reqBO.getReceiveType());
            if (splitOrderBO.getAmount().compareTo(totalCharge[0].setScale(2, 4)) != 0) {
                throw new FscBusinessException("198888", "\u524d\u7aef\u63d0\u4ea4\u91d1\u989d\u4e0e\u540e\u7aef\u8ba1\u7b97\u4e0d\u4e00\u81f4\uff01");
            }
            fscOrderPOS.add(fscOrderPo);
            fscOrderIds.add(fscOrderPo.getFscOrderId());
            FscOrderInvoicePO fscOrderInvoicePo = (FscOrderInvoicePO)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderInvoicePO.class);
            fscOrderInvoicePo.setFscOrderId(fscOrderPo.getFscOrderId());
            fscOrderInvoicePo.setBillOperId(reqBO.getUserId().toString());
            fscOrderInvoicePo.setBillOperName(reqBO.getName());
            fscOrderInvoicePo.setBillTime(new Date());
            fscOrderInvoicePo.setBillTimeStart(new Date());
            fscOrderInvoicePOS.add(fscOrderInvoicePo);
            FscInvoiceRulePO fscInvoiceRulePO = new FscInvoiceRulePO();
            fscInvoiceRulePO.setFscOrderId(fscOrderPo.getFscOrderId());
            fscInvoiceRulePO.setDataFlag(FscConstants.FscInvoiceRuleDataFlag.YES);
            fscInvoiceRulePO.setDataStatus(FscConstants.FscInvoiceRuleStatus.NO);
            fscInvoiceRulePO.setElecFlag(elecFlag);
            fscInvoiceRulePO.setElecStatus(FscConstants.FscInvoiceRuleStatus.NO);
            fscInvoiceRulePOS.add(fscInvoiceRulePO);
        }
        if (CollectionUtils.isEmpty(fscOrderPOS) || CollectionUtils.isEmpty(fscOrderRelationPOS) || CollectionUtils.isEmpty(fscOrderItemPOS) || CollectionUtils.isEmpty(fscOrderInvoicePOS) || CollectionUtils.isEmpty(fscInvoiceRulePOS)) {
            throw new FscBusinessException("193008", "\u5f00\u7968\u4e3b\u5355\u7ec4\u88c5\u53c2\u6570\u4e3a\u7a7a");
        }
        fscOrderItemPOS.forEach(fscOrderItemPO -> fscOrderItemPO.setId(Long.valueOf(Sequence.getInstance().nextId())));
        this.fscOrderMapper.insertBatch(fscOrderPOS);
        this.fscOrderRelationMapper.insertBatch(fscOrderRelationPOS);
        this.fscOrderItemMapper.insertBatch(fscOrderItemPOS);
        this.fscOrderInvoiceMapper.insertBatch(fscOrderInvoicePOS);
        this.fscInvoiceRuleMapper.insertBatch(fscInvoiceRulePOS);
        if (!CollectionUtils.isEmpty(fscPayLogUpdateList)) {
            this.fscPayLogMapper.updateFscOrderNo(fscPayLogUpdateList);
        }
        if (!CollectionUtils.isEmpty(reqBO.getFscShouldPayPOS())) {
            this.fscShouldPayMapper.updateStatusByBatch(reqBO.getFscShouldPayPOS());
        }
        if (reqBO.getSettleType().equals(FscConstants.SettleType.ORDER)) {
            FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
            fscShouldPayPO.setPayeeId(reqBO.getPayeeId());
            fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.DEL);
            fscShouldPayPO.setOrderIds(orderIds);
            this.fscShouldPayMapper.updateShouldPayStatusBySettle(fscShouldPayPO);
        }
        FscBillOrderCreateBusiRspBO rspBO = new FscBillOrderCreateBusiRspBO();
        if (FscConstants.FscOrderOperType.save.equals(reqBO.getOperType())) {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderIds(fscOrderIds);
            fscOrderPO.setOrderState(FscConstants.FscInvoiceOrderState.DRAFT);
            this.fscOrderMapper.dealSave(fscOrderPO);
        } else {
            FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderStatusStartAtomReqBO.class);
            for (Long fscOrderId : fscOrderIds) {
                fscOrderStatusStartAtomReqBO.setOrderId(fscOrderId);
                FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
                if ("0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) continue;
                throw new FscBusinessException("193008", fscOrderStatusStartAtomRspBO.getRespDesc());
            }
            if (reqBO.getWebSource() != null && reqBO.getWebSource().equals(FscConstants.FscWebSource.AGR_DOWN)) {
                FscBillSendSaleFscOrderApplyAbilityReqBO abilityReqBO = new FscBillSendSaleFscOrderApplyAbilityReqBO();
                abilityReqBO.setUserId(reqBO.getUserId());
                abilityReqBO.setUserName(reqBO.getUserName());
                abilityReqBO.setFscOrderIds(fscOrderIds);
                abilityReqBO.setDeptId(reqBO.getDeptId());
                abilityReqBO.setDeptName(reqBO.getDeptName());
                abilityReqBO.setPersonId(reqBO.getPersonId());
                abilityReqBO.setPersonName(reqBO.getPersonName());
                abilityReqBO.setYcUserId(reqBO.getYcUserId());
                abilityReqBO.setName(reqBO.getName());
                abilityReqBO.setOrgId(reqBO.getOrgId());
                abilityReqBO.setOrgPath(reqBO.getOrgPath());
                this.dealApproval(abilityReqBO, rspBO);
            }
        }
        rspBO.setFscOrderIds(fscOrderIds);
        return rspBO;
    }

    @Transactional(isolation=Isolation.READ_UNCOMMITTED)
    public void dealCheck(List<Long> acceptOrderIds, Integer receiveType, List<Long> fscOrderIds) {
        FscOrderPO checkPo = new FscOrderPO();
        checkPo.setAcceptOrderIds(acceptOrderIds);
        checkPo.setReceiveType(receiveType);
        checkPo.setFscOrderIds(fscOrderIds);
        int checkResult = this.fscOrderMapper.getInvoiceCheckBy(checkPo);
        if (checkResult > 0) {
            throw new FscBusinessException("198888", "\u5b58\u5728\u8ba2\u5355\u5df2\u53d1\u8d77\u7ed3\u7b97\u5355\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u8d77\u8ba2\u5355\u7ed3\u7b97");
        }
    }

    public void dealDescAndModel(FscOrderItemPO fscOrderItemPO, FscBillOrderCreateBusiReqBO reqBO) {
        if ("2".equals(reqBO.getOrderSource())) {
            if (FscInvoiceValueTypeEnum.PLAN_MATERIAL.getCode().equals(reqBO.getInvoiceValueType()) && !org.springframework.util.StringUtils.isEmpty((Object)fscOrderItemPO.getPlanItemName())) {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getPlanItemName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getPlanItemSpecification(), null, fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getPlanItemCode()));
            } else if (FscInvoiceValueTypeEnum.AGREE_MATERIAL.getCode().equals(reqBO.getInvoiceValueType()) && !org.springframework.util.StringUtils.isEmpty((Object)fscOrderItemPO.getSkuMaterialName())) {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuMaterialName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getMaterialSpec(), fscOrderItemPO.getMaterialModel(), fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getSkuMaterialId()));
            } else {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), null, null));
            }
        } else if ("1".equals(reqBO.getOrderSource())) {
            if (FscInvoiceValueTypeEnum.PLAN_MATERIAL.getCode().equals(reqBO.getInvoiceValueType())) {
                if (!org.springframework.util.StringUtils.isEmpty((Object)fscOrderItemPO.getPlanItemName())) {
                    fscOrderItemPO.setProductDescription(fscOrderItemPO.getPlanItemName());
                    fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getPlanItemSpecification(), null, fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getPlanItemCode()));
                } else if (!org.springframework.util.StringUtils.isEmpty((Object)fscOrderItemPO.getSkuMaterialName())) {
                    fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuMaterialName());
                    fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getMaterialSpec(), fscOrderItemPO.getMaterialModel(), fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getSkuMaterialId()));
                } else {
                    fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuName());
                    fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), null, null));
                }
            } else if (FscInvoiceValueTypeEnum.AGREE_MATERIAL.getCode().equals(reqBO.getInvoiceValueType())) {
                if (!org.springframework.util.StringUtils.isEmpty((Object)fscOrderItemPO.getSkuMaterialName())) {
                    fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuMaterialName());
                    fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getMaterialSpec(), fscOrderItemPO.getMaterialModel(), fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getSkuMaterialId()));
                } else if (!org.springframework.util.StringUtils.isEmpty((Object)fscOrderItemPO.getPlanItemName())) {
                    fscOrderItemPO.setProductDescription(fscOrderItemPO.getPlanItemName());
                    fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getPlanItemSpecification(), null, fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getPlanItemCode()));
                } else {
                    fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuName());
                    fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), null, null));
                }
            } else {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), null, null));
            }
        }
    }

    public String dealSpecificationsModel(String spec, String model, String materialBJ, String materialId) {
        if (!org.springframework.util.StringUtils.isEmpty((Object)materialId) && materialId.startsWith("61")) {
            return "";
        }
        String specificationsModel = "";
        specificationsModel = !org.springframework.util.StringUtils.isEmpty((Object)spec) && !org.springframework.util.StringUtils.isEmpty((Object)model) && !org.springframework.util.StringUtils.isEmpty((Object)materialBJ) ? spec + "|" + model + "|" + materialBJ : (!org.springframework.util.StringUtils.isEmpty((Object)spec) && !org.springframework.util.StringUtils.isEmpty((Object)model) ? spec + "|" + model : (!org.springframework.util.StringUtils.isEmpty((Object)model) && !org.springframework.util.StringUtils.isEmpty((Object)materialBJ) ? model + "|" + materialBJ : (!org.springframework.util.StringUtils.isEmpty((Object)spec) && !org.springframework.util.StringUtils.isEmpty((Object)materialBJ) ? spec + "|" + materialBJ : (!org.springframework.util.StringUtils.isEmpty((Object)spec) ? spec : (!org.springframework.util.StringUtils.isEmpty((Object)model) ? model : materialBJ)))));
        if (!org.springframework.util.StringUtils.isEmpty((Object)specificationsModel) && specificationsModel.length() > 40) {
            return specificationsModel.substring(0, 40);
        }
        return specificationsModel;
    }

    private void syncOrderStatus(List<Long> fscOrderIds) {
        fscOrderIds.forEach(fscOrderId -> {
            FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
            fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
            fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
            this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
        });
    }

    private void valid(FscBillSendSaleFscOrderApplyAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
            throw new FscBusinessException("191000", "\u53c2\u6570[fscOrderIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getWebSource() != null && reqBO.getWebSource().equals(FscConstants.FscWebSource.AGR_DOWN)) {
            if (reqBO.getDeptId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[deptId]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBO.getDeptName())) {
                throw new FscBusinessException("191000", "\u5165\u53c2[deptName]\u4e3a\u7a7a");
            }
            if (reqBO.getPersonId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[personId]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBO.getPersonName())) {
                throw new FscBusinessException("191000", "\u5165\u53c2[personName]\u4e3a\u7a7a");
            }
            if (reqBO.getYcUserId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[ycUserId]\u4e3a\u7a7a");
            }
        }
    }

    private void dealWorkFlow(FscOrderPO fscOrderPo) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderPo.getFscOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(fscOrderPo.getOrderState());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("confirmFlag", FscConstants.BillOrderConfirmFlag.CONFIRM);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
    }

    private Boolean invokeUacTask(FscBillSendSaleFscOrderApplyAbilityReqBO reqBO, Long l, boolean individuallyPay) {
        UacNoTaskAuditCreateReqBO auditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        auditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        auditCreateReqBO.setCreateOperName(reqBO.getName());
        auditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        auditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(l);
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (individuallyPay) {
            if (FscOrderSourceEnum.ELECTRIC_AREA.getCode().equals(fscOrderPO.getOrderSource()) && FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType()) && FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType())) {
                auditCreateReqBO.setMenuId("FSC_ARGEE_DOWN_ORDER_INVOICE_PROCESS");
            } else {
                auditCreateReqBO.setMenuId("M001007");
            }
        } else {
            auditCreateReqBO.setMenuId("M001008");
        }
        auditCreateReqBO.setOrgId(reqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(l);
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(l.toString());
        approvalObjBO.setObjName("\u9500\u552e\u7ed3\u7b97\u5355\u5ba1\u6279");
        approvalObjBO.setObjType(FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL);
        approvalObjBOList.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        auditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        log.info("\u5ba1\u6279\u5165\u53c2================" + JSON.toJSONString((Object)auditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("191019", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        return uacNoTaskAuditCreateRspBO.getNotFindFlag();
    }

    private void valItem(FscOrderPO fscOrderPO) {
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(fscOrderPO.getFscOrderId());
        List fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderItemPOList)) {
            List orderIds = fscOrderItemPOList.stream().map(FscOrderItemPO::getOrderId).collect(Collectors.toList());
            FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
            fscShouldPayPO.setOrderIds(orderIds);
            fscShouldPayPO.setPayeeId(fscOrderPO.getPayeeId());
            ArrayList<Integer> statusList = new ArrayList<Integer>();
            statusList.add(FscConstants.ShouldPayStatus.TO_PAY);
            statusList.add(FscConstants.ShouldPayStatus.PART_PAY);
            statusList.add(FscConstants.ShouldPayStatus.PAYED);
            statusList.add(FscConstants.ShouldPayStatus.TO_RELIEF);
            fscShouldPayPO.setShouldPayStatusList(statusList);
            List fscShouldPayPOList = this.fscShouldPayMapper.getList(fscShouldPayPO);
            if (null != fscShouldPayPOList) {
                for (FscShouldPayPO fscShouldPayPOFor : fscShouldPayPOList) {
                    if (!FscConstants.ShouldObjectType.SALE_ORDER.equals(fscShouldPayPOFor.getObjectType()) && !FscConstants.ShouldObjectType.CHECK_ORDER.equals(fscShouldPayPOFor.getObjectType()) && !FscConstants.ShouldObjectType.DELIVER_ORDER.equals(fscShouldPayPOFor.getObjectType()) || !FscConstants.ShouldPayType.ADVANCE_PAY.equals(fscShouldPayPOFor.getShouldPayType()) && !FscConstants.ShouldPayType.ARRIVAL_SHOULD_PAY.equals(fscShouldPayPOFor.getShouldPayType()) && !FscConstants.ShouldPayType.ACCEPT_SHOULD_PAY.equals(fscShouldPayPOFor.getShouldPayType()) && !FscConstants.ShouldPayType.DEPOSIT_SHOULD_PAY.equals(fscShouldPayPOFor.getShouldPayType()) && !FscConstants.ShouldPayType.PAYMENT_PRE_PAY.equals(fscShouldPayPOFor.getShouldPayType()) || fscShouldPayPOFor.getShouldPayAmount().compareTo(fscShouldPayPOFor.getClaimAmt()) <= 0) continue;
                    throw new FscBusinessException("191026", "\u7ed3\u7b97\u5355\u4e2d\u6709\u8ba2\u5355\u4e3a\u8fdb\u884c\u9884\u6536\u8ba4\u9886\uff0c\u8bf7\u5148\u8ba4\u9886\u540e\u518d\u8fdb\u884c\u7ed3\u7b97\u5f00\u7968\u3002");
                }
            }
        }
    }

    private void dealApproval(FscBillSendSaleFscOrderApplyAbilityReqBO reqBO, FscBillOrderCreateBusiRspBO rspBO) {
        for (Long l : reqBO.getFscOrderIds()) {
            FscOrderPO order = new FscOrderPO();
            order.setFscOrderId(l);
            order = this.fscOrderMapper.getModelBy(order);
            FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
            fscOrderItemPO.setFscOrderId(l);
            List fscOrderItemList = this.fscOrderItemMapper.getList(fscOrderItemPO);
            if (CollectionUtils.isEmpty((Collection)fscOrderItemList)) {
                throw new FscBusinessException("193008", "\u9500\u552e\u7ed3\u7b97\u5355\uff1a" + order.getOrderNo() + "\uff0c\u67e5\u8be2\u7ed3\u7b97\u8ba2\u5355\u660e\u7ec6\u4e3a\u7a7a\uff01");
            }
            int index = 1;
            for (FscOrderItemPO po : fscOrderItemList) {
                if (StringUtils.isNotBlank((CharSequence)po.getSpecificationsModel()) && po.getSpecificationsModel().length() > 120) {
                    throw new FscBusinessException("193004", "\u9500\u552e\u7ed3\u7b97\u5355\uff1a" + order.getOrderNo() + "\uff0c\u7b2c" + index + "\u884c\u89c4\u683c\u578b\u53f7\u4e0d\u53ef\u8d85\u8fc7120\u5b57\u7b26\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\u4e4b\u540e\u8fdb\u884c\u63d0\u4ea4\uff01");
                }
                ++index;
            }
            this.fscOrderMapper.deleteOrderSendTemp(l);
            FscOrderPO fscSendTemp = (FscOrderPO)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscOrderPO.class);
            fscSendTemp.setFscOrderId(l);
            fscSendTemp.setYcDeptId(reqBO.getDeptId().toString());
            fscSendTemp.setYcDeptName(reqBO.getDeptName());
            fscSendTemp.setYcPersonId(reqBO.getPersonId().toString());
            fscSendTemp.setYcPersonName(reqBO.getPersonName());
            fscSendTemp.setBuynerNo(order.getBuynerNo());
            fscSendTemp.setBuynerName(order.getBuynerName());
            log.debug("========\u63a8\u9001\u9500\u552e\u5355\u7533\u8bf7\u4e34\u65f6\u4fdd\u5b58\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)fscSendTemp));
            this.fscOrderMapper.insertOrderSendTemp(fscSendTemp);
            boolean individuallyPay = !order.getReceiveType().equals(FscConstants.FscOrderReceiveType.INDIVIDUAL);
            Boolean uacFlag = this.invokeUacTask(reqBO, l, individuallyPay);
            FscOrderPO fscOrderPO = new FscOrderPO();
            if (uacFlag.booleanValue() && individuallyPay) {
                throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u7ed3\u7b97\u5355\u5ba1\u6279\u6d41\uff01");
            }
            if (uacFlag.booleanValue()) {
                fscOrderPO.setSendState(FscOrderSendStateEnum.NOT_AUDIT.getCode());
                fscOrderPO.setOrderState(FscConstants.FscInvoiceOrderState.APPROVAL_PASS);
                rspBO.setApprovalFlag(true);
            }
            if (!uacFlag.booleanValue()) {
                FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
                taskPo.setFscOrderId(l);
                List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
                fscOrderPO.setSignApplyTime(new Date());
                if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
                    List auditedPostIdList = pendAuditPostIdList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
                    fscOrderPO.setSendStation(Joiner.on((String)",").join(auditedPostIdList) + ",");
                }
                fscOrderPO.setSendState(FscOrderSendStateEnum.NO_AUDIT.getCode());
                fscOrderPO.setSendApplyTime(new Date());
                fscOrderPO.setSendUserId(reqBO.getUserId());
                fscOrderPO.setSendUserName(reqBO.getName());
            }
            fscOrderPO.setFscOrderId(l);
            fscOrderPO.setOperatorId(reqBO.getUserId());
            fscOrderPO.setOperatorName(reqBO.getName());
            String operationNo = String.valueOf(reqBO.getOrgId());
            String[] org = this.proOrg.split(",");
            String[] pur = reqBO.getOrgPath().split("-");
            block2: for (String pro : org) {
                for (String t : pur) {
                    if (!pro.equals(t)) continue;
                    operationNo = pro;
                    continue block2;
                }
            }
            fscOrderPO.setOperationNo(operationNo);
            this.fscOrderMapper.updateById(fscOrderPO);
            if (reqBO.getWebSource() == null || !reqBO.getWebSource().equals(FscConstants.FscWebSource.AGR_DOWN)) continue;
            this.dealWorkFlow(order);
        }
    }

    private void checkOrderBillNum(Map<Long, FscOrderItemPO> itemMap, Integer receiveType) {
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setOrderItemIdSets(itemMap.keySet());
        fscOrderItemPO.setReceiveType(receiveType);
        List orderItemPOS = this.fscOrderItemMapper.getCheckList(fscOrderItemPO);
        if (!CollectionUtils.isEmpty((Collection)orderItemPOS)) {
            for (FscOrderItemPO orderItemPO : orderItemPOS) {
                FscOrderItemPO invoiceItem = itemMap.get(orderItemPO.getOrderItemId());
                if (invoiceItem.getTotalNum().subtract(orderItemPO.getNum()).compareTo(invoiceItem.getNum()) < 0) {
                    throw new FscBusinessException("198888", "\u8ba2\u5355\u660e\u7ec6\u884c[" + invoiceItem.getOrderItemId() + "]\u672c\u6b21\u63d0\u7968\u6570\u91cf\u8d85\u8fc7\u53ef\u63d0\u7968\u6570\u91cf\uff01");
                }
                if (invoiceItem.getTotalAmt().subtract(orderItemPO.getAmt()).compareTo(invoiceItem.getAmt()) >= 0) continue;
                throw new FscBusinessException("198888", "\u8ba2\u5355\u660e\u7ec6\u884c[" + invoiceItem.getOrderItemId() + "]\u672c\u6b21\u63d0\u7968\u6570\u91cf\u8d85\u8fc7\u53ef\u63d0\u7968\u6570\u91cf\uff01");
            }
        }
    }
}

