/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscBillSendSaleFscOrderApplyAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillSendSaleFscOrderApplyAbilityReqBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderUpdateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderUpdateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderUpdateBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.common.ability.enums.FscInvoiceValueTypeEnum;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.enums.FscOrderSendStateEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.fsc.util.TaxUtils;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscBillOrderUpdateBusiServiceImpl
implements FscBillOrderUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderUpdateBusiServiceImpl.class);
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscBillSendSaleFscOrderApplyAbilityService fscBillSendSaleFscOrderApplyAbilityService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;
    @Value(value="${fsc.main.electricity.pro.org:100100}")
    private String electricityOrg;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    private static final String BUSI_NAME = "\u8fd0\u8425\u63d0\u4ea4";

    @Override
    public FscBillOrderUpdateBusiRspBO dealUpdate(FscBillOrderUpdateBusiReqBO reqBO) {
        List<FscOrderItemPO> fscOrderItemList;
        FscBillOrderUpdateBusiRspBO rspBO = new FscBillOrderUpdateBusiRspBO();
        FscOrderInvoicePO fscOrderInvoicePO = (FscOrderInvoicePO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscOrderInvoicePO.class);
        this.fscOrderInvoiceMapper.updateById(fscOrderInvoicePO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO.setRemark(reqBO.getRemark());
        fscOrderPO.setInvoiceRemark(reqBO.getInvoiceRemark());
        fscOrderPO.setUpdateOperId(reqBO.getUserId().toString());
        fscOrderPO.setUpdateOperName(reqBO.getName());
        fscOrderPO.setUpdateTime(new Date());
        fscOrderPO.setTotalCharge(reqBO.getTotalCharge());
        this.fscOrderMapper.updateById(fscOrderPO);
        this.fscAttachmentMapper.deleteByfscOrderId(reqBO.getFscOrderId());
        ArrayList<FscAttachmentPO> fscAttachmentPOList = new ArrayList<FscAttachmentPO>();
        if (!CollectionUtils.isEmpty(reqBO.getAttachmentList())) {
            for (AttachmentBO attachmentBO : reqBO.getAttachmentList()) {
                FscAttachmentPO fscAttachmentPO = (FscAttachmentPO)JSONObject.parseObject((String)JSON.toJSONString((Object)attachmentBO), FscAttachmentPO.class);
                fscAttachmentPO.setFscOrderId(reqBO.getFscOrderId());
                fscAttachmentPO.setObjId(reqBO.getFscOrderId());
                fscAttachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                fscAttachmentPOList.add(fscAttachmentPO);
            }
            this.fscAttachmentMapper.insertBatch(fscAttachmentPOList);
        }
        if (!CollectionUtils.isEmpty(fscOrderItemList = reqBO.getFscOrderItemPoList())) {
            int count;
            ArrayList<FscOrderItemPO> updateList = new ArrayList<FscOrderItemPO>();
            ArrayList addList = new ArrayList();
            ArrayList<Long> deleteList = new ArrayList<Long>();
            FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
            fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
            fscOrderItemPO.setOrderItemIds(fscOrderItemList.stream().filter(e -> e.getOrderItemId() != null).map(e -> e.getOrderItemId()).collect(Collectors.toList()));
            List list = this.fscOrderItemMapper.getList(fscOrderItemPO);
            List<Object> hasItemIds = new ArrayList();
            Map<Object, Object> idMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)list)) {
                hasItemIds = list.stream().map(FscOrderItemPO::getOrderItemId).collect(Collectors.toList());
                idMap = list.stream().collect(Collectors.toMap(FscOrderItemPO::getOrderItemId, orderItemPO -> orderItemPO, (e1, e2) -> e2));
            }
            for (FscOrderItemPO po : fscOrderItemList) {
                if (hasItemIds.contains(po.getOrderItemId())) {
                    if (BigDecimal.ZERO.compareTo(po.getNum()) >= 0) {
                        if (!idMap.containsKey(po.getOrderItemId())) continue;
                        deleteList.add(((FscOrderItemPO)idMap.get(po.getOrderItemId())).getId());
                        continue;
                    }
                    FscOrderItemPO orderItemPO2 = (FscOrderItemPO)idMap.get(po.getOrderItemId());
                    po.setPurchaseAmt(po.getNum().multiply(orderItemPO2.getPurchasePrice()));
                    BigDecimal purchaseTaxAmt = TaxUtils.calTaxAmt((BigDecimal)po.getPurchaseAmt(), (BigDecimal)orderItemPO2.getTaxRate());
                    po.setPurchaseUntaxAmt(po.getPurchaseAmt().subtract(purchaseTaxAmt));
                    if (orderItemPO2.getSalesUnitRate() != null && orderItemPO2.getSalesUnitRate().compareTo(BigDecimal.ZERO) > 0) {
                        po.setSettleNum(po.getNum().multiply(orderItemPO2.getSalesUnitRate()));
                    }
                    updateList.add(po);
                    continue;
                }
                addList.add(po);
            }
            if (!CollectionUtils.isEmpty(updateList) && (count = this.fscOrderItemMapper.updateBatchByList(updateList)) < 1) {
                throw new FscBusinessException("190000", "\u7ed3\u7b97\u660e\u7ec6\u66f4\u65b0\u5931\u8d25\uff01");
            }
            if (!CollectionUtils.isEmpty(deleteList) && (count = this.fscOrderItemMapper.deleteItemListByIds(deleteList)) < 1) {
                throw new FscBusinessException("190000", "\u7ed3\u7b97\u660e\u7ec6\u5220\u9664\u5931\u8d25\uff01");
            }
            if (!CollectionUtils.isEmpty((Collection)addList)) {
                ArrayList<FscOrderItemPO> insertPos = new ArrayList<FscOrderItemPO>();
                List inspectionVoucherIdList = addList.stream().map(e -> e.getAcceptOrderId()).collect(Collectors.toList());
                FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
                fscAcceptOrderListQueryAtomReqBO.setInspectionVoucherIdList(inspectionVoucherIdList);
                fscAcceptOrderListQueryAtomReqBO.setReceiveType(reqBO.getReceiveType());
                if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType())) {
                    fscAcceptOrderListQueryAtomReqBO.setReceiveType(FscConstants.FscOrderReceiveType.OPERATION);
                }
                fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.TRADE_INVOICE);
                if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                    fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.PRO_INVOICE);
                }
                if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && !FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType())) {
                    fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.MATCH_INVOICE);
                }
                if (FscConstants.FscOrderReceiveType.INDIVIDUAL.equals(reqBO.getReceiveType())) {
                    fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.INDIVIDUAL_TYPE);
                }
                fscAcceptOrderListQueryAtomReqBO.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
                FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = new FscAcceptOrderListQueryAtomRspBO();
                log.debug("\u4e3b\u5355\u5f00\u7968\u67e5\u8be2\u9a8c\u6536\u5355\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscAcceptOrderListQueryAtomReqBO));
                fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
                log.debug("\u4e3b\u5355\u5f00\u7968\u67e5\u8be2\u9a8c\u6536\u5355\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscAcceptOrderListQueryAtomRspBO));
                if (null == fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap() || fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap().size() != inspectionVoucherIdList.size()) {
                    throw new FscBusinessException("191014", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
                }
                Iterator iterator = addList.iterator();
                while (iterator.hasNext()) {
                    FscOrderItemPO itemPO = (FscOrderItemPO)iterator.next();
                    FscOrderInfoBO fscOrderInfoBO = (FscOrderInfoBO)fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap().get(itemPO.getAcceptOrderId());
                    List orderItemPOS = JSONObject.parseArray((String)JSON.toJSONString((Object)fscOrderInfoBO.getFscOrderItemBOS()), FscOrderItemPO.class);
                    for (FscOrderItemPO orderItemPO3 : orderItemPOS) {
                        if (!orderItemPO3.getOrderItemId().equals(itemPO.getOrderItemId())) continue;
                        if (Objects.nonNull(fscOrderInfoBO.getOrderType()) && PebExtConstant.OrderType.CX_AGR.equals(fscOrderInfoBO.getOrderType())) {
                            orderItemPO3.setSkuName(orderItemPO3.getSkuMaterialLongDesc());
                        }
                        orderItemPO3.setFscOrderId(itemPO.getFscOrderId());
                        FscOrderItemPO fscOrderItemReqBO = itemPO;
                        if (Objects.nonNull(fscOrderItemReqBO.getProductDescription()) || Objects.nonNull(fscOrderItemReqBO.getSpecificationsModel())) {
                            orderItemPO3.setProductDescription(fscOrderItemReqBO.getProductDescription());
                            orderItemPO3.setSpecificationsModel(fscOrderItemReqBO.getSpecificationsModel());
                        } else {
                            this.dealDescAndModel(orderItemPO3, reqBO);
                        }
                        if (fscOrderItemReqBO.getNum() != null && fscOrderItemReqBO.getNum().compareTo(BigDecimal.ZERO) > 0) {
                            orderItemPO3.setNum(fscOrderItemReqBO.getNum());
                            orderItemPO3.setAmt(fscOrderItemReqBO.getAmt());
                            orderItemPO3.setTaxAmt(TaxUtils.calTaxAmt((BigDecimal)orderItemPO3.getAmt(), (BigDecimal)orderItemPO3.getTaxRate()));
                            orderItemPO3.setUntaxAmt(orderItemPO3.getAmt().subtract(orderItemPO3.getTaxAmt()));
                            orderItemPO3.setPurchaseAmt(fscOrderItemReqBO.getNum().multiply(orderItemPO3.getPurchasePrice()));
                            BigDecimal purchaseTaxAmt = TaxUtils.calTaxAmt((BigDecimal)orderItemPO3.getPurchaseAmt(), (BigDecimal)orderItemPO3.getTaxRate());
                            orderItemPO3.setPurchaseUntaxAmt(orderItemPO3.getPurchaseAmt().subtract(purchaseTaxAmt));
                            if (orderItemPO3.getSalesUnitRate() != null && orderItemPO3.getSalesUnitRate().compareTo(BigDecimal.ZERO) > 0) {
                                orderItemPO3.setSettlePrice(orderItemPO3.getPrice().divide(orderItemPO3.getSalesUnitRate(), 8, 4));
                                orderItemPO3.setSettleNum(orderItemPO3.getNum().multiply(orderItemPO3.getSalesUnitRate()));
                            }
                            if (fscOrderItemReqBO.getNum().multiply(orderItemPO3.getPrice()).setScale(2, 4).compareTo(fscOrderItemReqBO.getAmt()) != 0) {
                                throw new FscBusinessException("198888", "\u524d\u7aef\u63d0\u4ea4\u660e\u7ec6\u884c\u91d1\u989d\u4e0e\u540e\u7aef\u8ba1\u7b97\u4e0d\u4e00\u81f4\uff01");
                            }
                        }
                        insertPos.add(orderItemPO3);
                    }
                }
                if (!CollectionUtils.isEmpty(insertPos)) {
                    insertPos.forEach(insertPo -> insertPo.setId(Long.valueOf(Sequence.getInstance().nextId())));
                    this.fscOrderItemMapper.insertBatch(insertPos);
                }
            }
        }
        if (!CollectionUtils.isEmpty(reqBO.getAcceptOrderIds())) {
            int count;
            List fscOrderRelationPOS = this.fscOrderItemMapper.getSumAmtByAccpetOrderId(reqBO.getAcceptOrderIds(), reqBO.getFscOrderId());
            if (!reqBO.getPayType().equals(FscConstants.FscPayType.FSC_PAY_TYPE_STAGE)) {
                for (FscOrderRelationPO fscOrderRelationPO : fscOrderRelationPOS) {
                    fscOrderRelationPO.setAmount(fscOrderRelationPO.getSettleAmt());
                }
            }
            if ((count = this.fscOrderRelationMapper.updateBatchByList(fscOrderRelationPOS)) < 1) {
                throw new FscBusinessException("190000", "\u7ed3\u7b97\u660e\u7ec6\u66f4\u65b0\u5931\u8d25\uff01");
            }
            count = this.fscOrderRelationMapper.checkSettleAmt(reqBO.getFscOrderId());
            if (count > 0) {
                throw new FscBusinessException("190000", "\u63d0\u7968\u91d1\u989d\u5f02\u5e38\uff01");
            }
            count = this.fscOrderMapper.checkSettleAmt(reqBO.getFscOrderId());
            if (count > 0) {
                throw new FscBusinessException("190000", "\u63d0\u7968\u91d1\u989d\u5f02\u5e38\uff01");
            }
        }
        if (reqBO.getOperType() == 1) {
            if (FscConstants.FscInvoiceOrderState.DRAFT.equals(reqBO.getCurStatus())) {
                FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderStatusStartAtomReqBO.class);
                fscOrderStatusStartAtomReqBO.setOrderId(reqBO.getFscOrderId());
                HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
                if (reqBO.getMakeType().equals(FscConstants.FscOrderMakeType.OPERTION)) {
                    if (reqBO.getIsprofess().equals("0")) {
                        paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.OPERATION_APPROVAL);
                    } else {
                        paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.PURCHASE_NOT_CHECK);
                    }
                } else if (reqBO.getMakeType().equals(FscConstants.FscOrderMakeType.SUPPLIER)) {
                    paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.OPERATION_NOT_CHECK);
                } else if (reqBO.getMakeType().equals(FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE)) {
                    paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.ELECTRONIC);
                }
                fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
                FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
                if (!"0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) {
                    throw new FscBusinessException("193008", fscOrderStatusStartAtomRspBO.getRespDesc());
                }
            } else if ("1".equals(reqBO.getIsprofess())) {
                FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
                fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
                fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
                fscOrderStatusFlowAtomReqBO.setOrderId(reqBO.getFscOrderId());
                fscOrderStatusFlowAtomReqBO.setCurStatus(reqBO.getCurStatus());
                this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
            }
            if ("0".equals(reqBO.getIsprofess())) {
                FscBillSendSaleFscOrderApplyAbilityReqBO abilityReqBO = (FscBillSendSaleFscOrderApplyAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscBillSendSaleFscOrderApplyAbilityReqBO.class);
                this.dealApproval(abilityReqBO, reqBO.getFscOrderId(), reqBO.getCurStatus());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealApproval(FscBillSendSaleFscOrderApplyAbilityReqBO reqBO, Long fscOrderId, Integer curStatus) {
        FscOrderPO order = new FscOrderPO();
        order.setFscOrderId(fscOrderId);
        order = this.fscOrderMapper.getModelBy(order);
        this.fscOrderMapper.deleteOrderSendTemp(fscOrderId);
        FscOrderPO fscSendTemp = (FscOrderPO)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscOrderPO.class);
        fscSendTemp.setFscOrderId(fscOrderId);
        fscSendTemp.setYcDeptId(reqBO.getDeptId().toString());
        fscSendTemp.setYcDeptName(reqBO.getDeptName());
        fscSendTemp.setYcPersonId(reqBO.getPersonId().toString());
        fscSendTemp.setYcPersonName(reqBO.getPersonName());
        fscSendTemp.setBuynerNo(order.getBuynerNo());
        fscSendTemp.setBuynerName(order.getBuynerName());
        log.debug("========\u63a8\u9001\u9500\u552e\u5355\u7533\u8bf7\u4e34\u65f6\u4fdd\u5b58\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)fscSendTemp));
        this.fscOrderMapper.insertOrderSendTemp(fscSendTemp);
        this.invokeUacTask(reqBO, fscOrderId);
        FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
        taskPo.setFscOrderId(fscOrderId);
        List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setSignApplyTime(new Date());
        if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
            List auditedPostIdList = pendAuditPostIdList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
            fscOrderPO.setSendStation(Joiner.on((String)",").join(auditedPostIdList) + ",");
        }
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setSendState(FscOrderSendStateEnum.NO_AUDIT.getCode());
        fscOrderPO.setSendApplyTime(new Date());
        fscOrderPO.setSendUserId(reqBO.getUserId());
        fscOrderPO.setSendUserName(reqBO.getName());
        fscOrderPO.setOperatorId(reqBO.getUserId());
        fscOrderPO.setOperatorName(reqBO.getName());
        String operationNo = String.valueOf(reqBO.getOrgId());
        String[] org = this.proOrg.split(",");
        String[] pur = reqBO.getOrgPath().split("-");
        block0: for (String pro : org) {
            for (String t : pur) {
                if (!pro.equals(t)) continue;
                operationNo = pro;
                continue block0;
            }
        }
        fscOrderPO.setOperationNo(operationNo);
        this.fscOrderMapper.updateById(fscOrderPO);
        if (reqBO.getWebSource() != null && reqBO.getWebSource().equals(FscConstants.FscWebSource.AGR_DOWN) && !FscConstants.FscInvoiceOrderState.DRAFT.equals(curStatus)) {
            this.dealWorkFlow(order);
        }
    }

    private void invokeUacTask(FscBillSendSaleFscOrderApplyAbilityReqBO reqBO, Long l) {
        UacNoTaskAuditCreateReqBO auditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        auditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        auditCreateReqBO.setCreateOperName(reqBO.getName());
        auditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        auditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        auditCreateReqBO.setMenuId("M001007");
        auditCreateReqBO.setOrgId(reqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(l);
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(l.toString());
        approvalObjBO.setObjName("\u9500\u552e\u7ed3\u7b97\u5355\u5ba1\u6279");
        approvalObjBO.setObjType(FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL);
        approvalObjBOList.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        auditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        log.info("\u5ba1\u6279\u5165\u53c2================" + JSON.toJSONString((Object)auditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("191019", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u7ed3\u7b97\u5355\u5ba1\u6279\u6d41\uff01");
        }
    }

    private void dealWorkFlow(FscOrderPO fscOrderPo) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderPo.getFscOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(fscOrderPo.getOrderState());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("confirmFlag", FscConstants.BillOrderConfirmFlag.CONFIRM);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
    }

    public void dealDescAndModel(FscOrderItemPO fscOrderItemPO, FscBillOrderUpdateBusiReqBO reqBO) {
        if ("2".equals(reqBO.getOrderSource())) {
            if (FscInvoiceValueTypeEnum.PLAN_MATERIAL.getCode().equals(reqBO.getInvoiceValueType()) && !StringUtils.isEmpty((Object)fscOrderItemPO.getPlanItemName())) {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getPlanItemName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getPlanItemSpecification(), null, fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getPlanItemCode()));
            } else if (FscInvoiceValueTypeEnum.AGREE_MATERIAL.getCode().equals(reqBO.getInvoiceValueType()) && !StringUtils.isEmpty((Object)fscOrderItemPO.getSkuMaterialName())) {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuMaterialName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getMaterialSpec(), fscOrderItemPO.getMaterialModel(), fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getSkuMaterialId()));
            } else {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), null, null));
            }
        } else if ("1".equals(reqBO.getOrderSource())) {
            if (FscInvoiceValueTypeEnum.PLAN_MATERIAL.getCode().equals(reqBO.getInvoiceValueType())) {
                if (!StringUtils.isEmpty((Object)fscOrderItemPO.getPlanItemName())) {
                    fscOrderItemPO.setProductDescription(fscOrderItemPO.getPlanItemName());
                    fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getPlanItemSpecification(), null, fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getPlanItemCode()));
                } else if (!StringUtils.isEmpty((Object)fscOrderItemPO.getSkuMaterialName())) {
                    fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuMaterialName());
                    fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getMaterialSpec(), fscOrderItemPO.getMaterialModel(), fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getSkuMaterialId()));
                } else {
                    fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuName());
                    fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), null, null));
                }
            } else if (FscInvoiceValueTypeEnum.AGREE_MATERIAL.getCode().equals(reqBO.getInvoiceValueType())) {
                if (!StringUtils.isEmpty((Object)fscOrderItemPO.getSkuMaterialName())) {
                    fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuMaterialName());
                    fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getMaterialSpec(), fscOrderItemPO.getMaterialModel(), fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getSkuMaterialId()));
                } else if (!StringUtils.isEmpty((Object)fscOrderItemPO.getPlanItemName())) {
                    fscOrderItemPO.setProductDescription(fscOrderItemPO.getPlanItemName());
                    fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getPlanItemSpecification(), null, fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getPlanItemCode()));
                } else {
                    fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuName());
                    fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), null, null));
                }
            } else {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), null, null));
            }
        }
    }

    public String dealSpecificationsModel(String spec, String model, String materialBJ, String materialId) {
        if (!StringUtils.isEmpty((Object)materialId) && materialId.startsWith("61")) {
            return "";
        }
        String specificationsModel = "";
        specificationsModel = !StringUtils.isEmpty((Object)spec) && !StringUtils.isEmpty((Object)model) && !StringUtils.isEmpty((Object)materialBJ) ? spec + "|" + model + "|" + materialBJ : (!StringUtils.isEmpty((Object)spec) && !StringUtils.isEmpty((Object)model) ? spec + "|" + model : (!StringUtils.isEmpty((Object)model) && !StringUtils.isEmpty((Object)materialBJ) ? model + "|" + materialBJ : (!StringUtils.isEmpty((Object)spec) && !StringUtils.isEmpty((Object)materialBJ) ? spec + "|" + materialBJ : (!StringUtils.isEmpty((Object)spec) ? spec : (!StringUtils.isEmpty((Object)model) ? model : materialBJ)))));
        if (!StringUtils.isEmpty((Object)specificationsModel) && specificationsModel.length() > 40) {
            return specificationsModel.substring(0, 40);
        }
        return specificationsModel;
    }
}

