/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bill.ability.bo.FscRecvClaimChangeBO;
import com.tydic.fsc.bill.busi.api.FscClaimChangePageListBusiService;
import com.tydic.fsc.bill.busi.bo.FscClaimChangePageListBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscClaimChangePageListBusiRspBO;
import com.tydic.fsc.bo.FscClaimDetailChangeBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.dao.FscClaimDetailChangeMapper;
import com.tydic.fsc.dao.FscRecvClaimChangeMapper;
import com.tydic.fsc.enums.FscRecvTypeEnum;
import com.tydic.fsc.enums.FscSystemSourceEnum;
import com.tydic.fsc.po.FscClaimDetailChangePO;
import com.tydic.fsc.po.FscRecvClaimChangePO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class FscClaimChangePageListBusiServiceImpl
implements FscClaimChangePageListBusiService {
    @Autowired
    private FscRecvClaimChangeMapper fscRecvClaimChangeMapper;
    @Autowired
    private FscClaimDetailChangeMapper fscClaimDetailChangeMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @Override
    public FscClaimChangePageListBusiRspBO getList(FscClaimChangePageListBusiReqBO reqBO) {
        FscClaimChangePageListBusiRspBO rspBO = new FscClaimChangePageListBusiRspBO();
        FscRecvClaimChangePO fscRecvClaimChangePO = (FscRecvClaimChangePO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscRecvClaimChangePO.class);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List changeListPage = this.fscRecvClaimChangeMapper.getListPage(fscRecvClaimChangePO, page);
        List changeListPageBo = JSON.parseArray((String)JSON.toJSONString((Object)changeListPage), FscRecvClaimChangeBO.class);
        Map<Object, Object> detailListMap = new HashMap();
        Map orderStatus = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_CLAIM_CHANGE_ORDER_STATUS ");
        Map pushStatus = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_CLAIM_CHANGE_PUSH_STATUS ");
        Map ConfirmStatus = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_CLAIM_CHANGE_CONFIRM_STATUS ");
        Map busiType = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_CLAIM_CHANGE_BUSI_TYPE");
        if (!CollectionUtils.isEmpty((Collection)changeListPageBo)) {
            List changeIds = changeListPageBo.stream().map(FscRecvClaimChangeBO::getChangeId).collect(Collectors.toList());
            FscClaimDetailChangePO fscClaimDetailChangePO = new FscClaimDetailChangePO();
            fscClaimDetailChangePO.setChangeIds(changeIds);
            this.build(reqBO, fscClaimDetailChangePO);
            List detailList = this.fscClaimDetailChangeMapper.queryAll(fscClaimDetailChangePO);
            detailListMap = detailList.stream().collect(Collectors.groupingBy(FscClaimDetailChangePO::getChangeId));
        }
        for (FscRecvClaimChangeBO bo : changeListPageBo) {
            List detailChangeBOS = JSON.parseArray((String)JSON.toJSONString(detailListMap.get(bo.getChangeId())), FscClaimDetailChangeBO.class);
            this.transform(bo, orderStatus, pushStatus);
            if (!CollectionUtils.isEmpty((Collection)detailChangeBOS)) {
                this.transformDetailList(detailChangeBOS, ConfirmStatus, busiType, bo);
            }
            bo.setFscClaimDetailChangeBOList(detailChangeBOS);
        }
        rspBO.setRows(changeListPageBo);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void build(FscClaimChangePageListBusiReqBO reqBO, FscClaimDetailChangePO fscClaimDetailChangePO) {
        fscClaimDetailChangePO.setConfirmStatus(reqBO.getConfirmStatus());
        fscClaimDetailChangePO.setConfirmStatusList(reqBO.getConfirmStatusList());
        fscClaimDetailChangePO.setConfirmUserName(reqBO.getConfirmUserName());
        fscClaimDetailChangePO.setConfirmDateEnd(reqBO.getConfirmDateEnd());
        fscClaimDetailChangePO.setConfirmDateBegin(reqBO.getConfirmDateBegin());
        fscClaimDetailChangePO.setBusiType(reqBO.getBusiType());
        fscClaimDetailChangePO.setChangeBusiType(reqBO.getChangeBusiType());
        fscClaimDetailChangePO.setOrderCode(reqBO.getOrderCode());
        fscClaimDetailChangePO.setChangeOrderCode(reqBO.getChangeOrderCode());
        fscClaimDetailChangePO.setChargeNo(reqBO.getChargeNo());
        fscClaimDetailChangePO.setChangeChargeNo(reqBO.getChangeChargeNo());
        fscClaimDetailChangePO.setFscOrderNo(reqBO.getFscOrderNo());
        fscClaimDetailChangePO.setChangeFscOrderNo(reqBO.getChangeFscOrderNo());
        fscClaimDetailChangePO.setChangeDetailNo(reqBO.getChangeDetailNo());
        fscClaimDetailChangePO.setOperationNo(reqBO.getOperationNo());
        fscClaimDetailChangePO.setChangeSource(reqBO.getChangeSource());
        fscClaimDetailChangePO.setSysSource(reqBO.getSysSource());
        fscClaimDetailChangePO.setChangeAmtBegin(reqBO.getChangeAmtBegin());
        fscClaimDetailChangePO.setChangeAmtEnd(reqBO.getChangeAmtEnd());
    }

    private void transform(FscRecvClaimChangeBO bo, Map<String, String> orderStatus, Map<String, String> pushStatus) {
        if (!StringUtils.isEmpty((Object)bo.getRecvType())) {
            bo.setRecvTypeStr(FscRecvTypeEnum.getCodeDesc((String)bo.getRecvType()));
        }
        if (!ObjectUtils.isEmpty((Object)bo.getBillStatus()) && null != orderStatus) {
            bo.setBillStatusStr(orderStatus.get(Convert.toStr((Object)bo.getBillStatus())));
        }
        if (!ObjectUtils.isEmpty((Object)bo.getPushStatus()) && null != pushStatus) {
            bo.setPushStatusStr(pushStatus.get(Convert.toStr((Object)bo.getPushStatus())));
        }
    }

    private void transformDetailList(List<FscClaimDetailChangeBO> detailChangeBOS, Map<String, String> ConfirmStatus, Map<String, String> busiType, FscRecvClaimChangeBO changeBO) {
        for (FscClaimDetailChangeBO bo : detailChangeBOS) {
            if (!ObjectUtils.isEmpty((Object)bo.getConfirmStatus()) && null != ConfirmStatus) {
                bo.setConfirmStatusStr(ConfirmStatus.get(Convert.toStr((Object)bo.getConfirmStatus())));
            }
            if (!ObjectUtils.isEmpty((Object)bo.getBusiType()) && null != busiType) {
                bo.setBusiTypeStr(busiType.get(Convert.toStr((Object)bo.getBusiType())));
            }
            if (!ObjectUtils.isEmpty((Object)bo.getChangeBusiType()) && null != busiType) {
                bo.setChangeBusiTypeStr(busiType.get(Convert.toStr((Object)bo.getChangeBusiType())));
            }
            if (!StringUtils.isEmpty((Object)bo.getSysSource())) {
                bo.setSysSourceStr(FscSystemSourceEnum.getCodeDesc((Integer)bo.getSysSource()));
            }
            if (!StringUtils.isEmpty((Object)bo.getChangeSource())) {
                bo.setChangeSourceStr(FscSystemSourceEnum.getCodeDesc((Integer)bo.getChangeSource()));
            }
            bo.setChangeDate(changeBO.getChangeDate());
            if (null != bo.getChangeSource() && 1 == bo.getChangeSource()) {
                bo.setEchoChangeAmt(bo.getChangeAmt());
                continue;
            }
            bo.setYcChangeAmt(bo.getChangeAmt());
        }
    }
}

