/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscOrderItemBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListPageQueryReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListPageQueryRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionItemListBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocInspectionDetailsListPageQueryService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.TaxUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscAcceptOrderListQueryAtomServiceImpl
implements FscAcceptOrderListQueryAtomService {
    @Autowired
    private FscUocInspectionDetailsListPageQueryService fscUocInspectionDetailsListPageQueryService;
    @Value(value="${acceptOrderTabId:80013}")
    private Integer TAB_ID;

    @Override
    public FscAcceptOrderListQueryAtomRspBO query(FscAcceptOrderListQueryAtomReqBO reqBO) {
        FscAcceptOrderListQueryAtomRspBO rspBO = new FscAcceptOrderListQueryAtomRspBO();
        if (null == reqBO.getTabId()) {
            reqBO.setTabId(this.TAB_ID);
        }
        reqBO.setIsAfterSales(false);
        rspBO.setFscOrderInfoBoMap(this.packOrderInfo(reqBO));
        return rspBO;
    }

    private Map<Long, FscOrderInfoBO> packOrderInfo(FscAcceptOrderListQueryAtomReqBO reqBO) {
        FscUocInspectionDetailsListPageQueryReqBO fscUocInspectionDetailsListPageQueryReqBO = (FscUocInspectionDetailsListPageQueryReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscUocInspectionDetailsListPageQueryReqBO.class));
        fscUocInspectionDetailsListPageQueryReqBO.setPageSize(100000);
        FscUocInspectionDetailsListPageQueryRspBO fscUocInspectionDetailsListPageQueryRspBO = this.fscUocInspectionDetailsListPageQueryService.getInspectionDetailsList(fscUocInspectionDetailsListPageQueryReqBO);
        if (!"0000".equals(fscUocInspectionDetailsListPageQueryRspBO.getRespCode())) {
            throw new FscBusinessException("194301", fscUocInspectionDetailsListPageQueryRspBO.getRespDesc());
        }
        HashMap<Long, FscOrderInfoBO> fscOrderInfoBoMap = new HashMap<Long, FscOrderInfoBO>();
        for (FscUocInspectionDetailsListBO row : fscUocInspectionDetailsListPageQueryRspBO.getRows()) {
            FscOrderInfoBO fscOrderInfoBO = (FscOrderInfoBO)JSON.parseObject((String)JSON.toJSONString((Object)row), FscOrderInfoBO.class);
            ArrayList<FscOrderItemBO> fscOrderItemBOS = new ArrayList<FscOrderItemBO>();
            for (FscUocInspectionItemListBO fscUocInspectionItemListBO : row.getInspectionItemInfo()) {
                FscOrderItemBO fscOrderItemBO = (FscOrderItemBO)JSONObject.parseObject((String)JSON.toJSONString((Object)fscUocInspectionItemListBO), FscOrderItemBO.class);
                fscOrderItemBO.setAcceptOrderId(Long.valueOf(Long.parseLong(row.getInspectionVoucherId())));
                fscOrderItemBO.setNum(new BigDecimal(fscUocInspectionItemListBO.getInspectionCount()));
                fscOrderItemBO.setSkuIdExt(fscUocInspectionItemListBO.getExtSkuId());
                fscOrderItemBO.setTaxRate(new BigDecimal(fscUocInspectionItemListBO.getTax()).divide(new BigDecimal(100), 2, 4));
                fscOrderItemBO.setUnit(fscUocInspectionItemListBO.getUnitName());
                if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
                    fscOrderItemBO.setAmt(new BigDecimal(fscUocInspectionItemListBO.getInspSaleMoney()));
                    fscOrderItemBO.setPrice(new BigDecimal(fscUocInspectionItemListBO.getSellingPrice()));
                }
                if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                    fscOrderItemBO.setAmt(new BigDecimal(fscUocInspectionItemListBO.getInspPurchaseMoney()));
                    fscOrderItemBO.setPrice(new BigDecimal(fscUocInspectionItemListBO.getPurchasingPrice()));
                }
                if (null != fscOrderItemBO.getAmt()) {
                    fscOrderItemBO.setTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemBO.getAmt(), (BigDecimal)fscOrderItemBO.getTaxRate()));
                    fscOrderItemBO.setUntaxAmt(fscOrderItemBO.getAmt().subtract(fscOrderItemBO.getTaxAmt()));
                }
                fscOrderItemBO.setSaleAmt(new BigDecimal(fscUocInspectionItemListBO.getInspSaleMoney()));
                fscOrderItemBO.setSalePrice(new BigDecimal(fscUocInspectionItemListBO.getSellingPrice()));
                fscOrderItemBO.setSaleTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemBO.getSaleAmt(), (BigDecimal)fscOrderItemBO.getTaxRate()));
                fscOrderItemBO.setSaleUntaxAmt(fscOrderItemBO.getSaleAmt().subtract(fscOrderItemBO.getSaleTaxAmt()));
                fscOrderItemBO.setPurchaseAmt(new BigDecimal(fscUocInspectionItemListBO.getInspPurchaseMoney()));
                fscOrderItemBO.setPurchasePrice(new BigDecimal(fscUocInspectionItemListBO.getPurchasingPrice()));
                fscOrderItemBO.setPurchaseTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemBO.getPurchaseAmt(), (BigDecimal)fscOrderItemBO.getTaxRate()));
                fscOrderItemBO.setPurchaseUntaxAmt(fscOrderItemBO.getPurchaseAmt().subtract(fscOrderItemBO.getPurchaseTaxAmt()));
                fscOrderItemBO.setOrderItemId(Long.valueOf(Long.parseLong(fscUocInspectionItemListBO.getInspectionItemId())));
                fscOrderItemBOS.add(fscOrderItemBO);
            }
            fscOrderInfoBO.setAcceptOrderId(Long.valueOf(Long.parseLong(row.getInspectionVoucherId())));
            fscOrderInfoBO.setOrderId(Long.valueOf(Long.parseLong(row.getOrderId())));
            fscOrderInfoBO.setAcceptOrderNo(row.getInspectionVoucherCode());
            fscOrderInfoBO.setExtOrderNo(row.getOutOrderId());
            fscOrderInfoBO.setSupplierName(row.getSupName());
            fscOrderInfoBO.setSupplierId(row.getSupNo());
            fscOrderInfoBO.setProOrgName(row.getProName());
            fscOrderInfoBO.setProOrgId(row.getProNo());
            fscOrderInfoBO.setPurchaserName(row.getPurName());
            fscOrderInfoBO.setPurchaserId(row.getPurNo());
            fscOrderInfoBO.setPayNodeAccountDays(row.getPaymentDays());
            fscOrderInfoBO.setOrderNo(row.getSaleVoucherNo());
            fscOrderInfoBO.setBusiMode(row.getTradeMode());
            if (!StringUtils.isBlank((CharSequence)row.getPurAccount())) {
                fscOrderInfoBO.setAccountSetId(Long.valueOf(row.getPurAccount()));
            }
            fscOrderInfoBO.setAccountSetName(row.getPurAccountName());
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
                fscOrderInfoBO.setOrderNo(row.getSaleVoucherNo());
                fscOrderInfoBO.setInspTotalMoney(row.getInspTotalSaleMoney());
            }
            if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                fscOrderInfoBO.setOrderNo(row.getPurchaseVoucherNo());
                fscOrderInfoBO.setInspTotalMoney(row.getInspTotalPurchaseMoney());
            }
            fscOrderInfoBO.setFscOrderItemBOS(fscOrderItemBOS);
            fscOrderInfoBoMap.put(fscOrderInfoBO.getAcceptOrderId(), fscOrderInfoBO);
        }
        return fscOrderInfoBoMap;
    }
}

