/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.utils;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.fsc.busibase.busi.bo.FscBillMailListPageQueryBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscComInvoiceListPageQueryBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscSearchEsSQLRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class FscBuildEsQrySqlConditionUtil {
    private static Integer maxPageSize;

    @Value(value="${es.max.page.size:10000}")
    public void setMaxPageSize(Integer maxPageSize) {
        FscBuildEsQrySqlConditionUtil.maxPageSize = maxPageSize;
    }

    public String buildComOrderEsSql(FscComOrderListPageQueryBusiReqBO reqBO) {
        FieldSortBuilder sortQueryFirst;
        Number invoiceNoEnd;
        Number invoiceNoBegin;
        RangeQueryBuilder rangeQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBO.getBusiStatus() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"busiStatus", (Object)reqBO.getBusiStatus()));
        }
        if (reqBO.getSupplierId() != null && reqBO.getSupplierId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplierId", (Object)reqBO.getSupplierId()));
        }
        if (reqBO.getQueryId() != null && reqBO.getQueryId() != 0L) {
            BoolQueryBuilder shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"payerId", (Object)reqBO.getQueryId()));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"payeeId", (Object)reqBO.getQueryId()));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (reqBO.getPurchaserId() != null && reqBO.getPurchaserId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purchaserId", (Object)reqBO.getPurchaserId()));
        }
        if (reqBO.getBuynerNo() != null && reqBO.getBuynerNo() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"buynerNo", (Object)reqBO.getBuynerNo()));
        }
        if (reqBO.getProOrgId() != null && reqBO.getProOrgId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"proOrgId", (Object)reqBO.getProOrgId()));
        }
        if (reqBO.getCreateOperId() != null && reqBO.getCreateOperId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (Object)reqBO.getCreateOperId()));
        }
        if (reqBO.getCreateOrgId() != null && reqBO.getCreateOrgId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOrgId", (Object)reqBO.getCreateOrgId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderNo.keyword", (String)("*" + reqBO.getOrderNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderNo.keyword", (String)("*" + reqBO.getSaleOrderNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupplierName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"supplierName.keyword", (String)("*" + reqBO.getSupplierName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurchaserName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purchaserName.keyword", (String)("*" + reqBO.getPurchaserName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderConfirmName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderConfirmName.keyword", (String)("*" + reqBO.getOrderConfirmName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"createOperName.keyword", (String)("*" + reqBO.getCreateOperName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getExtOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"extOrderNo.keyword", (String)("*" + reqBO.getExtOrderNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getFscOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"fscOrderNo.keyword", (String)("*" + reqBO.getFscOrderNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPayOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"payOperName.keyword", (String)("*" + reqBO.getPayOperName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPayConfirmName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"payConfirmName.keyword", (String)("*" + reqBO.getPayConfirmName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAcceptOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"acceptOrderNo.keyword", (String)("*" + reqBO.getAcceptOrderNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getDiscountOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"discountOperName.keyword", (String)("*" + reqBO.getDiscountOperName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPreviousHandler())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"previousHandler.keyword", (String)("*" + reqBO.getPreviousHandler() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAuditOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"auditOperName.keyword", (String)("*" + reqBO.getAuditOperName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeBegin()) || StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEnd())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"createTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeBegin())) {
                rangeQueryBuilder.gte((Object)this.getTime(reqBO.getCreateTimeBegin()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEnd())) {
                rangeQueryBuilder.lte((Object)this.getTime(reqBO.getCreateTimeEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getArrivalTimeStart()) || StringUtils.isNotBlank((CharSequence)reqBO.getArrivalTimeEnd())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"arrivalTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getArrivalTimeStart())) {
                rangeQueryBuilder.gte((Object)this.getTime(reqBO.getArrivalTimeStart()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getArrivalTimeEnd())) {
                rangeQueryBuilder.lte((Object)this.getTime(reqBO.getArrivalTimeEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAuditTimeStart()) || StringUtils.isNotBlank((CharSequence)reqBO.getAuditTimeEnd())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"auditTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getAuditTimeStart())) {
                rangeQueryBuilder.gte((Object)this.getTime(reqBO.getAuditTimeStart()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getAuditTimeEnd())) {
                rangeQueryBuilder.lte((Object)this.getTime(reqBO.getAuditTimeEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPayConfirmTimeStart()) || StringUtils.isNotBlank((CharSequence)reqBO.getPayConfirmTimeEnd())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"payConfirmTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getPayConfirmTimeStart())) {
                rangeQueryBuilder.gte((Object)this.getTime(reqBO.getPayConfirmTimeStart()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getPayConfirmTimeEnd())) {
                rangeQueryBuilder.lte((Object)this.getTime(reqBO.getPayConfirmTimeEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getBillTimeBegin()) || StringUtils.isNotBlank((CharSequence)reqBO.getBillTimeEnd())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"billTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getBillTimeBegin())) {
                rangeQueryBuilder.gte((Object)this.getTime(reqBO.getBillTimeBegin()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getBillTimeEnd())) {
                rangeQueryBuilder.lte((Object)this.getTime(reqBO.getBillTimeEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (null != reqBO.getBillDateBegin() || null != reqBO.getBillDateEnd()) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"billDate");
            if (null != reqBO.getBillDateBegin()) {
                rangeQueryBuilder.gte((Object)reqBO.getBillDateBegin().getTime());
            }
            if (null != reqBO.getBillDateEnd()) {
                rangeQueryBuilder.lte((Object)reqBO.getBillDateEnd().getTime());
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderConfirmTimeStart()) || StringUtils.isNotBlank((CharSequence)reqBO.getOrderConfirmTimeEnd())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"orderConfirmTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderConfirmTimeStart())) {
                rangeQueryBuilder.gte((Object)this.getTime(reqBO.getOrderConfirmTimeStart()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderConfirmTimeEnd())) {
                rangeQueryBuilder.lte((Object)this.getTime(reqBO.getOrderConfirmTimeEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSignTimeBegin()) || StringUtils.isNotBlank((CharSequence)reqBO.getSignTimeEnd())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"signTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSignTimeBegin())) {
                Date begin = DateUtils.strToDate((String)reqBO.getSignTimeBegin());
                Long signTimeBegin = begin.getTime();
                rangeQueryBuilder.gte((Object)signTimeBegin);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSignTimeEnd())) {
                Date end = DateUtils.strToDate((String)reqBO.getSignTimeEnd());
                Long signTimeEnd = end.getTime();
                rangeQueryBuilder.lte((Object)signTimeEnd);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getInvoiceType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"invoiceType", (Object)reqBO.getInvoiceType()));
        }
        if (reqBO.getBillCycle() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"billCycle", (Object)reqBO.getBillCycle()));
        }
        if (reqBO.getCreditAmount() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"creditAmount", (Object)reqBO.getCreditAmount()));
        }
        if (reqBO.getAuditType() != null && (long)reqBO.getAuditType().intValue() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"auditType", (Object)reqBO.getAuditType()));
        }
        if (null != reqBO.getInvoiceCategory()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"invoiceCategory", (Object)reqBO.getInvoiceCategory()));
        }
        if (null != reqBO.getCreditAmount()) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"creditAmount");
            BigDecimal creditAmount = reqBO.getCreditAmount();
            rangeQueryBuilder.gte((Object)creditAmount);
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getInvoiceNoBegin()) || StringUtils.isNotBlank((CharSequence)reqBO.getInvoiceNoEnd())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"invoiceNo");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getInvoiceNoBegin())) {
                invoiceNoBegin = Long.parseLong(reqBO.getInvoiceNoBegin());
                rangeQueryBuilder.gte((Object)invoiceNoBegin);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getInvoiceNoEnd())) {
                invoiceNoEnd = Long.parseLong(reqBO.getInvoiceNoEnd());
                rangeQueryBuilder.lte((Object)invoiceNoEnd);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getDiscountOperTimeStart()) || StringUtils.isNotBlank((CharSequence)reqBO.getDiscountOperTimeEnd())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"discountOperTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getDiscountOperTimeStart())) {
                rangeQueryBuilder.gte((Object)this.getTime(reqBO.getDiscountOperTimeStart()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getDiscountOperTimeEnd())) {
                rangeQueryBuilder.lte((Object)this.getTime(reqBO.getDiscountOperTimeEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getBuyName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"buyName", (Object)reqBO.getBuyName()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getTaskOperIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"taskOperIdList", reqBO.getTaskOperIdList()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getAuditStatuss())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"auditStatus", reqBO.getAuditStatuss()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getAuditedTaskOperIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"auditedTaskOperIdList", reqBO.getAuditedTaskOperIdList()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getAuditedPostIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"auditedPostIdList", reqBO.getAuditedPostIdList()));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getConsignee())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"receiverName.keyword", (String)("*" + reqBO.getConsignee() + "*")));
        }
        if (!CollectionUtils.isEmpty(reqBO.getInspectionOper())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"inspectionOper", reqBO.getInspectionOper()));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getBuyer())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purPlaceOrderName.keyword", (String)("*" + reqBO.getBuyer() + "*")));
        }
        if (reqBO.getAccountSetId() != null && reqBO.getAccountSetId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"accountSetId", (Object)reqBO.getAccountSetId()));
        }
        if (null != reqBO.getOrderSource() && reqBO.getOrderSource() != 0) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderSource", (Object)reqBO.getOrderSource()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getOrderFlows())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderFlow", reqBO.getOrderFlows()));
        }
        if (reqBO.getBuildAction() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"buildAction", (Object)reqBO.getBuildAction()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getPayerIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"payerId", reqBO.getPayerIds()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getPayeeIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"payeeId", reqBO.getPayeeIds()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getOrderStates())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderState", reqBO.getOrderStates()));
        }
        if (null != reqBO.getBusiCategory()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"busiCategory", (Object)reqBO.getBusiCategory()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPayChannel())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"payChannel", (String)reqBO.getPayChannel()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getTransactionId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"transactionId.keyword", (String)("*" + reqBO.getTransactionId() + "*")));
        }
        if (null != reqBO.getTotalChargeStart() || null != reqBO.getTotalChargeEnd()) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"totalCharge");
            if (null != reqBO.getTotalChargeStart()) {
                invoiceNoBegin = reqBO.getTotalChargeStart().doubleValue();
                rangeQueryBuilder.gte((Object)invoiceNoBegin);
            }
            if (null != reqBO.getTotalChargeEnd()) {
                invoiceNoEnd = reqBO.getTotalChargeEnd().doubleValue();
                rangeQueryBuilder.lte((Object)invoiceNoEnd);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getShouldPayDateStart())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"shouldPayDateStart");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getShouldPayDateStart())) {
                rangeQueryBuilder.gte((Object)this.getTime(reqBO.getShouldPayDateStart()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getShouldPayDateEnd())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"shouldPayDateEnd");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getShouldPayDateEnd())) {
                rangeQueryBuilder.gte((Object)this.getTime(reqBO.getShouldPayDateEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPayTimeStart()) || StringUtils.isNotBlank((CharSequence)reqBO.getPayTimeEnd())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"payTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getPayTimeStart())) {
                rangeQueryBuilder.gte((Object)this.getTime(reqBO.getPayTimeStart()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getPayTimeEnd())) {
                rangeQueryBuilder.lte((Object)this.getTime(reqBO.getPayTimeEnd()));
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (!CollectionUtils.isEmpty(reqBO.getShouldPayTypes())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"shouldPayType", reqBO.getShouldPayTypes()));
        }
        if (reqBO.getMakeType() != null && (long)reqBO.getMakeType().intValue() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"makeType", (Object)reqBO.getMakeType()));
        }
        if (reqBO.getReceiveType() != null && (long)reqBO.getReceiveType().intValue() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"receiveType", (Object)reqBO.getReceiveType()));
        }
        SortOrder order = SortOrder.DESC;
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        if (reqBO.getOrderBy() != null) {
            order = SortOrder.ASC;
            sortQueryFirst = (FieldSortBuilder)SortBuilders.fieldSort((String)reqBO.getOrderBy()).order(order);
        } else {
            sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(order)).unmappedType("date");
        }
        if (!CollectionUtils.isEmpty(reqBO.getFscOrderIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"fscOrderId", reqBO.getFscOrderIds()));
        }
        if (reqBO.getFscOrderId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"fscOrderId", (Object)reqBO.getFscOrderId()));
        }
        if ("3".equals(reqBO.getWebSource())) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"parentOrderId"));
        } else if ("4".equals(reqBO.getWebSource())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)"parentOrderId"));
        }
        FscSearchEsSQLRspBO fscSearchEsSQLRspBO = new FscSearchEsSQLRspBO();
        fieldSortBuilders.add(sortQueryFirst);
        fscSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        fscSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        fscSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        fscSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(fscSearchEsSQLRspBO);
    }

    public String buildComInvoiceEsSql(FscComInvoiceListPageQueryBusiReqBO reqBO) {
        FieldSortBuilder sortQueryFirst;
        RangeQueryBuilder rangeQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBO.getMakeType() != null && (long)reqBO.getMakeType().intValue() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"makeType", (Object)reqBO.getMakeType()));
        }
        if (reqBO.getReceiveType() != null && (long)reqBO.getReceiveType().intValue() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"receiveType", (Object)reqBO.getReceiveType()));
        }
        if (reqBO.getInvoiceId() != null && reqBO.getInvoiceId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"invoiceId", (Object)reqBO.getInvoiceId()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getInvoiceIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"invoiceId", reqBO.getInvoiceIds()));
        }
        if (reqBO.getFscOrderId() != null && reqBO.getFscOrderId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"fscOrderId", (Object)reqBO.getFscOrderId()));
        }
        if (!CollectionUtils.isEmpty(reqBO.getFscOrderIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"fscOrderId", reqBO.getFscOrderIds()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupplierId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"supplierId.keyword", (String)("*" + reqBO.getSupplierId() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurchaserId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purchaserId.keyword", (String)("*" + reqBO.getPurchaserId() + "*")));
        }
        if (reqBO.getBillDateStart() != null || reqBO.getBillDateEnd() != null) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"billDate");
            if (reqBO.getBillDateStart() != null) {
                long billDateStart = reqBO.getBillDateStart().getTime();
                rangeQueryBuilder.gte((Object)billDateStart);
            }
            if (reqBO.getBillDateEnd() != null) {
                Long billDateEnd = reqBO.getBillDateEnd().getTime();
                rangeQueryBuilder.lte((Object)billDateEnd);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (reqBO.getBillTimeStart() != null || reqBO.getBillTimeEnd() != null) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"billTime");
            if (reqBO.getBillTimeStart() != null) {
                long billTimeStart = reqBO.getBillTimeStart().getTime();
                rangeQueryBuilder.gte((Object)billTimeStart);
            }
            if (reqBO.getBillTimeEnd() != null) {
                Long billTimeEnd = reqBO.getBillTimeEnd().getTime();
                rangeQueryBuilder.lte((Object)billTimeEnd);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (reqBO.getSignTimeStart() != null || reqBO.getSignTimeEnd() != null) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"signTime");
            if (reqBO.getSignTimeStart() != null) {
                long signTimeStart = reqBO.getSignTimeStart().getTime();
                rangeQueryBuilder.gte((Object)signTimeStart);
            }
            if (reqBO.getSignTimeEnd() != null) {
                Long signTimeEnd = reqBO.getSignTimeEnd().getTime();
                rangeQueryBuilder.lte((Object)signTimeEnd);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getInvoiceType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"invoiceType", (Object)reqBO.getInvoiceType()));
        }
        if (null != reqBO.getInvoiceCategory()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"invoiceCategory", (Object)reqBO.getInvoiceCategory()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderNo.keyword", (String)("*" + reqBO.getOrderNo() + "*")));
        }
        SortOrder order = SortOrder.DESC;
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        if (reqBO.getOrderBy() != null) {
            order = SortOrder.ASC;
            sortQueryFirst = (FieldSortBuilder)SortBuilders.fieldSort((String)reqBO.getOrderBy()).order(order);
        } else {
            sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(order)).unmappedType("date");
        }
        FscSearchEsSQLRspBO fscSearchEsSQLRspBO = new FscSearchEsSQLRspBO();
        fieldSortBuilders.add(sortQueryFirst);
        fscSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        fscSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        fscSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        fscSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(fscSearchEsSQLRspBO);
    }

    private String getQueryString(FscSearchEsSQLRspBO uocSearchEsSQLRspBO) {
        if (uocSearchEsSQLRspBO.getPageNo() <= 0) {
            uocSearchEsSQLRspBO.setPageNo(1);
        }
        JSONObject queryJson = new JSONObject();
        if (maxPageSize < uocSearchEsSQLRspBO.getPageSize()) {
            queryJson.put("size", (Object)maxPageSize);
        } else {
            queryJson.put("size", (Object)uocSearchEsSQLRspBO.getPageSize());
        }
        queryJson.put("from", (Object)(uocSearchEsSQLRspBO.getPageSize() * (uocSearchEsSQLRspBO.getPageNo() - 1)));
        String queryString = uocSearchEsSQLRspBO.getBoolQueryBuilder().toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        String sortString = uocSearchEsSQLRspBO.getSortQuery().toString();
        queryJson.put("sort", (Object)JSON.parseArray((String)sortString));
        return queryJson.toJSONString();
    }

    public String buildBillMailEsSql(FscBillMailListPageQueryBusiReqBO reqBO) {
        FieldSortBuilder sortQueryFirst;
        RangeQueryBuilder rangeQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBO.getMakeId() != null && reqBO.getMakeId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"makeId", (Object)reqBO.getMakeId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getMakeName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"makeName", (String)reqBO.getMakeName()));
        }
        if (reqBO.getReceiveId() != null && reqBO.getReceiveId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"receiveId", (Object)reqBO.getReceiveId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getReceiveName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"receiveName", (String)reqBO.getReceiveName()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getBuyName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"buyName", (Object)reqBO.getBuyName()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getMailStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"mailStatus", (String)reqBO.getMailStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderNo.keyword", (String)("*" + reqBO.getOrderNo() + "*")));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getInvoiceNoStart())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"invoiceNoMax");
            if (reqBO.getInvoiceNoStart() != null) {
                String invoiceNoStart = reqBO.getInvoiceNoStart();
                rangeQueryBuilder.lte((Object)invoiceNoStart);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getInvoiceNoEnd())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"invoiceNoMin");
            if (reqBO.getInvoiceNoStart() != null) {
                String invoiceNoEnd = reqBO.getInvoiceNoEnd();
                rangeQueryBuilder.gte((Object)invoiceNoEnd);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getBillDateStart())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"billDateMax");
            if (reqBO.getBillDateStart() != null) {
                String billDateStart = reqBO.getBillDateStart();
                billDateStart = billDateStart.substring(0, 10);
                rangeQueryBuilder.lt((Object)billDateStart);
            }
            boolQueryBuilder.mustNot((QueryBuilder)rangeQueryBuilder);
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getBillDateEnd())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"billDateMin");
            if (reqBO.getBillDateEnd() != null) {
                String billDateEnd = reqBO.getBillDateEnd();
                billDateEnd = billDateEnd.substring(0, 10);
                rangeQueryBuilder.gt((Object)billDateEnd);
            }
            boolQueryBuilder.mustNot((QueryBuilder)rangeQueryBuilder);
        }
        SortOrder order = SortOrder.DESC;
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        if (reqBO.getOrderBy() != null) {
            order = SortOrder.ASC;
            sortQueryFirst = (FieldSortBuilder)SortBuilders.fieldSort((String)reqBO.getOrderBy()).order(order);
        } else {
            sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(order)).unmappedType("date");
        }
        FscSearchEsSQLRspBO fscSearchEsSQLRspBO = new FscSearchEsSQLRspBO();
        fieldSortBuilders.add(sortQueryFirst);
        fscSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        fscSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        fscSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        fscSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(fscSearchEsSQLRspBO);
    }

    private long getTime(String time) {
        long timeStamp;
        try {
            timeStamp = DateUtil.parseDate((CharSequence)time).getTime();
        }
        catch (Exception e) {
            timeStamp = Long.parseLong(time);
        }
        return timeStamp;
    }
}

