/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscCreditDeductAtomBO;
import com.tydic.fsc.busibase.atom.api.FscCreditDeductAtomService;
import com.tydic.fsc.busibase.atom.bo.FscCreditDeductAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscCreditDeductAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCreditBalanceMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscCreditBalancePO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.uoc.common.ability.api.PebExtSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.api.UocInspectionDetailsListPageQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.PebExtSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.PebExtSalesSingleDetailsListQueryRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUpperOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscCreditDeductAtomServiceImpl
implements FscCreditDeductAtomService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscCreditBalanceMapper fscCreditBalanceMapper;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private UocInspectionDetailsListPageQueryAbilityService uocInspectionDetailsListPageQueryAbilityService;
    @Autowired
    private PebExtSalesSingleDetailsListQueryAbilityService pebExtSalesSingleDetailsListQueryAbilityService;
    private static final Integer IS_CREDIT = 1;

    @Override
    public FscCreditDeductAtomRspBO dealAccountDeduct(FscCreditDeductAtomReqBO reqBO) {
        FscMerchantPO fscMerchantPo = new FscMerchantPO();
        fscMerchantPo.setOrgId(reqBO.getSupId());
        fscMerchantPo.setDelFlag(FscConstants.DicDelFlag.NO);
        fscMerchantPo.setPayBusiSceneRangeLike(reqBO.getPayBusiness());
        fscMerchantPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        fscMerchantPo = this.fscMerchantMapper.getModelBy(fscMerchantPo);
        if (null == fscMerchantPo) {
            throw new FscBusinessException("194304", "\u67e5\u8be2\u5546\u6237\u4e3a\u7a7a");
        }
        FscMerchantPO merchant = new FscMerchantPO();
        merchant.setPayBusiSceneRangeLike(reqBO.getPayBusiness());
        merchant.setParentId(fscMerchantPo.getMerchantId());
        merchant.setDelFlag(FscConstants.DicDelFlag.NO);
        merchant.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
        merchant.setPayObjId(reqBO.getCreditOrgId());
        merchant = this.fscMerchantMapper.getModelBy(merchant);
        if (null != merchant) {
            BeanUtils.copyProperties((Object)merchant, (Object)fscMerchantPo);
        }
        FscCreditBalancePO fscCreditBalancePo = new FscCreditBalancePO();
        fscCreditBalancePo.setMerchantId(fscMerchantPo.getMerchantId());
        fscCreditBalancePo.setPurOrgId(reqBO.getCreditOrgId());
        fscCreditBalancePo.setPayBusiness(reqBO.getPayBusiness());
        FscCreditBalancePO fscCreditBalance = this.fscCreditBalanceMapper.getModelBy(fscCreditBalancePo);
        BigDecimal totalAmt = reqBO.getFscCreditDeductAtomBOS().stream().map(FscCreditDeductAtomBO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (null == fscCreditBalance) {
            if (fscMerchantPo.getPayCreditAmount() == null) {
                throw new FscBusinessException("194304", "\u5546\u6237\u6388\u4fe1\u989d\u5ea6\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u7f6e\u6388\u4fe1\u989d\u5ea6\u3002");
            }
            fscCreditBalancePo.setAvailableAmount(fscMerchantPo.getPayCreditAmount().subtract(totalAmt));
            fscCreditBalancePo.setCreditAmount(fscMerchantPo.getPayCreditAmount());
            fscCreditBalancePo.setPayBusiness(reqBO.getPayBusiness());
            fscCreditBalancePo.setUsedAmount(totalAmt);
            fscCreditBalancePo.setUpdateTime(new Date());
            fscCreditBalancePo.setTotalCostAmout(totalAmt);
            fscCreditBalancePo.setReturnedAmout(BigDecimal.ZERO);
            this.fscCreditBalanceMapper.insert(fscCreditBalancePo);
        } else {
            int i;
            if (totalAmt.compareTo(BigDecimal.ZERO) > 0) {
                fscCreditBalance.setTotalCostAmout(fscCreditBalance.getTotalCostAmout().add(totalAmt));
            }
            if (totalAmt.compareTo(BigDecimal.ZERO) < 0) {
                fscCreditBalance.setReturnedAmout(fscCreditBalance.getReturnedAmout().add(totalAmt.abs()));
            }
            if ((i = this.fscCreditBalanceMapper.updateAmtById(fscMerchantPo.getMerchantId(), reqBO.getCreditOrgId(), reqBO.getPayBusiness(), totalAmt, fscCreditBalance.getTotalCostAmout(), fscCreditBalance.getReturnedAmout())) != 1) {
                BigDecimal availableAmount = fscCreditBalance.getAvailableAmount();
                BigDecimal creditAmount = fscCreditBalance.getCreditAmount();
                if (availableAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    throw new FscBusinessException("194304", "\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
                }
                if (totalAmt.compareTo(BigDecimal.ZERO) > 0 && availableAmount.compareTo(totalAmt) < 0) {
                    throw new FscBusinessException("194304", "\u53ef\u7528\u91d1\u989d\u5c0f\u4e8e\u6263\u51cf\u91d1\u989d");
                }
                if (totalAmt.compareTo(BigDecimal.ZERO) < 0 && availableAmount.add(totalAmt.abs()).compareTo(creditAmount) > 0) {
                    throw new FscBusinessException("194304", "\u6263\u51cf\u91d1\u989d\u52a0\u4e0a\u53ef\u7528\u91d1\u989d\u5927\u4e8e\u6388\u4fe1\u989d\u5ea6");
                }
            }
        }
        this.writeLog(fscMerchantPo, fscCreditBalance, reqBO);
        return new FscCreditDeductAtomRspBO();
    }

    private void writeLog(FscMerchantPO fscMerchant, FscCreditBalancePO fscCreditBalance, FscCreditDeductAtomReqBO reqBO) {
        Date now = new Date();
        ArrayList<FscPayLogPO> fscPayLogPos = new ArrayList<FscPayLogPO>();
        reqBO.getFscCreditDeductAtomBOS().forEach(fscCreditDeductAtomBO -> {
            FscPayLogPO fscPayLogPo = new FscPayLogPO();
            long nextId = Sequence.getInstance().nextId();
            fscPayLogPo.setId(nextId);
            fscPayLogPo.setAccountId(fscMerchant.getAccountId());
            fscPayLogPo.setOrgId(reqBO.getCreditOrgId());
            fscPayLogPo.setUserName(fscMerchant.getOrgName());
            fscPayLogPo.setBusiTime(now);
            fscPayLogPo.setPayeeId(reqBO.getSupId());
            fscPayLogPo.setBusiOrderType(fscCreditDeductAtomBO.getOrderType());
            fscPayLogPo.setBusiAmount(fscCreditDeductAtomBO.getAmount());
            fscPayLogPo.setPayBusiness(reqBO.getPayBusiness());
            fscPayLogPo.setOrgCode(reqBO.getCreditOrgCode());
            if (fscCreditDeductAtomBO.getAmount().compareTo(BigDecimal.ZERO) > 0) {
                fscPayLogPo.setBusiCategory(FscConstants.FscBusiCategory.ORDER_PAY);
            } else {
                fscPayLogPo.setBusiCategory(FscConstants.FscBusiCategory.ORDER_REFUND);
            }
            if (null != reqBO.getBusiCategory()) {
                fscPayLogPo.setBusiCategory(reqBO.getBusiCategory());
            }
            fscPayLogPo.setBusiOrderNo(fscCreditDeductAtomBO.getOrderNo());
            this.queryUmcAccount(fscCreditDeductAtomBO.getOrderNo(), fscPayLogPo);
            if (null == fscCreditBalance) {
                BigDecimal totalAmt = reqBO.getFscCreditDeductAtomBOS().stream().map(FscCreditDeductAtomBO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                fscPayLogPo.setBusiBeforeAmount(fscMerchant.getPayCreditAmount());
                fscPayLogPo.setBusiAfterAmount(fscMerchant.getPayCreditAmount().subtract(totalAmt));
            } else {
                fscPayLogPo.setBusiBeforeAmount(fscCreditBalance.getAvailableAmount());
                fscPayLogPo.setBusiAfterAmount(fscCreditBalance.getAvailableAmount().subtract(fscCreditDeductAtomBO.getAmount()));
            }
            fscPayLogPo.setIsCredit(IS_CREDIT);
            fscPayLogPo.setCreateTime(now);
            if (null != reqBO.getUserName()) {
                fscPayLogPo.setCreateOperId(reqBO.getUserName());
            }
            fscPayLogPos.add(fscPayLogPo);
        });
        this.fscPayLogMapper.insertBatch(fscPayLogPos);
    }

    private void queryUmcAccount(String orderNo, FscPayLogPO fscPayLogPo) {
        if (null == orderNo || null == fscPayLogPo) {
            return;
        }
        Long fscOrderId = this.fscOrderMapper.getOrderIdByNo(orderNo);
        if (null != fscOrderId) {
            UocInspectionDetailsListPageQueryReqBO uocInspectionDetailsListPageQueryReqBO = new UocInspectionDetailsListPageQueryReqBO();
            uocInspectionDetailsListPageQueryReqBO.setRelId(fscOrderId);
            UocInspectionDetailsListPageQueryRspBO detailsList = this.uocInspectionDetailsListPageQueryAbilityService.getInspectionDetailsList(uocInspectionDetailsListPageQueryReqBO);
            if (null != detailsList && !CollectionUtils.isEmpty((Collection)detailsList.getRows())) {
                UocInspectionDetailsListBO bo = (UocInspectionDetailsListBO)detailsList.getRows().get(0);
                String purAccount = bo.getPurAccount();
                String purAccountName = bo.getPurAccountName();
                if (!StringUtils.isEmpty((Object)purAccount)) {
                    fscPayLogPo.setPurAccountId(Long.valueOf(purAccount));
                }
                fscPayLogPo.setPurAccountName(purAccountName);
            }
        } else {
            List childOrderList;
            PebExtSalesSingleDetailsListQueryReqBO singleDetailsListQueryReqBO = new PebExtSalesSingleDetailsListQueryReqBO();
            singleDetailsListQueryReqBO.setSaleVoucherNo(orderNo);
            singleDetailsListQueryReqBO.setTabId(Integer.valueOf(30001));
            PebExtSalesSingleDetailsListQueryRspBO salesSingleDetailsListQueryRspBO = this.pebExtSalesSingleDetailsListQueryAbilityService.getPebExtSalesSingleDetailsListQuery(singleDetailsListQueryReqBO);
            if (null != salesSingleDetailsListQueryRspBO && !CollectionUtils.isEmpty((Collection)salesSingleDetailsListQueryRspBO.getRows()) && !CollectionUtils.isEmpty((Collection)(childOrderList = ((PebExtUpperOrderAbilityBO)salesSingleDetailsListQueryRspBO.getRows().get(0)).getChildOrderList()))) {
                PebExtChildOrderAbilityBO pebExtChildOrderAbilityBO = (PebExtChildOrderAbilityBO)childOrderList.get(0);
                String purAccountName = pebExtChildOrderAbilityBO.getPurAccountName();
                String purAccount = pebExtChildOrderAbilityBO.getPurAccount();
                if (!StringUtils.isEmpty((Object)purAccount)) {
                    fscPayLogPo.setPurAccountId(Long.valueOf(purAccount));
                }
                fscPayLogPo.setPurAccountName(purAccountName);
            }
        }
    }
}

