/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderFlowEnum;
import com.tydic.fsc.constants.FscOrderFlowProcKeyEnum;
import com.tydic.fsc.dao.FscLogOrdBusiMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscLogOrdBusiPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.osworkflow.engine.runtime.NextStepsResult;
import com.tydic.osworkflow.engine.runtime.ProcessService;
import com.tydic.osworkflow.engine.runtime.ProcessStartBuilder;
import com.tydic.osworkflow.engine.runtime.StepWithOutInstance;
import com.tydic.osworkflow.engine.runtime.Task;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscOrderStatusStartAtomServiceImpl
implements FscOrderStatusStartAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderStatusStartAtomServiceImpl.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private ProcessStartBuilder processStartBuilder;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscLogOrdBusiMapper fscLogOrdBusiMapper;
    @Value(value="${workflow.inst.type:WithInstance}")
    private String workflowInstEnable;

    @Override
    public FscOrderStatusStartAtomRspBO dealStatusStart(FscOrderStatusStartAtomReqBO reqBO) {
        String stepType;
        Integer newStatus;
        this.val(reqBO);
        if (null == FscOrderFlowProcKeyEnum.getInstance((String)reqBO.getOrderFlow().toString())) {
            throw new FscBusinessException("194310", "\u8bf7\u914d\u7f6e\u679a\u4e3e");
        }
        String procKey = FscOrderFlowProcKeyEnum.getInstance((String)reqBO.getOrderFlow().toString()).getDescr();
        if (FscConstants.OrderFlow.PAY.equals(reqBO.getOrderFlow()) && ("1".equals(reqBO.getIsprofess()) || !StringUtils.isEmpty((Object)reqBO.getIndividually()))) {
            procKey = FscOrderFlowProcKeyEnum.DOWN_PAY.getDescr();
        }
        if (log.isDebugEnabled()) {
            log.debug("\u72b6\u6001\u673a\u542f\u52a8\u5165\u53c2:{} id:{}", (Object)JSON.toJSONString((Object)((Object)reqBO)), (Object)procKey);
        }
        String taskId = null;
        if ("NoneInstance".equals(this.workflowInstEnable)) {
            StepWithOutInstance stepInstance = this.processService.newProcessStartBuilder().variables(reqBO.getParamMap()).procDefId(null).procDefKey(procKey).sysCode("FSC").startWithOutInstance();
            if (log.isDebugEnabled()) {
                log.debug("\u72b6\u6001\u673a\u65e0\u5b9e\u4f8b\u542f\u52a8\u56de\u53c2:{} \u5165\u53c2:{} id:{}", new Object[]{JSON.toJSONString((Object)stepInstance), JSON.toJSONString((Object)((Object)reqBO)), procKey});
            }
            if (null == stepInstance) {
                throw new FscBusinessException("194310", "\u65e0\u5b9e\u4f8b\u542f\u52a8\u6d41\u7a0b\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            }
            newStatus = this.string2Integer(stepInstance.getStepId());
            stepType = stepInstance.getStepType();
        } else {
            NextStepsResult nextStepsResult = this.processStartBuilder.variables(reqBO.getParamMap()).procDefId(null).procDefKey(procKey).sysCode("FSC").startWithInstance();
            if (log.isDebugEnabled()) {
                log.debug("\u72b6\u6001\u673a\u6709\u5b9e\u4f8b\u542f\u52a8\u56de\u53c2:{} \u5165\u53c2:{} id:{}", new Object[]{JSON.toJSONString((Object)nextStepsResult), JSON.toJSONString((Object)((Object)reqBO)), procKey});
            }
            if (CollectionUtils.isEmpty((Collection)nextStepsResult.getTaskList())) {
                throw new FscBusinessException("194310", "\u6709\u5b9e\u4f8b\u542f\u52a8\u6d41\u7a0b\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            }
            Task task = (Task)nextStepsResult.getTaskList().get(0);
            newStatus = this.string2Integer(task.getStepId());
            stepType = task.getStepType();
            taskId = task.getTaskId();
        }
        this.updateStatus(reqBO, newStatus, procKey, taskId);
        this.writeLog(reqBO);
        FscOrderStatusStartAtomRspBO rspBO = new FscOrderStatusStartAtomRspBO();
        rspBO.setIsAuto("AUTO".equals(stepType) ? FscConstants.IsAutoFLow.YES : FscConstants.IsAutoFLow.NO);
        rspBO.setNewStatus(newStatus);
        return rspBO;
    }

    private void val(FscOrderStatusStartAtomReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u4e2d\u5fc3\u6838\u5fc3\u7ed3\u7b97\u72b6\u6001\u673a\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderFlow()) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u4e2d\u5fc3\u6838\u5fc3\u7ed3\u7b97\u72b6\u6001\u673a\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5931\u8d25,[OrderFlow]\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u4e2d\u5fc3\u6838\u5fc3\u7ed3\u7b97\u72b6\u6001\u673a\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5931\u8d25,[OrderId]\u5165\u53c2\u4e3a\u7a7a");
        }
    }

    private Integer string2Integer(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new FscBusinessException("194310", "\u72b6\u6001\u673a\u539f\u5b50\u670d\u52a1\u7ed3\u7b97\u4e3b\u5355\u72b6\u6001\u8f6c\u6362\u5f02\u5e38");
        }
    }

    private void updateStatus(FscOrderStatusStartAtomReqBO reqBO, Integer newStatus, String procKey, String taskId) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPo.setOrderFlowKey(procKey);
        fscOrderPo.setOrderState(newStatus);
        fscOrderPo.setCreateTimeStart(new Date());
        fscOrderPo.setTaskId(taskId);
        this.fscOrderMapper.updateById(fscOrderPo);
    }

    private void writeLog(FscOrderStatusStartAtomReqBO reqBO) {
        FscLogOrdBusiPO fscLogOrdBusiPo = new FscLogOrdBusiPO();
        fscLogOrdBusiPo.setBusiName(FscOrderFlowEnum.getInstance((Integer)reqBO.getOrderFlow()).getDescr());
        fscLogOrdBusiPo.setBusiType(reqBO.getOrderFlow());
        fscLogOrdBusiPo.setCreateCompanyId(reqBO.getCompanyId());
        fscLogOrdBusiPo.setCreateCompanyName(reqBO.getCompanyName());
        fscLogOrdBusiPo.setCreateOperId(reqBO.getUserId());
        fscLogOrdBusiPo.setCreateOperName(reqBO.getName());
        fscLogOrdBusiPo.setCreateOrgId(reqBO.getOrgId());
        fscLogOrdBusiPo.setCreateOrgName(reqBO.getOrgName());
        fscLogOrdBusiPo.setCreateTime(new Date());
        fscLogOrdBusiPo.setFscOrderId(reqBO.getOrderId());
        this.fscLogOrdBusiMapper.insert(fscLogOrdBusiPo);
    }
}

