/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscAccountAdvanceDeductAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAccountAdvanceDeductAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAccountAdvanceDeductAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscPayLogPO;
import java.math.BigDecimal;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscAccountAdvanceDeductAtomServiceImpl
implements FscAccountAdvanceDeductAtomService {
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;

    @Override
    public FscAccountAdvanceDeductAtomRspBO dealAccountAdvanceDeduct(FscAccountAdvanceDeductAtomReqBO reqBO) {
        BigDecimal totalAmt;
        FscMerchantPO fscMerchantPo = new FscMerchantPO();
        fscMerchantPo.setOrgId(reqBO.getSupId());
        fscMerchantPo.setDelFlag(FscConstants.DicDelFlag.NO);
        fscMerchantPo.setPayBusiSceneRangeLike(reqBO.getPayBusiness());
        fscMerchantPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        fscMerchantPo = this.fscMerchantMapper.getModelBy(fscMerchantPo);
        if (null == fscMerchantPo) {
            throw new FscBusinessException("194304", "\u67e5\u8be2\u5546\u6237\u4e3a\u7a7a");
        }
        FscMerchantPO merchant = new FscMerchantPO();
        merchant.setPayBusiSceneRangeLike(reqBO.getPayBusiness());
        merchant.setParentId(fscMerchantPo.getMerchantId());
        merchant.setDelFlag(FscConstants.DicDelFlag.NO);
        merchant.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
        merchant.setPayObjId(reqBO.getCreditOrgId());
        merchant = this.fscMerchantMapper.getModelBy(merchant);
        if (null != merchant) {
            BeanUtils.copyProperties((Object)merchant, (Object)fscMerchantPo);
        }
        BigDecimal overdraft = fscMerchantPo.getOverdraft();
        FscAccountPO queryVo = new FscAccountPO();
        queryVo.setBusiType(reqBO.getPayBusiness());
        queryVo.setOrgCode(reqBO.getCreditOrgCode());
        FscAccountPO fscAccountPo = this.fscAccountMapper.getModelBy(queryVo);
        if (fscAccountPo == null) {
            throw new FscBusinessException("194304", "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u76f8\u5173\u4fe1\u606f\uff01");
        }
        if (reqBO.getOperationType() == 0) {
            reqBO.setBusiCategory(FscConstants.FscBusiCategory.ADVANCE_FREEZE);
            totalAmt = reqBO.getTotalAmount();
            BigDecimal totalAvailableCredit = fscAccountPo.getAdvanceAmount().subtract(fscAccountPo.getFreezeAmount()).subtract(fscAccountPo.getUseAmount());
            if (totalAvailableCredit.compareTo(totalAmt) > 0) {
                fscAccountPo.setFreezeAmount(fscAccountPo.getFreezeAmount().add(totalAmt));
                reqBO.setOverdraftBefore(overdraft.subtract(fscAccountPo.getOverdraftAmount()));
                reqBO.setOverdraftAfter(overdraft.subtract(fscAccountPo.getOverdraftAmount()));
            } else {
                reqBO.setOverdraftBefore(overdraft.subtract(fscAccountPo.getOverdraftAmount()));
                BigDecimal totalAvailable = totalAvailableCredit.add(overdraft);
                if (totalAvailable.compareTo(totalAmt) < 0) {
                    throw new FscBusinessException("194304", "\u9884\u5b58\u6b3e\u53ef\u7528\u91d1\u989d\u4e0d\u8db3\uff01");
                }
                fscAccountPo.setOverdraftAmount(totalAmt.subtract(totalAvailableCredit));
                fscAccountPo.setFreezeAmount(fscAccountPo.getFreezeAmount().add(totalAmt));
                reqBO.setOverdraftAfter(overdraft.subtract(fscAccountPo.getOverdraftAmount()));
            }
        } else if (reqBO.getOperationType() == 1) {
            reqBO.setBusiCategory(FscConstants.FscBusiCategory.ADVANCE_PAY);
            totalAmt = reqBO.getTotalAmount();
            fscAccountPo.setUseAmount(fscAccountPo.getUseAmount().add(reqBO.getTotalAmount()));
            fscAccountPo.setFreezeAmount(fscAccountPo.getFreezeAmount().subtract(totalAmt));
            reqBO.setOverdraftBefore(overdraft.subtract(fscAccountPo.getOverdraftAmount()));
            reqBO.setOverdraftAfter(overdraft.subtract(fscAccountPo.getOverdraftAmount()));
        } else if (reqBO.getOperationType() == 2) {
            reqBO.setOverdraftBefore(overdraft.subtract(fscAccountPo.getOverdraftAmount()));
            reqBO.setBusiCategory(FscConstants.FscBusiCategory.ADVANCE_REFUND);
            fscAccountPo.setFreezeAmount(fscAccountPo.getFreezeAmount().subtract(reqBO.getTotalAmount()));
            if (fscAccountPo.getOverdraftAmount().compareTo(BigDecimal.ZERO) > 0) {
                if (fscAccountPo.getOverdraftAmount().compareTo(reqBO.getTotalAmount()) > 0) {
                    fscAccountPo.setOverdraftAmount(fscAccountPo.getOverdraftAmount().subtract(reqBO.getTotalAmount()));
                } else {
                    fscAccountPo.setOverdraftAmount(BigDecimal.ZERO);
                }
            }
            reqBO.setOverdraftAfter(overdraft.subtract(fscAccountPo.getOverdraftAmount()));
        }
        this.fscAccountMapper.updateAmount(fscAccountPo);
        this.writeAdviceLog(fscAccountPo, reqBO);
        FscAccountAdvanceDeductAtomRspBO rspBO = new FscAccountAdvanceDeductAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void writeAdviceLog(FscAccountPO fscAccountPo, FscAccountAdvanceDeductAtomReqBO reqBO) {
        Date now = new Date();
        FscPayLogPO fscPayLogPo = new FscPayLogPO();
        long nextId = Sequence.getInstance().nextId();
        fscPayLogPo.setId(nextId);
        fscPayLogPo.setOrgId(reqBO.getCreditOrgId());
        fscPayLogPo.setUserName(fscAccountPo.getOrgName());
        fscPayLogPo.setBusiTime(now);
        fscPayLogPo.setPayeeId(reqBO.getSupId());
        fscPayLogPo.setBusiOrderType(reqBO.getOrderType());
        fscPayLogPo.setBusiAmount(reqBO.getTotalAmount());
        fscPayLogPo.setPayBusiness("1");
        fscPayLogPo.setBusiCategory(reqBO.getBusiCategory());
        fscPayLogPo.setOrgCode(reqBO.getCreditOrgCode());
        if (reqBO.getTotalAmount().compareTo(BigDecimal.ZERO) > 0) {
            fscPayLogPo.setBusiCategory(FscConstants.FscBusiCategory.ORDER_PAY);
        } else {
            fscPayLogPo.setBusiCategory(FscConstants.FscBusiCategory.ORDER_REFUND);
        }
        if (null != reqBO.getBusiCategory()) {
            fscPayLogPo.setBusiCategory(reqBO.getBusiCategory());
        }
        fscPayLogPo.setOverdraftBeforeAmount(reqBO.getOverdraftBefore());
        fscPayLogPo.setOverdraftAfterAmount(reqBO.getOverdraftAfter());
        fscPayLogPo.setBusiOrderNo(reqBO.getOrderNo());
        fscPayLogPo.setIsCredit(0);
        fscPayLogPo.setCreateTime(now);
        if (null != reqBO.getUserName()) {
            fscPayLogPo.setCreateOperId(reqBO.getUserName());
        }
        this.fscPayLogMapper.insert(fscPayLogPo);
    }
}

