/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscAccountAdvanceDeductAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAccountAdvanceDeductAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAccountAdvanceDeductAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscPayLogPO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscAccountAdvanceDeductAtomServiceImpl
implements FscAccountAdvanceDeductAtomService {
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;

    @Override
    public FscAccountAdvanceDeductAtomRspBO dealAccountAdvanceDeduct(FscAccountAdvanceDeductAtomReqBO reqBO) {
        FscMerchantPO fscMerchantPo = new FscMerchantPO();
        fscMerchantPo.setOrgId(reqBO.getSupId());
        fscMerchantPo.setDelFlag(FscConstants.DicDelFlag.NO);
        fscMerchantPo.setPayBusiSceneRangeLike(reqBO.getPayBusiness());
        fscMerchantPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        fscMerchantPo = this.fscMerchantMapper.getModelBy(fscMerchantPo);
        if (null == fscMerchantPo) {
            throw new FscBusinessException("194304", "\u67e5\u8be2\u5546\u6237\u4e3a\u7a7a");
        }
        FscMerchantPO merchant = new FscMerchantPO();
        merchant.setPayBusiSceneRangeLike(reqBO.getPayBusiness());
        merchant.setParentId(fscMerchantPo.getMerchantId());
        merchant.setDelFlag(FscConstants.DicDelFlag.NO);
        merchant.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
        merchant.setPayObjId(reqBO.getCreditOrgId());
        merchant = this.fscMerchantMapper.getModelBy(merchant);
        if (null != merchant) {
            BeanUtils.copyProperties((Object)merchant, (Object)fscMerchantPo);
        }
        BigDecimal overdraft = fscMerchantPo.getOverdraft();
        FscAccountPO fscAccountPo = null;
        FscAccountPO deptAccount = null;
        FscAccountPO queryVo = new FscAccountPO();
        queryVo.setBusiType(reqBO.getPayBusiness());
        if (!Objects.equals(reqBO.getCreditOrgId(), reqBO.getDeptId())) {
            queryVo.setOrgId(reqBO.getDeptId());
            queryVo.setOrgTreePath(reqBO.getCreditOrgId().toString());
            deptAccount = this.fscAccountMapper.getModelBy(queryVo);
            if (deptAccount != null && (deptAccount.getAdvanceAmount().compareTo(BigDecimal.ZERO) > 0 || deptAccount.getOverdraftAmount().compareTo(BigDecimal.ZERO) > 0)) {
                overdraft = deptAccount.getOverdraft();
                fscAccountPo = deptAccount;
            }
        }
        queryVo.setOrgId(null);
        queryVo.setOrgTreePath(null);
        queryVo.setOrgCode(reqBO.getCreditOrgCode());
        FscAccountPO parentAccountPo = this.fscAccountMapper.getModelBy(queryVo);
        if (fscAccountPo == null && parentAccountPo == null) {
            throw new FscBusinessException("194304", "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u76f8\u5173\u4fe1\u606f\uff01");
        }
        if (fscAccountPo == null) {
            fscAccountPo = parentAccountPo;
        }
        overdraft = overdraft.subtract(fscAccountPo.getDistributeOverdraftAmount());
        BigDecimal totalAmt = reqBO.getTotalAmount();
        BigDecimal totalAvailableCredit = fscAccountPo.getAdvanceAmount().subtract(fscAccountPo.getFreezeAmount()).subtract(fscAccountPo.getUseAmount()).subtract(fscAccountPo.getDistributeAdvanceAmount());
        reqBO.setIsCredit(0);
        FscAccountAdvanceDeductAtomRspBO rspBO = new FscAccountAdvanceDeductAtomRspBO();
        FscPayLogPO fscPayLogPo = new FscPayLogPO();
        String orderNo = reqBO.getOrderNo();
        if (reqBO.getOrderNo().contains("-")) {
            orderNo = orderNo.substring(0, orderNo.indexOf("-"));
        }
        fscPayLogPo.setBusiOrderNo(orderNo);
        fscPayLogPo.setBusiCategory(FscConstants.FscBusiCategory.ADVANCE_FREEZE);
        fscPayLogPo = this.fscPayLogMapper.getModelBy(fscPayLogPo);
        if (reqBO.getOperationType() == 0) {
            reqBO.setBusiCategory(FscConstants.FscBusiCategory.ADVANCE_FREEZE);
            if (totalAvailableCredit.compareTo(totalAmt) > 0) {
                reqBO.setAdvanceBeforeAmount(totalAvailableCredit);
                fscAccountPo.setFreezeAmount(fscAccountPo.getFreezeAmount().add(totalAmt));
                reqBO.setOverdraftBefore(overdraft.subtract(fscAccountPo.getOverdraftAmount()));
                reqBO.setOverdraftAfter(overdraft.subtract(fscAccountPo.getOverdraftAmount()));
                reqBO.setAdvanceAfterAmount(totalAvailableCredit.subtract(totalAmt));
                rspBO.setAdvancePayType(FscConstants.AdvancePayType.ADVANCE_PAY);
                rspBO.setAdvanceAmt(totalAmt);
                rspBO.setOverdraftAmt(BigDecimal.ZERO);
            } else {
                reqBO.setIsCredit(1);
                if (totalAvailableCredit.compareTo(BigDecimal.ZERO) > 0) {
                    reqBO.setAdvanceBeforeAmount(totalAvailableCredit);
                    rspBO.setAdvancePayType(FscConstants.AdvancePayType.ADVANCE_OVERDRAFT_PAY);
                    rspBO.setOverdraftAmt(totalAmt.subtract(totalAvailableCredit));
                    rspBO.setAdvanceAmt(totalAvailableCredit);
                } else {
                    reqBO.setAdvanceBeforeAmount(BigDecimal.ZERO);
                    rspBO.setAdvancePayType(FscConstants.AdvancePayType.OVERDRAFT_PAY);
                    rspBO.setOverdraftAmt(totalAmt);
                    rspBO.setAdvanceAmt(BigDecimal.ZERO);
                }
                reqBO.setOverdraftBefore(overdraft.subtract(fscAccountPo.getOverdraftAmount()));
                BigDecimal totalAvailable = totalAvailableCredit.add(overdraft);
                if (totalAvailable.compareTo(totalAmt) < 0) {
                    throw new FscBusinessException("194304", "\u9884\u5b58\u6b3e\u53ef\u7528\u91d1\u989d\u4e0d\u8db3\uff01");
                }
                fscAccountPo.setOverdraftAmount(totalAmt.subtract(totalAvailableCredit));
                fscAccountPo.setFreezeAmount(fscAccountPo.getFreezeAmount().add(totalAmt));
                reqBO.setOverdraftAfter(overdraft.subtract(fscAccountPo.getOverdraftAmount()));
                reqBO.setAdvanceAfterAmount(BigDecimal.ZERO);
            }
            int count = this.fscAccountMapper.updateAmount(fscAccountPo);
            if (count <= 0) {
                throw new FscBusinessException("194304", "\u64cd\u4f5c\u5931\u8d25,\u7cfb\u7edf\u7e41\u5fd9,\u8bf7\u91cd\u65b0\u4e0b\u5355\uff01");
            }
        } else if (reqBO.getOperationType() == 1) {
            FscPayLogPO payLogPo = new FscPayLogPO();
            payLogPo.setBusiOrderNo(reqBO.getOrderNo());
            payLogPo.setBusiCategory(FscConstants.FscBusiCategory.ADVANCE_PAY);
            int num = this.fscPayLogMapper.getCheckBy(payLogPo);
            if (num > 0) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u8be5\u8ba2\u5355\u5df2\u5b8c\u6210\u9884\u5b58\u6b3e\u9a8c\u6536\u6263\u51cf\uff01");
                return rspBO;
            }
            fscAccountPo = this.dealUseAccount(reqBO, parentAccountPo, deptAccount, fscPayLogPo);
            reqBO.setBusiCategory(FscConstants.FscBusiCategory.ADVANCE_PAY);
            if (fscPayLogPo == null) {
                throw new FscBusinessException("194304", "\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u51bb\u7ed3\u8bb0\u5f55");
            }
            if (reqBO.getOrderNo().contains("-")) {
                List<FscPayLogPO> fscPayLogPOList = this.fscPayLogMapper.getListByParentNo(orderNo);
                BigDecimal totalBusiAmount = BigDecimal.ZERO;
                if (!CollectionUtils.isEmpty(fscPayLogPOList)) {
                    totalBusiAmount = fscPayLogPOList.stream().map(FscPayLogPO::getBusiAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                if (fscPayLogPo.getAdvanceBeforeAmount().compareTo(totalBusiAmount.add(totalAmt)) > 0) {
                    reqBO.setAdvanceBeforeAmount(fscPayLogPo.getAdvanceBeforeAmount().subtract(totalBusiAmount));
                    reqBO.setAdvanceAfterAmount(reqBO.getAdvanceBeforeAmount().subtract(totalAmt));
                    reqBO.setOverdraftBefore(fscPayLogPo.getOverdraftBeforeAmount());
                    reqBO.setOverdraftAfter(fscPayLogPo.getOverdraftBeforeAmount());
                } else if (fscPayLogPo.getAdvanceBeforeAmount().compareTo(totalBusiAmount) > 0) {
                    reqBO.setAdvanceBeforeAmount(fscPayLogPo.getAdvanceBeforeAmount().subtract(totalBusiAmount));
                    reqBO.setAdvanceAfterAmount(BigDecimal.ZERO);
                    reqBO.setOverdraftBefore(fscPayLogPo.getOverdraftBeforeAmount());
                    reqBO.setOverdraftAfter(reqBO.getOverdraftBefore().add(reqBO.getAdvanceBeforeAmount().subtract(totalAmt)));
                } else {
                    reqBO.setAdvanceBeforeAmount(BigDecimal.ZERO);
                    reqBO.setAdvanceAfterAmount(BigDecimal.ZERO);
                    reqBO.setOverdraftBefore(fscPayLogPo.getAdvanceBeforeAmount().add(fscPayLogPo.getOverdraftBeforeAmount().subtract(totalBusiAmount)));
                    reqBO.setOverdraftAfter(reqBO.getOverdraftBefore().subtract(totalAmt));
                }
            } else {
                reqBO.setOverdraftBefore(fscPayLogPo.getOverdraftBeforeAmount() == null ? BigDecimal.ZERO : fscPayLogPo.getOverdraftBeforeAmount());
                reqBO.setOverdraftAfter(fscPayLogPo.getOverdraftAfterAmount() == null ? BigDecimal.ZERO : fscPayLogPo.getOverdraftAfterAmount());
                reqBO.setAdvanceBeforeAmount(fscPayLogPo.getAdvanceBeforeAmount() == null ? BigDecimal.ZERO : fscPayLogPo.getAdvanceBeforeAmount());
                reqBO.setAdvanceAfterAmount(fscPayLogPo.getAdvanceAfterAmount() == null ? BigDecimal.ZERO : fscPayLogPo.getAdvanceAfterAmount());
            }
            fscAccountPo.setUseAmount(fscAccountPo.getUseAmount().add(reqBO.getTotalAmount()));
            fscAccountPo.setFreezeAmount(fscAccountPo.getFreezeAmount().subtract(totalAmt));
            fscAccountPo.setOrderAmount(reqBO.getTotalAmount());
            int count = this.fscAccountMapper.updateUseAmount(fscAccountPo);
            if (count <= 0) {
                throw new FscBusinessException("194304", "\u64cd\u4f5c\u5931\u8d25,\u66f4\u65b0\u8d26\u6237\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (fscAccountPo.getOverdraftAmount().compareTo(BigDecimal.ZERO) > 0) {
                reqBO.setIsCredit(1);
            }
        } else if (reqBO.getOperationType() == 2) {
            fscAccountPo = this.dealUseAccount(reqBO, parentAccountPo, deptAccount, fscPayLogPo);
            if (reqBO.getObjId() != null) {
                FscPayLogPO payLogPo = new FscPayLogPO();
                payLogPo.setBusiCategory(FscConstants.FscBusiCategory.ADVANCE_REFUND);
                payLogPo.setObjId(reqBO.getObjId());
                payLogPo.setBusiOrderNo(reqBO.getOrderNo());
                int num = this.fscPayLogMapper.getCheckBy(payLogPo);
                if (num > 0) {
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u8be5\u8ba2\u5355\u5df2\u5b8c\u6210\u9000\u6b3e,\u8bf7\u52ff\u91cd\u590d\u9000\u6b3e\uff01");
                    return rspBO;
                }
            }
            if (totalAvailableCredit.compareTo(BigDecimal.ZERO) > 0) {
                reqBO.setAdvanceBeforeAmount(totalAvailableCredit);
            } else {
                reqBO.setAdvanceBeforeAmount(BigDecimal.ZERO);
            }
            reqBO.setOverdraftBefore(overdraft.subtract(fscAccountPo.getOverdraftAmount()));
            reqBO.setBusiCategory(FscConstants.FscBusiCategory.ADVANCE_REFUND);
            fscAccountPo.setFreezeAmount(fscAccountPo.getFreezeAmount().subtract(reqBO.getTotalAmount()));
            if (fscAccountPo.getOverdraftAmount().compareTo(BigDecimal.ZERO) > 0) {
                if (fscAccountPo.getOverdraftAmount().compareTo(reqBO.getTotalAmount()) > 0) {
                    fscAccountPo.setOverdraftAmount(fscAccountPo.getOverdraftAmount().subtract(reqBO.getTotalAmount()));
                } else {
                    fscAccountPo.setOverdraftAmount(BigDecimal.ZERO);
                }
                reqBO.setIsCredit(1);
            }
            if ((totalAvailableCredit = fscAccountPo.getAdvanceAmount().subtract(fscAccountPo.getFreezeAmount()).subtract(fscAccountPo.getOverdraftAmount())).compareTo(BigDecimal.ZERO) > 0) {
                reqBO.setAdvanceAfterAmount(totalAvailableCredit);
            } else {
                reqBO.setAdvanceAfterAmount(BigDecimal.ZERO);
            }
            reqBO.setOverdraftAfter(overdraft.subtract(fscAccountPo.getOverdraftAmount()));
            int count = this.fscAccountMapper.updateAmount(fscAccountPo);
            if (count <= 0) {
                throw new FscBusinessException("194304", "\u64cd\u4f5c\u5931\u8d25,\u7cfb\u7edf\u7e41\u5fd9\uff01");
            }
        }
        this.writeAdviceLog(fscAccountPo, reqBO, fscMerchantPo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscAccountPO dealUseAccount(FscAccountAdvanceDeductAtomReqBO reqBO, FscAccountPO parentAccountPo, FscAccountPO deptAccount, FscPayLogPO fscPayLogPo) {
        if (deptAccount == null) {
            return parentAccountPo;
        }
        if (fscPayLogPo == null || fscPayLogPo.getAccountId() == null) {
            return parentAccountPo;
        }
        if (fscPayLogPo.getAccountId().equals(parentAccountPo.getId())) {
            return parentAccountPo;
        }
        if (fscPayLogPo.getAccountId().equals(deptAccount.getId())) {
            return deptAccount;
        }
        return parentAccountPo;
    }

    private void writeAdviceLog(FscAccountPO fscAccountPo, FscAccountAdvanceDeductAtomReqBO reqBO, FscMerchantPO fscMerchantPO) {
        Date now = new Date();
        FscPayLogPO fscPayLogPo = new FscPayLogPO();
        long nextId = Sequence.getInstance().nextId();
        fscPayLogPo.setId(nextId);
        fscPayLogPo.setOrgId(fscAccountPo.getOrgId());
        fscPayLogPo.setUserName(reqBO.getName());
        fscPayLogPo.setBusiTime(now);
        fscPayLogPo.setPayeeId(reqBO.getSupId());
        fscPayLogPo.setBusiOrderType(reqBO.getBusiOrderType());
        fscPayLogPo.setOrderType(reqBO.getOrderType());
        fscPayLogPo.setTradeMode(reqBO.getTradeMode());
        fscPayLogPo.setBusiAmount(reqBO.getTotalAmount());
        fscPayLogPo.setPayBusiness("1");
        fscPayLogPo.setBusiCategory(reqBO.getBusiCategory());
        fscPayLogPo.setOrgCode(reqBO.getCreditOrgCode());
        fscPayLogPo.setAccountId(fscAccountPo.getId());
        fscPayLogPo.setObjId(reqBO.getObjId());
        if (reqBO.getTotalAmount().compareTo(BigDecimal.ZERO) > 0) {
            fscPayLogPo.setBusiCategory(FscConstants.FscBusiCategory.ORDER_PAY);
        } else {
            fscPayLogPo.setBusiCategory(FscConstants.FscBusiCategory.ORDER_REFUND);
        }
        if (null != reqBO.getBusiCategory()) {
            fscPayLogPo.setBusiCategory(reqBO.getBusiCategory());
        }
        fscPayLogPo.setOverdraftBeforeAmount(reqBO.getOverdraftBefore());
        fscPayLogPo.setOverdraftAfterAmount(reqBO.getOverdraftAfter());
        fscPayLogPo.setBusiOrderNo(reqBO.getOrderNo());
        fscPayLogPo.setIsCredit(reqBO.getIsCredit());
        fscPayLogPo.setCreateTime(now);
        fscPayLogPo.setAdvanceBeforeAmount(reqBO.getAdvanceBeforeAmount());
        fscPayLogPo.setAdvanceAfterAmount(reqBO.getAdvanceAfterAmount());
        if (null != reqBO.getUserName()) {
            fscPayLogPo.setCreateOperId(reqBO.getUserName());
        }
        this.fscPayLogMapper.insert(fscPayLogPo);
    }
}

