/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscStockOperAtomService;
import com.tydic.fsc.busibase.atom.bo.FscStockOperAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscStockOperAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscStockItemMapper;
import com.tydic.fsc.dao.FscStockMapper;
import com.tydic.fsc.dao.FscStockRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscStockItemPO;
import com.tydic.fsc.po.FscStockPO;
import com.tydic.fsc.po.FscStockRelationPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscStockOperAtomServiceImpl
implements FscStockOperAtomService {
    @Autowired
    private FscStockMapper fscStockMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscStockItemMapper fscStockItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscStockRelationMapper fscStockRelationMapper;

    @Override
    public FscStockOperAtomRspBO dealStockOper(FscStockOperAtomReqBO reqBO) {
        this.val(reqBO);
        FscStockOperAtomRspBO fscStockOperAtomRspBO = new FscStockOperAtomRspBO();
        fscStockOperAtomRspBO.setRespCode("0000");
        fscStockOperAtomRspBO.setRespDesc("\u6210\u529f");
        this.dealBound(reqBO);
        return fscStockOperAtomRspBO;
    }

    private void dealBound(FscStockOperAtomReqBO reqBO) {
        Long fscStockId = this.createFscStock(reqBO);
        FscInvoiceItemPO fscInvoiceItemPO = new FscInvoiceItemPO();
        fscInvoiceItemPO.setFscOrderId(reqBO.getFscOrderId());
        List<FscInvoiceItemPO> fscInvoiceItemList = this.fscInvoiceItemMapper.getListGroupByItem(fscInvoiceItemPO);
        if (CollectionUtils.isEmpty(fscInvoiceItemList)) {
            throw new FscBusinessException("194312", "\u6ca1\u6709\u67e5\u8be2\u5230\u53d1\u7968\u8be6\u60c5\u4fe1\u606f");
        }
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
        List<FscOrderItemPO> fscOrderItemList = this.fscOrderItemMapper.getList(fscOrderItemPO);
        if (CollectionUtils.isEmpty(fscOrderItemList)) {
            throw new FscBusinessException("194312", "\u6ca1\u6709\u67e5\u8be2\u5230\u4e3b\u5355\u660e\u7ec6\u4fe1\u606f");
        }
        Map<String, FscOrderItemPO> collect = fscOrderItemList.stream().collect(Collectors.toMap(fscOrderItem -> "" + fscOrderItem.getOrderItemId() + fscOrderItem.getAcceptOrderId(), fscOrderItem -> fscOrderItem));
        Map<String, FscStockItemPO> FscStockItemPOMap = this.qryStockItem(fscInvoiceItemList);
        ArrayList<Long> fscStockItemIdList = new ArrayList<Long>(fscOrderItemList.size());
        ArrayList<FscStockItemPO> fscStockItemPOList = new ArrayList<FscStockItemPO>();
        for (FscInvoiceItemPO invoiceItemPO : fscInvoiceItemList) {
            FscStockItemPO fscStockItemPO = null;
            if (!CollectionUtils.isEmpty(FscStockItemPOMap)) {
                fscStockItemPO = FscStockItemPOMap.get("" + invoiceItemPO.getOrderItemId() + invoiceItemPO.getAcceptOrderId());
            }
            if (fscStockItemPO != null) {
                if (reqBO.getOperType().equals(FscConstants.FscStockOperType.INBOUND)) {
                    fscStockItemPO.setPrice(invoiceItemPO.getPrice());
                    fscStockItemPO.setAmt(invoiceItemPO.getAmt());
                    fscStockItemPO.setTaxAmt(invoiceItemPO.getTaxAmt());
                    fscStockItemPO.setUntaxAmt(invoiceItemPO.getUntaxAmt());
                    fscStockItemPO.setNum(fscStockItemPO.getNum().add(invoiceItemPO.getNum()));
                    fscStockItemPO.setInNum(invoiceItemPO.getNum());
                    fscStockItemPO.setUpdateTime(new Date());
                    fscStockItemPO.setStockAmt(BigDecimal.ZERO);
                    if (BigDecimal.ZERO.compareTo(fscStockItemPO.getNum()) != 0) {
                        fscStockItemPO.setStockAmt(fscInvoiceItemPO.getAmt());
                    }
                    int i = this.fscStockItemMapper.updateById(fscStockItemPO);
                    fscStockItemIdList.add(fscStockItemPO.getId());
                    if (i >= 1) continue;
                    throw new FscBusinessException("194312", "\u51fa\u5e93\u66f4\u65b0\u8868\u5931\u8d25");
                }
                fscStockItemPO.setOutNum(fscStockItemPO.getOutNum().add(invoiceItemPO.getNum()));
                fscStockItemPO.setNum(fscStockItemPO.getNum().subtract(invoiceItemPO.getNum()));
                fscStockItemPO.setUpdateTime(new Date());
                fscStockItemPO.setStockAmt(BigDecimal.ZERO);
                if (BigDecimal.ZERO.compareTo(fscStockItemPO.getNum()) != 0) {
                    fscStockItemPO.setStockAmt(fscStockItemPO.getNum().multiply(fscStockItemPO.getPrice()));
                }
                fscStockItemPO.setSalePrice(invoiceItemPO.getPrice());
                fscStockItemPO.setSaleAmt(invoiceItemPO.getAmt());
                fscStockItemPO.setSaleUntaxAmt(invoiceItemPO.getUntaxAmt());
                fscStockItemPO.setSaleTaxAmt(invoiceItemPO.getTaxAmt());
                int i = this.fscStockItemMapper.updateById(fscStockItemPO);
                fscStockItemIdList.add(fscStockItemPO.getId());
                if (i >= 1) continue;
                throw new FscBusinessException("194312", "\u51fa\u5e93\u66f4\u65b0\u8868\u5931\u8d25");
            }
            fscStockItemPO = new FscStockItemPO();
            BeanUtils.copyProperties((Object)invoiceItemPO, (Object)fscStockItemPO);
            FscOrderItemPO fscOrderItemPO1 = collect.get("" + fscStockItemPO.getOrderItemId() + fscStockItemPO.getAcceptOrderId());
            fscStockItemPO = this.createStockItem(fscStockItemPO, fscOrderItemPO1, invoiceItemPO, reqBO.getOperType());
            fscStockItemPOList.add(fscStockItemPO);
            fscStockItemIdList.add(fscStockItemPO.getId());
        }
        if (!CollectionUtils.isEmpty(fscStockItemPOList)) {
            this.fscStockItemMapper.insertBatch(fscStockItemPOList);
        }
        this.createStockRelation(fscStockItemIdList, fscStockId);
    }

    private FscStockItemPO createStockItem(FscStockItemPO fscStockItemPO, FscOrderItemPO fscOrderItemPO1, FscInvoiceItemPO invoiceItemPO, Integer operType) {
        if (fscOrderItemPO1 != null) {
            if (!StringUtils.isBlank((CharSequence)fscOrderItemPO1.getSkuIdExt())) {
                fscStockItemPO.setSkuIdExt(fscOrderItemPO1.getSkuIdExt());
            }
            fscStockItemPO.setSkuNo(fscOrderItemPO1.getSkuNo());
            fscStockItemPO.setTaxRate(fscOrderItemPO1.getTaxRate());
        }
        long fscStockItemId = Sequence.getInstance().nextId();
        fscStockItemPO.setId(fscStockItemId);
        if (operType.equals(FscConstants.FscStockOperType.INBOUND)) {
            fscStockItemPO.setInNum(invoiceItemPO.getNum());
            fscStockItemPO.setNum(invoiceItemPO.getNum());
            fscStockItemPO.setOutNum(BigDecimal.ZERO);
            fscStockItemPO.setStockAmt(invoiceItemPO.getAmt());
            fscStockItemPO.setCreateTime(new Date());
        } else {
            fscStockItemPO.setInNum(BigDecimal.ZERO);
            fscStockItemPO.setNum(invoiceItemPO.getNum().negate());
            fscStockItemPO.setAmt(null);
            fscStockItemPO.setPrice(null);
            fscStockItemPO.setTaxAmt(null);
            fscStockItemPO.setUntaxAmt(null);
            fscStockItemPO.setOutNum(invoiceItemPO.getNum());
            fscStockItemPO.setStockAmt(invoiceItemPO.getAmt().negate());
            fscStockItemPO.setSalePrice(invoiceItemPO.getPrice());
            fscStockItemPO.setSaleAmt(invoiceItemPO.getAmt());
            fscStockItemPO.setSaleUntaxAmt(invoiceItemPO.getUntaxAmt());
            fscStockItemPO.setSaleTaxAmt(invoiceItemPO.getTaxAmt());
            fscStockItemPO.setCreateTime(new Date());
        }
        return fscStockItemPO;
    }

    private void createStockRelation(List<Long> fscStockItemIdList, Long fscStockId) {
        ArrayList<FscStockRelationPO> fscStockRelationPOList = new ArrayList<FscStockRelationPO>();
        for (Long fscStockItemId : fscStockItemIdList) {
            FscStockRelationPO fscStockRelationPO = new FscStockRelationPO();
            fscStockRelationPO.setId(Sequence.getInstance().nextId());
            fscStockRelationPO.setStockId(fscStockId);
            fscStockRelationPO.setStockItemId(fscStockItemId);
            fscStockRelationPOList.add(fscStockRelationPO);
        }
        this.fscStockRelationMapper.insertBatch(fscStockRelationPOList);
    }

    private Long createFscStock(FscStockOperAtomReqBO reqBO) {
        FscStockPO fscStockPO = new FscStockPO();
        long fscStockId = Sequence.getInstance().nextId();
        fscStockPO.setId(fscStockId);
        fscStockPO.setFscOrderId(reqBO.getFscOrderId());
        fscStockPO.setStockFlag(reqBO.getOperType());
        fscStockPO.setCreateTime(new Date());
        fscStockPO.setStockStore("\u8fea\u6613\u91c7\u4ed3\u5e93");
        String inStockNo = this.createStockNo(reqBO);
        fscStockPO.setStockNo(inStockNo);
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(reqBO.getFscOrderId());
        fscInvoicePO = this.fscInvoiceMapper.getInvoiceByOrderId(fscInvoicePO);
        if (fscInvoicePO == null) {
            throw new FscBusinessException("194312", "\u6ca1\u6709\u67e5\u8be2\u5230\u53d1\u7968\u4fe1\u606f");
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (fscOrderPO == null) {
            throw new FscBusinessException("194312", "\u6ca1\u6709\u67e5\u8be2\u5230\u7ed3\u7b97\u4e3b\u5355\u4fe1\u606f");
        }
        fscStockPO.setOrderNo(fscOrderPO.getOrderNo());
        fscStockPO.setSupplierId(fscOrderPO.getSupplierId());
        fscStockPO.setSupplierName(fscOrderPO.getSupplierName());
        fscStockPO.setPurchaserId(fscOrderPO.getPurchaserId());
        fscStockPO.setPurchaserName(fscOrderPO.getPurchaserName());
        fscStockPO.setTotalAmt(fscOrderPO.getTotalCharge());
        fscStockPO.setTaxAmt(fscInvoicePO.getTaxAmt());
        fscStockPO.setUntaxAmt(fscInvoicePO.getUntaxAmt());
        int insert = this.fscStockMapper.insert(fscStockPO);
        if (insert < 1) {
            throw new FscBusinessException("194312", "\u5165\u5e93\u8868\u65b0\u589e\u5931\u8d25");
        }
        return fscStockId;
    }

    private String createStockNo(FscStockOperAtomReqBO reqBO) {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setOrgType("-1");
        if (FscConstants.FscStockOperType.INBOUND.equals(reqBO.getOperType())) {
            encodedSerialGetServiceReqBO.setEncodedRuleCode("IN_STOCK_ORDER_NO");
        } else if (FscConstants.FscStockOperType.OUTBOUND.equals(reqBO.getOperType())) {
            encodedSerialGetServiceReqBO.setEncodedRuleCode("OUT_STOCK_ORDER_NO");
        }
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        return (String)encodedSerialGetServiceRspBO.getSerialNoList().get(0);
    }

    private Map<String, FscStockItemPO> qryStockItem(List<FscInvoiceItemPO> fscInvoiceItemList) {
        ArrayList<FscStockItemPO> fscStockItemPOList = new ArrayList<FscStockItemPO>();
        for (FscInvoiceItemPO invoiceItemPO : fscInvoiceItemList) {
            FscStockItemPO fscStockItemPO2 = new FscStockItemPO();
            fscStockItemPO2.setAcceptOrderId(invoiceItemPO.getAcceptOrderId());
            fscStockItemPO2.setOrderItemId(invoiceItemPO.getOrderItemId());
            fscStockItemPO2.setOrderId(invoiceItemPO.getOrderId());
            fscStockItemPOList.add(fscStockItemPO2);
        }
        if (CollectionUtils.isEmpty(fscStockItemPOList = this.fscStockItemMapper.getListByCondition(fscStockItemPOList))) {
            return null;
        }
        Map<String, FscStockItemPO> FscStockItemPOMap = fscStockItemPOList.stream().collect(Collectors.toMap(fscStockItemPO -> "" + fscStockItemPO.getOrderItemId() + fscStockItemPO.getAcceptOrderId(), fscStockItemPO -> fscStockItemPO));
        return FscStockItemPOMap;
    }

    private void val(FscStockOperAtomReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5e93\u5b58\u51fa\u5165\u5e93\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u5e93\u5b58\u51fa\u5165\u5e93\u539f\u5b50\u670d\u52a1\u5931\u8d25,[fscOrderId]\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperType()) {
            throw new FscBusinessException("191000", "\u5e93\u5b58\u51fa\u5165\u5e93\u539f\u5b50\u670d\u52a1\u5931\u8d25,[operType]\u5165\u53c2\u4e3a\u7a7a");
        }
        if (FscConstants.FscStockOperType.INBOUND.equals(reqBO.getOperType())) {
            FscStockPO fscStockPO = new FscStockPO();
            fscStockPO.setFscOrderId(reqBO.getFscOrderId());
            fscStockPO.setStockFlag(reqBO.getOperType());
            fscStockPO = this.fscStockMapper.getModelBy(fscStockPO);
            if (fscStockPO != null) {
                throw new FscBusinessException("194312", "\u4e0d\u80fd\u91cd\u590d\u5165\u5e93");
            }
        }
    }
}

