/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcPayBillReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcPayBillRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcPrePayBillReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcPrePayBillRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscPushYcPayBillService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.SSLClient;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscPushYcPayBillServiceImpl
implements FscPushYcPayBillService {
    private static final Logger log = LoggerFactory.getLogger(FscPushYcPayBillServiceImpl.class);
    @Value(value="${esb.yc.pre.pay.url}")
    private String ESB_PUSH_YC_PRE_PAY_URL;
    @Value(value="${esb.yc.pay.url}")
    private String ESB_PUSH_YC_PAY_URL;

    @Override
    public FscPushYcPrePayBillRspBO pushYcPrePayBill(FscPushYcPrePayBillReqBO reqBO) {
        FscPushYcPrePayBillRspBO rspBO;
        String respStr = "";
        JSONObject data = new JSONObject();
        data.put("purchaseAdPayment", (Object)reqBO.getPurchaseAdPayment());
        data.put("purchaseAdPaymentLine", reqBO.getPurchaseAdPaymentLine());
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("p_type", "SavebaseInfo");
        map.put("p_switch", "Tesco");
        map.put("jsonMap", data.toJSONString());
        map.put("HEADER_ID", "3");
        log.info("\u63a8\u9001\u4e1a\u8d22\u91c7\u8d2d\u9884\u4ed8\u6b3e\u5165\u53c2\uff1a" + map);
        try {
            respStr = SSLClient.doPost(this.ESB_PUSH_YC_PRE_PAY_URL + "?respId=145950&userId=" + reqBO.getUserId(), map);
        }
        catch (Exception e) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u4e1a\u8d22\u63a5\u53e3\u63a8\u9001\u91c7\u8d2d\u9884\u4ed8\u5931\u8d25\uff01[" + this.ESB_PUSH_YC_PRE_PAY_URL + "]");
        }
        if (StringUtils.isEmpty((CharSequence)respStr)) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u4e1a\u8d22\u63a5\u53e3\u63a8\u9001\u91c7\u8d2d\u9884\u4ed8\u8fd4\u56de\u503c\u4e3a\u7a7a\uff01");
        }
        try {
            log.info("\u8c03\u7528\u4e1a\u8d22\u63a5\u53e3\u63a8\u9001\u91c7\u8d2d\u9884\u4ed8\u8fd4\u56de\u62a5\u6587\uff1a" + respStr);
            rspBO = this.resolvePreRsp(respStr);
        }
        catch (Exception e) {
            throw new FscBusinessException("198888", "\u89e3\u6790\u91c7\u8d2d\u9884\u4ed8\u8fd4\u56de\u62a5\u6587\u5931\u8d25\uff01[" + respStr + "]");
        }
        return rspBO;
    }

    @Override
    public FscPushYcPayBillRspBO pushYcPayBill(FscPushYcPayBillReqBO reqBO) {
        FscPushYcPayBillRspBO rspBO;
        String respStr = "";
        JSONObject data = new JSONObject();
        data.put("purchasePayment", (Object)reqBO.getPurchasePayment());
        data.put("purchasePaymentInfo", reqBO.getPurchasePaymentInfo());
        data.put("purchasePaymentSettlementInfo", reqBO.getPurchasePaymentSettlementInfo());
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("p_type", "SavebaseInfo");
        map.put("p_switch", "Tesco");
        map.put("jsonMap", data.toJSONString());
        map.put("HEADER_ID", "4");
        log.info("\u63a8\u9001\u4e1a\u8d22\u91c7\u8d2d\u4ed8\u6b3e\u5165\u53c2\uff1a" + map);
        try {
            respStr = SSLClient.doPost(this.ESB_PUSH_YC_PAY_URL + "?respId=145950&userId=" + reqBO.getUserId(), map);
        }
        catch (Exception e) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u4e1a\u8d22\u63a5\u53e3\u63a8\u9001\u91c7\u8d2d\u4ed8\u6b3e\u5931\u8d25\uff01[" + this.ESB_PUSH_YC_PAY_URL + "]");
        }
        if (StringUtils.isEmpty((CharSequence)respStr)) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u4e1a\u8d22\u63a5\u53e3\u63a8\u9001\u91c7\u8d2d\u4ed8\u6b3e\u8fd4\u56de\u503c\u4e3a\u7a7a\uff01");
        }
        log.info("\u63a8\u9001\u4e1a\u8d22\u91c7\u8d2d\u4ed8\u6b3e\u54cd\u5e94\u62a5\u6587" + respStr);
        try {
            rspBO = this.resolveRsp(respStr);
        }
        catch (Exception e) {
            throw new FscBusinessException("198888", "\u89e3\u6790\u91c7\u8d2d\u9884\u4ed8\u8fd4\u56de\u62a5\u6587\u5931\u8d25\uff01[" + respStr + "]");
        }
        return rspBO;
    }

    private FscPushYcPayBillRspBO resolveRsp(String respStr) {
        FscPushYcPayBillRspBO rspBO = new FscPushYcPayBillRspBO();
        JSONArray jsonArray = JSONObject.parseArray((String)respStr);
        if (!jsonArray.get(0).equals("Y")) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u63a8\u9001\u4e1a\u8d22\u5931\u8d25\uff01" + jsonArray.get(1).toString());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscPushYcPrePayBillRspBO resolvePreRsp(String respStr) {
        FscPushYcPrePayBillRspBO rspBO = new FscPushYcPrePayBillRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        JSONArray jsonArray = JSONObject.parseArray((String)respStr);
        if (!jsonArray.get(0).equals("Y")) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u63a8\u9001\u4e1a\u8d22\u5931\u8d25\uff01" + jsonArray.get(1).toString());
            return rspBO;
        }
        return rspBO;
    }
}

