/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.atom.api.FscOrderFailLogUpdateAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderFailLogUpdateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocOrderRelItemBo;
import com.tydic.fsc.busibase.external.api.bo.FscUocOrderRelUpdateReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocOrderRelUpdateRspBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocOrderRelUpdateAbilityService;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.uoc.common.ability.api.UocGetOrderRelAbilityService;
import com.tydic.uoc.common.ability.bo.UocGetOrderRelReqBo;
import com.tydic.uoc.common.ability.bo.UocGetOrderRelRspBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscUocOrderRelUpdateAtomServiceImpl
implements FscUocOrderRelUpdateAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscUocOrderRelUpdateAtomServiceImpl.class);
    @Autowired
    private FscUocOrderRelUpdateAbilityService fscUocOrderRelUpdateAbilityService;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderFailLogUpdateAtomService fscOrderFailLogUpdateAtomService;
    @Autowired
    private UocGetOrderRelAbilityService uocGetOrderRelAbilityService;
    private static final String DEL_FLAG = "1";

    @Override
    public FscUocOrderRelUpdateAtomRspBO dealRelUpdate(FscUocOrderRelUpdateAtomReqBO reqBO) {
        this.val(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("194313", "\u67e5\u8be2\u7ed3\u7b97\u5355\u4e3a\u7a7a");
        }
        if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) {
            return new FscUocOrderRelUpdateAtomRspBO();
        }
        if (FscConstants.FscRelUpdateAtomOperType.FSC_ORDER.equals(reqBO.getOperType())) {
            FscOrderRelationPO fscOrderRelation = new FscOrderRelationPO();
            fscOrderRelation.setFscOrderId(reqBO.getFscOrderId());
            ArrayList<Integer> excludeStateList = new ArrayList<Integer>(1);
            excludeStateList.add(FscBillStatus.MAIN_ORDER_CANCELLATION.getCode());
            excludeStateList.add(FscBillStatus.MAIN_ORDER_DEL.getCode());
            fscOrderRelation.setExcludeStateList(excludeStateList);
            List<FscOrderRelationPO> fscOrderRelationPOS = this.fscOrderRelationMapper.getList(fscOrderRelation);
            UocGetOrderRelReqBo uocGetOrderRelReqBo = new UocGetOrderRelReqBo();
            uocGetOrderRelReqBo.setFscOrderId(reqBO.getFscOrderId());
            if (log.isDebugEnabled()) {
                log.debug("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocGetOrderRelReqBo));
            }
            UocGetOrderRelRspBo uocGetOrderRelRspBo = this.uocGetOrderRelAbilityService.getList(uocGetOrderRelReqBo);
            if (log.isDebugEnabled()) {
                log.debug("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocGetOrderRelRspBo));
            }
            if (!"0000".equals(uocGetOrderRelRspBo.getRespCode())) {
                throw new FscBusinessException("194323", uocGetOrderRelRspBo.getRespDesc());
            }
            if (!CollectionUtils.isEmpty((Collection)uocGetOrderRelRspBo.getRows())) {
                Map<Object, Object> orderRelationPOMap = new HashMap();
                if (!CollectionUtils.isEmpty(fscOrderRelationPOS)) {
                    orderRelationPOMap = fscOrderRelationPOS.stream().collect(Collectors.toMap(FscOrderRelationPO::getAcceptOrderId, Function.identity(), (e1, e2) -> e1));
                }
                HashMap finalOrderRelationPOMap = orderRelationPOMap;
                uocGetOrderRelRspBo.getRows().forEach(e -> {
                    if (null == finalOrderRelationPOMap.get(e.getInspectionOrderId())) {
                        FscOrderRelationPO po = new FscOrderRelationPO();
                        po.setFscOrderId(Convert.toLong((Object)e.getRelId()));
                        po.setOrderId(e.getOrderId());
                        po.setAcceptOrderId(e.getInspectionOrderId());
                        po.setDelFlag(DEL_FLAG);
                        fscOrderRelationPOS.add(po);
                    }
                });
            }
            FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
            fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
            List<FscOrderItemPO> orderItemList = this.fscOrderItemMapper.getList(fscOrderItemPO);
            Map<Long, List<FscOrderItemPO>> individualMap = orderItemList.stream().collect(Collectors.groupingBy(FscOrderItemPO::getAcceptOrderId));
            if (!CollectionUtils.isEmpty(fscOrderRelationPOS)) {
                FscOrderPO finalFscOrderPO = fscOrderPO;
                fscOrderRelationPOS.forEach(fscOrderRelationPO -> {
                    FscUocOrderRelUpdateRspBO fscUocOrderRelUpdateRspBO;
                    FscUocOrderRelUpdateReqBO fscUocOrderRelUpdateReqBO = new FscUocOrderRelUpdateReqBO();
                    fscUocOrderRelUpdateReqBO.setInspectionVoucherId(fscOrderRelationPO.getAcceptOrderId());
                    fscUocOrderRelUpdateReqBO.setOrderId(fscOrderRelationPO.getOrderId());
                    fscUocOrderRelUpdateReqBO.setRelId(reqBO.getFscOrderId());
                    fscUocOrderRelUpdateReqBO.setRelState(reqBO.getRelState());
                    fscUocOrderRelUpdateReqBO.setDelFlag(fscOrderRelationPO.getDelFlag());
                    fscUocOrderRelUpdateReqBO.setSettleType(finalFscOrderPO.getSettleType());
                    if (null == reqBO.getRelState()) {
                        fscUocOrderRelUpdateReqBO.setRelState(this.getRelStatus(finalFscOrderPO.getOrderState()));
                    }
                    if (FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(finalFscOrderPO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(finalFscOrderPO.getOrderFlow()) || FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(finalFscOrderPO.getOrderFlow())) {
                        fscUocOrderRelUpdateReqBO.setRelType(FscConstants.FscRelType.SERVICE_INVOICE);
                    }
                    if (FscConstants.OrderFlow.INVOICE.equals(finalFscOrderPO.getOrderFlow())) {
                        if (FscConstants.FscOrderReceiveType.OPERATION.equals(finalFscOrderPO.getReceiveType())) {
                            fscUocOrderRelUpdateReqBO.setRelType(FscConstants.FscRelType.PRO_INVOICE);
                        }
                        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(finalFscOrderPO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(finalFscOrderPO.getMakeType())) {
                            fscUocOrderRelUpdateReqBO.setRelType(FscConstants.FscRelType.TRADE_INVOICE);
                        }
                        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(finalFscOrderPO.getReceiveType()) && !FscConstants.FscOrderMakeType.OPERTION.equals(finalFscOrderPO.getMakeType())) {
                            fscUocOrderRelUpdateReqBO.setRelType(FscConstants.FscRelType.MATCH_INVOICE);
                        }
                        if (FscConstants.FscOrderReceiveType.INDIVIDUAL.equals(finalFscOrderPO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(finalFscOrderPO.getMakeType())) {
                            fscUocOrderRelUpdateReqBO.setRelType(FscConstants.FscRelType.INDIVIDUAL_TYPE);
                        }
                    }
                    if (!DEL_FLAG.equals(fscUocOrderRelUpdateReqBO.getDelFlag())) {
                        List fscOrderItemPOS = (List)individualMap.get(fscOrderRelationPO.getAcceptOrderId());
                        List<FscUocOrderRelItemBo> uocOrderRelItemBos = fscOrderItemPOS.stream().map(e -> {
                            FscUocOrderRelItemBo fscUocOrderRelItemBo = new FscUocOrderRelItemBo();
                            fscUocOrderRelItemBo.setAmt(e.getAmt());
                            fscUocOrderRelItemBo.setNum(e.getNum());
                            fscUocOrderRelItemBo.setOrdItemId(e.getOrderItemId());
                            fscUocOrderRelItemBo.setOrderId(fscOrderRelationPO.getOrderId());
                            fscUocOrderRelItemBo.setRelId(reqBO.getFscOrderId());
                            return fscUocOrderRelItemBo;
                        }).collect(Collectors.toList());
                        fscUocOrderRelUpdateReqBO.setUocOrderRelItemBos(uocOrderRelItemBos);
                    }
                    if (!"0000".equals((fscUocOrderRelUpdateRspBO = this.fscUocOrderRelUpdateAbilityService.dealRelUpdate(fscUocOrderRelUpdateReqBO)).getRespCode())) {
                        if (log.isDebugEnabled()) {
                            log.debug("\u540c\u6b65\u8ba2\u5355\u4e2d\u5fc3\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)((Object)fscUocOrderRelUpdateRspBO)));
                        }
                        if (FscConstants.FscOrderFailRetansFlag.YES.equals(reqBO.getSyncOrderFlag())) {
                            throw new FscBusinessException("194313", JSON.toJSONString((Object)((Object)fscUocOrderRelUpdateRspBO)));
                        }
                        FscOrderFailLogUpdateAtomReqBO fscOrderFailLogUpdateAtomReqBO = new FscOrderFailLogUpdateAtomReqBO();
                        fscOrderFailLogUpdateAtomReqBO.setObjId(reqBO.getFscOrderId());
                        fscOrderFailLogUpdateAtomReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_SYNC_ORD);
                        fscOrderFailLogUpdateAtomReqBO.setBusiFailDesc(fscUocOrderRelUpdateRspBO.getRespDesc());
                        this.fscOrderFailLogUpdateAtomService.dealInsert(fscOrderFailLogUpdateAtomReqBO);
                    }
                });
            }
        }
        if (FscConstants.FscRelUpdateAtomOperType.ORDER.equals(reqBO.getOperType())) {
            reqBO.getFscOrderRelUpdateBOS().forEach(fscOrderRelUpdateBO -> {
                FscUocOrderRelUpdateReqBO fscUocOrderRelUpdateReqBO = (FscUocOrderRelUpdateReqBO)((Object)((Object)JSON.parseObject((String)JSON.toJSONString((Object)fscOrderRelUpdateBO), FscUocOrderRelUpdateReqBO.class)));
                FscUocOrderRelUpdateRspBO fscUocOrderRelUpdateRspBO = this.fscUocOrderRelUpdateAbilityService.dealRelUpdate(fscUocOrderRelUpdateReqBO);
                if (!"0000".equals(fscUocOrderRelUpdateRspBO.getRespCode())) {
                    if (log.isDebugEnabled()) {
                        log.debug("\u540c\u6b65\u8ba2\u5355\u4e2d\u5fc3\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)((Object)fscUocOrderRelUpdateRspBO)));
                    }
                    if (FscConstants.FscOrderFailRetansFlag.YES.equals(reqBO.getSyncOrderFlag())) {
                        throw new FscBusinessException("194313", JSON.toJSONString((Object)((Object)fscUocOrderRelUpdateRspBO)));
                    }
                }
            });
        }
        return new FscUocOrderRelUpdateAtomRspBO();
    }

    private void val(FscUocOrderRelUpdateAtomReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperType()) {
            throw new FscBusinessException("191000", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u539f\u5b50\u670d\u52a1\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (FscConstants.FscRelUpdateAtomOperType.FSC_ORDER.equals(reqBO.getOperType())) {
            if (null == reqBO.getFscOrderId()) {
                throw new FscBusinessException("191000", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u539f\u5b50\u670d\u52a1\u5165\u53c2\u7ed3\u7b97\u5355ID\u4e3a\u7a7a");
            }
        } else if (FscConstants.FscRelUpdateAtomOperType.ORDER.equals(reqBO.getOperType())) {
            if (!CollectionUtils.isEmpty(reqBO.getFscOrderRelUpdateBOS())) {
                throw new FscBusinessException("191000", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355\u5bf9\u8c61\u4e3a\u7a7a");
            }
        } else {
            throw new FscBusinessException("191000", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u539f\u5b50\u670d\u52a1\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u672a\u5b9a\u4e49");
        }
    }

    private Integer getRelStatus(Integer orderState) {
        if (FscBillStatus.SIGNED_SUCCEED.getCode().equals(orderState)) {
            return FscConstants.FscRelStatus.SIGN;
        }
        if (FscBillStatus.INVOICED.getCode().equals(orderState)) {
            return FscConstants.FscRelStatus.BILLED;
        }
        if (FscBillStatus.MAIN_ORDER_CANCELLATION.getCode().equals(orderState)) {
            return FscConstants.FscRelStatus.UNCOMMITTED;
        }
        return FscConstants.FscRelStatus.COMMITTED;
    }
}

