/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.external.api.bo.FscPushInvoiceToErpReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushInvoiceToErpRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscPushInvoiceToErpService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.SSLClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscPushInvoiceToErpServiceImpl
implements FscPushInvoiceToErpService {
    private static final Logger log = LoggerFactory.getLogger(FscPushInvoiceToErpServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Value(value="${ERP_INVOICE_PUSH_URL:http://172.16.3.98:8080/ords/erp/mewoublic/updateinvoiceinfo}")
    private String ERP_INVOICE_PUSH_URL;

    @Override
    public FscPushInvoiceToErpRspBO pushInvoiceToErp(FscPushInvoiceToErpReqBO reqBO) {
        if (this.isDebugEnabled) {
            log.debug("\u63a8\u9001\u53d1\u7968\u5165\u53c2\uff1a" + reqBO.toString());
        }
        this.initParam(reqBO);
        String returnString = SSLClient.doGet(this.ERP_INVOICE_PUSH_URL + "?P_TRANSACTION_ID=" + reqBO.getP_TRANSACTION_ID() + "&P_INVOICE_STR=" + reqBO.getP_INVOICE_STR());
        log.debug("\u63a8\u9001\u53d1\u7968\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)(this.ERP_INVOICE_PUSH_URL + "?P_TRANSACTION_ID=" + reqBO.getP_TRANSACTION_ID() + "&P_INVOICE_STR=" + reqBO.getP_INVOICE_STR()));
        log.debug("\u63a8\u9001\u53d1\u7968\u8fd4\u56de\u62a5\u6587\uff1a{}", (Object)returnString);
        if (StringUtils.isEmpty((Object)returnString)) {
            throw new FscBusinessException("193146", "\u63a8\u9001\u53d1\u7968\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
        }
        FscPushInvoiceToErpRspBO fscPushInvoiceToErpRspBO = new FscPushInvoiceToErpRspBO();
        try {
            fscPushInvoiceToErpRspBO = (FscPushInvoiceToErpRspBO)((Object)JSONObject.parseObject((String)returnString, FscPushInvoiceToErpRspBO.class));
        }
        catch (JSONException e) {
            fscPushInvoiceToErpRspBO.setRespCode("190000");
            fscPushInvoiceToErpRspBO.setRespDesc("\u8fd4\u56de\u62a5\u6587\u5f02\u5e38");
            return fscPushInvoiceToErpRspBO;
        }
        if (!"S".equals(fscPushInvoiceToErpRspBO.getStatus())) {
            fscPushInvoiceToErpRspBO.setRespCode("190000");
            fscPushInvoiceToErpRspBO.setRespDesc(fscPushInvoiceToErpRspBO.getMessage());
        } else {
            fscPushInvoiceToErpRspBO.setRespCode("0000");
        }
        return fscPushInvoiceToErpRspBO;
    }

    private void initParam(FscPushInvoiceToErpReqBO reqBo) {
        if (StringUtils.isEmpty((Object)reqBo.getP_TRANSACTION_ID()) && StringUtils.isEmpty((Object)reqBo.getP_INVOICE_STR())) {
            throw new FscBusinessException("193146", "\u8bf7\u6c42\u5165\u53c2\u4e0d\u80fd\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

