/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscOrderItemBO;
import com.tydic.fsc.busibase.atom.api.FscSaleOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.TaxUtils;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPebOrderItemAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPebUpperOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscSaleOrderListQueryAtomServiceImpl
implements FscSaleOrderListQueryAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscSaleOrderListQueryAtomServiceImpl.class);
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    @Value(value="${saleOrderTabId:30001}")
    private Integer TAB_ID;

    @Override
    public FscSaleOrderListQueryAtomRspBO qrySaleOrderList(FscSaleOrderListQueryAtomReqBO reqBO) {
        UocSalesSingleDetailsListQueryReqBO saleDetailsReqBO = new UocSalesSingleDetailsListQueryReqBO();
        if (reqBO.getPageSize() == null) {
            saleDetailsReqBO.setPageSize(10000);
        }
        saleDetailsReqBO.setIsAfterSales(Boolean.valueOf(false));
        saleDetailsReqBO.setOrderIdList(reqBO.getOrderIds());
        saleDetailsReqBO.setRelId(reqBO.getRelId());
        saleDetailsReqBO.setTabId(this.TAB_ID);
        saleDetailsReqBO.setPageNo(reqBO.getPageNo().intValue());
        log.debug("\u67e5\u8be2\u9500\u552e\u5355\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)saleDetailsReqBO));
        UocSalesSingleDetailsListQueryRspBO saleDetailsRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(saleDetailsReqBO);
        if (!saleDetailsRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(saleDetailsRspBO.getRespCode(), "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25:" + saleDetailsRspBO.getRespDesc());
        }
        log.debug("\u67e5\u8be2\u9500\u552e\u5355\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)saleDetailsRspBO));
        FscSaleOrderListQueryAtomRspBO rspBO = new FscSaleOrderListQueryAtomRspBO();
        this.buildOrderInfo(saleDetailsRspBO.getRows(), rspBO, reqBO);
        rspBO.setTotal(saleDetailsRspBO.getTotal());
        rspBO.setRecordsTotal(saleDetailsRspBO.getRecordsTotal());
        rspBO.setPageNo(saleDetailsRspBO.getPageNo());
        return rspBO;
    }

    private void buildOrderInfo(List<UocPebUpperOrderAbilityBO> rows, FscSaleOrderListQueryAtomRspBO rspBO, FscSaleOrderListQueryAtomReqBO reqBO) {
        HashMap<Long, FscOrderInfoBO> fscOrderInfoBoMap = new HashMap<Long, FscOrderInfoBO>();
        HashSet<String> orderCodeList = new HashSet<String>();
        HashSet<String> orderOperList = new HashSet<String>();
        for (UocPebUpperOrderAbilityBO row : rows) {
            FscOrderInfoBO fscOrderInfoBO = (FscOrderInfoBO)JSON.parseObject((String)JSON.toJSONString(row.getChildOrderList().get(0)), FscOrderInfoBO.class);
            ArrayList<FscOrderItemBO> fscOrderItemBOS = new ArrayList<FscOrderItemBO>();
            for (UocPebChildOrderAbilityBO childOrderBo : row.getChildOrderList()) {
                for (UocPebOrderItemAbilityBO orderItemBo : childOrderBo.getOrderItemList()) {
                    FscOrderItemBO fscOrderItemBO = (FscOrderItemBO)JSONObject.parseObject((String)JSON.toJSONString((Object)orderItemBo), FscOrderItemBO.class);
                    if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) || FscConstants.FscOrderReceiveType.INDIVIDUAL.equals(reqBO.getReceiveType())) {
                        if (orderItemBo.getDownLeaveInvoiceNum().compareTo(BigDecimal.ZERO) == 0) continue;
                        fscOrderItemBO.setTotalAmt(new BigDecimal(orderItemBo.getSaleFeeMoney()));
                        fscOrderItemBO.setAmt(orderItemBo.getDownLeaveInvoiceAmt());
                        fscOrderItemBO.setNum(orderItemBo.getDownLeaveInvoiceNum());
                        fscOrderItemBO.setPrice(new BigDecimal(orderItemBo.getSellingPrice()));
                    }
                    if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                        if (orderItemBo.getUpLeaveInvoiceNum().compareTo(BigDecimal.ZERO) == 0) continue;
                        fscOrderItemBO.setTotalAmt(new BigDecimal(orderItemBo.getPurchaseFeeMoney()));
                        fscOrderItemBO.setAmt(orderItemBo.getUpLeaveInvoiceAmt());
                        fscOrderItemBO.setNum(orderItemBo.getUpLeaveInvoiceNum());
                        fscOrderItemBO.setPrice(new BigDecimal(orderItemBo.getPurchasingPrice()));
                    }
                    fscOrderItemBO.setAcceptOrderId(Long.valueOf(Long.parseLong(row.getSaleVoucherId())));
                    fscOrderItemBO.setOrderId(Long.valueOf(childOrderBo.getOrderId()));
                    fscOrderItemBO.setSkuNo(orderItemBo.getSkuCode());
                    BigDecimal returnCount = new BigDecimal(orderItemBo.getReturnCount());
                    BigDecimal refuseCount = new BigDecimal(orderItemBo.getRefuseCount());
                    fscOrderItemBO.setTotalNum(new BigDecimal(orderItemBo.getPurchaseCount()).subtract(returnCount).subtract(refuseCount));
                    if (!StringUtils.isEmpty((CharSequence)orderItemBo.getSendCount())) {
                        fscOrderItemBO.setSendCount(new BigDecimal(orderItemBo.getSendCount()));
                    }
                    fscOrderItemBO.setSkuIdExt(orderItemBo.getOutSkuId());
                    fscOrderItemBO.setTaxRate(new BigDecimal(orderItemBo.getTax()).divide(new BigDecimal(100), 2, 4));
                    fscOrderItemBO.setUnit(orderItemBo.getUnitName());
                    if (null != fscOrderItemBO.getAmt()) {
                        fscOrderItemBO.setTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemBO.getAmt(), (BigDecimal)fscOrderItemBO.getTaxRate()));
                        fscOrderItemBO.setUntaxAmt(fscOrderItemBO.getAmt().subtract(fscOrderItemBO.getTaxAmt()));
                    }
                    fscOrderItemBO.setSaleAmt(new BigDecimal(orderItemBo.getSaleFeeMoney()));
                    fscOrderItemBO.setSalePrice(new BigDecimal(orderItemBo.getSellingPrice()));
                    fscOrderItemBO.setSaleTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemBO.getSaleAmt(), (BigDecimal)fscOrderItemBO.getTaxRate()));
                    fscOrderItemBO.setSaleUntaxAmt(fscOrderItemBO.getSaleAmt().subtract(fscOrderItemBO.getSaleTaxAmt()));
                    fscOrderItemBO.setPurchaseAmt(new BigDecimal(orderItemBo.getPurchaseFeeMoney()));
                    fscOrderItemBO.setPurchasePrice(new BigDecimal(orderItemBo.getPurchasingPrice()));
                    fscOrderItemBO.setPurchaseTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemBO.getPurchaseAmt(), (BigDecimal)fscOrderItemBO.getTaxRate()));
                    fscOrderItemBO.setPurchaseUntaxAmt(fscOrderItemBO.getPurchaseAmt().subtract(fscOrderItemBO.getPurchaseTaxAmt()));
                    fscOrderItemBO.setOrderItemId(Long.valueOf(Long.parseLong(orderItemBo.getOrderItemId())));
                    fscOrderItemBO.setOrdItemId(Long.valueOf(Long.parseLong(orderItemBo.getOrderItemId())));
                    fscOrderItemBO.setOrderCode(row.getSaleVoucherNo());
                    fscOrderItemBO.setSalesUnitRate(orderItemBo.getSalesUnitRate());
                    fscOrderItemBO.setSettleUnit(orderItemBo.getSettleUnit());
                    if (fscOrderItemBO.getSalesUnitRate() != null && fscOrderItemBO.getSalesUnitRate().compareTo(BigDecimal.ZERO) > 0 && fscOrderItemBO.getPrice() != null) {
                        fscOrderItemBO.setSettlePrice(fscOrderItemBO.getPrice().divide(fscOrderItemBO.getSalesUnitRate(), 8, 4));
                        fscOrderItemBO.setSettleNum(fscOrderItemBO.getNum().multiply(fscOrderItemBO.getSalesUnitRate()));
                    }
                    fscOrderItemBOS.add(fscOrderItemBO);
                }
                fscOrderInfoBO.setAcceptOrderId(Long.valueOf(Long.parseLong(row.getSaleVoucherId())));
                fscOrderInfoBO.setOrderId(Long.valueOf(Long.parseLong(row.getOrderId())));
                fscOrderInfoBO.setExtOrderNo(row.getOutOrderId());
                fscOrderInfoBO.setSupplierName(row.getSupName());
                fscOrderInfoBO.setSupplierId(row.getSupNo());
                fscOrderInfoBO.setProOrgName(row.getProName());
                fscOrderInfoBO.setProOrgId(row.getProNo());
                fscOrderInfoBO.setPurchaserName(childOrderBo.getPurName());
                fscOrderInfoBO.setPurchaserId(childOrderBo.getPurNo());
                if (childOrderBo.getPaymentDays() != null) {
                    fscOrderInfoBO.setPayNodeAccountDays(Integer.valueOf(childOrderBo.getPaymentDays()));
                }
                fscOrderInfoBO.setOrderNo(row.getSaleVoucherNo());
                if (StringUtils.isNotBlank((CharSequence)childOrderBo.getTradeMode())) {
                    fscOrderInfoBO.setBusiMode(Integer.valueOf(childOrderBo.getTradeMode()));
                }
                if (!StringUtils.isBlank((CharSequence)childOrderBo.getPurAccount())) {
                    fscOrderInfoBO.setAccountSetId(Long.valueOf(childOrderBo.getPurAccount()));
                }
                fscOrderInfoBO.setAccountSetName(childOrderBo.getPurAccountName());
                if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) || FscConstants.FscOrderReceiveType.INDIVIDUAL.equals(reqBO.getReceiveType())) {
                    fscOrderInfoBO.setOrderNo(row.getSaleVoucherNo());
                    fscOrderInfoBO.setInspTotalMoney(new BigDecimal(childOrderBo.getSaleFeeMoney()));
                    fscOrderInfoBO.setInspInvoiceMoney(childOrderBo.getDownTotalLeaveInvoiceAmt());
                }
                if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                    fscOrderInfoBO.setOrderNo(row.getPurchaseVoucherNo());
                    fscOrderInfoBO.setInspTotalMoney(new BigDecimal(childOrderBo.getPurchaseFeeMoney()));
                    fscOrderInfoBO.setInspInvoiceMoney(childOrderBo.getUpTotalLeaveInvoiceAmt());
                }
                fscOrderInfoBO.setFscOrderItemBOS(fscOrderItemBOS);
                fscOrderInfoBO.setOrderType(Integer.valueOf(row.getOrderType()));
                fscOrderInfoBO.setOperatorId(childOrderBo.getOperatorId());
                fscOrderInfoBO.setOperatorName(childOrderBo.getOperatorName());
                fscOrderInfoBO.setOperationNo(childOrderBo.getOperationNo());
                fscOrderInfoBoMap.put(fscOrderInfoBO.getAcceptOrderId(), fscOrderInfoBO);
                orderCodeList.add(row.getSaleVoucherNo());
                if (StringUtils.isEmpty((CharSequence)childOrderBo.getOperatorName())) continue;
                orderOperList.add(childOrderBo.getOperatorName());
            }
            fscOrderInfoBO.setFscOrderItemBOS(fscOrderItemBOS);
        }
        rspBO.setFscOrderInfoBoMap(fscOrderInfoBoMap);
        rspBO.setOrderCodeList(orderCodeList);
        rspBO.setOrderOperList(orderOperList);
    }
}

