/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.external.api.bo.FscContractCapitalPlanSynBo;
import com.tydic.fsc.busibase.external.api.bo.FscGetContractCapitalPlanBo;
import com.tydic.fsc.busibase.external.api.bo.FscGetContractCapitalPlanReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetContractCapitalPlanRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscGetContractCapitalPlanService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscPurchasePushLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscPurchasePushLogPo;
import com.tydic.fsc.utils.SSLClient;
import com.tydic.uac.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscGetContractCapitalPlanServiceImpl
implements FscGetContractCapitalPlanService {
    private static final Logger log = LoggerFactory.getLogger(FscGetContractCapitalPlanServiceImpl.class);
    @Value(value="${CONTRACT_CAPITAL_PLAN_URL:http://172.20.8.161:8097/apiHandler/getAllMsg}")
    private String contractCapitalPlanUrl;
    @Value(value="${CONTRACT_CAPITAL_PLAN_ADVANCE_SQL:532}")
    private String contractCapitalPlanAdvanceSql;
    @Value(value="${CONTRACT_CAPITAL_PLAN_SETTLE_SQL:539}")
    private String contractCapitalPlanSettleSql;
    @Autowired
    private FscPurchasePushLogMapper fscPurchasePushLogMapper;

    @Override
    public FscGetContractCapitalPlanRspBO GetContractCapitalPlan(FscGetContractCapitalPlanReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getPeriod()) || CollectionUtils.isEmpty(reqBO.getContractNum()) || reqBO.getOrgId() == null || StringUtils.isEmpty((Object)reqBO.getToken()) || reqBO.getCapitalPayType() == null) {
            throw new BusinessException("198888", "\u83b7\u53d6\u8d44\u91d1\u8ba1\u5212\u5165\u53c2\u7f3a\u5931");
        }
        FscGetContractCapitalPlanRspBO rspBO = new FscGetContractCapitalPlanRspBO();
        ArrayList<FscGetContractCapitalPlanBo> rows = new ArrayList<FscGetContractCapitalPlanBo>();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", reqBO.getToken());
        for (String num : reqBO.getContractNum()) {
            String respStr = "";
            JSONObject data = new JSONObject();
            if (reqBO.getCapitalPayType() == 1) {
                data.put("sqlId", (Object)this.contractCapitalPlanAdvanceSql);
            } else {
                data.put("sqlId", (Object)this.contractCapitalPlanSettleSql);
            }
            JSONObject jsonMap = new JSONObject();
            jsonMap.put("ORG_ID", (Object)reqBO.getOrgId());
            jsonMap.put("CONTRACT_NUM", (Object)num);
            jsonMap.put("PERIOD", (Object)reqBO.getPeriod());
            if (reqBO.getPageNo() != null && reqBO.getPageSize() != null) {
                jsonMap.put("pageNum", (Object)reqBO.getPageNo());
                jsonMap.put("pageSize", (Object)reqBO.getPageSize());
            }
            data.put("jsonMap", (Object)jsonMap);
            String s = JSONObject.toJSONString((Object)data);
            log.info("\u67e5\u8be2\u8d44\u91d1\u8ba1\u5212\u5165\u53c2\uff1a" + s + " \u67e5\u8be2\u8d44\u91d1\u8ba1\u5212Token:" + reqBO.getToken());
            try {
                respStr = SSLClient.doPostWithHeadMap(this.contractCapitalPlanUrl, s, header);
            }
            catch (Exception e) {
                this.saveLog(num, "\u67e5\u8be2\u8d44\u91d1\u8ba1\u5212\u5165\u53c2\uff1a" + s + " \u67e5\u8be2\u8d44\u91d1\u8ba1\u5212Token:" + reqBO.getToken(), e.getMessage(), 0);
                throw new FscBusinessException("198888", "\u67e5\u8be2\u8d44\u91d1\u8ba1\u5212\u5931\u8d25\uff01[" + e.getMessage() + "]");
            }
            if (StringUtils.isEmpty((Object)respStr)) {
                this.saveLog(num, "\u67e5\u8be2\u8d44\u91d1\u8ba1\u5212\u5165\u53c2\uff1a" + s + " \u67e5\u8be2\u8d44\u91d1\u8ba1\u5212Token:" + reqBO.getToken(), "\u67e5\u8be2\u8d44\u91d1\u8ba1\u5212\u67e5\u8be2\u8fd4\u56de\u503c\u4e3a\u7a7a", 0);
                throw new FscBusinessException("198888", "\u67e5\u8be2\u8d44\u91d1\u8ba1\u5212\u8fd4\u56de\u503c\u4e3a\u7a7a\uff01");
            }
            log.info("\u67e5\u8be2\u8d44\u91d1\u8ba1\u5212" + respStr);
            try {
                List<FscGetContractCapitalPlanBo> list = this.resolveRsp(respStr, rspBO, reqBO);
                rows.addAll(list);
            }
            catch (Exception e) {
                this.saveLog(num, "\u67e5\u8be2\u8d44\u91d1\u8ba1\u5212\u5165\u53c2\uff1a" + s + " \u67e5\u8be2\u8d44\u91d1\u8ba1\u5212Token:" + reqBO.getToken(), "\u89e3\u6790\u67e5\u8be2\u8d44\u91d1\u8ba1\u5212\u8fd4\u56de\u62a5\u6587\u5931\u8d25:" + respStr, 0);
                throw new FscBusinessException("198888", "\u89e3\u6790\u67e5\u8be2\u8d44\u91d1\u8ba1\u5212\u8fd4\u56de\u62a5\u6587\u5931\u8d25\uff01[" + respStr + "]");
            }
        }
        rspBO.setRows(rows);
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private List<FscGetContractCapitalPlanBo> resolveRsp(String respStr, FscGetContractCapitalPlanRspBO planRspBO, FscGetContractCapitalPlanReqBO reqBO) {
        ArrayList<FscGetContractCapitalPlanBo> rspBO = new ArrayList<FscGetContractCapitalPlanBo>();
        JSONObject jsonObject = JSONObject.parseObject((String)respStr);
        if (!((Boolean)jsonObject.get((Object)"state")).booleanValue()) {
            throw new BusinessException("8888", (String)jsonObject.get((Object)"message"));
        }
        JSONObject value = (JSONObject)jsonObject.get((Object)"value");
        JSONArray rows = (JSONArray)value.get((Object)"rows");
        Integer total = (Integer)value.get((Object)"total");
        if (!CollectionUtils.isEmpty((Collection)rows)) {
            List list = JSONObject.parseArray((String)JSONObject.toJSONString((Object)rows), FscContractCapitalPlanSynBo.class);
            for (FscContractCapitalPlanSynBo bo : list) {
                FscGetContractCapitalPlanBo planBo = new FscGetContractCapitalPlanBo();
                planBo.setLineId(bo.getLINE_ID());
                planBo.setHeaderId(bo.getHEADER_ID());
                planBo.setItemId(bo.getITEM_ID());
                planBo.setItemName(bo.getITEM_NAME());
                planBo.setSource(bo.getSOURCE());
                planBo.setCapitalType(bo.getCAPITAL_TYPE());
                planBo.setRecOrgId(bo.getREC_ORG_ID());
                planBo.setRecOrgName(bo.getREC_ORG_NAME());
                planBo.setPaperAmount(bo.getPAPER_AMOUNT());
                planBo.setNotPayAmount(bo.getNOT_PAY_AMOUNT());
                planBo.setPlanAmount(bo.getPLAN_AMOUNT());
                planBo.setContractNum(bo.getCONTRACT_NUM());
                planBo.setContractName(bo.getCONTRACT_NAME());
                planBo.setContractId(bo.getCONTRACT_ID());
                planBo.setPeriod(bo.getPERIOD());
                planBo.setOrgName(bo.getORG_NAME());
                planBo.setAmount(bo.getAMOUNT());
                planBo.setExeAmount(bo.getEXE_AMOUNT());
                planBo.setOccAmount(bo.getOCC_AMOUNT());
                planBo.setRemark(bo.getREMARK());
                planBo.setTabType(bo.getTAB_TYPE());
                planBo.setOrgId(bo.getORG_ID());
                rspBO.add(planBo);
            }
        }
        if (total != null && reqBO.getPageNo() != null && reqBO.getPageSize() != null) {
            planRspBO.setRecordsTotal(total);
            planRspBO.setPageNo(reqBO.getPageNo());
            planRspBO.setTotal(total % reqBO.getPageSize() > 0 ? total / reqBO.getPageSize() + 1 : total / reqBO.getPageSize());
        }
        return rspBO;
    }

    private void saveLog(String objectNo, String pushData, String rspData, Integer state) {
        FscPurchasePushLogPo purchasePushLogPo = new FscPurchasePushLogPo();
        purchasePushLogPo.setObjectNo(objectNo);
        purchasePushLogPo.setCreateTime(new Date());
        purchasePushLogPo.setPushStatus(state);
        purchasePushLogPo.setRespData(rspData);
        purchasePushLogPo.setType(FscConstants.FscPurchasePushType.CONTRACT_CAPITAL_PLAN);
        purchasePushLogPo.setPushData(pushData);
        purchasePushLogPo.setId(Sequence.getInstance().nextId());
        this.fscPurchasePushLogMapper.insert(purchasePushLogPo);
    }
}

