/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoItemReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoItemRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscGetInvoiceInfoItemExternalService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.EsbParamUtil;
import com.tydic.fsc.utils.SSLClient;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class FscGetInvoiceInfoItemExternalServiceImpl
implements FscGetInvoiceInfoItemExternalService {
    private static final Logger log = LoggerFactory.getLogger(FscGetInvoiceInfoItemExternalServiceImpl.class);
    @Autowired
    private Environment environment;
    @Value(value="${esb.getInvoiceItem.url:}")
    private String ESB_GET_INVOICE_INFO_URL;

    @Override
    public FscGetInvoiceInfoItemRspBO getInvoiceInfoItem(FscGetInvoiceInfoItemReqBO reqBO) {
        this.val(reqBO);
        String hsn = this.environment.getProperty("SUPPLIER_ID_" + reqBO.getSupplierId());
        String reqStr = JSON.toJSONString((Object)((Object)reqBO), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        JSONObject jsonObject = JSON.parseObject((String)reqStr);
        if (null != reqBO.getProOrgId()) {
            jsonObject.put("orgId", (Object)reqBO.getProOrgId());
        }
        reqStr = JSON.toJSONString((Object)jsonObject);
        String reqEsbStr = EsbParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_PAY");
        log.debug("\u83b7\u53d6\u7b2c\u4e09\u65b9\u5f00\u7968\u660e\u7ec6\u6570\u636e\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)this.ESB_GET_INVOICE_INFO_URL);
        log.debug("\u83b7\u53d6\u7b2c\u4e09\u65b9\u5f00\u7968\u660e\u7ec6\u6570\u636e\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)reqEsbStr);
        String rspJson = SSLClient.doPost(this.ESB_GET_INVOICE_INFO_URL, reqEsbStr);
        String replaced = rspJson.replaceAll("\\\\r", "");
        log.debug("\u83b7\u53d6\u7b2c\u4e09\u65b9\u5f00\u7968\u660e\u7ec6\u6570\u636e\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)rspJson);
        log.debug("\u83b7\u53d6\u7b2c\u4e09\u65b9\u5f00\u7968\u660e\u7ec6\u6570\u636e\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)replaced);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)rspJson)) {
            throw new FscBusinessException("194319", "\u8bf7\u6c42\u8bf7\u6c42ESB\u83b7\u53d6\u7535\u5546\u5f00\u7968\u660e\u7ec6\u6570\u636e\u63a5\u53e3\u8fd4\u56de\u7a7a");
        }
        FscGetInvoiceInfoItemRspBO rspBO = (FscGetInvoiceInfoItemRspBO)((Object)JSON.parseObject((String)replaced, FscGetInvoiceInfoItemRspBO.class));
        if (null == rspBO.getSuccess() || !rspBO.getSuccess().booleanValue() || null == rspBO.getResult()) {
            throw new FscBusinessException("194319", "\u7535\u5546\u8fd4\u56de\u9519\u8bef\u63cf\u8ff0\uff1a" + rspBO.getResultMessage());
        }
        if (null == rspBO.getResult()) {
            throw new FscBusinessException("194319", "\u8bf7\u6c42\u8bf7\u6c42ESB\u83b7\u53d6\u7535\u5546\u5f00\u7968\u660e\u7ec6\u6570\u636e\u63a5\u53e3result\u8fd4\u56de\u7a7a");
        }
        rspBO.setResultCode("0000");
        return rspBO;
    }

    private void val(FscGetInvoiceInfoItemReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u7535\u5546\u5f00\u7968\u8be6\u60c5\u6570\u636e\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)reqBO), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        if (StringUtils.isBlank((String)reqBO.getInvoiceCode())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[invoiceCode]\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getInvoiceId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[invoiceId]\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getSupplierId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[supplierId]\u4e3a\u7a7a");
        }
    }

    public String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\t|\\r|\\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }
}

