/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscOrderItemBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListPageQueryReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListPageQueryRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionItemListBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocInspectionDetailsListPageQueryService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.TaxUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscAcceptOrderListQueryAtomServiceImpl
implements FscAcceptOrderListQueryAtomService {
    private static final Logger log = LogManager.getLogger(FscAcceptOrderListQueryAtomServiceImpl.class);
    @Autowired
    private FscUocInspectionDetailsListPageQueryService fscUocInspectionDetailsListPageQueryService;
    private static final Integer SCALE_EIGHT = 8;
    private static final Integer SCALE_FOUR = 4;
    @Value(value="${acceptOrderTabId:80013}")
    private Integer TAB_ID;

    @Override
    public FscAcceptOrderListQueryAtomRspBO query(FscAcceptOrderListQueryAtomReqBO reqBO) {
        FscAcceptOrderListQueryAtomRspBO rspBO = new FscAcceptOrderListQueryAtomRspBO();
        if (null == reqBO.getTabId()) {
            reqBO.setTabId(this.TAB_ID);
        }
        reqBO.setIsAfterSales(false);
        return this.packOrderInfo(reqBO, rspBO);
    }

    private FscAcceptOrderListQueryAtomRspBO packOrderInfo(FscAcceptOrderListQueryAtomReqBO reqBO, FscAcceptOrderListQueryAtomRspBO rspBO) {
        FscUocInspectionDetailsListPageQueryReqBO fscUocInspectionDetailsListPageQueryReqBO = (FscUocInspectionDetailsListPageQueryReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscUocInspectionDetailsListPageQueryReqBO.class));
        if (reqBO.getPageSize() == null) {
            fscUocInspectionDetailsListPageQueryReqBO.setPageSize(100000);
        }
        fscUocInspectionDetailsListPageQueryReqBO.setIsChange("0");
        fscUocInspectionDetailsListPageQueryReqBO.setIsFscQuery("0");
        FscUocInspectionDetailsListPageQueryRspBO fscUocInspectionDetailsListPageQueryRspBO = this.fscUocInspectionDetailsListPageQueryService.getInspectionDetailsList(fscUocInspectionDetailsListPageQueryReqBO);
        if (!"0000".equals(fscUocInspectionDetailsListPageQueryRspBO.getRespCode())) {
            throw new FscBusinessException("194301", fscUocInspectionDetailsListPageQueryRspBO.getRespDesc());
        }
        HashMap<Long, FscOrderInfoBO> fscOrderInfoBoMap = new HashMap<Long, FscOrderInfoBO>();
        HashSet<String> orderCodeList = new HashSet<String>();
        HashSet<String> orderOperList = new HashSet<String>();
        for (FscUocInspectionDetailsListBO row : fscUocInspectionDetailsListPageQueryRspBO.getRows()) {
            FscOrderInfoBO fscOrderInfoBO = (FscOrderInfoBO)JSON.parseObject((String)JSON.toJSONString((Object)row), FscOrderInfoBO.class);
            ArrayList<FscOrderItemBO> fscOrderItemBOS = new ArrayList<FscOrderItemBO>();
            for (FscUocInspectionItemListBO fscUocInspectionItemListBO : row.getInspectionItemInfo()) {
                BigDecimal welfareRate;
                BigDecimal personRate;
                if (new BigDecimal(fscUocInspectionItemListBO.getInspectionCount()).compareTo(BigDecimal.ZERO) <= 0 || (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) || FscConstants.FscOrderReceiveType.INDIVIDUAL.equals(reqBO.getReceiveType())) && fscUocInspectionItemListBO.getDownLeaveInvoiceNum().compareTo(BigDecimal.ZERO) <= 0 || FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType()) && fscUocInspectionItemListBO.getUpLeaveInvoiceNum().compareTo(BigDecimal.ZERO) <= 0) continue;
                FscOrderItemBO fscOrderItemBO = (FscOrderItemBO)JSONObject.parseObject((String)JSON.toJSONString((Object)fscUocInspectionItemListBO), FscOrderItemBO.class);
                fscOrderItemBO.setAcceptOrderId(Long.valueOf(Long.parseLong(row.getInspectionVoucherId())));
                fscOrderItemBO.setTotalNum(new BigDecimal(fscUocInspectionItemListBO.getInspectionCount()));
                fscOrderItemBO.setNum(new BigDecimal(fscUocInspectionItemListBO.getInspectionCount()));
                if (FscConstants.OpenInvoiceType.INDIVIDUALLY_DOWN.equals(reqBO.getOpenInvoiceType())) {
                    personRate = fscUocInspectionItemListBO.getSaleMoneyIntegral().divide(new BigDecimal(fscUocInspectionItemListBO.getInspSaleMoney()), (int)SCALE_EIGHT, RoundingMode.HALF_UP);
                    log.debug("\u5458\u5de5\u4e2a\u4eba\u4e0b\u6e38\u5f00\u7968\u67e5\u8be2,\u4e2a\u4eba\u5360\u6bd4\uff1a{}", (Object)personRate.toString());
                    fscOrderItemBO.setNum(new BigDecimal(fscUocInspectionItemListBO.getInspectionCount()).multiply(personRate).setScale((int)SCALE_FOUR, RoundingMode.HALF_UP));
                }
                if (FscConstants.OpenInvoiceType.WELFARE_PUR_DOWN.equals(reqBO.getOpenInvoiceType())) {
                    welfareRate = fscUocInspectionItemListBO.getIntegralFee().divide(new BigDecimal(fscUocInspectionItemListBO.getInspSaleMoney()), (int)SCALE_EIGHT, RoundingMode.HALF_UP);
                    log.debug("\u5458\u5de5\u8d85\u5e02\u4e0b\u6e38\u5f00\u7968\u67e5\u8be2,\u798f\u5229\u5360\u6bd4\uff1a{}", (Object)welfareRate.toString());
                    fscOrderItemBO.setNum(new BigDecimal(fscUocInspectionItemListBO.getInspectionCount()).multiply(welfareRate).setScale((int)SCALE_FOUR, RoundingMode.HALF_UP));
                }
                fscOrderItemBO.setPlanItemCode(fscUocInspectionItemListBO.getPlanItemCode());
                fscOrderItemBO.setPlanItemName(fscUocInspectionItemListBO.getPlanItemName());
                fscOrderItemBO.setPlanItemSpecification(fscUocInspectionItemListBO.getPlanItemSpecification());
                fscOrderItemBO.setMaterialBj(fscUocInspectionItemListBO.getMaterialBj());
                fscOrderItemBO.setSendCount(new BigDecimal(fscUocInspectionItemListBO.getSendCount()));
                fscOrderItemBO.setSkuIdExt(fscUocInspectionItemListBO.getExtSkuId());
                fscOrderItemBO.setTaxRate(new BigDecimal(fscUocInspectionItemListBO.getTax()).divide(new BigDecimal(100), 2, 4));
                fscOrderItemBO.setUnit(fscUocInspectionItemListBO.getUnitName());
                if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) || FscConstants.FscOrderReceiveType.INDIVIDUAL.equals(reqBO.getReceiveType())) {
                    fscOrderItemBO.setTotalAmt(new BigDecimal(fscUocInspectionItemListBO.getInspSaleMoney()));
                    fscOrderItemBO.setAmt(fscUocInspectionItemListBO.getDownLeaveInvoiceAmt());
                    fscOrderItemBO.setNum(fscUocInspectionItemListBO.getDownLeaveInvoiceNum());
                    fscOrderItemBO.setPrice(new BigDecimal(fscUocInspectionItemListBO.getSellingPrice()));
                    if (FscConstants.OpenInvoiceType.INDIVIDUALLY_DOWN.equals(reqBO.getOpenInvoiceType())) {
                        fscOrderItemBO.setAmt(fscUocInspectionItemListBO.getSaleMoneyIntegral());
                    }
                    if (FscConstants.OpenInvoiceType.WELFARE_PUR_DOWN.equals(reqBO.getOpenInvoiceType())) {
                        fscOrderItemBO.setAmt(fscUocInspectionItemListBO.getIntegralFee());
                    }
                }
                if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                    fscOrderItemBO.setTotalAmt(new BigDecimal(fscUocInspectionItemListBO.getInspPurchaseMoney()));
                    fscOrderItemBO.setAmt(fscUocInspectionItemListBO.getUpLeaveInvoiceAmt());
                    fscOrderItemBO.setNum(fscUocInspectionItemListBO.getUpLeaveInvoiceNum());
                    fscOrderItemBO.setPrice(new BigDecimal(fscUocInspectionItemListBO.getPurchasingPrice()));
                }
                if (null != fscOrderItemBO.getAmt()) {
                    fscOrderItemBO.setTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemBO.getAmt(), (BigDecimal)fscOrderItemBO.getTaxRate()));
                    fscOrderItemBO.setUntaxAmt(fscOrderItemBO.getAmt().subtract(fscOrderItemBO.getTaxAmt()));
                }
                fscOrderItemBO.setSaleAmt(new BigDecimal(fscUocInspectionItemListBO.getInspSaleMoney()));
                if (FscConstants.OpenInvoiceType.INDIVIDUALLY_DOWN.equals(reqBO.getOpenInvoiceType())) {
                    personRate = fscUocInspectionItemListBO.getSaleMoneyIntegral().divide(new BigDecimal(fscUocInspectionItemListBO.getInspSaleMoney()), (int)SCALE_EIGHT, RoundingMode.HALF_UP);
                    fscOrderItemBO.setSaleAmt(new BigDecimal(fscUocInspectionItemListBO.getInspSaleMoney()).multiply(personRate));
                }
                if (FscConstants.OpenInvoiceType.WELFARE_PUR_DOWN.equals(reqBO.getOpenInvoiceType())) {
                    welfareRate = fscUocInspectionItemListBO.getIntegralFee().divide(new BigDecimal(fscUocInspectionItemListBO.getInspSaleMoney()), (int)SCALE_EIGHT, RoundingMode.HALF_UP);
                    fscOrderItemBO.setSaleAmt(new BigDecimal(fscUocInspectionItemListBO.getInspSaleMoney()).multiply(welfareRate));
                }
                fscOrderItemBO.setSalePrice(new BigDecimal(fscUocInspectionItemListBO.getSellingPrice()));
                fscOrderItemBO.setSaleTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemBO.getSaleAmt(), (BigDecimal)fscOrderItemBO.getTaxRate()));
                fscOrderItemBO.setSaleUntaxAmt(fscOrderItemBO.getSaleAmt().subtract(fscOrderItemBO.getSaleTaxAmt()));
                fscOrderItemBO.setPurchaseAmt(new BigDecimal(fscUocInspectionItemListBO.getInspPurchaseMoney()));
                if (FscConstants.OpenInvoiceType.INDIVIDUALLY_DOWN.equals(reqBO.getOpenInvoiceType())) {
                    personRate = fscUocInspectionItemListBO.getSaleMoneyIntegral().divide(new BigDecimal(fscUocInspectionItemListBO.getInspSaleMoney()), (int)SCALE_EIGHT, RoundingMode.HALF_UP);
                    fscOrderItemBO.setPurchaseAmt(new BigDecimal(fscUocInspectionItemListBO.getInspPurchaseMoney()).multiply(personRate));
                }
                if (FscConstants.OpenInvoiceType.WELFARE_PUR_DOWN.equals(reqBO.getOpenInvoiceType())) {
                    welfareRate = fscUocInspectionItemListBO.getIntegralFee().divide(new BigDecimal(fscUocInspectionItemListBO.getInspSaleMoney()), (int)SCALE_EIGHT, RoundingMode.HALF_UP);
                    fscOrderItemBO.setPurchaseAmt(new BigDecimal(fscUocInspectionItemListBO.getInspPurchaseMoney()).multiply(welfareRate));
                }
                fscOrderItemBO.setPurchasePrice(new BigDecimal(fscUocInspectionItemListBO.getPurchasingPrice()));
                fscOrderItemBO.setPurchaseTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemBO.getPurchaseAmt(), (BigDecimal)fscOrderItemBO.getTaxRate()));
                fscOrderItemBO.setPurchaseUntaxAmt(fscOrderItemBO.getPurchaseAmt().subtract(fscOrderItemBO.getPurchaseTaxAmt()));
                fscOrderItemBO.setOrderItemId(Long.valueOf(Long.parseLong(fscUocInspectionItemListBO.getInspectionItemId())));
                fscOrderItemBO.setOrderCode(row.getSaleVoucherNo());
                fscOrderItemBO.setAcceptOrderCode(row.getInspectionVoucherCode());
                fscOrderItemBO.setSalesUnitRate(fscUocInspectionItemListBO.getSalesUnitRate());
                fscOrderItemBO.setSettleUnit(fscUocInspectionItemListBO.getSettleUnit());
                if (fscUocInspectionItemListBO.getSalesUnitRate() != null && fscUocInspectionItemListBO.getSalesUnitRate().compareTo(BigDecimal.ZERO) > 0 && fscOrderItemBO.getPrice() != null) {
                    fscOrderItemBO.setSettlePrice(fscOrderItemBO.getPrice().divide(fscUocInspectionItemListBO.getSalesUnitRate(), 8, 4));
                    fscOrderItemBO.setSettleNum(fscOrderItemBO.getNum().multiply(fscUocInspectionItemListBO.getSalesUnitRate()));
                }
                fscOrderItemBO.setSkuMaterialName(fscUocInspectionItemListBO.getSkuMaterialName());
                fscOrderItemBO.setMaterialModel(fscUocInspectionItemListBO.getMaterialModel());
                fscOrderItemBO.setMaterialSpec(fscUocInspectionItemListBO.getMaterialSpec());
                fscOrderItemBO.setSkuMaterialId(fscUocInspectionItemListBO.getSkuMaterialId());
                fscOrderItemBOS.add(fscOrderItemBO);
            }
            fscOrderInfoBO.setAcceptOrderId(Long.valueOf(Long.parseLong(row.getInspectionVoucherId())));
            fscOrderInfoBO.setOrderId(Long.valueOf(Long.parseLong(row.getOrderId())));
            fscOrderInfoBO.setAcceptOrderNo(row.getInspectionVoucherCode());
            fscOrderInfoBO.setExtOrderNo(row.getOutOrderId());
            fscOrderInfoBO.setSupplierName(row.getSupName());
            fscOrderInfoBO.setSupplierId(row.getSupNo());
            fscOrderInfoBO.setProOrgName(row.getProName());
            fscOrderInfoBO.setProOrgId(row.getProNo());
            fscOrderInfoBO.setPurchaserName(row.getPurName());
            fscOrderInfoBO.setPurchaserId(row.getPurNo());
            fscOrderInfoBO.setPayNodeAccountDays(row.getPaymentDays());
            fscOrderInfoBO.setOrderNo(row.getSaleVoucherNo());
            fscOrderInfoBO.setBusiMode(row.getTradeMode());
            if (!StringUtils.isBlank((CharSequence)row.getPurAccount())) {
                fscOrderInfoBO.setAccountSetId(Long.valueOf(row.getPurAccount()));
            }
            fscOrderInfoBO.setAccountSetName(row.getPurAccountName());
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) || FscConstants.FscOrderReceiveType.INDIVIDUAL.equals(reqBO.getReceiveType())) {
                fscOrderInfoBO.setOrderNo(row.getSaleVoucherNo());
                fscOrderInfoBO.setInspTotalMoney(row.getInspTotalSaleMoney());
                fscOrderInfoBO.setInspInvoiceMoney(row.getDownTotalLeaveInvoiceAmt());
            }
            if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                fscOrderInfoBO.setOrderNo(row.getPurchaseVoucherNo());
                fscOrderInfoBO.setInspTotalMoney(row.getInspTotalPurchaseMoney());
                fscOrderInfoBO.setInspInvoiceMoney(row.getUpTotalLeaveInvoiceAmt());
            }
            fscOrderInfoBO.setFscOrderItemBOS(fscOrderItemBOS);
            fscOrderInfoBO.setOrderType(row.getOrderType());
            fscOrderInfoBO.setOperatorId(row.getOperatorId());
            fscOrderInfoBO.setOperatorName(row.getOperatorName());
            fscOrderInfoBO.setOperatorDeptId(row.getAdminConfrimOrgId());
            fscOrderInfoBO.setOperatorDeptName(row.getAdminConfrimOrgName());
            fscOrderInfoBO.setOperationNo(row.getOperationNo());
            fscOrderInfoBO.setModelContractId(row.getModelContractId());
            fscOrderInfoBO.setProModelContractId(row.getProModelContractId());
            fscOrderInfoBO.setModelContractNo(row.getModelContractNo());
            fscOrderInfoBO.setProModelContractNo(row.getProModelContractNo());
            fscOrderInfoBO.setProtocolId(row.getProtocolId());
            fscOrderInfoBO.setPlaAgreementCode(row.getPlaAgreementCode());
            fscOrderInfoBoMap.put(fscOrderInfoBO.getAcceptOrderId(), fscOrderInfoBO);
            orderCodeList.add(row.getSaleVoucherNo());
            if (StringUtils.isEmpty((CharSequence)row.getOperatorName())) continue;
            orderOperList.add(row.getOperatorName());
        }
        rspBO.setFscOrderInfoBoMap(fscOrderInfoBoMap);
        rspBO.setOrderCodeList(orderCodeList);
        rspBO.setOrderOperList(orderOperList);
        rspBO.setTotal(fscUocInspectionDetailsListPageQueryRspBO.getTotal());
        rspBO.setRecordsTotal(fscUocInspectionDetailsListPageQueryRspBO.getRecordsTotal());
        rspBO.setPageNo(fscUocInspectionDetailsListPageQueryRspBO.getPageNo());
        return rspBO;
    }
}

