/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscAccountAdvanceDeductAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAccountAdvanceDeductAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAccountAdvanceDeductAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.enums.AdvancePayTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscPayLogPO;
import com.tydic.uoc.common.ability.api.UocInspectionDetailsListPageQueryAbilityService;
import com.tydic.uoc.common.ability.api.UocOrderIdQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocInspectionDetailsListPageQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocOrderIdQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocOrderIdQueryRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscAccountAdvanceDeductAtomServiceImpl
implements FscAccountAdvanceDeductAtomService {
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private UocOrderIdQueryAbilityService uocOrderIdQueryAbilityService;
    @Autowired
    private UocInspectionDetailsListPageQueryAbilityService uocInspectionDetailsListPageQueryAbilityService;
    @Value(value="${acceptOrderTabId:80013}")
    private Integer TAB_ID;

    @Override
    public FscAccountAdvanceDeductAtomRspBO dealAccountAdvanceDeduct(FscAccountAdvanceDeductAtomReqBO reqBO) {
        FscPayLogPO payLogPo;
        FscMerchantPO fscMerchantPo = new FscMerchantPO();
        fscMerchantPo.setOrgId(reqBO.getSupId());
        fscMerchantPo.setDelFlag(FscConstants.DicDelFlag.NO);
        fscMerchantPo.setEnable(1);
        fscMerchantPo.setPayBusiSceneRangeLike(reqBO.getPayBusiness());
        fscMerchantPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        fscMerchantPo = this.fscMerchantMapper.getModelBy(fscMerchantPo);
        if (null == fscMerchantPo) {
            throw new FscBusinessException("194304", "\u67e5\u8be2\u5546\u6237\u4e3a\u7a7a");
        }
        FscMerchantPO merchant = new FscMerchantPO();
        merchant.setPayBusiSceneRangeLike(reqBO.getPayBusiness());
        merchant.setParentId(fscMerchantPo.getMerchantId());
        merchant.setDelFlag(FscConstants.DicDelFlag.NO);
        merchant.setEnable(1);
        merchant.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
        merchant.setPayObjId(reqBO.getCreditOrgId());
        merchant = this.fscMerchantMapper.getModelBy(merchant);
        if (null != merchant) {
            BeanUtils.copyProperties((Object)merchant, (Object)fscMerchantPo);
        }
        BigDecimal overdraft = fscMerchantPo.getOverdraft();
        FscAccountPO fscAccountPo = null;
        FscAccountPO deptAccount = null;
        FscAccountPO queryVo = new FscAccountPO();
        queryVo.setBusiType(reqBO.getPayBusiness());
        if (reqBO.getDeptId() != null && !Objects.equals(reqBO.getCreditOrgId(), reqBO.getDeptId())) {
            queryVo.setOrgId(reqBO.getDeptId());
            queryVo.setOrgTreePath(reqBO.getCreditOrgId().toString());
            deptAccount = this.fscAccountMapper.getModelBy(queryVo);
            if (deptAccount != null && (deptAccount.getAdvanceAmount().compareTo(BigDecimal.ZERO) > 0 || deptAccount.getOverdraftAmount().compareTo(BigDecimal.ZERO) > 0)) {
                overdraft = deptAccount.getOverdraft();
                fscAccountPo = deptAccount;
            }
        }
        queryVo.setOrgId(null);
        queryVo.setOrgTreePath(null);
        queryVo.setOrgCode(reqBO.getCreditOrgCode());
        FscAccountPO parentAccountPo = this.fscAccountMapper.getModelBy(queryVo);
        if (fscAccountPo == null && parentAccountPo == null) {
            throw new FscBusinessException("194304", "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u76f8\u5173\u4fe1\u606f\uff01");
        }
        if (fscAccountPo == null) {
            fscAccountPo = parentAccountPo;
        }
        overdraft = overdraft.subtract(fscAccountPo.getDistributeOverdraftAmount());
        BigDecimal totalAmt = reqBO.getTotalAmount();
        BigDecimal totalAvailableCredit = fscAccountPo.getAdvanceAmount().subtract(fscAccountPo.getFreezeAmount()).subtract(fscAccountPo.getUseAmount()).subtract(fscAccountPo.getDistributeAdvanceAmount());
        FscAccountAdvanceDeductAtomRspBO rspBO = new FscAccountAdvanceDeductAtomRspBO();
        FscPayLogPO fscPayLogPo = new FscPayLogPO();
        String orderNo = reqBO.getOrderNo();
        fscPayLogPo.setBusiOrderNo(orderNo);
        ArrayList<Integer> busiCategoryList = new ArrayList<Integer>();
        busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_FREEZE);
        fscPayLogPo.setBusiCategoryList(busiCategoryList);
        List<FscPayLogPO> fscPayLogPoList = this.fscPayLogMapper.getList(fscPayLogPo);
        if (CollectionUtils.isEmpty(fscPayLogPoList) && reqBO.getOrderNo().contains("-")) {
            orderNo = orderNo.substring(0, orderNo.lastIndexOf("-"));
        }
        fscPayLogPo.setBusiOrderNo(orderNo);
        busiCategoryList.add(FscConstants.FscBusiCategory.ADVANCE_REFUND);
        fscPayLogPo.setBusiCategoryList(busiCategoryList);
        fscPayLogPoList = this.fscPayLogMapper.getList(fscPayLogPo);
        if (CollectionUtils.isEmpty(fscPayLogPoList) && orderNo.contains("DTWZ")) {
            orderNo = orderNo.replace("DTWZ", "DTGFWZB");
            fscPayLogPo.setBusiOrderNo(orderNo);
            fscPayLogPoList = this.fscPayLogMapper.getList(fscPayLogPo);
        }
        if (!CollectionUtils.isEmpty(fscPayLogPoList)) {
            BigDecimal busiAmount = BigDecimal.ZERO;
            BigDecimal advanceAmount = BigDecimal.ZERO;
            BigDecimal overdraftAmount = BigDecimal.ZERO;
            for (FscPayLogPO po : fscPayLogPoList) {
                busiAmount = busiAmount.add(po.getBusiAmount());
                advanceAmount = advanceAmount.add(po.getAdvanceAmt());
                overdraftAmount = overdraftAmount.add(po.getOverdraftAmt());
                if (!FscConstants.FscBusiCategory.ADVANCE_FREEZE.equals(po.getBusiCategory())) continue;
                fscPayLogPo = po;
            }
            fscPayLogPo.setBusiAmount(busiAmount);
            fscPayLogPo.setAdvanceAmt(advanceAmount);
            fscPayLogPo.setOverdraftAmt(overdraftAmount);
            fscPayLogPo.setAdvanceAfterAmount(fscPayLogPo.getAdvanceBeforeAmount().subtract(advanceAmount));
            fscPayLogPo.setOverdraftAfterAmount(fscPayLogPo.getOverdraftAfterAmount().subtract(overdraftAmount));
        } else {
            fscPayLogPo = null;
        }
        if (reqBO.getOperationType() == 0) {
            reqBO.setBusiCategory(FscConstants.FscBusiCategory.ADVANCE_FREEZE);
            if (totalAvailableCredit.compareTo(totalAmt) > 0) {
                reqBO.setAdvanceBeforeAmount(totalAvailableCredit);
                reqBO.setOverdraftBefore(overdraft);
                reqBO.setOverdraftAfter(overdraft);
                reqBO.setAdvanceAfterAmount(totalAvailableCredit.subtract(totalAmt));
                rspBO.setAdvancePayType(FscConstants.AdvancePayType.ADVANCE_PAY);
                rspBO.setAdvanceAmt(totalAmt);
                rspBO.setOverdraftAmt(BigDecimal.ZERO);
            } else {
                if (totalAvailableCredit.add(overdraft).compareTo(totalAmt) < 0) {
                    throw new FscBusinessException("194304", "\u9884\u5b58\u6b3e\u989d\u5ea6\u4e0d\u8db3\uff0c\u8054\u7cfb\u8fd0\u8425\u4eba\u5458\u5904\u7406\uff01");
                }
                if (totalAvailableCredit.compareTo(BigDecimal.ZERO) > 0) {
                    reqBO.setAdvanceBeforeAmount(totalAvailableCredit);
                    reqBO.setOverdraftBefore(overdraft);
                    reqBO.setOverdraftAfter(overdraft.subtract(totalAmt.subtract(totalAvailableCredit)));
                    rspBO.setAdvancePayType(FscConstants.AdvancePayType.ADVANCE_OVERDRAFT_PAY);
                    rspBO.setOverdraftAmt(totalAmt.subtract(totalAvailableCredit));
                    rspBO.setAdvanceAmt(totalAvailableCredit);
                } else {
                    reqBO.setAdvanceBeforeAmount(BigDecimal.ZERO);
                    reqBO.setOverdraftBefore(overdraft.add(totalAvailableCredit));
                    reqBO.setOverdraftAfter(reqBO.getOverdraftBefore().subtract(totalAmt));
                    rspBO.setAdvancePayType(FscConstants.AdvancePayType.OVERDRAFT_PAY);
                    rspBO.setOverdraftAmt(totalAmt);
                    rspBO.setAdvanceAmt(BigDecimal.ZERO);
                }
                fscAccountPo.setOverdraftAmount(fscAccountPo.getOverdraftAmount().add(reqBO.getOverdraftBefore().subtract(reqBO.getOverdraftAfter())));
                reqBO.setAdvanceAfterAmount(BigDecimal.ZERO);
            }
            fscAccountPo.setFreezeAmount(fscAccountPo.getFreezeAmount().add(reqBO.getTotalAmount()));
            int count = this.fscAccountMapper.updateAmount(fscAccountPo);
            if (count <= 0) {
                throw new FscBusinessException("194304", "\u64cd\u4f5c\u5931\u8d25,\u7cfb\u7edf\u7e41\u5fd9,\u8bf7\u91cd\u65b0\u4e0b\u5355\uff01");
            }
            reqBO.setAdvanceAmt(reqBO.getAdvanceBeforeAmount().subtract(reqBO.getAdvanceAfterAmount()));
            reqBO.setOverdraftAmt(reqBO.getOverdraftBefore().subtract(reqBO.getOverdraftAfter()));
        } else if (reqBO.getOperationType() == 1) {
            if (fscPayLogPo == null) {
                throw new FscBusinessException("194304", "\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u51bb\u7ed3\u8bb0\u5f55");
            }
            payLogPo = new FscPayLogPO();
            payLogPo.setBusiOrderNo(reqBO.getOrderNo());
            payLogPo.setBusiCategory(FscConstants.FscBusiCategory.ADVANCE_PAY);
            int num = this.fscPayLogMapper.getCheckBy(payLogPo);
            if (num > 0) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u8be5\u8ba2\u5355\u5df2\u5b8c\u6210\u9884\u5b58\u6b3e\u9a8c\u6536\u6263\u51cf\uff01");
                return rspBO;
            }
            fscAccountPo = this.dealUseAccount(reqBO, parentAccountPo, deptAccount, fscPayLogPo);
            if (totalAvailableCredit.compareTo(BigDecimal.ZERO) > 0) {
                reqBO.setAdvanceBeforeAmount(totalAvailableCredit);
                reqBO.setAdvanceAfterAmount(totalAvailableCredit);
                reqBO.setOverdraftBefore(overdraft);
                reqBO.setOverdraftAfter(overdraft);
            } else {
                reqBO.setAdvanceBeforeAmount(BigDecimal.ZERO);
                reqBO.setAdvanceAfterAmount(BigDecimal.ZERO);
                reqBO.setOverdraftBefore(overdraft.add(totalAvailableCredit));
                reqBO.setOverdraftAfter(overdraft.add(totalAvailableCredit));
            }
            reqBO.setBusiCategory(FscConstants.FscBusiCategory.ADVANCE_PAY);
            if (reqBO.getOrderNo().contains("-")) {
                List<FscPayLogPO> fscPayLogPOList = this.fscPayLogMapper.getListByParentNo(orderNo);
                BigDecimal totalBusiAmount = BigDecimal.ZERO;
                if (!CollectionUtils.isEmpty(fscPayLogPOList)) {
                    totalBusiAmount = fscPayLogPOList.stream().map(FscPayLogPO::getBusiAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                if (fscPayLogPo.getAdvanceBeforeAmount().compareTo(totalBusiAmount.add(totalAmt)) > 0) {
                    reqBO.setAdvanceAmt(totalAmt);
                    reqBO.setOverdraftAmt(BigDecimal.ZERO);
                } else if (fscPayLogPo.getAdvanceBeforeAmount().compareTo(totalBusiAmount) > 0) {
                    reqBO.setAdvanceAmt(fscPayLogPo.getAdvanceBeforeAmount().subtract(totalBusiAmount));
                    reqBO.setOverdraftAmt(totalAmt.subtract(reqBO.getAdvanceAmt()));
                } else {
                    reqBO.setAdvanceAmt(BigDecimal.ZERO);
                    reqBO.setOverdraftAmt(totalAmt);
                }
            } else {
                reqBO.setAdvanceAmt(fscPayLogPo.getAdvanceAmt());
                reqBO.setOverdraftAmt(fscPayLogPo.getOverdraftAmt());
            }
            fscAccountPo.setOrderAmount(reqBO.getTotalAmount());
            int count = this.fscAccountMapper.updateUseAmount(fscAccountPo);
            if (count <= 0) {
                throw new FscBusinessException("194304", "\u64cd\u4f5c\u5931\u8d25,\u66f4\u65b0\u8d26\u6237\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (reqBO.getOverdraftAmt().compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal amt = this.fscPayLogMapper.getUsedAdvance(fscAccountPo.getOrgId());
                BigDecimal useAmt = fscAccountPo.getAdvanceAmount().subtract(amt);
                if (useAmt.compareTo(reqBO.getOverdraftAmt()) >= 0) {
                    reqBO.setReimbursementAmount(reqBO.getOverdraftAmt());
                } else if (useAmt.compareTo(BigDecimal.ZERO) > 0) {
                    reqBO.setReimbursementAmount(useAmt);
                }
            }
            if (fscPayLogPo.getOverdraftAmt().subtract(fscPayLogPo.getReimbursementAmount()).compareTo(BigDecimal.ZERO) > 0) {
                if (reqBO.getTotalAmount().compareTo(fscPayLogPo.getOverdraftAmt().subtract(fscPayLogPo.getReimbursementAmount())) > 0) {
                    fscPayLogPo.setReimbursementAmount(fscPayLogPo.getOverdraftAmt().subtract(fscPayLogPo.getReimbursementAmount()));
                } else {
                    fscPayLogPo.setReimbursementAmount(reqBO.getTotalAmount());
                }
                fscPayLogPo.setReimbursementDate(new Date());
                this.fscPayLogMapper.updateBack(Collections.singletonList(fscPayLogPo));
            }
        } else if (reqBO.getOperationType() == 2) {
            if (fscPayLogPo == null) {
                throw new FscBusinessException("194304", "\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u51bb\u7ed3\u8bb0\u5f55");
            }
            if (reqBO.getTotalAmount().compareTo(BigDecimal.ZERO) > 0) {
                reqBO.setTotalAmount(reqBO.getTotalAmount().multiply(new BigDecimal(-1)));
            }
            fscAccountPo = this.dealUseAccount(reqBO, parentAccountPo, deptAccount, fscPayLogPo);
            if (reqBO.getObjId() != null) {
                payLogPo = new FscPayLogPO();
                payLogPo.setBusiCategory(FscConstants.FscBusiCategory.ADVANCE_REFUND);
                payLogPo.setObjId(reqBO.getObjId());
                payLogPo.setBusiOrderNo(reqBO.getOrderNo());
                int num = this.fscPayLogMapper.getCheckBy(payLogPo);
                if (num > 0) {
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u8be5\u8ba2\u5355\u5df2\u5b8c\u6210\u9000\u6b3e,\u8bf7\u52ff\u91cd\u590d\u9000\u6b3e\uff01");
                    return rspBO;
                }
            }
            if (totalAvailableCredit.compareTo(BigDecimal.ZERO) > 0) {
                reqBO.setAdvanceBeforeAmount(totalAvailableCredit);
            } else {
                reqBO.setAdvanceBeforeAmount(BigDecimal.ZERO);
                overdraft = overdraft.add(totalAvailableCredit);
            }
            reqBO.setOverdraftBefore(overdraft);
            reqBO.setBusiCategory(FscConstants.FscBusiCategory.ADVANCE_REFUND);
            if (totalAvailableCredit.compareTo(reqBO.getTotalAmount()) <= 0) {
                reqBO.setAdvanceAfterAmount(reqBO.getAdvanceBeforeAmount());
                reqBO.setOverdraftAfter(overdraft.subtract(reqBO.getTotalAmount()));
            } else if (totalAvailableCredit.compareTo(BigDecimal.ZERO) < 0 && totalAvailableCredit.compareTo(reqBO.getTotalAmount()) > 0) {
                reqBO.setOverdraftAfter(overdraft.subtract(totalAvailableCredit));
                reqBO.setAdvanceAfterAmount(totalAvailableCredit.subtract(reqBO.getTotalAmount()));
            } else {
                reqBO.setAdvanceAfterAmount(totalAvailableCredit.subtract(reqBO.getTotalAmount()));
                reqBO.setOverdraftAfter(overdraft);
            }
            if (fscPayLogPo.getOverdraftAmt().compareTo(BigDecimal.ZERO) <= 0) {
                reqBO.setAdvanceAmt(reqBO.getTotalAmount());
                reqBO.setOverdraftAmt(BigDecimal.ZERO);
            } else if (fscPayLogPo.getOverdraftAmt().add(reqBO.getTotalAmount()).compareTo(BigDecimal.ZERO) >= 0) {
                reqBO.setOverdraftAmt(reqBO.getTotalAmount());
                reqBO.setAdvanceAmt(BigDecimal.ZERO);
            } else {
                reqBO.setOverdraftAmt(fscPayLogPo.getOverdraftAmt().multiply(new BigDecimal(-1)));
                reqBO.setAdvanceAmt(reqBO.getTotalAmount().subtract(reqBO.getOverdraftAmt()));
            }
            fscAccountPo.setFreezeAmount(fscAccountPo.getFreezeAmount().add(reqBO.getTotalAmount()));
            fscAccountPo.setOverdraftAmount(fscAccountPo.getOverdraftAmount().add(reqBO.getOverdraftBefore().subtract(reqBO.getOverdraftAfter())));
            int count = this.fscAccountMapper.updateAmount(fscAccountPo);
            if (count <= 0) {
                throw new FscBusinessException("194304", "\u64cd\u4f5c\u5931\u8d25,\u7cfb\u7edf\u7e41\u5fd9\uff01");
            }
            reqBO.setTotalAmount(reqBO.getTotalAmount());
            rspBO.setAdvanceAmt(reqBO.getAdvanceAmt().multiply(new BigDecimal(-1)));
        }
        this.writeAdviceLog(fscAccountPo, reqBO, fscMerchantPo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscAccountPO dealUseAccount(FscAccountAdvanceDeductAtomReqBO reqBO, FscAccountPO parentAccountPo, FscAccountPO deptAccount, FscPayLogPO fscPayLogPo) {
        if (deptAccount == null) {
            return parentAccountPo;
        }
        if (fscPayLogPo == null || fscPayLogPo.getAccountId() == null) {
            return parentAccountPo;
        }
        if (fscPayLogPo.getAccountId().equals(parentAccountPo.getId())) {
            return parentAccountPo;
        }
        if (fscPayLogPo.getAccountId().equals(deptAccount.getId())) {
            return deptAccount;
        }
        return parentAccountPo;
    }

    private void writeAdviceLog(FscAccountPO fscAccountPo, FscAccountAdvanceDeductAtomReqBO reqBO, FscMerchantPO fscMerchantPO) {
        Date now = reqBO.getBusiTime() != null ? reqBO.getBusiTime() : new Date();
        FscPayLogPO fscPayLogPo = new FscPayLogPO();
        long nextId = Sequence.getInstance().nextId();
        fscPayLogPo.setId(nextId);
        fscPayLogPo.setOrgId(fscAccountPo.getOrgId());
        fscPayLogPo.setUserName(reqBO.getName());
        fscPayLogPo.setBusiTime(now);
        fscPayLogPo.setPayeeId(reqBO.getSupId());
        fscPayLogPo.setBusiOrderType(reqBO.getBusiOrderType());
        fscPayLogPo.setOrderType(reqBO.getOrderType());
        fscPayLogPo.setTradeMode(reqBO.getTradeMode());
        fscPayLogPo.setBusiAmount(reqBO.getTotalAmount());
        fscPayLogPo.setPayBusiness("1");
        fscPayLogPo.setBusiCategory(reqBO.getBusiCategory());
        fscPayLogPo.setOrgCode(reqBO.getCreditOrgCode());
        fscPayLogPo.setAccountId(fscAccountPo.getId());
        fscPayLogPo.setObjId(reqBO.getObjId());
        if (reqBO.getTotalAmount().compareTo(BigDecimal.ZERO) > 0) {
            fscPayLogPo.setBusiCategory(FscConstants.FscBusiCategory.ORDER_PAY);
        } else {
            fscPayLogPo.setBusiCategory(FscConstants.FscBusiCategory.ORDER_REFUND);
        }
        if (null != reqBO.getBusiCategory()) {
            fscPayLogPo.setBusiCategory(reqBO.getBusiCategory());
        }
        fscPayLogPo.setOverdraftBeforeAmount(reqBO.getOverdraftBefore() == null ? BigDecimal.ZERO : reqBO.getOverdraftBefore());
        fscPayLogPo.setOverdraftAfterAmount(reqBO.getOverdraftAfter() == null ? BigDecimal.ZERO : reqBO.getOverdraftAfter());
        fscPayLogPo.setBusiOrderNo(reqBO.getOrderNo());
        fscPayLogPo.setCreateTime(now);
        fscPayLogPo.setAdvanceBeforeAmount(reqBO.getAdvanceBeforeAmount() == null ? BigDecimal.ZERO : reqBO.getAdvanceBeforeAmount());
        fscPayLogPo.setAdvanceAfterAmount(reqBO.getAdvanceAfterAmount() == null ? BigDecimal.ZERO : reqBO.getAdvanceAfterAmount());
        if (null != reqBO.getUserName()) {
            fscPayLogPo.setCreateOperId(reqBO.getUserName());
        }
        fscPayLogPo.setAdvanceAmt(reqBO.getAdvanceAmt());
        fscPayLogPo.setOverdraftAmt(reqBO.getOverdraftAmt());
        fscPayLogPo.setReimbursementAmount(reqBO.getReimbursementAmount() != null ? reqBO.getReimbursementAmount() : BigDecimal.ZERO);
        if (fscPayLogPo.getOverdraftAmt().compareTo(BigDecimal.ZERO) == 0 && fscPayLogPo.getAdvanceAmt().compareTo(BigDecimal.ZERO) != 0) {
            fscPayLogPo.setAdvancePayType(AdvancePayTypeEnum.ADVANCE_PAYMENT.getCode());
        } else if (fscPayLogPo.getAdvanceAmt().compareTo(BigDecimal.ZERO) == 0 && fscPayLogPo.getOverdraftAmt().compareTo(BigDecimal.ZERO) != 0) {
            fscPayLogPo.setAdvancePayType(AdvancePayTypeEnum.OVERDRAFT.getCode());
        } else if (fscPayLogPo.getAdvanceAmt().compareTo(BigDecimal.ZERO) != 0 && fscPayLogPo.getOverdraftAmt().compareTo(BigDecimal.ZERO) != 0) {
            fscPayLogPo.setAdvancePayType(AdvancePayTypeEnum.ADVANCE_PAYMENT_DEPOSIT.getCode());
        }
        if (fscPayLogPo.getOverdraftAmt().compareTo(BigDecimal.ZERO) > 0) {
            fscPayLogPo.setIsCredit(FscConstants.IsCredit.YES);
        } else {
            fscPayLogPo.setIsCredit(FscConstants.IsCredit.NO);
        }
        UocOrderIdQueryReqBO uocOrderIdQueryReqBO = new UocOrderIdQueryReqBO();
        uocOrderIdQueryReqBO.setSaleVoucherNo(fscPayLogPo.getBusiOrderNo());
        UocOrderIdQueryRspBO uocOrderIdQueryRspBO = this.uocOrderIdQueryAbilityService.getOrderIdOrCode(uocOrderIdQueryReqBO);
        if ("0000".equals(uocOrderIdQueryRspBO.getRespCode()) && uocOrderIdQueryRspBO.getOrderId() != null) {
            fscPayLogPo.setBusiOrderId(uocOrderIdQueryRspBO.getOrderId());
            UocInspectionDetailsListPageQueryReqBO uocInspectionDetailsListPageQueryReqBO = new UocInspectionDetailsListPageQueryReqBO();
            uocInspectionDetailsListPageQueryReqBO.setTabId(this.TAB_ID);
            uocInspectionDetailsListPageQueryReqBO.setOrderId(fscPayLogPo.getBusiOrderId());
            uocInspectionDetailsListPageQueryReqBO.setPageSize(1);
            uocInspectionDetailsListPageQueryReqBO.setPageNo(1);
            UocInspectionDetailsListPageQueryRspBO uocInspectionDetailsListPageQueryRspBO = this.uocInspectionDetailsListPageQueryAbilityService.getInspectionDetailsList(uocInspectionDetailsListPageQueryReqBO);
            if ("0000".equals(uocInspectionDetailsListPageQueryRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)uocInspectionDetailsListPageQueryRspBO.getRows())) {
                UocInspectionDetailsListBO uocInspectionDetailsListBO = (UocInspectionDetailsListBO)uocInspectionDetailsListPageQueryRspBO.getRows().get(0);
                fscPayLogPo.setAcceptId(uocInspectionDetailsListBO.getInspectionVoucherId());
                fscPayLogPo.setAcceptCode(uocInspectionDetailsListBO.getInspectionVoucherCode());
                fscPayLogPo.setErpAcceptCode(uocInspectionDetailsListBO.getErpInspectionVoucherCode());
            }
        }
        this.fscPayLogMapper.insert(fscPayLogPo);
    }
}

