/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscShouldPayRspBO;
import com.tydic.fsc.busibase.atom.api.FscPayShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscShouldPayNoEnum;
import com.tydic.fsc.dao.FscAccountMainMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountMainPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgNameListQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPayShouldPayCreateAtomServiceImpl
implements FscPayShouldPayCreateAtomService {
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscAccountMainMapper fscAccountMainMapper;
    @Value(value="${OPER_ORG_CODE:101123}")
    private String operationOrgCode;
    @Autowired
    private UmcEnterpriseOrgNameListQryAbilityService umcEnterpriseOrgNameListQryAbilityService;

    @Override
    public FscPayShouldPayCreateAtomRspBO dealShouldPayCreate(FscPayShouldPayCreateAtomReqBO atomReqBO) {
        ArrayList<FscShouldPayRspBO> fscShouldPayRspBOs = new ArrayList<FscShouldPayRspBO>();
        List fscShouldPayPOS = JSON.parseArray((String)JSON.toJSONString(atomReqBO.getFscShouldPayBOS()), FscShouldPayPO.class);
        List serialNoList = null;
        if (FscShouldPayNoEnum.getInstance((Integer)((FscShouldPayPO)fscShouldPayPOS.get(0)).getShouldPayType()) == null) {
            throw new FscBusinessException("194311", "\u5e94\u4ed8\u7c7b\u578b\u6ca1\u5b9a\u4e49\u679a\u4e3e");
        }
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscShouldPayNoEnum.getInstance((Integer)((FscShouldPayPO)fscShouldPayPOS.get(0)).getShouldPayType()).getDescr());
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(fscShouldPayPOS.size()));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        serialNoList = encodedSerialGetServiceRspBO.getSerialNoList();
        ArrayList<FscShouldPayPO> finishPay = new ArrayList<FscShouldPayPO>();
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        Long fscOrderId = Sequence.getInstance().nextId();
        BigDecimal totalAmt = new BigDecimal(0);
        ArrayList<Long> operationNos = new ArrayList<Long>();
        for (FscShouldPayPO fscShouldPayPO : fscShouldPayPOS) {
            if (StringUtils.isEmpty((Object)fscShouldPayPO.getOperationNo())) continue;
            operationNos.add(Long.parseLong(fscShouldPayPO.getOperationNo()));
        }
        UmcEnterpriseOrgNameListQryAbilityRspBO rspBO = null;
        Map orgMap = new HashMap();
        if (!CollectionUtils.isEmpty(operationNos)) {
            UmcEnterpriseOrgNameListQryAbilityReqBO abilityReqBO = new UmcEnterpriseOrgNameListQryAbilityReqBO();
            abilityReqBO.setOrgIdList(operationNos);
            rspBO = this.umcEnterpriseOrgNameListQryAbilityService.qryEnterpriseOrgNameList(abilityReqBO);
            orgMap = rspBO.getOrgMap();
        }
        for (int i = 0; i < fscShouldPayPOS.size(); ++i) {
            Long shouldPayId = Sequence.getInstance().nextId();
            FscShouldPayPO fscShouldPayPO = (FscShouldPayPO)fscShouldPayPOS.get(i);
            if (rspBO != null && rspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Map)rspBO.getOrgMap()) && !StringUtils.isEmpty((Object)fscShouldPayPO.getOperationNo())) {
                fscShouldPayPO.setOperationName(((UmcDycEnterpriseOrgBO)orgMap.get(Long.valueOf(fscShouldPayPO.getOperationNo()))).getOrgName());
            }
            if (Objects.isNull(fscShouldPayPO.getOperatorName())) {
                fscShouldPayPO.setOperatorName(fscShouldPayPO.getPurPlaceOrderName());
            }
            if (fscShouldPayPO.getOperatorId() == null && fscShouldPayPO.getPurPlaceOrderId() != null) {
                fscShouldPayPO.setOperatorId(Long.valueOf(fscShouldPayPO.getPurPlaceOrderId()));
            }
            fscShouldPayPO.setShouldPayId(shouldPayId);
            fscShouldPayPO.setCreateId(atomReqBO.getUserId());
            fscShouldPayPO.setCreateName(atomReqBO.getName());
            fscShouldPayPO.setCreateAccount(atomReqBO.getUserName());
            fscShouldPayPO.setCreateTime(new Date());
            fscShouldPayPO.setCreateCompanyId(atomReqBO.getCompanyId());
            fscShouldPayPO.setCreateCompanyName(atomReqBO.getCompanyName());
            fscShouldPayPO.setCreateOrgId(atomReqBO.getOrgId());
            fscShouldPayPO.setCreateOrgName(atomReqBO.getOrgName());
            fscShouldPayPO.setPenalty(new BigDecimal(0));
            fscShouldPayPO.setOriginalAmount(fscShouldPayPO.getShouldPayAmount());
            if (fscShouldPayPO.getShouldPayType().equals(FscConstants.ShouldPayType.PAYMENT_ADVANCE_PAY)) {
                fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.PAYED);
                fscShouldPayPO.setToPayAmount(new BigDecimal(0));
                fscShouldPayPO.setPaidAmount(fscShouldPayPO.getShouldPayAmount());
                fscShouldPayPO.setPayingAmount(new BigDecimal(0));
                finishPay.add(fscShouldPayPO);
                FscOrderPayItemPO po = new FscOrderPayItemPO();
                po.setFscOrderId(fscOrderId);
                po.setOrderPayItemId(Sequence.getInstance().nextId());
                po.setShouldPayId(shouldPayId);
                po.setPayAmount(fscShouldPayPO.getShouldPayAmount());
                fscOrderPayItemPOs.add(po);
                totalAmt = totalAmt.add(fscShouldPayPO.getShouldPayAmount());
            } else {
                fscShouldPayPO.setShouldPayStatus(FscConstants.ShouldPayStatus.TO_PAY);
                fscShouldPayPO.setToPayAmount(fscShouldPayPO.getShouldPayAmount());
                fscShouldPayPO.setPaidAmount(new BigDecimal(0));
                fscShouldPayPO.setPayingAmount(new BigDecimal(0));
            }
            fscShouldPayPO.setShouldPayNo((String)serialNoList.get(i));
            fscShouldPayPO.setPayMethod(fscShouldPayPO.getShouldPayMethod());
            FscShouldPayRspBO bo = new FscShouldPayRspBO();
            bo.setShouldPayId(shouldPayId);
            bo.setObjectId(fscShouldPayPO.getObjectId());
            bo.setOrderId(fscShouldPayPO.getOrderId());
            fscShouldPayRspBOs.add(bo);
            if (!StringUtils.isEmpty((Object)fscShouldPayPO.getAgreementId())) continue;
            fscShouldPayPO.setAgreementId(null);
        }
        this.fscShouldPayMapper.insertBatch(fscShouldPayPOS);
        FscPayShouldPayCreateAtomRspBO atomRspBO = new FscPayShouldPayCreateAtomRspBO();
        if (!CollectionUtils.isEmpty(finishPay)) {
            this.createPayAndPay(finishPay, fscOrderId, totalAmt, fscOrderPayItemPOs);
            atomRspBO.setFscOrderId(fscOrderId);
        }
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u6210\u529f");
        atomRspBO.setFscShouldPayRspBOs(fscShouldPayRspBOs);
        return atomRspBO;
    }

    private void createPayAndPay(List<FscShouldPayPO> finishPay, Long fscOrderId, BigDecimal totalAmt, List<FscOrderPayItemPO> fscOrderPayItemPOs) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.PAY);
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("PAYMENT_REQUEST_NO");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        fscOrderPO.setOrderNo((String)encodedSerialGetServiceRspBO.getSerialNoList().get(0));
        fscOrderPO.setPayerId(finishPay.get(0).getPayerId());
        fscOrderPO.setPayerName(finishPay.get(0).getPayerName());
        fscOrderPO.setPayeeId(finishPay.get(0).getPayeeId());
        fscOrderPO.setPayeeName(finishPay.get(0).getPayeeName());
        FscAccountMainPO mainQueryVo = new FscAccountMainPO();
        mainQueryVo.setBusiType("1");
        mainQueryVo.setOrgCode(this.operationOrgCode);
        FscAccountMainPO fscAccountMainPo = this.fscAccountMainMapper.getModelBy(mainQueryVo);
        if (fscAccountMainPo != null) {
            fscOrderPO.setPayeeAccountName(fscAccountMainPo.getMainAccountName());
            fscOrderPO.setPayeeBankAccount(fscAccountMainPo.getBankAccount());
            fscOrderPO.setPayeeBankName(fscAccountMainPo.getBankName());
        }
        fscOrderPO.setPayType(finishPay.get(0).getPayType());
        fscOrderPO.setShouldPayType(finishPay.get(0).getShouldPayType());
        fscOrderPO.setCreateOperId(finishPay.get(0).getCreateId());
        fscOrderPO.setCreateOperName(finishPay.get(0).getCreateName());
        fscOrderPO.setPayTime(new Date());
        fscOrderPO.setCreateTime(new Date());
        fscOrderPO.setCreateCompanyId(finishPay.get(0).getCreateCompanyId());
        fscOrderPO.setCreateCompanyName(finishPay.get(0).getCreateCompanyName());
        fscOrderPO.setCreateOrgId(finishPay.get(0).getCreateOrgId());
        fscOrderPO.setCreateOrgName(finishPay.get(0).getCreateOrgName());
        fscOrderPO.setTotalCharge(totalAmt);
        fscOrderPO.setContractNo(finishPay.get(0).getContractNo());
        fscOrderPO.setContractId(finishPay.get(0).getContractId());
        fscOrderPO.setBusiCategory(FscConstants.FscOrderBusiCategory.PAY);
        fscOrderPO.setPaidAmount(totalAmt);
        fscOrderPO.setPayingAmount(BigDecimal.ZERO);
        fscOrderPO.setToPayAmount(BigDecimal.ZERO);
        fscOrderPO.setBuynerNo(finishPay.get(0).getBuyerNo());
        fscOrderPO.setBuynerName(finishPay.get(0).getBuyerName());
        fscOrderPO.setOrderType(finishPay.get(0).getOrderType());
        fscOrderPO.setOrderState(FscConstants.FscPayOrderState.PAIED);
        fscOrderPO.setTradeMode(finishPay.get(0).getTradeMode());
        if (finishPay.get(0).getCreateId() != null) {
            fscOrderPO.setPayOperId(finishPay.get(0).getCreateId().toString());
        }
        fscOrderPO.setPayOperName(finishPay.get(0).getCreateName());
        this.fscOrderMapper.insert(fscOrderPO);
        this.fscOrderPayItemMapper.insertBatch(fscOrderPayItemPOs);
    }
}

