/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomRspBO;
import com.tydic.fsc.utils.SSLClient;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.CharsetUtils;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscSendNotificationExtAtomServiceImpl
implements FscSendNotificationExtAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscSendNotificationExtAtomServiceImpl.class);
    @Value(value="${notification_app_id:notification_app_id}")
    private String notificationAppId;
    @Value(value="${notification_app_url:notification_app_url}")
    private String notificationAppUrl;

    @Override
    public FscSendNotificationExtAtomRspBO sendNotification(FscSendNotificationExtAtomReqBO reqBO) {
        FscSendNotificationExtAtomRspBO rspBO = new FscSendNotificationExtAtomRspBO();
        for (Long receiveId : reqBO.getReceiveIds()) {
            HashMap<String, String> infoMap = new HashMap<String, String>();
            infoMap.put("sendid", reqBO.getUserId().toString());
            infoMap.put("recid", receiveId.toString());
            infoMap.put("appid", this.notificationAppId);
            infoMap.put("titel", reqBO.getTitel());
            infoMap.put("text", reqBO.getText());
            try {
                String result = FscSendNotificationExtAtomServiceImpl.httpUploadSignature2(this.notificationAppUrl, infoMap);
                log.info("\u8c03\u7528\u53d1\u9001\u901a\u77e5\u51fa\u53c2\uff1a" + result);
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                if (jsonObject == null) {
                    log.error("\u53d1\u9001\u901a\u77e5\u5931\u8d25:\u63a5\u6536\u54cd\u5e94\u4e3a\u7a7a");
                    continue;
                }
                if (jsonObject.get((Object)"code").equals("0")) continue;
                log.error("\u53d1\u9001\u901a\u77e5\u5931\u8d25:" + jsonObject.getString("message"));
            }
            catch (IOException e) {
                log.error("\u53d1\u9001\u901a\u77e5\u5931\u8d25:" + e.getMessage());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void sendFrom(String requestJsonStr, String url, String token) {
        Map map = (Map)JSONObject.parseObject((String)requestJsonStr, Map.class);
        HashMap<String, String> param = new HashMap<String, String>(map.size());
        for (Map.Entry elem : map.entrySet()) {
            if (elem.getValue() == null) continue;
            param.put((String)elem.getKey(), elem.getValue().toString());
        }
        try {
            HashMap<String, String> header = null;
            if (token != null) {
                header = new HashMap<String, String>(1);
                header.put("auth-token", token);
            }
            String rsp = SSLClient.doPost(url, param, header);
            log.debug("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\uff1a" + rsp);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38!" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpUploadSignature2(String actionUrl, Map<String, String> infoMap) throws IOException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(actionUrl);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(20000).setSocketTimeout(30000).setConnectTimeout(20000).build();
        httpPost.setConfig(requestConfig);
        String result = null;
        String boundary = "--------------4585696313564699";
        HashMap<String, StringBody> mapParam = new HashMap<String, StringBody>();
        for (String string : infoMap.keySet()) {
            mapParam.put(string, new StringBody(infoMap.get(string), StandardCharsets.UTF_8));
        }
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
        for (Map.Entry entry : mapParam.entrySet()) {
            multipartEntityBuilder.addPart((String)entry.getKey(), (ContentBody)entry.getValue()).setCharset(CharsetUtils.get((String)"UTF-8"));
        }
        multipartEntityBuilder.setCharset(StandardCharsets.UTF_8);
        multipartEntityBuilder.setBoundary(boundary);
        HttpEntity httpEntity = multipartEntityBuilder.build();
        httpPost.setEntity(httpEntity);
        httpPost.setHeader("Content-Type", "multipart/form-data;boundary=" + boundary);
        try (CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)httpPost);){
            HttpEntity entity = closeableHttpResponse.getEntity();
            if (entity != null) {
                System.out.println("--------------------------------------");
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                System.out.println("Response content: " + result);
                System.out.println("--------------------------------------");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return result;
    }
}

