/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscCreditDeductAtomBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscPayShouldRefundBO;
import com.tydic.fsc.bo.FscPhasePayListBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscCreditDeductAtomService;
import com.tydic.fsc.busibase.atom.api.FscPayShouldPayRefundCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscSaleOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscSettleRefundShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscCreditDeductAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscCreditDeductAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayRefundCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayRefundCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSettleRefundShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSettleRefundShouldPayCreateAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscRefundReasonEnum;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayDetailMapper;
import com.tydic.fsc.dao.FscOrderRefundPayRelationMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayDetailPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRefundPayRelationPo;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import com.tydic.uoc.common.ability.api.UocOrderInfoQueryAbilityService;
import com.tydic.uoc.common.ability.bo.OrdItemRspBO;
import com.tydic.uoc.common.ability.bo.UocOrderInfoQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocOrderInfoQueryRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscSettleRefundShouldPayCreateAtomServiceImpl
implements FscSettleRefundShouldPayCreateAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscSettleRefundShouldPayCreateAtomServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private UocOrderInfoQueryAbilityService uocOrderInfoQueryAbilityService;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscOrderPayDetailMapper fscOrderPayDetailMapper;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscSaleOrderListQueryAtomService fscSaleOrderListQueryAtomService;
    @Autowired
    private FscOrderRefundPayRelationMapper fscOrderRefundPayRelationMapper;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private FscPayShouldPayRefundCreateAtomService fscPayShouldPayRefundCreateAtomService;
    @Autowired
    private FscCreditDeductAtomService fscCreditDeductAtomService;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;

    @Override
    public FscSettleRefundShouldPayCreateAtomRspBO createSettleRefundShouldPay(FscSettleRefundShouldPayCreateAtomReqBO reqBO) {
        this.dealCreateRefundShould(reqBO.getOrderRefundPO(), reqBO);
        FscSettleRefundShouldPayCreateAtomRspBO rspBO = new FscSettleRefundShouldPayCreateAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealCreateRefundShould(FscOrderRefundPO orderRefundPO, FscSettleRefundShouldPayCreateAtomReqBO reqBO) {
        if (!FscRefundReasonEnum.RETURN_OR_EXCHANGE_PROBLEM.getCode().equals(orderRefundPO.getRefundReasonType().toString())) {
            return;
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(orderRefundPO.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        ArrayList<Long> fscOrderIdList = new ArrayList<Long>(1);
        fscOrderIdList.add(orderRefundPO.getFscOrderId());
        List<Long> orderIdList = this.fscOrderRelationMapper.getOrderIdList(fscOrderIdList);
        UocOrderInfoQueryReqBO uocOrderInfoQueryReqBO = new UocOrderInfoQueryReqBO();
        uocOrderInfoQueryReqBO.setOrderIdList(orderIdList);
        log.debug("\u67e5\u8be2\u8ba2\u5355\u5e94\u4ed8\u91d1\u989d\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocOrderInfoQueryReqBO));
        UocOrderInfoQueryRspBO uocOrderInfoQueryRspBO = this.uocOrderInfoQueryAbilityService.getOrderInfoCode(uocOrderInfoQueryReqBO);
        log.debug("\u67e5\u8be2\u8ba2\u5355\u5e94\u4ed8\u91d1\u989d\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocOrderInfoQueryRspBO));
        if (!"0000".equals(uocOrderInfoQueryRspBO.getRespCode())) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u7ed3\u7b97\u5355\u4e0b\u8ba2\u5355\u91d1\u989d\u5931\u8d25\uff1a" + uocOrderInfoQueryRspBO.getRespDesc());
        }
        Map orderMap = uocOrderInfoQueryRspBO.getOrdItemRspBOList().stream().collect(Collectors.toMap(OrdItemRspBO::getOrderId, Function.identity()));
        List<Object> fscOrderPayDetailPOList = new ArrayList();
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(orderRefundPO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(orderRefundPO.getMakeType())) {
            List<FscClaimDetailPO> fscClaimDetailPOList = this.fscClaimDetailMapper.getListByOrderIds(orderIdList);
            for (FscClaimDetailPO fscClaimDetailPO : fscClaimDetailPOList) {
                FscOrderPayDetailPO orderPayDetailPO = new FscOrderPayDetailPO();
                orderPayDetailPO.setOrderId(fscClaimDetailPO.getOrderId());
                orderPayDetailPO.setPayAmount(fscClaimDetailPO.getClaimAmt());
                fscOrderPayDetailPOList.add(orderPayDetailPO);
            }
        } else {
            FscOrderPayDetailPO fscOrderPayDetailPO = new FscOrderPayDetailPO();
            fscOrderPayDetailPO.setOrderIdList(orderIdList);
            fscOrderPayDetailPO.setNotPayeeId(this.operationOrgId);
            fscOrderPayDetailPOList = this.fscOrderPayDetailMapper.getListForRefund(fscOrderPayDetailPO);
        }
        if (CollectionUtils.isEmpty(fscOrderPayDetailPOList)) {
            return;
        }
        Map<Long, List<FscOrderPayDetailPO>> fscOrderPayDetailMap = fscOrderPayDetailPOList.stream().collect(Collectors.groupingBy(t -> t.getOrderId()));
        log.debug("++++fscOrderPayDetailMap:{}", (Object)JSON.toJSONString(fscOrderPayDetailMap));
        if (!CollectionUtils.isEmpty((Collection)uocOrderInfoQueryRspBO.getOrdItemRspBOList())) {
            Map<Object, Object> fscOrderInfoBoMap = new HashMap();
            if (orderRefundPO.getSettleType() == null || orderRefundPO.getSettleType().equals(FscConstants.SettleType.INSPECTION)) {
                FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
                fscAcceptOrderListQueryAtomReqBO.setRelId(orderRefundPO.getFscOrderId());
                FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
                if (!"0000".equals(fscAcceptOrderListQueryAtomRspBO.getRespCode())) {
                    throw new FscBusinessException("191019", fscAcceptOrderListQueryAtomRspBO.getRespDesc());
                }
                if (CollectionUtils.isEmpty(fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                    throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
                }
                fscOrderInfoBoMap = fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
            } else {
                FscSaleOrderListQueryAtomReqBO atomReqBO = new FscSaleOrderListQueryAtomReqBO();
                atomReqBO.setRelId(orderRefundPO.getFscOrderId());
                FscSaleOrderListQueryAtomRspBO fscSaleOrderListQueryAtomRspBO = this.fscSaleOrderListQueryAtomService.qrySaleOrderList(atomReqBO);
                if (!"0000".equals(fscSaleOrderListQueryAtomRspBO.getRespCode())) {
                    throw new FscBusinessException("191019", fscSaleOrderListQueryAtomRspBO.getRespDesc());
                }
                if (CollectionUtils.isEmpty(fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                    throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
                }
                fscOrderInfoBoMap = fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
            }
            log.debug("++++fscOrderInfoBoMap:{}", (Object)JSON.toJSONString(fscOrderInfoBoMap));
            BigDecimal nodePayRatio = BigDecimal.ZERO;
            FscOrderInfoBO fscOrderInfoBO = fscOrderInfoBoMap.values().stream().max(Comparator.comparing(FscOrderInfoBO::getOrderCreateTime)).get();
            if (FscConstants.FscPayType.FSC_PAY_TYPE_STAGE.equals(fscOrderPO.getPayType())) {
                if (fscOrderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
                    fscOrderInfoBO.setPayList(fscOrderInfoBO.getProPayList());
                }
                ArrayList<FscPhasePayListBO> payListBOS = new ArrayList<FscPhasePayListBO>();
                if (!CollectionUtils.isEmpty((Collection)fscOrderInfoBO.getPayList())) {
                    for (FscPhasePayListBO payListBO : fscOrderInfoBO.getPayList()) {
                        if (payListBO.getPayNode() != 4 || payListBO.getNodePayRatio().compareTo(BigDecimal.ZERO) <= 0) continue;
                        payListBOS.add(payListBO);
                        nodePayRatio = payListBO.getNodePayRatio();
                    }
                }
            }
            ArrayList<FscOrderRefundPayRelationPo> fscOrderRefundPayRelationPoList = new ArrayList<FscOrderRefundPayRelationPo>();
            ArrayList<FscOrderPayDetailPO> updateRefundAmtPoList = new ArrayList<FscOrderPayDetailPO>();
            ArrayList<FscShouldPayPO> fscShouldPayPOList = new ArrayList<FscShouldPayPO>();
            for (Long key : fscOrderPayDetailMap.keySet()) {
                BigDecimal orderAmt;
                List<FscOrderPayDetailPO> fscOrderPayDetailPOS = fscOrderPayDetailMap.get(key);
                BigDecimal payAmt = fscOrderPayDetailPOS.stream().map(FscOrderPayDetailPO::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                OrdItemRspBO ordItemRspBO = (OrdItemRspBO)orderMap.get(key);
                if (FscConstants.FscOrderReceiveType.OPERATION.equals(orderRefundPO.getReceiveType()) && FscConstants.FscOrderMakeType.SUPPLIER.equals(orderRefundPO.getMakeType())) {
                    orderAmt = ordItemRspBO == null ? BigDecimal.ZERO : ordItemRspBO.getTotalPurchaseMoney();
                } else {
                    BigDecimal bigDecimal = orderAmt = ordItemRspBO == null ? BigDecimal.ZERO : ordItemRspBO.getTotalSaleMoney();
                }
                if (orderAmt != null && nodePayRatio.compareTo(BigDecimal.ZERO) > 0) {
                    orderAmt = orderAmt.multiply(nodePayRatio).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
                }
                log.debug("+++++\u91d1\u989d\uff1a{},{}", (Object)payAmt, (Object)orderAmt);
                if (payAmt.compareTo(orderAmt) <= 0) continue;
                BigDecimal releaseRefundAmt = payAmt.subtract(orderAmt);
                List<FscOrderPayDetailPO> orderPayDetailPOList = this.fscOrderPayDetailMapper.getListBySettleId(orderRefundPO.getFscOrderId());
                for (FscOrderPayDetailPO payDetailPO : orderPayDetailPOList) {
                    if (payDetailPO.getPayAmount().subtract(payDetailPO.getRefundAmt()).compareTo(BigDecimal.ZERO) <= 0 || releaseRefundAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
                    BigDecimal refundAmt = releaseRefundAmt.compareTo(payDetailPO.getPayAmount()) > 0 ? payDetailPO.getPayAmount() : releaseRefundAmt;
                    FscOrderRefundPayRelationPo fscOrderRefundPayRelationPo = this.buildOrderRefundPayRelation(orderRefundPO, payDetailPO, ordItemRspBO.getOrderCode(), refundAmt, reqBO);
                    payDetailPO.setRefundAmt(refundAmt);
                    updateRefundAmtPoList.add(payDetailPO);
                    fscOrderRefundPayRelationPoList.add(fscOrderRefundPayRelationPo);
                    FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
                    fscShouldPayPO.setShouldPayId(payDetailPO.getShouldPayId());
                    fscShouldPayPO.setRefundAmt(refundAmt);
                    fscShouldPayPOList.add(fscShouldPayPO);
                    releaseRefundAmt = releaseRefundAmt.subtract(refundAmt);
                }
            }
            log.debug("++++fscOrderRefundPayRelationPoList:{}", (Object)JSON.toJSONString(fscOrderRefundPayRelationPoList));
            if (!CollectionUtils.isEmpty(fscOrderRefundPayRelationPoList)) {
                this.buildShouldPayRefund(fscOrderRefundPayRelationPoList, orderRefundPO, reqBO);
                this.fscOrderRefundPayRelationMapper.insertBatch(fscOrderRefundPayRelationPoList);
            }
            log.debug("++++updateRefundAmtPoList:{}", (Object)JSON.toJSONString(updateRefundAmtPoList));
            if (!CollectionUtils.isEmpty(updateRefundAmtPoList)) {
                this.fscOrderPayDetailMapper.updateRefundAmtBatchAdd(updateRefundAmtPoList);
            }
            log.debug("++++fscShouldPayPOList:{}", (Object)JSON.toJSONString(fscShouldPayPOList));
            if (!CollectionUtils.isEmpty(fscShouldPayPOList)) {
                this.fscShouldPayMapper.updateRefundAmountBatch(fscShouldPayPOList);
            }
        }
    }

    private void buildShouldPayRefund(List<FscOrderRefundPayRelationPo> relationPoList, FscOrderRefundPO orderRefundPO, FscSettleRefundShouldPayCreateAtomReqBO reqBO) {
        Map<Long, List<FscOrderRefundPayRelationPo>> orderPayMap = relationPoList.stream().collect(Collectors.groupingBy(FscOrderRefundPayRelationPo::getFscOrderPayId));
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(new ArrayList<Long>(orderPayMap.keySet()));
        List<FscOrderPO> fscOrderPOList = this.fscOrderMapper.getList(fscOrderPO);
        Map fscOrderPOMap = fscOrderPOList.stream().collect(Collectors.toMap(FscOrderPO::getFscOrderId, Function.identity()));
        for (Long key : orderPayMap.keySet()) {
            List<FscOrderRefundPayRelationPo> orderRefundPayRelationPoList = orderPayMap.get(key);
            BigDecimal refundAmt = orderRefundPayRelationPoList.stream().map(FscOrderRefundPayRelationPo::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            FscOrderPO orderPO = (FscOrderPO)fscOrderPOMap.get(key);
            Long shouldPayRefundId = this.createShouldPay(orderRefundPO, reqBO, orderPO, refundAmt);
            for (FscOrderRefundPayRelationPo fscOrderRefundPayRelationPo : orderRefundPayRelationPoList) {
                fscOrderRefundPayRelationPo.setRefundShouldPayId(shouldPayRefundId);
                fscOrderRefundPayRelationPo.setFscOrderPayId(orderPO.getFscOrderId());
                fscOrderRefundPayRelationPo.setFscOrderPayNo(orderPO.getOrderNo());
            }
        }
    }

    private void dealCreditDeduct(FscOrderPO fscOrderPO, FscOrderRefundPayRelationPo fscOrderRefundPayRelationPo, FscSettleRefundShouldPayCreateAtomReqBO reqBO) {
        FscCreditDeductAtomReqBO fscCreditDeductAtomReqBO = new FscCreditDeductAtomReqBO();
        FscCreditDeductAtomBO fscCreditDeductAtomBO = new FscCreditDeductAtomBO();
        fscCreditDeductAtomBO.setAmount(fscOrderRefundPayRelationPo.getRefundAmount().negate());
        fscCreditDeductAtomBO.setOrderNo(fscOrderRefundPayRelationPo.getOrderNo());
        fscCreditDeductAtomBO.setOrderType(FscConstants.CreditOrderType.ORDER);
        fscCreditDeductAtomBO.setObjId(fscOrderRefundPayRelationPo.getOrderId());
        ArrayList<FscCreditDeductAtomBO> fscCreditDeductAtomBOList = new ArrayList<FscCreditDeductAtomBO>();
        fscCreditDeductAtomBOList.add(fscCreditDeductAtomBO);
        fscCreditDeductAtomReqBO.setCreditOrgId(fscOrderPO.getPurchaserId());
        fscCreditDeductAtomReqBO.setSupId(fscOrderPO.getSupplierId());
        if (fscOrderPO.getOrderSource().toString().equals("1")) {
            fscCreditDeductAtomReqBO.setPayBusiness("2");
        } else if (fscOrderPO.getOrderSource().toString().equals("2")) {
            fscCreditDeductAtomReqBO.setPayBusiness("1");
        } else if (fscOrderPO.getOrderSource().toString().equals("3")) {
            fscCreditDeductAtomReqBO.setPayBusiness("3");
        }
        fscCreditDeductAtomReqBO.setCreditOrgCode(fscOrderPO.getBuynerNo());
        if (!StringUtils.isEmpty((Object)fscCreditDeductAtomReqBO.getCreditOrgCode())) {
            UmcEnterpriseOrgQryDetailAbilityReqBO abilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
            abilityReqBO.setOrgCode(fscCreditDeductAtomReqBO.getCreditOrgCode());
            UmcEnterpriseOrgQryDetailAbilityRspBO abilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(abilityReqBO);
            if (!abilityRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(abilityRspBO.getRespCode(), "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5931\u8d25\uff01" + abilityRspBO.getRespDesc());
            }
            if (abilityRspBO.getUmcEnterpriseOrgDetailBO() == null) {
                throw new FscBusinessException("198888", "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            fscCreditDeductAtomReqBO.setCreditOrgId(abilityRspBO.getUmcEnterpriseOrgDetailBO().getOrgId());
        }
        fscCreditDeductAtomReqBO.setFscCreditDeductAtomBOS(fscCreditDeductAtomBOList);
        fscCreditDeductAtomReqBO.setName(reqBO.getName());
        fscCreditDeductAtomReqBO.setUserId(reqBO.getUserId());
        fscCreditDeductAtomReqBO.setOrderType(fscOrderPO.getOrderType());
        fscCreditDeductAtomReqBO.setTradeMode(fscOrderPO.getTradeMode());
        fscCreditDeductAtomReqBO.setBusiCategory(FscConstants.FscBusiCategory.ORDER_REFUND_RETURN);
        log.info("\u9000\u7968\u9000\u6b3e\u8fd4\u8fd8\u6388\u4fe1\u5165\u53c2:" + JSONObject.toJSONString((Object)((Object)fscCreditDeductAtomReqBO)));
        FscCreditDeductAtomRspBO atomRspBO = this.fscCreditDeductAtomService.dealAccountDeduct(fscCreditDeductAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException("193113", atomRspBO.getRespDesc());
        }
    }

    private Long createShouldPay(FscOrderRefundPO orderRefundPO, FscSettleRefundShouldPayCreateAtomReqBO reqBO, FscOrderPO fscOrderPO, BigDecimal refundAmt) {
        String refundBillDate = this.fscInvoiceMapper.getRefundBillDate(orderRefundPO.getRefundId());
        FscPayShouldPayRefundCreateAtomReqBO atomReqBO = new FscPayShouldPayRefundCreateAtomReqBO();
        ArrayList<FscPayShouldRefundBO> fscPayShouldRefundBOS = new ArrayList<FscPayShouldRefundBO>();
        FscPayShouldRefundBO fscPayShouldRefundBO = new FscPayShouldRefundBO();
        fscPayShouldRefundBO.setRefundShouldPayNo(orderRefundPO.getFscOrderNo());
        fscPayShouldRefundBO.setPayerId(orderRefundPO.getPayerId());
        fscPayShouldRefundBO.setPayerName(orderRefundPO.getPayerName());
        fscPayShouldRefundBO.setPayeeId(orderRefundPO.getPayeeId());
        fscPayShouldRefundBO.setPayeeName(orderRefundPO.getPayeeName());
        fscPayShouldRefundBO.setRefundNo(orderRefundPO.getRefundNo());
        fscPayShouldRefundBO.setRefundId(orderRefundPO.getRefundId());
        fscPayShouldRefundBO.setSupplierName(orderRefundPO.getSupplierName());
        fscPayShouldRefundBO.setSupplierId(orderRefundPO.getSupplierId());
        fscPayShouldRefundBO.setOrderSource(orderRefundPO.getOrderSource());
        fscPayShouldRefundBO.setOrderType(orderRefundPO.getOrderType());
        fscPayShouldRefundBO.setRefundType(FscConstants.RefundType.REFUND_INVOICE);
        fscPayShouldRefundBO.setGenerateType(FscConstants.FscRefundGenerateType.AUTO);
        fscPayShouldRefundBO.setTotalPaidAmount(fscOrderPO.getTotalCharge());
        fscPayShouldRefundBO.setRefundAmount(refundAmt);
        fscPayShouldRefundBO.setBillDate(refundBillDate);
        fscPayShouldRefundBO.setRefundShouldPayById(orderRefundPO.getFscOrderId());
        fscPayShouldRefundBO.setFscOrderId(orderRefundPO.getFscOrderId());
        fscPayShouldRefundBO.setFscOrderNo(orderRefundPO.getFscOrderNo());
        fscPayShouldRefundBO.setBuynerNo(orderRefundPO.getBuynerNo());
        fscPayShouldRefundBO.setBuynerName(orderRefundPO.getBuynerName());
        fscPayShouldRefundBO.setOperatorId(orderRefundPO.getOperatorId());
        fscPayShouldRefundBO.setOperatorName(orderRefundPO.getOperatorName());
        fscPayShouldRefundBO.setOperatorDeptId(orderRefundPO.getOperationId());
        fscPayShouldRefundBO.setOperatorDeptName(orderRefundPO.getOperationName());
        fscPayShouldRefundBO.setCreateUserId(reqBO.getUserId());
        fscPayShouldRefundBO.setCreateUserName(reqBO.getUserName());
        fscPayShouldRefundBO.setCreateTime(new Date());
        fscPayShouldRefundBO.setCreateOrgId(reqBO.getOrgId());
        fscPayShouldRefundBO.setCreateOrgName(reqBO.getOrgName());
        fscPayShouldRefundBO.setRefundPayStatus(FscConstants.RefundPayStatus.DRAFT);
        fscPayShouldRefundBO.setPayOrderId(fscOrderPO.getFscOrderId());
        fscPayShouldRefundBO.setPayOrderNo(fscOrderPO.getOrderNo());
        fscPayShouldRefundBO.setPayingAmount(BigDecimal.ZERO);
        fscPayShouldRefundBO.setPaidAmount(BigDecimal.ZERO);
        fscPayShouldRefundBO.setUserType(FscConstants.RefundUserType.PURCHASE);
        fscPayShouldRefundBO.setTradeMode(orderRefundPO.getTradeMode());
        fscPayShouldRefundBOS.add(fscPayShouldRefundBO);
        atomReqBO.setFscPayShouldRefundBOS(fscPayShouldRefundBOS);
        FscPayShouldPayRefundCreateAtomRspBO atomRspBO = this.fscPayShouldPayRefundCreateAtomService.dealShouldPayRefundCreate(atomReqBO);
        if (!atomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("190000", "\u9000\u7968\u5355\u521b\u5efa\u9000\u6b3e\u5e94\u4ed8\u5931\u8d25\uff1a" + atomRspBO.getRespDesc());
        }
        return atomRspBO.getRefundShouldPayIdList().get(0);
    }

    private FscOrderRefundPayRelationPo buildOrderRefundPayRelation(FscOrderRefundPO orderRefundPO, FscOrderPayDetailPO payDetailPO, String orderCode, BigDecimal refundAmt, FscSettleRefundShouldPayCreateAtomReqBO reqBO) {
        FscOrderRefundPayRelationPo fscOrderRefundPayRelationPo = new FscOrderRefundPayRelationPo();
        fscOrderRefundPayRelationPo.setId(Sequence.getInstance().nextId());
        fscOrderRefundPayRelationPo.setFscOrderId(orderRefundPO.getFscOrderId());
        fscOrderRefundPayRelationPo.setFscOrderNo(orderRefundPO.getFscOrderNo());
        fscOrderRefundPayRelationPo.setOrderId(payDetailPO.getOrderId());
        fscOrderRefundPayRelationPo.setOrderNo(orderCode);
        fscOrderRefundPayRelationPo.setPayAmount(payDetailPO.getPayAmount());
        fscOrderRefundPayRelationPo.setRefundAmount(refundAmt);
        fscOrderRefundPayRelationPo.setCreateId(reqBO.getUserId());
        fscOrderRefundPayRelationPo.setCreateName(reqBO.getUserName());
        fscOrderRefundPayRelationPo.setCreateTime(new Date());
        fscOrderRefundPayRelationPo.setPayOrderId(payDetailPO.getFscOrderId());
        fscOrderRefundPayRelationPo.setPayOrderNo(payDetailPO.getFscOrderNo());
        fscOrderRefundPayRelationPo.setFscOrderPayId(payDetailPO.getFscOrderId());
        fscOrderRefundPayRelationPo.setFscOrderPayNo(payDetailPO.getFscOrderNo());
        fscOrderRefundPayRelationPo.setPayingAmount(BigDecimal.ZERO);
        fscOrderRefundPayRelationPo.setRefundedAmount(BigDecimal.ZERO);
        String fscOrderBillDate = this.fscInvoiceMapper.getFscOrderBillDate(orderRefundPO.getFscOrderId());
        fscOrderRefundPayRelationPo.setBillDate(fscOrderBillDate);
        return fscOrderRefundPayRelationPo;
    }
}

