/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.external.api.bo.FscGetSettlePlatFormInvoiceBo;
import com.tydic.fsc.busibase.external.api.bo.FscGetSettlePlatFormInvoiceEsbBo;
import com.tydic.fsc.busibase.external.api.bo.FscGetSettlePlatFormInvoiceReqBo;
import com.tydic.fsc.busibase.external.api.bo.FscGetSettlePlatFormInvoiceRspBo;
import com.tydic.fsc.busibase.external.api.esb.FscGetSettlePlatFormInvoiceService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.EncryptUtil;
import com.tydic.fsc.utils.SSLClient;
import com.tydic.uac.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscGetSettlePlatFormInvoiceServiceImpl
implements FscGetSettlePlatFormInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(FscGetSettlePlatFormInvoiceServiceImpl.class);
    @Value(value="${CONTRACT_CAPITAL_PLAN_URL:http://172.20.8.161:8097/apiHandler/getAllMsg}")
    private String getSettlePlatFormInvoiceUrl;
    @Value(value="${GET_SETTLE_PLAT_FORM_INVOICE_SQL:551}")
    private String getSettlePlatFormInvoiceSql;
    @Value(value="${SETTLE_PLAT_FORM_INVOICE_PREFIX:http://172.20.8.161:8090/segment/image?imageUrl=}")
    private String invoicePrefix;

    @Override
    public FscGetSettlePlatFormInvoiceRspBo getSettlePlatFormInvoice(FscGetSettlePlatFormInvoiceReqBo reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getORG_ID()) || StringUtils.isEmpty((Object)reqBO.getUSER_ID()) || StringUtils.isEmpty((Object)reqBO.getToken())) {
            throw new BusinessException("198888", "\u83b7\u53d6\u7edf\u4e00\u7ed3\u7b97\u7cfb\u7edf\u53d1\u7968\u4fe1\u606f\u5165\u53c2\u7f3a\u5931");
        }
        FscGetSettlePlatFormInvoiceRspBo rspBO = new FscGetSettlePlatFormInvoiceRspBo();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", reqBO.getToken());
        header.put("stamp", EncryptUtil.getStamp());
        String respStr = "";
        JSONObject data = new JSONObject();
        data.put("sqlId", (Object)this.getSettlePlatFormInvoiceSql);
        JSONObject jsonMap = new JSONObject();
        jsonMap.put("ORG_ID", (Object)reqBO.getORG_ID());
        jsonMap.put("USER_ID", (Object)reqBO.getUSER_ID());
        jsonMap.put("INVOICE_FOLDER_NAME", (Object)reqBO.getINVOICE_FOLDER_NAME());
        jsonMap.put("INVOICE_NUMBER", (Object)reqBO.getINVOICE_NUMBER());
        jsonMap.put("INVOICE_TOTAL_S", (Object)reqBO.getINVOICE_TOTAL_S());
        jsonMap.put("INVOICE_TOTAL_E", (Object)reqBO.getINVOICE_TOTAL_E());
        jsonMap.put("INVOICE_DATE_S", (Object)reqBO.getINVOICE_DATE_S());
        jsonMap.put("INVOICE_DATE_E", (Object)reqBO.getINVOICE_DATE_E());
        if (!StringUtils.isEmpty((Object)reqBO.getPageNum()) && !StringUtils.isEmpty((Object)reqBO.getPageSize())) {
            jsonMap.put("pageNum", (Object)reqBO.getPageNum());
            jsonMap.put("pageSize", (Object)reqBO.getPageSize());
        }
        data.put("jsonMap", (Object)jsonMap);
        String s = JSONObject.toJSONString((Object)data);
        log.info("\u67e5\u8be2\u7edf\u4e00\u7ed3\u7b97\u7cfb\u7edf\u53d1\u7968\u5165\u53c2\uff1a" + s + " \u67e5\u8be2\u7edf\u4e00\u7ed3\u7b97\u7cfb\u7edf\u53d1\u7968Token:" + reqBO.getToken());
        try {
            respStr = SSLClient.doPostWithHeadMap(this.getSettlePlatFormInvoiceUrl, s, header);
        }
        catch (Exception e) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u7edf\u4e00\u7ed3\u7b97\u7cfb\u7edf\u53d1\u7968\u5931\u8d25\uff01[" + e.getMessage() + "]");
        }
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u7edf\u4e00\u7ed3\u7b97\u7cfb\u7edf\u53d1\u7968\u8fd4\u56de\u503c\u4e3a\u7a7a\uff01");
        }
        log.info("\u67e5\u8be2\u7edf\u4e00\u7ed3\u7b97\u7cfb\u7edf\u53d1\u7968\u51fa\u53c2" + respStr);
        try {
            rspBO = this.resolveRsp(respStr, reqBO);
        }
        catch (Exception e) {
            throw new FscBusinessException("198888", "\u89e3\u6790\u67e5\u8be2\u7edf\u4e00\u7ed3\u7b97\u7cfb\u7edf\u53d1\u7968\u8fd4\u56de\u62a5\u6587\u5931\u8d25\uff01[" + respStr + "]");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscGetSettlePlatFormInvoiceRspBo resolveRsp(String respStr, FscGetSettlePlatFormInvoiceReqBo reqBO) {
        FscGetSettlePlatFormInvoiceRspBo rspBo = new FscGetSettlePlatFormInvoiceRspBo();
        ArrayList<FscGetSettlePlatFormInvoiceBo> list = new ArrayList<FscGetSettlePlatFormInvoiceBo>();
        JSONObject jsonObject = JSONObject.parseObject((String)respStr);
        if (!((Boolean)jsonObject.get((Object)"state")).booleanValue()) {
            throw new BusinessException("8888", (String)jsonObject.get((Object)"message"));
        }
        JSONObject value = (JSONObject)jsonObject.get((Object)"value");
        Integer total = (Integer)value.get((Object)"total");
        JSONArray rows = (JSONArray)value.get((Object)"rows");
        List invoiceEsbBos = JSONObject.parseArray((String)JSONObject.toJSONString((Object)rows), FscGetSettlePlatFormInvoiceEsbBo.class);
        if (!CollectionUtils.isEmpty((Collection)invoiceEsbBos)) {
            for (FscGetSettlePlatFormInvoiceEsbBo bo : invoiceEsbBos) {
                FscGetSettlePlatFormInvoiceBo invoiceBo = new FscGetSettlePlatFormInvoiceBo();
                invoiceBo.setInvoiceId(bo.getINVOICE_ID());
                invoiceBo.setInvoiceNum(bo.getINVOICE_NUM());
                invoiceBo.setInvoiceType(bo.getINVOICE_TYPE());
                invoiceBo.setBillType(bo.getBILL_TYPE());
                invoiceBo.setInvoiceName(bo.getINVOICE_NAME());
                invoiceBo.setInvoiceDate(bo.getINVOICE_DATE());
                invoiceBo.setStatus(bo.getSTATUS());
                invoiceBo.setStatusDis(bo.getSTATUS_DIS());
                invoiceBo.setInvoiceTotal(bo.getINVOICE_TOTAL());
                invoiceBo.setInvoiceAmount(bo.getINVOICE_AMOUNT());
                invoiceBo.setInvoiceTax(bo.getINVOICE_TAX());
                invoiceBo.setInvoiceFolderId(bo.getINVOICE_FOLDER_ID());
                invoiceBo.setInvoiceFolderName(bo.getINVOICE_FOLDER_NAME());
                if (!StringUtils.isEmpty((Object)bo.getOCR_ADDERSS())) {
                    invoiceBo.setOcrAdderss(this.invoicePrefix + bo.getOCR_ADDERSS());
                    String[] path = bo.getOCR_ADDERSS().split("/");
                    invoiceBo.setOcrAdderssName(path[path.length - 1]);
                }
                list.add(invoiceBo);
            }
        }
        rspBo.setRows(list);
        if (!StringUtils.isEmpty((Object)reqBO.getPageNum()) && !StringUtils.isEmpty((Object)reqBO.getPageSize()) && total != null) {
            rspBo.setPageNo(Integer.parseInt(reqBO.getPageNum()));
            rspBo.setRecordsTotal(total);
            rspBo.setTotal(total % Integer.parseInt(reqBO.getPageSize()) > 0 ? total / Integer.parseInt(reqBO.getPageSize()) + 1 : total / Integer.parseInt(reqBO.getPageSize()));
        }
        return rspBo;
    }
}

