/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.fsc.busibase.external.api.bo.FscInvoiceSubmitExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscInvoiceSubmitExternalRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscInvoiceSubmitExternalSnReqBO;
import com.tydic.fsc.busibase.external.api.esb.FscInvoiceSubmitExternalService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.EsbParamUtil;
import com.tydic.fsc.utils.SSLClient;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class FscInvoiceSubmitExternalServiceImpl
implements FscInvoiceSubmitExternalService {
    private static final Logger log = LoggerFactory.getLogger(FscInvoiceSubmitExternalServiceImpl.class);
    @Autowired
    private Environment environment;
    private static final String JD_SUP_ID = "JD_SUP_ID";
    @Value(value="${esb.invoiceApply.url:http://39.106.83.78:8001/OSN/api/invoiceApply/v1}")
    private String URL;
    @Value(value="${SUPPLIER_JD_ID_FL:202200511}")
    private String jdIdFl;
    @Value(value="${SUPPLIER_SUNING_FL:202200512}")
    private String snIdFl;
    @Value(value="${SUPPLIER_SUNING:100057}")
    private String SUNING;
    @Value(value="${SUPPLIER_GAJ:100056}")
    private String SUPPLIER_GAJ;
    private static final String ZORE = "0";

    @Override
    public FscInvoiceSubmitExternalRspBO submitInvoice(FscInvoiceSubmitExternalReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u5f00\u7968\u63d0\u4ea4\u8bf7\u6c42\u7535\u5546\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
        }
        this.initReqBO(reqBO);
        String hsn = this.environment.getProperty("SUPPLIER_ID_" + reqBO.getSupplierId());
        String reqEsbJson = null;
        if (reqBO.getSupplierId().equals(this.snIdFl) || reqBO.getSupplierId().equals(this.SUNING)) {
            FscInvoiceSubmitExternalSnReqBO snReqBO = this.initSnReqBO(reqBO);
            reqEsbJson = EsbParamUtil.getEsbReqStr(JSON.toJSONString((Object)snReqBO), hsn, "BUSINESS_PAY");
        } else {
            reqEsbJson = EsbParamUtil.getEsbReqStr(JSON.toJSONString((Object)reqBO), hsn, "BUSINESS_PAY");
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42ESB\u7535\u5546\u5f00\u7968\u63d0\u4ea4\u5165\u53c2:{},URL:{}", (Object)reqEsbJson, (Object)this.URL);
        }
        String rspJson = SSLClient.doPost(this.URL, reqEsbJson);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42ESB\u7535\u5546\u5f00\u7968\u63d0\u4ea4\u51fa\u53c2:{}", (Object)rspJson);
        }
        if (StringUtils.isBlank((CharSequence)rspJson)) {
            throw new FscBusinessException("194320", "\u8bf7\u6c42\u8bf7\u6c42ESB\u7535\u5546\u5f00\u7968\u63d0\u4ea4\u63a5\u53e3\u8fd4\u56de\u7a7a");
        }
        FscInvoiceSubmitExternalRspBO rspBO = (FscInvoiceSubmitExternalRspBO)((Object)JSON.parseObject((String)rspJson, FscInvoiceSubmitExternalRspBO.class));
        if (!rspBO.getSuccess().booleanValue()) {
            throw new FscBusinessException("194320", rspBO.getResultMessage());
        }
        return rspBO;
    }

    private FscInvoiceSubmitExternalSnReqBO initSnReqBO(FscInvoiceSubmitExternalReqBO reqBO) {
        FscInvoiceSubmitExternalSnReqBO snReqBO = new FscInvoiceSubmitExternalSnReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)snReqBO);
        if (!StringUtils.isEmpty((CharSequence)reqBO.getAreaCode())) {
            snReqBO.setAreaCode(Integer.valueOf(reqBO.getAreaCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getCityCode())) {
            snReqBO.setCityCode(Integer.valueOf(reqBO.getCityCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getInvoiceType())) {
            snReqBO.setInvoiceType(Integer.valueOf(reqBO.getInvoiceType()));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getProvinceCode())) {
            snReqBO.setProvinceCode(Integer.valueOf(reqBO.getProvinceCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getTownCode())) {
            snReqBO.setTownCode(Integer.valueOf(reqBO.getTownCode()));
        }
        snReqBO.setTimestamp(new Date());
        return snReqBO;
    }

    private void initReqBO(FscInvoiceSubmitExternalReqBO reqBO) {
        String jdSupId = this.environment.getProperty(JD_SUP_ID);
        if (reqBO.getSupplierId().equals(jdSupId) || this.jdIdFl.equals(reqBO.getSupplierId())) {
            reqBO.setEnterpriseBankAccount(reqBO.getAccount());
            reqBO.setEnterpriseBankName(reqBO.getBank());
            reqBO.setEnterpriseRegAddress(reqBO.getAddress());
            reqBO.setEnterpriseRegPhone(reqBO.getPhone());
        }
        if (null == reqBO.getTotalBatch()) {
            reqBO.setTotalBatch(FscConstants.BASIC_INVOICE_BATCH_NUM);
        }
        if (null == reqBO.getBizInvoiceContent()) {
            reqBO.setBizInvoiceContent(FscConstants.BASIC_INVOICE_CONTENT);
        }
        if (null == reqBO.getInvoiceOrg()) {
            reqBO.setInvoiceOrg("6");
        }
        if (null == reqBO.getInvoiceNum()) {
            reqBO.setInvoiceNum(reqBO.getExtOrderNos().size());
        }
        if (null == reqBO.getTotalBatchInvoiceAmount()) {
            reqBO.setTotalBatchInvoiceAmount(reqBO.getTotalCharge());
        }
        if (null == reqBO.getBillDate()) {
            reqBO.setBillDate(DateUtils.dateToStr((Date)new Date()));
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getTownCode()) && reqBO.getSupplierId().equals(this.SUPPLIER_GAJ)) {
            reqBO.setTownCode(null);
        } else if (StringUtils.isBlank((CharSequence)reqBO.getTownCode())) {
            reqBO.setTownCode(ZORE);
        }
        if (FscConstants.FscInvoiceCategory.ELEC.equals(reqBO.getInvoiceCategory())) {
            reqBO.setInvoiceType(FscConstants.FscElecInvoiceType.ELEC.toString());
        } else if (FscConstants.FscInvoiceCategory.FULL.equals(reqBO.getInvoiceCategory())) {
            reqBO.setInvoiceType(FscConstants.FscElecInvoiceType.FULL_ELEC.toString());
        } else {
            reqBO.setInvoiceType(FscConstants.FscElecInvoiceType.SPECIAL.toString());
        }
    }
}

