/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.external.api.bo.FinanceDraftBO;
import com.tydic.fsc.busibase.external.api.bo.FscQryFinanceDraftReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscQryFinanceDraftRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscQryFinanceDraftService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.SSLClient;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscQryFinanceDraftServiceImpl
implements FscQryFinanceDraftService {
    private static final Logger log = LoggerFactory.getLogger(FscQryFinanceDraftServiceImpl.class);
    @Value(value="${esb.yc.recv.claim.url:http://test02.chinacoal.com:8010/OA_HTML/bfwebapps/conServlet.jsp}")
    private String Bill_TAX_YC_SYS_URL;

    @Override
    public FscQryFinanceDraftRspBO qryFinanceDraft(FscQryFinanceDraftReqBO reqBO) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("p_type", "data_api");
        map.put("p_switch", "DATA_API");
        map.put("pageNum", reqBO.getPageNo() + "");
        map.put("pageSize", reqBO.getPageSize() + "");
        map.put("jsonMap", this.rep(reqBO));
        log.info("\u4e1a\u8d22\u67e5\u8be2\u6c47\u7968\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a{}, \u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)JSON.toJSONString(map), (Object)this.Bill_TAX_YC_SYS_URL);
        String returnString = SSLClient.doPost(this.Bill_TAX_YC_SYS_URL + "?respId=145440&userId=" + reqBO.getYcUserId(), map);
        log.info("\u4e1a\u8d22\u67e5\u8be2\u6c47\u7968\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)returnString);
        if (StringUtils.isEmpty((Object)returnString)) {
            throw new FscBusinessException("194317", "\u4e1a\u8d22\u67e5\u8be2\u6c47\u7968\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        JSONObject parseData = JSONObject.parseObject((String)returnString);
        JSONArray rows = parseData.getJSONArray("rows");
        FscQryFinanceDraftRspBO qryFinanceDraftRspBO = new FscQryFinanceDraftRspBO();
        if (rows != null && rows.size() > 0) {
            List<FinanceDraftBO> list = rows.stream().map(obj -> {
                JSONObject obj1 = (JSONObject)obj;
                FinanceDraftBO bo = new FinanceDraftBO();
                bo.setNum(obj1.getString("NUM"));
                bo.setDraftId(obj1.getString("DRAFT_ID"));
                bo.setDraftTypeDis(obj1.getString("DRAFT_CATEGORY_DIS"));
                bo.setDraftNumber(obj1.getString("DRAFT_NUMBER"));
                bo.setDraftAmount(obj1.getString("RECEIPT_AMOUNT"));
                bo.setDraftDate(obj1.getString("DRAFT_DATE"));
                bo.setDueDate(obj1.getString("EXPIRY_DATE"));
                bo.setDraftName(obj1.getString("DRAWER"));
                bo.setInvoiceName(obj1.getString("ENDORSER"));
                bo.setAcceptorName(obj1.getString("PAYMENT_BANK"));
                bo.setAcceptorDate(obj1.getString("ACCEPT_DATE"));
                bo.setOrgName(obj1.getString("FORE_HAND"));
                bo.setBillStatusDis(obj1.getString("BILL_STATUS_DIS"));
                return bo;
            }).collect(Collectors.toList());
            qryFinanceDraftRspBO.setRows(list);
            qryFinanceDraftRspBO.setRecordsTotal(Integer.valueOf(parseData.getString("total")));
        } else {
            qryFinanceDraftRspBO.setRecordsTotal(0);
        }
        qryFinanceDraftRspBO.setPageNo(reqBO.getPageNo());
        qryFinanceDraftRspBO.setRespCode("0000");
        qryFinanceDraftRspBO.setRespCode("0000");
        return qryFinanceDraftRspBO;
    }

    private String rep(FscQryFinanceDraftReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sqlIds", (Object)"10404");
        jsonObject.put("BILL_STATUS", (Object)"REC");
        if (!StringUtils.isEmpty((Object)reqBO.getDraftNumber())) {
            jsonObject.put("DRAFT_NUMBER", (Object)reqBO.getDraftNumber());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getDraftDateStart())) {
            jsonObject.put("DRAFT_DATE_START", (Object)reqBO.getDraftDateStart());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getDraftDateEnd())) {
            jsonObject.put("DRAFT_DATE_END", (Object)reqBO.getDraftDateEnd());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getDraftAmountStart())) {
            jsonObject.put("RECEIPT_AMOUNT_START", (Object)reqBO.getDraftAmountStart());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getDraftAmountEnd())) {
            jsonObject.put("RECEIPT_AMOUNT_END", (Object)reqBO.getDraftAmountEnd());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getDraftName())) {
            jsonObject.put("DRAWER", (Object)reqBO.getDraftName());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getInvoiceName())) {
            jsonObject.put("ENDORSER", (Object)reqBO.getInvoiceName());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getAcceptorName())) {
            jsonObject.put("PAYMENT_BANK", (Object)reqBO.getAcceptorName());
        }
        return jsonObject.toJSONString();
    }
}

