/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscFinanceBankSerialBO;
import com.tydic.fsc.bo.FscFinanceDraftInfoBO;
import com.tydic.fsc.bo.FscFinancePayItemBO;
import com.tydic.fsc.bo.FscFinancePayReduceBO;
import com.tydic.fsc.bo.FscFinancePlanItemBO;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.busibase.atom.api.FscFinanceCapitalInfoAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinanceCapitalInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceCapitalInfoAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceOccupyBankBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceOccupyBankReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceOccupyDraftBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceOccupyDraftReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceOccupyRspBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceOccupyCapitalBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceOccupyCapitalReqBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceOccupySupplyBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceOccupySupplyReqBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrDraftService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseBankService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseCapitalService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseSupplyService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeDetailMapper;
import com.tydic.fsc.dao.FscContractRelationMapper;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceCapitalPlanMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscFinancePayReduceMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.enums.FscFundsclaimBillTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargeDetailPO;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import com.tydic.fsc.po.FscFinanceCapitalPlanPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscFinancePayItemPO;
import com.tydic.fsc.po.FscFinancePayReducePO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.util.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinanceCapitalInfoAtomServiceImpl
implements FscFinanceCapitalInfoAtomService {
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscAccountChargeDetailMapper fscAccountChargeDetailMapper;
    @Autowired
    private FscFinanceCapitalPlanMapper fscFinanceCapitalPlanMapper;
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscFinancePayReduceMapper fscFinancePayReduceMapper;
    @Autowired
    private FscFinanceOccupyOrReleaseBankService fscFinanceOccupyOrReleaseBankService;
    @Autowired
    private FscFinanceOccupyOrDraftService fscFinanceOccupyOrDraftService;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;
    @Autowired
    private FscContractRelationMapper fscContractRelationMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscFinanceOccupyOrReleaseCapitalService fscFinanceOccupyOrReleaseCapitalService;
    @Autowired
    private FscFinanceOccupyOrReleaseSupplyService fscFinanceOccupyOrReleaseSupplyService;
    @Value(value="${finance.occupy.plan.enable:true}")
    private boolean enableFlag;

    @Override
    public FscFinanceCapitalInfoAtomRspBO dealFinanceCapitalInfo(FscFinanceCapitalInfoAtomReqBO reqBO) {
        int count;
        Map<Object, Object> payItemMap = new HashMap();
        FscOrderPayItemPO qryVo = new FscOrderPayItemPO();
        qryVo.setFscOrderId(reqBO.getObjId());
        List<FscOrderPayItemPO> poList = this.fscOrderPayItemMapper.getList(qryVo);
        payItemMap = poList.stream().collect(Collectors.toMap(FscOrderPayItemPO::getShouldPayId, FscOrderPayItemPO::getOrderPayItemId));
        if (CollectionUtils.isEmpty(poList)) {
            FscAccountChargeDetailPO detailQueryVo = new FscAccountChargeDetailPO();
            detailQueryVo.setChargeId(reqBO.getObjId());
            List<FscAccountChargeDetailPO> chargeDetailPOList = this.fscAccountChargeDetailMapper.getList(detailQueryVo);
            payItemMap = chargeDetailPOList.stream().collect(Collectors.toMap(FscAccountChargeDetailPO::getId, FscAccountChargeDetailPO::getId));
        }
        ArrayList<FscFinanceCapitalPlanPO> capitalList = new ArrayList<FscFinanceCapitalPlanPO>();
        ArrayList<FscFinanceDraftInfoPO> draftList = new ArrayList<FscFinanceDraftInfoPO>();
        ArrayList<FscFinanceBankStatementPO> bankList = new ArrayList<FscFinanceBankStatementPO>();
        ArrayList<FscFinancePayReducePO> reduceList = new ArrayList<FscFinancePayReducePO>();
        ArrayList<FscFinancePayItemPO> financeItemList = new ArrayList<FscFinancePayItemPO>();
        String billtypeName = null;
        String extBizBilltype = null;
        if (CollectionUtils.isEmpty(poList) || FscConstants.PaymentMethod.PRE_PAY.equals(poList.get(0).getShouldPayMethod())) {
            billtypeName = FscFundsclaimBillTypeEnum.ADV_PAY_BILL_TYPE_USED_CONTRACT.getDescription();
            extBizBilltype = FscFundsclaimBillTypeEnum.ADV_PAY_BILL_TYPE_USED_CONTRACT.getName();
        } else {
            billtypeName = FscFundsclaimBillTypeEnum.PAY_BILL_TYPE_USED_CONTRACT.getDescription();
            extBizBilltype = FscFundsclaimBillTypeEnum.PAY_BILL_TYPE_USED_CONTRACT.getName();
        }
        if (reqBO.getFscOrderPayItemBOS() == null || reqBO.getFscOrderPayItemBOS().isEmpty()) {
            throw new FscBusinessException("198888", "\u4ed8\u6b3e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (FscOrderPayItemBO orderPayItemBO : reqBO.getFscOrderPayItemBOS()) {
            this.checkLocalAmount(orderPayItemBO, reqBO.getExchangeRate());
            if (!CollectionUtils.isEmpty((Collection)orderPayItemBO.getReduceList())) {
                for (FscFinancePayReduceBO reduceBO : orderPayItemBO.getReduceList()) {
                    FscFinancePayReducePO reducePO = new FscFinancePayReducePO();
                    BeanUtils.copyProperties((Object)reduceBO, (Object)reducePO);
                    reducePO.setReduceId(Sequence.getInstance().nextId());
                    reducePO.setFscOrderId(reqBO.getObjId());
                    reducePO.setOrderPayItemId((Long)payItemMap.get(orderPayItemBO.getShouldPayId()));
                    reduceList.add(reducePO);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)orderPayItemBO.getSerialList())) {
                for (FscFinanceBankSerialBO bankSerialBO : orderPayItemBO.getSerialList()) {
                    FscFinanceBankStatementPO bankPO = new FscFinanceBankStatementPO();
                    BeanUtils.copyProperties((Object)bankSerialBO, (Object)bankPO);
                    bankPO.setStatementId(Sequence.getInstance().nextId());
                    bankPO.setFscOrderId(reqBO.getObjId());
                    bankPO.setCreateTime(new Date());
                    bankPO.setBilltypeName(billtypeName);
                    bankPO.setExtBizBilltype(extBizBilltype);
                    bankPO.setOrderPayItemId((Long)payItemMap.get(orderPayItemBO.getShouldPayId()));
                    bankList.add(bankPO);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)orderPayItemBO.getPlanList())) {
                for (FscFinancePlanItemBO planItemBO : orderPayItemBO.getPlanList()) {
                    FscFinanceCapitalPlanPO planPO = new FscFinanceCapitalPlanPO();
                    BeanUtils.copyProperties((Object)planItemBO, (Object)planPO);
                    planPO.setCaptialId(Sequence.getInstance().nextId());
                    planPO.setFscOrderId(reqBO.getObjId());
                    planPO.setOrderPayItemId((Long)payItemMap.get(orderPayItemBO.getShouldPayId()));
                    capitalList.add(planPO);
                }
            }
            if (orderPayItemBO.getFinanceItemList() == null || orderPayItemBO.getFinanceItemList().isEmpty()) {
                throw new FscBusinessException("198888", String.format("\u4ed8\u6b3e\u4fe1\u606f[%s]\u5bf9\u5e94\u4ed8\u6b3e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", orderPayItemBO.getItemNo()));
            }
            for (FscFinancePayItemBO financePayItemBO : orderPayItemBO.getFinanceItemList()) {
                BigDecimal payAmount;
                FscFinancePayItemPO payItemPO = new FscFinancePayItemPO();
                BeanUtils.copyProperties((Object)financePayItemBO, (Object)payItemPO);
                payItemPO.setFinancePayItemId(Sequence.getInstance().nextId());
                payItemPO.setShouldPayId(orderPayItemBO.getShouldPayId());
                payItemPO.setOrderPayItemId((Long)payItemMap.get(orderPayItemBO.getShouldPayId()));
                payItemPO.setFscOrderId(reqBO.getObjId());
                financeItemList.add(payItemPO);
                BigDecimal occAmountSum = BigDecimal.ZERO;
                if (!CollectionUtils.isEmpty((Collection)financePayItemBO.getPlanList())) {
                    for (FscFinancePlanItemBO planItemBO : financePayItemBO.getPlanList()) {
                        FscFinanceCapitalPlanPO planPO = new FscFinanceCapitalPlanPO();
                        BeanUtils.copyProperties((Object)planItemBO, (Object)planPO);
                        planPO.setCaptialId(Sequence.getInstance().nextId());
                        planPO.setFscOrderId(reqBO.getObjId());
                        payItemPO.setShouldPayId(orderPayItemBO.getShouldPayId());
                        planPO.setFinancePayItemId(payItemPO.getFinancePayItemId());
                        capitalList.add(planPO);
                        occAmountSum = occAmountSum.add(planPO.getOccAmount());
                    }
                }
                if (occAmountSum.compareTo(payAmount = financePayItemBO.getPayAmount()) != 0) {
                    throw new FscBusinessException("198888", String.format("%s\u4ed8\u6b3e\u4fe1\u606f\u91d1\u989d\u548c\u5173\u8054\u8d44\u91d1\u8ba1\u5212\u91d1\u989d\u4e0d\u7b49\uff01", financePayItemBO.getPayItemNo()));
                }
                if (CollectionUtils.isEmpty((Collection)financePayItemBO.getDraftList())) continue;
                for (FscFinanceDraftInfoBO draftInfoBO : financePayItemBO.getDraftList()) {
                    FscFinanceDraftInfoPO draftInfoPO = new FscFinanceDraftInfoPO();
                    BeanUtils.copyProperties((Object)draftInfoBO, (Object)draftInfoPO);
                    draftInfoPO.setDraftId(Sequence.getInstance().nextId());
                    draftInfoPO.setFinancePayItemId(payItemPO.getFinancePayItemId());
                    draftInfoPO.setFscOrderId(reqBO.getObjId());
                    draftInfoPO.setCreateTime(new Date());
                    draftInfoPO.setExtbilltypeName(billtypeName);
                    draftInfoPO.setExtBizBilltype(extBizBilltype);
                    draftList.add(draftInfoPO);
                }
            }
        }
        if (!CollectionUtils.isEmpty(financeItemList) && (count = this.fscFinancePayItemMapper.insertBatch(financeItemList)) != financeItemList.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u5171\u4eab\u4ed8\u6b3e\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(capitalList) && (count = this.fscFinanceCapitalPlanMapper.insertBatch(capitalList)) != capitalList.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u4ed8\u6b3e\u8d44\u91d1\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(draftList) && (count = this.fscFinanceDraftInfoMapper.insertBatch(draftList)) != draftList.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u4ed8\u6b3e\u7968\u636e\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(bankList) && (count = this.fscFinanceBankStatementMapper.insertBatch(bankList)) != bankList.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u4ed8\u6b3e\u6d41\u6c34\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(reduceList) && (count = this.fscFinancePayReduceMapper.insertBatch(reduceList)) != reduceList.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u4ed8\u6b3e\u6d41\u6c34\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if ("1".equals(reqBO.getOperationType().toString())) {
            if (!CollectionUtils.isEmpty(reduceList) && (count = this.fscContractRelationMapper.updateBatchById(reduceList)) != reduceList.size()) {
                throw new FscBusinessException("0000", "\u66f4\u65b0\u6838\u51cf\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (!CollectionUtils.isEmpty(capitalList)) {
                this.occupyCapital(capitalList, reqBO);
            }
            if (!CollectionUtils.isEmpty(draftList)) {
                this.occupyDraft(draftList, reqBO);
            }
            if (!CollectionUtils.isEmpty(bankList)) {
                this.occupyBank(bankList, reqBO);
            }
        }
        FscFinanceCapitalInfoAtomRspBO rspBO = new FscFinanceCapitalInfoAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void occupyCapital(List<FscFinanceCapitalPlanPO> capitalList, FscFinanceCapitalInfoAtomReqBO reqBO) {
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        financePO.setFscOrderId(reqBO.getObjId());
        financePO = this.fscOrderFinanceMapper.getModelBy(financePO);
        ArrayList<FscFinanceOccupyCapitalBO> occupyList = new ArrayList<FscFinanceOccupyCapitalBO>(capitalList.size());
        for (FscFinanceCapitalPlanPO planPO : capitalList) {
            FscFinanceOccupyCapitalBO capitalBO = new FscFinanceOccupyCapitalBO();
            capitalBO.setAmount(planPO.getOccAmount());
            capitalBO.setGuid(planPO.getCaptialId() + "");
            capitalBO.setLedgerType(planPO.getExt1());
            capitalBO.setPlanDayItem(planPO.getPlanItemCode());
            capitalBO.setBillCode(reqBO.getObjNo());
            capitalBO.setBizTypeCode(financePO.getBizTypeCode());
            occupyList.add(capitalBO);
        }
        FscFinanceOccupyCapitalReqBO capitalReqBO = new FscFinanceOccupyCapitalReqBO();
        capitalReqBO.setUnitCode(financePO.getCashUnitCode());
        capitalReqBO.setPeriod(capitalList.get(0).getPeriod());
        capitalReqBO.setList(occupyList);
        FscFinanceOccupyRspBO occupyRspBO = this.fscFinanceOccupyOrReleaseCapitalService.occupyCapital(capitalReqBO);
        if (!"0000".equals(occupyRspBO.getRespCode()) && this.enableFlag) {
            throw new FscBusinessException(occupyRspBO.getRespCode(), "\u5360\u7528\u8d44\u91d1\u8ba1\u5212\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    private void occupyDraft(List<FscFinanceDraftInfoPO> draftList, FscFinanceCapitalInfoAtomReqBO reqBO) {
        FscFinanceOccupyRspBO occupyRspBO;
        ArrayList<FscFinanceOccupySupplyBO> supplyList = new ArrayList<FscFinanceOccupySupplyBO>();
        ArrayList<FscFinanceOccupyDraftBO> receivableBOList = new ArrayList<FscFinanceOccupyDraftBO>();
        for (FscFinanceDraftInfoPO draftInfoPO : draftList) {
            if (FscConstants.FinanceDraftType.RECEIVABLE_DRAFT.equals(draftInfoPO.getDraftType())) {
                FscFinanceOccupyDraftBO draftBO = new FscFinanceOccupyDraftBO();
                draftBO.setCreateUser(reqBO.getUserName());
                draftBO.setCreateUserName(reqBO.getName());
                draftBO.setOrgId(reqBO.getFinanceOrgId());
                draftBO.setOrgName(reqBO.getFinanceOrgName());
                draftBO.setBizClaimAmt(draftInfoPO.getOccAmt());
                draftBO.setClaimTime(DateUtil.dateToStrLong((Date)draftInfoPO.getCreateTime()));
                draftBO.setBilltypeName(draftInfoPO.getExtbilltypeName());
                draftBO.setExtBizBilltype(draftInfoPO.getExtBizBilltype());
                draftBO.setLedgerReceGuid(draftInfoPO.getGuid());
                draftBO.setHeadGuid(draftInfoPO.getDraftId() + "");
                draftBO.setBillCode(reqBO.getObjNo());
                draftBO.setClaimSource(draftInfoPO.getDraftType() + "");
                receivableBOList.add(draftBO);
                continue;
            }
            FscFinanceOccupySupplyBO supplyBO = new FscFinanceOccupySupplyBO();
            supplyBO.setBizClaimAmount(draftInfoPO.getOccAmt());
            supplyBO.setHeadGuid(draftInfoPO.getDraftId() + "");
            supplyBO.setBillCode(reqBO.getObjNo());
            supplyBO.setClaimTime(DateUtil.dateToStrLong((Date)draftInfoPO.getCreateTime()));
            supplyBO.setCreateUser(reqBO.getName());
            supplyBO.setCreateUserName(reqBO.getUserName());
            supplyBO.setLedgerSupplyGuid(draftInfoPO.getGuid());
            supplyBO.setExtBizBillType(draftInfoPO.getExtBizBilltype());
            supplyBO.setExtBizTypeName(draftInfoPO.getExtbilltypeName());
            supplyBO.setOrgId(reqBO.getFinanceOrgId());
            supplyBO.setOrgName(reqBO.getFinanceOrgName());
            supplyList.add(supplyBO);
        }
        if (!CollectionUtils.isEmpty(supplyList)) {
            FscFinanceOccupySupplyReqBO supplyReqBO = new FscFinanceOccupySupplyReqBO();
            supplyReqBO.setSupplyList(supplyList);
            occupyRspBO = this.fscFinanceOccupyOrReleaseSupplyService.occupySupply(supplyReqBO);
            if (!"0000".equals(occupyRspBO.getRespCode())) {
                throw new FscBusinessException("198888", "\u5360\u7528\u4f9b\u5e94\u94fe\u53f0\u8d26\u5931\u8d25\uff1a" + occupyRspBO.getRespDesc());
            }
            for (FscFinanceDraftInfoPO draftInfoPO : draftList) {
                draftInfoPO.setExtId(occupyRspBO.getData().get(draftInfoPO.getGuid() + "-" + draftInfoPO.getDraftId()));
            }
        }
        if (!CollectionUtils.isEmpty(receivableBOList)) {
            FscFinanceOccupyDraftReqBO draftReqBO = new FscFinanceOccupyDraftReqBO();
            draftReqBO.setDraftList(receivableBOList);
            draftReqBO.setDraftType(FscConstants.FinanceDraftType.RECEIVABLE_DRAFT);
            occupyRspBO = this.fscFinanceOccupyOrDraftService.occupyDraft(draftReqBO);
            if (!"0000".equals(occupyRspBO.getRespCode())) {
                throw new FscBusinessException("198888", "\u5e94\u6536\u7968\u636e\u5931\u8d25\uff1a" + occupyRspBO.getRespDesc());
            }
            for (FscFinanceDraftInfoPO draftInfoPO : draftList) {
                draftInfoPO.setExtId(occupyRspBO.getData().get(draftInfoPO.getGuid() + "-" + draftInfoPO.getDraftId()));
            }
        }
        this.fscFinanceDraftInfoMapper.updateExtIdBatch(draftList);
    }

    private void occupyBank(List<FscFinanceBankStatementPO> bankList, FscFinanceCapitalInfoAtomReqBO reqBO) {
        FscFinanceOccupyBankReqBO bankReqBO = new FscFinanceOccupyBankReqBO();
        ArrayList<FscFinanceOccupyBankBO> bankBOList = new ArrayList<FscFinanceOccupyBankBO>();
        for (FscFinanceBankStatementPO bankStatementPO : bankList) {
            FscFinanceOccupyBankBO bankBO = new FscFinanceOccupyBankBO();
            bankBO.setFlowGuid(bankStatementPO.getGuid());
            bankBO.setHeadGuid(bankStatementPO.getStatementId() + "");
            bankBO.setBillCode(reqBO.getObjNo());
            bankBO.setBizClaimAmt(bankStatementPO.getOccAmt());
            bankBO.setCreateUser(reqBO.getUserName());
            bankBO.setCreateUserName(reqBO.getName());
            bankBO.setClaimTime(DateUtil.dateToStrLong((Date)bankStatementPO.getCreateTime()));
            bankBO.setOrgId(reqBO.getFinanceOrgId());
            bankBO.setOrgName(reqBO.getFinanceOrgName());
            bankBO.setBilltypeName(bankStatementPO.getBilltypeName());
            bankBO.setExtBizBilltype(bankStatementPO.getExtBizBilltype());
            bankBO.setClaimType("1");
            bankBOList.add(bankBO);
        }
        bankReqBO.setBankList(bankBOList);
        FscFinanceOccupyRspBO occupyRspBO = this.fscFinanceOccupyOrReleaseBankService.occupyBank(bankReqBO);
        if (!"0000".equals(occupyRspBO.getRespCode())) {
            throw new FscBusinessException("198888", "\u5360\u7528\u94f6\u884c\u6d41\u6c34\u4fe1\u606f\u5931\u8d25:" + occupyRspBO.getRespDesc());
        }
        for (FscFinanceBankStatementPO bankStatementPO : bankList) {
            bankStatementPO.setExtId(occupyRspBO.getData().get(bankStatementPO.getGuid() + "-" + bankStatementPO.getStatementId()));
        }
        this.fscFinanceBankStatementMapper.updateExtIdBatch(bankList);
    }

    private void checkLocalAmount(FscOrderPayItemBO orderPayItemBO, BigDecimal exchangeRate) {
        BigDecimal occAmtLocal;
        BigDecimal occAmt;
        if (exchangeRate == null) {
            throw new FscBusinessException("198888", "\u6c47\u7387\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)orderPayItemBO.getReduceList())) {
            for (FscFinancePayReduceBO reduceBO : orderPayItemBO.getReduceList()) {
                BigDecimal reduceAmt = reduceBO.getReduceAmt();
                BigDecimal reduceAmtLocal = reduceBO.getReduceAmtLocal();
                if (reduceAmt != null) {
                    if (reduceAmtLocal == null) {
                        throw new FscBusinessException("198888", String.format("%s\u6838\u51cf\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e0d\u80fd\u4e3a\u7a7a", reduceBO.getItemNo()));
                    }
                    if (reduceAmt.multiply(exchangeRate).compareTo(reduceAmtLocal) == 0) continue;
                    throw new FscBusinessException("198888", String.format("%s\u6838\u51cf\u91d1\u989d\u4e0e\u672c\u5e01\u4f4d\u8f6c\u6362\u540e\u91d1\u989d\u4e0d\u76f8\u7b49", reduceBO.getItemNo()));
                }
                throw new FscBusinessException("198888", String.format("%s\u6838\u51cf\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", reduceBO.getItemNo()));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)orderPayItemBO.getSerialList())) {
            for (FscFinanceBankSerialBO bankSerialBO : orderPayItemBO.getSerialList()) {
                BigDecimal amountUnclaimed = bankSerialBO.getAmountUnclaimed();
                BigDecimal amountUnclaimedLocal = bankSerialBO.getAmountUnclaimedLocal();
                occAmt = bankSerialBO.getOccAmt();
                occAmtLocal = bankSerialBO.getOccAmtLocal();
                if (amountUnclaimed != null) {
                    if (amountUnclaimedLocal == null) {
                        throw new FscBusinessException("198888", String.format("%s\u94f6\u884c\u6d41\u6c34\u53ef\u8ba4\u9886\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e0d\u80fd\u4e3a\u7a7a", bankSerialBO.getItemNo()));
                    }
                    if (amountUnclaimed.multiply(exchangeRate).compareTo(amountUnclaimedLocal) != 0) {
                        throw new FscBusinessException("198888", String.format("%s\u94f6\u884c\u6d41\u6c34\u53ef\u8ba4\u9886\u91d1\u989d\u4e0e\u672c\u5e01\u4f4d\u8f6c\u6362\u540e\u91d1\u989d\u4e0d\u76f8\u7b49", bankSerialBO.getItemNo()));
                    }
                } else {
                    throw new FscBusinessException("198888", String.format("%s\u94f6\u884c\u6d41\u6c34\u53ef\u8ba4\u9886\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", bankSerialBO.getItemNo()));
                }
                if (occAmt != null) {
                    if (occAmtLocal == null) {
                        throw new FscBusinessException("198888", String.format("%s\u94f6\u884c\u6d41\u6c34\u4ed8\u6b3e\u5360\u7528\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e0d\u80fd\u4e3a\u7a7a", bankSerialBO.getItemNo()));
                    }
                    if (occAmt.multiply(exchangeRate).compareTo(occAmtLocal) == 0) continue;
                    throw new FscBusinessException("198888", String.format("%s\u94f6\u884c\u6d41\u6c34\u4ed8\u6b3e\u5360\u7528\u91d1\u989d\u4e0e\u672c\u5e01\u4f4d\u8f6c\u6362\u540e\u91d1\u989d\u4e0d\u76f8\u7b49", bankSerialBO.getItemNo()));
                }
                throw new FscBusinessException("198888", String.format("%s\u94f6\u884c\u6d41\u6c34\u4ed8\u6b3e\u5360\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", bankSerialBO.getItemNo()));
            }
        }
        if (orderPayItemBO.getFinanceItemList() == null || orderPayItemBO.getFinanceItemList().isEmpty()) {
            throw new FscBusinessException("198888", String.format("%s\u4ed8\u6b3e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", orderPayItemBO.getItemNo()));
        }
        for (FscFinancePayItemBO financePayItemBO : orderPayItemBO.getFinanceItemList()) {
            if (financePayItemBO.getPlanList() == null || financePayItemBO.getPlanList().isEmpty()) {
                throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a", financePayItemBO.getPayItemNo()));
            }
            for (FscFinancePlanItemBO financePlanItemBO : financePayItemBO.getPlanList()) {
                BigDecimal balAmount = financePlanItemBO.getBalAmount();
                if (balAmount == null) {
                    throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u4f59\u989d\u4e0d\u80fd\u4e3a\u7a7a", financePayItemBO.getPayItemNo()));
                }
                BigDecimal occAmount = financePlanItemBO.getOccAmount();
                if (occAmount == null) {
                    throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u672c\u6b21\u5360\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", financePayItemBO.getPayItemNo()));
                }
                if (balAmount.compareTo(occAmount) >= 0) continue;
                throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u4f59\u989d\u4e0d\u80fd\u5c0f\u4e8e\u672c\u6b21\u5360\u7528\u91d1\u989d", financePayItemBO.getPayItemNo()));
            }
            if (CollectionUtils.isEmpty((Collection)financePayItemBO.getDraftList())) continue;
            for (FscFinanceDraftInfoBO draftInfoBO : financePayItemBO.getDraftList()) {
                occAmt = draftInfoBO.getOccAmt();
                occAmtLocal = draftInfoBO.getOccAmtLocal();
                if (occAmt != null) {
                    if (occAmtLocal == null) {
                        throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u7968\u636e\u5360\u7528\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e0d\u80fd\u4e3a\u7a7a", financePayItemBO.getPayItemNo()));
                    }
                    if (occAmt.multiply(exchangeRate).compareTo(occAmtLocal) == 0) continue;
                    throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u7968\u636e\u5360\u7528\u91d1\u989d\u4e0e\u672c\u5e01\u4f4d\u8f6c\u6362\u540e\u91d1\u989d\u4e0d\u76f8\u7b49", financePayItemBO.getPayItemNo()));
                }
                throw new FscBusinessException("198888", String.format("%s\u8d44\u91d1\u8ba1\u5212\u7968\u636e\u5360\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", financePayItemBO.getPayItemNo()));
            }
        }
    }
}

