/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscFinanceSettlePayReduceListAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinanceSettlePayReduceListAtomReqBo;
import com.tydic.fsc.busibase.atom.bo.FscFinanceSettlePayReduceListAtomRspBo;
import com.tydic.fsc.dao.FscContractRelationMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscContractRelationPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscFinanceSettlePayReduceListAtomServiceImpl
implements FscFinanceSettlePayReduceListAtomService {
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscContractRelationMapper fscContractRelationMapper;

    @Override
    public FscFinanceSettlePayReduceListAtomRspBo dealFinanceSettlePayReduce(FscFinanceSettlePayReduceListAtomReqBo reqBo) {
        FscFinanceSettlePayReduceListAtomRspBo rspBo = new FscFinanceSettlePayReduceListAtomRspBo();
        Long fscOrderId = reqBo.getFscOrderId();
        if (fscOrderId == null) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<FscOrderRelationPO> orderRelationPOList = this.fscOrderRelationMapper.getListByOrderIdGroupByContractId(fscOrderId);
        List<Long> contractIds = orderRelationPOList.stream().map(FscOrderRelationPO::getContractId).collect(Collectors.toList());
        List<FscContractRelationPO> hasContractPoList = this.fscContractRelationMapper.getListByContractIdsAndFscOrderId(contractIds, fscOrderId);
        ArrayList contractRelationList = Lists.newArrayList();
        for (FscOrderRelationPO fscOrderRelationPO : orderRelationPOList) {
            FscContractRelationPO hasContractPo = hasContractPoList.stream().filter(order -> ObjectUtil.equal((Object)order.getContractId(), (Object)fscOrderRelationPO.getContractId())).findFirst().orElse(null);
            if (hasContractPo != null && hasContractPo.getReducedAmt() != null && hasContractPo.getReducedAmt().compareTo(BigDecimal.ZERO) > 0) continue;
            FscContractRelationPO fscContractRelationPO = this.getFscContractRelationPO(fscOrderRelationPO);
            if (hasContractPo != null && hasContractPo.getRelationId() != null) {
                fscContractRelationPO.setRelationId(null);
                FscContractRelationPO updatePo = new FscContractRelationPO();
                updatePo.setRelationId(hasContractPo.getRelationId());
                this.fscContractRelationMapper.updateBy(fscContractRelationPO, updatePo);
                continue;
            }
            contractRelationList.add(fscContractRelationPO);
        }
        if (!contractRelationList.isEmpty()) {
            this.fscContractRelationMapper.insertBatch(contractRelationList);
        }
        rspBo.setFscOrderIds(Lists.newArrayList((Object[])new Long[]{fscOrderId}));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private FscContractRelationPO getFscContractRelationPO(FscOrderRelationPO fscOrderRelationPO) {
        FscContractRelationPO relationPo = new FscContractRelationPO();
        relationPo.setRelationId(Sequence.getInstance().nextId());
        relationPo.setFscOrderId(fscOrderRelationPO.getFscOrderId());
        relationPo.setFscOrderNo(fscOrderRelationPO.getFscOrderNo());
        relationPo.setContractId(fscOrderRelationPO.getContractId());
        relationPo.setContractNo(fscOrderRelationPO.getContractNo());
        relationPo.setContractName(fscOrderRelationPO.getContractName());
        relationPo.setSettleAmt(fscOrderRelationPO.getSettleAmt());
        relationPo.setReducedAmt(BigDecimal.ZERO);
        relationPo.setCreateTime(new Date());
        return relationPo;
    }
}

