/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb.finance;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinancePushSettleReqBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinancePushSettleRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinancePushSettleService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.SSLClient;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscFinancePushSettleServiceImpl
implements FscFinancePushSettleService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePushSettleServiceImpl.class);
    @Value(value="${finance.push.settle.url:}")
    private String settleUrl;

    @Override
    public FscFinancePushSettleRspBO dealPushSettle(FscFinancePushSettleReqBO reqBO) {
        log.debug("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u4ed8\u6b3e\u5355\u5165\u53c2:{}", (Object)reqBO.getReqData());
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", reqBO.getToken());
        log.info("\u8bf7\u6c42\u8def\u5f84\uff1a" + this.settleUrl);
        String respStr = SSLClient.doPostWithHeadMap(this.settleUrl, reqBO.getReqData(), headerMap);
        if (StringUtils.isEmpty((CharSequence)respStr)) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7ed3\u7b97\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        log.debug("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7ed3\u7b97\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587:{}", (Object)respStr);
        FscFinancePushSettleRspBO rspBO = new FscFinancePushSettleRspBO();
        rspBO.setRespStr(respStr);
        try {
            JSONObject respObj = JSONObject.parseObject((String)respStr);
            if (StringUtils.isEmpty((CharSequence)respObj.getString("code"))) {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7ed3\u7b97\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u72b6\u6001\u7801code\u4e3a\u7a7a\uff01");
                return rspBO;
            }
            if (!"0".equals(respObj.getString("code"))) {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u63a5\u53e3\u8fd4\u56de\u5904\u7406\u5931\u8d25\u4fe1\u606f\uff1a" + respObj.getString("msg"));
                return rspBO;
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc(respObj.getString("msg"));
            return rspBO;
        }
        catch (Exception e) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u89e3\u6790\u8d22\u52a1\u5171\u4eab\u7ed3\u7b97\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u5931\u8d25" + respStr);
            return rspBO;
        }
    }
}

