/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.utils;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.exception.FscBusinessException;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportExcel {
    private static final Logger log = LoggerFactory.getLogger(ExportExcel.class);

    public static String createExcel(Workbook workbook) {
        String path = System.getProperty("user.dir") + "/temporaryfile/" + UUID.randomUUID().toString() + ".xlsx";
        File file = new File(path);
        File fileParent = file.getParentFile();
        if (!fileParent.exists()) {
            fileParent.mkdirs();
        }
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            try {
                workbook.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new FscBusinessException("198888", "\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25" + e);
        }
        try {
            workbook.write((OutputStream)fout);
        }
        catch (IOException e) {
            throw new FscBusinessException("198888", "exl\u5185\u5bb9\u5199\u5165\u5931\u8d25" + e);
        }
        finally {
            try {
                workbook.close();
                fout.close();
            }
            catch (IOException iOException) {}
        }
        return path;
    }

    public static String createExcelSetFileName(Workbook workbook, String fileName) {
        String path = System.getProperty("user.dir") + "/temporaryfile/" + fileName;
        File file = new File(path);
        File fileParent = file.getParentFile();
        if (!fileParent.exists()) {
            fileParent.mkdirs();
        }
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            try {
                workbook.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new FscBusinessException("198888", "\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25" + e);
        }
        try {
            workbook.write((OutputStream)fout);
        }
        catch (IOException e) {
            throw new FscBusinessException("198888", "exl\u5185\u5bb9\u5199\u5165\u5931\u8d25" + e);
        }
        finally {
            try {
                workbook.close();
                fout.close();
            }
            catch (IOException iOException) {}
        }
        return path;
    }

    public static Workbook createWorkbook(String[] field, String[] title, String list) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = null;
        int n = 0;
        try {
            sheet = workbook.createSheet();
            workbook.setSheetName(n, "sheet1");
            workbook.setSelectedTab(0);
            assert (sheet != null);
            CellStyle style = workbook.createCellStyle();
            style.setBorderTop(BorderStyle.THIN);
            style.setBorderBottom(BorderStyle.THIN);
            style.setBorderLeft(BorderStyle.THIN);
            style.setBorderRight(BorderStyle.THIN);
            Row row0 = sheet.createRow(0);
            for (int i = 0; i < title.length; ++i) {
                Cell cell_1 = row0.createCell(i);
                cell_1.setCellValue(title[i]);
                cell_1.setCellStyle(style);
            }
            List result = JSONObject.parseArray((String)list, JSONObject.class);
            for (JSONObject map : result) {
                int index = sheet.getLastRowNum() + 1;
                Row row = sheet.createRow(index);
                for (int i = 0; i < title.length; ++i) {
                    String titleField = field[i];
                    Cell cell = row.createCell(i);
                    cell.setCellValue(map.getString(titleField));
                    cell.setCellStyle(style);
                }
            }
        }
        catch (Exception e) {
            throw new FscBusinessException("198888", "\u521b\u5efasheet\u5931\u8d25");
        }
        finally {
            if (workbook != null) {
                IOUtils.closeQuietly((Closeable)workbook);
            }
        }
        return workbook;
    }

    public static void merge(Workbook workbook, Integer same, Integer merge) {
        Sheet sheet = workbook.getSheetAt(0);
        if (sheet.getLastRowNum() == 1) {
            return;
        }
        for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
            Row data;
            Row row = sheet.getRow(i);
            String content = row.getCell(same.intValue()).getStringCellValue();
            int index = 0;
            int j = i + 1;
            while (j <= sheet.getLastRowNum() && content.equals((data = sheet.getRow(j)).getCell(same.intValue()).getStringCellValue())) {
                index = j++;
            }
            if (index == 0) continue;
            CellRangeAddress cra = new CellRangeAddress(i, index, merge.intValue(), merge.intValue());
            sheet.addMergedRegion(cra);
            i = index;
        }
    }
}

