/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.external.api.bo.FscNoticeEcomDelMsgExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscNoticeEcomDelMsgExternalRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscNoticeEcomDelMsgExternalService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.EsbParamUtil;
import com.tydic.fsc.utils.SSLClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class FscNoticeEcomDelMsgExternalServiceImpl
implements FscNoticeEcomDelMsgExternalService {
    private static final Logger log = LoggerFactory.getLogger(FscNoticeEcomDelMsgExternalServiceImpl.class);
    @Autowired
    private Environment environment;
    @Value(value="${esb.delInvoiceMsg.url:}")
    private String ESB_DEL_INVOICE_MSG_URL;

    @Override
    public FscNoticeEcomDelMsgExternalRspBO delEcomDelMsg(FscNoticeEcomDelMsgExternalReqBO reqBO) {
        this.valid(reqBO);
        String hsn = this.environment.getProperty("SUPPLIER_ID_" + reqBO.getSupplierId());
        String reqString = JSON.toJSONString((Object)reqBO);
        String reqEsbJson = EsbParamUtil.getEsbReqStr(reqString, hsn, "BUSINESS_PAY");
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42ESB\u5220\u9664\u7535\u5546\u6d88\u606f\u5165\u53c2:{},URL:{}", (Object)reqEsbJson, (Object)this.ESB_DEL_INVOICE_MSG_URL);
        }
        String rspJson = SSLClient.doPost(this.ESB_DEL_INVOICE_MSG_URL, reqEsbJson);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42ESB\u5220\u9664\u7535\u5546\u6d88\u606f\u51fa\u53c2:{}", (Object)rspJson);
        }
        if (StringUtils.isBlank((CharSequence)rspJson)) {
            throw new FscBusinessException("194320", "\u8bf7\u6c42ESB\u5220\u9664\u7535\u5546\u6d88\u606f\u63a5\u53e3\u8fd4\u56de\u7a7a");
        }
        FscNoticeEcomDelMsgExternalRspBO rspBO = (FscNoticeEcomDelMsgExternalRspBO)((Object)JSON.parseObject((String)rspJson, FscNoticeEcomDelMsgExternalRspBO.class));
        if (!rspBO.getSuccess().booleanValue()) {
            throw new FscBusinessException("194320", rspBO.getResultMessage());
        }
        return rspBO;
    }

    public void valid(FscNoticeEcomDelMsgExternalReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u7535\u5546\u6d88\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        }
        if (reqBO.getId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u7c7b\u578b[id]\u4e3a\u7a7a");
        }
        if (reqBO.getSupplierId() == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4f9b\u5e94\u5546id[supplierId]\u4e3a\u7a7a");
        }
    }
}

