/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.external.api.bo.FscPushNewYcPayRefundBillReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushNewYcPayRefundBillRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscPushNewYcPayRefundBillService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.SSLClient;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscPushNewYcPayRefundBillServiceImpl
implements FscPushNewYcPayRefundBillService {
    private static final Logger log = LoggerFactory.getLogger(FscPushNewYcPayRefundBillServiceImpl.class);
    @Value(value="${NEW_YC_PRE_PAY_REFUND_URL}")
    private String newYcPrePayRefundUrl;
    @Value(value="${NEW_YC_PRE_SET_REFUND_URL}")
    private String newYcSetPayRefundUrl;

    @Override
    public FscPushNewYcPayRefundBillRspBO pushNewYcPayRefundBill(FscPushNewYcPayRefundBillReqBO reqBO) {
        log.debug("\u63a8\u9001\u65b0\u4e1a\u8d22\u9000\u6b3e\u5355\u636e\u5165\u53c2:" + JSONObject.toJSONString((Object)reqBO));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("cipherCode", reqBO.getData());
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", reqBO.getToken());
        String respStr = null;
        try {
            if (reqBO.getIsPre().booleanValue()) {
                log.debug("\u63a8\u9001\u65b0\u4e1a\u8d22\u9884\u4ed8\u5355\u9000\u6b3e\u5355\u636e\u5730\u5740:" + this.newYcPrePayRefundUrl);
                respStr = SSLClient.doPost(this.newYcPrePayRefundUrl, paramMap, headerMap);
            } else {
                log.debug("\u63a8\u9001\u65b0\u4e1a\u8d22\u4ed8\u6b3e\u5355\u9000\u6b3e\u5355\u636e\u5730\u5740:" + this.newYcSetPayRefundUrl);
                respStr = SSLClient.doPost(this.newYcSetPayRefundUrl, paramMap, headerMap);
            }
            log.debug("\u63a8\u9001\u65b0\u4e1a\u8d22\u9884\u4ed8\u5355\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587:" + respStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FscBusinessException("198888", "\u63a8\u9001\u65b0\u4e1a\u8d22\u9884\u4ed8/\u4ed8\u6b3e\u5355\u9000\u6b3e\u5355\u636e\u63a5\u53e3\u5f02\u5e38\uff01");
        }
        if (StringUtils.isEmpty((Object)respStr)) {
            throw new FscBusinessException("198888", "\u63a8\u9001\u65b0\u4e1a\u8d22\u9884\u4ed8/\u4ed8\u6b3e\u5355\u9000\u6b3e\u5355\u636e\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        FscPushNewYcPayRefundBillRspBO rspBO = new FscPushNewYcPayRefundBillRspBO();
        try {
            rspBO = (FscPushNewYcPayRefundBillRspBO)((Object)JSONObject.parseObject((String)respStr, FscPushNewYcPayRefundBillRspBO.class));
            if (rspBO.getCode().equals("200")) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            } else {
                rspBO.setRespCode("190000");
                rspBO.setRespDesc("\u63a8\u9001\u65b0\u4e1a\u8d22\u9884\u4ed8/\u4ed8\u6b3e\u5355\u9000\u6b3e\u5355\u636e\u5931\u8d25:" + respStr);
            }
        }
        catch (Exception e) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u89e3\u6790\u65b0\u4e1a\u8d22\u9884\u4ed8/\u4ed8\u6b3e\u5355\u9000\u6b3e\u5355\u636e\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u5931\u8d25:" + respStr);
            log.error("\u89e3\u6790\u65b0\u4e1a\u8d22\u9884\u4ed8/\u4ed8\u6b3e\u5355\u9000\u6b3e\u5355\u636e\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u5931\u8d25\uff01");
            e.printStackTrace();
        }
        rspBO.setRspData(respStr);
        return rspBO;
    }
}

