/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscFinanceReleaseRefundInfoAtomService;
import com.tydic.fsc.busibase.atom.bo.FscFinanceReleaseRefundInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscFinanceReleaseRefundInfoAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceReleaseBankReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceReleaseDraftReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscFinanceReleaseRspBO;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceReleaseSupplyReqBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrDraftService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseBankService;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceOccupyOrReleaseSupplyService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceBankStatementMapper;
import com.tydic.fsc.dao.FscFinanceDraftInfoMapper;
import com.tydic.fsc.dao.FscPurchasePushLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinanceBankStatementPO;
import com.tydic.fsc.po.FscFinanceDraftInfoPO;
import com.tydic.fsc.po.FscPurchasePushLogPo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscFinanceReleaseRefundInfoAtomServiceImpl
implements FscFinanceReleaseRefundInfoAtomService {
    @Autowired
    private FscFinanceDraftInfoMapper fscFinanceDraftInfoMapper;
    @Autowired
    private FscFinanceBankStatementMapper fscFinanceBankStatementMapper;
    @Autowired
    private FscFinanceOccupyOrReleaseBankService fscFinanceOccupyOrReleaseBankService;
    @Autowired
    private FscFinanceOccupyOrDraftService fscFinanceOccupyOrDraftService;
    @Autowired
    private FscFinanceOccupyOrReleaseSupplyService fscFinanceOccupyOrReleaseSupplyService;
    @Autowired
    private FscPurchasePushLogMapper fscPurchasePushLogMapper;

    @Override
    public FscFinanceReleaseRefundInfoAtomRspBO dealReleaseRefundInfo(FscFinanceReleaseRefundInfoAtomReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u9000\u6b3eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getReleaseType() == null || reqBO.getReleaseType() == 1) {
            this.dealReleaseAll(reqBO);
        } else {
            this.dealRelease(reqBO.getDraftExtIds(), reqBO.getBankExtIds(), reqBO.getSupplyExtIds(), reqBO);
        }
        FscFinanceReleaseRefundInfoAtomRspBO rspBO = new FscFinanceReleaseRefundInfoAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealReleaseAll(FscFinanceReleaseRefundInfoAtomReqBO reqBO) {
        HashSet<String> draftExtIds = new HashSet<String>();
        HashSet<String> supplyExtIds = new HashSet<String>();
        FscFinanceDraftInfoPO draftQueryVo = new FscFinanceDraftInfoPO();
        draftQueryVo.setRefundId(reqBO.getRefundId());
        List<FscFinanceDraftInfoPO> draftList = this.fscFinanceDraftInfoMapper.getList(draftQueryVo);
        for (FscFinanceDraftInfoPO draftPO : draftList) {
            if (StringUtils.isBlank((String)draftPO.getExtId())) continue;
            if (FscConstants.FinanceDraftType.SUPPLY.equals(draftPO.getDraftType())) {
                supplyExtIds.add(draftPO.getExtId());
                continue;
            }
            draftExtIds.add(draftPO.getExtId());
        }
        FscFinanceBankStatementPO queryVo = new FscFinanceBankStatementPO();
        queryVo.setRefundId(reqBO.getRefundId());
        List<FscFinanceBankStatementPO> statementPOList = this.fscFinanceBankStatementMapper.getList(queryVo);
        ArrayList<String> bankExtIds = new ArrayList<String>();
        for (FscFinanceBankStatementPO statementPO : statementPOList) {
            if (StringUtils.isEmpty((String)statementPO.getExtId())) continue;
            bankExtIds.add(statementPO.getExtId());
        }
        this.dealRelease(draftExtIds, bankExtIds, supplyExtIds, reqBO);
    }

    private void dealRelease(Set<String> draftExtIds, List<String> bankExtIds, Set<String> supplyExtIds, FscFinanceReleaseRefundInfoAtomReqBO reqBO) {
        FscFinanceReleaseRspBO rspBO;
        ArrayList<FscPurchasePushLogPo> logPoList = new ArrayList<FscPurchasePushLogPo>();
        if (!CollectionUtils.isEmpty(bankExtIds)) {
            FscFinanceReleaseBankReqBO bankReqBO = new FscFinanceReleaseBankReqBO();
            bankReqBO.setGuids(bankExtIds);
            bankReqBO.setToken(reqBO.getToken());
            rspBO = this.fscFinanceOccupyOrReleaseBankService.releaseBank(bankReqBO);
            if (!"0000".equals(rspBO.getRespCode())) {
                throw new FscBusinessException("190000", "\u91ca\u653e\u6d41\u6c34\u4fe1\u606f\u5931\u8d25\uff01");
            }
            logPoList.add(this.addPushLog(reqBO.getRefundId(), reqBO.getRefundNo(), JSONObject.toJSONString((Object)bankReqBO), rspBO.getRespStr(), FscConstants.FscPurchasePushType.FINANCE_BANK_RELEASE));
        }
        if (!CollectionUtils.isEmpty(draftExtIds)) {
            FscFinanceReleaseDraftReqBO draftReqBO = new FscFinanceReleaseDraftReqBO();
            draftReqBO.setGuids(draftExtIds);
            draftReqBO.setDraftType(FscConstants.FinanceDraftType.DRAFT);
            rspBO = this.fscFinanceOccupyOrDraftService.releaseDraft(draftReqBO);
            if (!"0000".equals(rspBO.getRespCode())) {
                throw new FscBusinessException("190000", "\u91ca\u653e\u7968\u636e\u4fe1\u606f\u5931\u8d25\uff01");
            }
            logPoList.add(this.addPushLog(reqBO.getRefundId(), reqBO.getRefundNo(), JSONObject.toJSONString((Object)draftReqBO), rspBO.getRespStr(), FscConstants.FscPurchasePushType.FINANCE_DRAFT_RELEASE));
        }
        if (!CollectionUtils.isEmpty(supplyExtIds)) {
            FscFinanceReleaseSupplyReqBO supplyReqBO = new FscFinanceReleaseSupplyReqBO();
            supplyReqBO.setGuids(supplyExtIds);
            supplyReqBO.setDraftType(FscConstants.FinanceDraftType.SUPPLY);
            rspBO = this.fscFinanceOccupyOrReleaseSupplyService.releaseSupply(supplyReqBO);
            if (!"0000".equals(rspBO.getRespCode())) {
                throw new FscBusinessException("190000", "\u91ca\u653e\u4f9b\u5e94\u94fe\u4fe1\u606f\u5931\u8d25\uff01");
            }
            logPoList.add(this.addPushLog(reqBO.getRefundId(), reqBO.getRefundNo(), JSONObject.toJSONString((Object)supplyReqBO), rspBO.getRespStr(), FscConstants.FscPurchasePushType.FINANCE_SUPPLY_RELEASE));
        }
        if (!CollectionUtils.isEmpty(logPoList)) {
            this.fscPurchasePushLogMapper.insertBatch(logPoList);
        }
    }

    private FscPurchasePushLogPo addPushLog(Long billId, String billNo, String reqData, String respData, Integer type) {
        FscPurchasePushLogPo logPo = new FscPurchasePushLogPo();
        logPo.setId(Sequence.getInstance().nextId());
        logPo.setCreateTime(new Date());
        logPo.setObjectId(billId);
        logPo.setObjectNo(billNo);
        logPo.setPushData(reqData);
        logPo.setRespData(respData);
        logPo.setPushStatus(FscConstants.FscPushStatus.SUCCESS);
        logPo.setType(type);
        return logPo;
    }
}

