/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscLogOrdBusiMapper;
import com.tydic.fsc.dao.FscOrdStateChgLogMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscLogOrdBusiPO;
import com.tydic.fsc.po.FscOrdStateChgLogPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.osworkflow.engine.runtime.NextStepsResult;
import com.tydic.osworkflow.engine.runtime.StepWithOutInstance;
import com.tydic.osworkflow.engine.runtime.Task;
import com.tydic.osworkflow.engine.runtime.TaskCompleteBuilder;
import com.tydic.osworkflow.engine.runtime.TaskService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscOrderStatusFlowAtomServiceImpl
implements FscOrderStatusFlowAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderStatusFlowAtomServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscLogOrdBusiMapper fscLogOrdBusiMapper;
    @Autowired
    private FscOrdStateChgLogMapper fscOrdStateChgLogMapper;
    @Autowired
    private TaskService taskService;
    @Autowired
    private TaskCompleteBuilder taskCompleteBuilder;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Value(value="${workflow.inst.type:WithInstance}")
    private String workflowInstEnable;

    @Override
    public FscOrderStatusFlowAtomRspBO dealStatusFlow(FscOrderStatusFlowAtomReqBO reqBO) {
        Boolean isFinish;
        String stepType;
        Integer newStatus;
        this.val(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        List<FscOrderPO> fscOrderPOS = this.fscOrderMapper.getList(fscOrderPO);
        if (CollectionUtils.isEmpty(fscOrderPOS)) {
            throw new FscBusinessException("194309", "\u7ed3\u7b97\u72b6\u6001\u673a\u6ca1\u6709\u67e5\u8be2\u5230\u6d41\u7a0b\u5931\u8d25");
        }
        fscOrderPO = fscOrderPOS.get(0);
        if (StringUtils.isBlank((CharSequence)fscOrderPO.getOrderFlowKey())) {
            throw new FscBusinessException("194309", "\u7ed3\u7b97\u72b6\u6001\u673a\u6ca1\u6709\u67e5\u8be2\u5230\u6d41\u7a0bKEY");
        }
        String stepId = reqBO.getCurStatus().toString();
        if (log.isDebugEnabled()) {
            log.debug("\u72b6\u6001\u673a\u6d41\u8f6c\u72b6\u6001\u5165\u53c2:{} id:{}", (Object)JSON.toJSONString((Object)((Object)reqBO)), (Object)stepId);
        }
        String taskId = null;
        if ("NoneInstance".equals(this.workflowInstEnable)) {
            StepWithOutInstance stepInstance = this.taskService.newTaskCompleteBuilder().procDefId(null).procDefKey(fscOrderPO.getOrderFlowKey()).sysCode("FSC").stepId(stepId).variables(reqBO.getParamMap()).completeWithOutInstance();
            if (log.isDebugEnabled()) {
                log.debug("\u72b6\u6001\u673a\u6d41\u8f6c\u65e0\u5b9e\u4f8b\u56de\u53c2:{} \u5165\u53c2:{} id:{}", new Object[]{JSON.toJSONString((Object)stepInstance), JSON.toJSONString((Object)((Object)reqBO)), stepId});
            }
            if (null == stepInstance) {
                throw new FscBusinessException("194309", "\u65e0\u5b9e\u4f8b\u6d41\u7a0b\u6d41\u8f6c\u670d\u52a1\u8fd4\u56de\u7a7a");
            }
            newStatus = this.string2Integer(stepInstance.getStepId());
            stepType = stepInstance.getStepType();
            isFinish = stepInstance.getIsFinish();
        } else {
            NextStepsResult nextStepsResult = this.taskCompleteBuilder.procDefId(null).procDefKey(fscOrderPO.getOrderFlowKey()).sysCode("FSC").stepId(stepId).variables(reqBO.getParamMap()).taskId(fscOrderPO.getTaskId()).completeWithInstance();
            if (log.isDebugEnabled()) {
                log.debug("\u72b6\u6001\u673a\u6d41\u8f6c\u6709\u5b9e\u4f8b\u56de\u53c2:{} \u5165\u53c2:{} id:{} taskId:{}", new Object[]{JSON.toJSONString((Object)nextStepsResult), JSON.toJSONString((Object)((Object)reqBO)), stepId, fscOrderPO.getTaskId()});
            }
            if (CollectionUtils.isEmpty((Collection)nextStepsResult.getTaskList())) {
                throw new FscBusinessException("194309", "\u6709\u5b9e\u4f8b\u6d41\u7a0b\u6d41\u8f6c\u670d\u52a1\u8fd4\u56de\u7a7a");
            }
            Task task = (Task)nextStepsResult.getTaskList().get(0);
            newStatus = this.string2Integer(task.getStepId());
            stepType = task.getStepType();
            isFinish = nextStepsResult.getIsfinish();
            taskId = task.getTaskId();
        }
        if (!isFinish.booleanValue()) {
            this.updateStatus(reqBO, newStatus, taskId);
        }
        this.writeLog(reqBO, fscOrderPO.getOrderFlow(), fscOrderPO.getOrderState(), newStatus);
        FscOrderStatusFlowAtomRspBO rspBO = new FscOrderStatusFlowAtomRspBO();
        rspBO.setIsAuto("AUTO".equals(stepType) ? FscConstants.IsAutoFLow.YES : FscConstants.IsAutoFLow.NO);
        rspBO.setNewStatus(newStatus);
        return rspBO;
    }

    @Override
    public FscOrderStatusFlowAtomRspBO dealRefundStatusFlow(FscOrderStatusFlowAtomReqBO reqBO) {
        Boolean isFinish;
        String stepType;
        Integer newStatus;
        this.val(reqBO);
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getOrderId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("194309", "\u7ed3\u7b97\u72b6\u6001\u673a\u6ca1\u6709\u67e5\u8be2\u5230\u6d41\u7a0b");
        }
        if (StringUtils.isEmpty((CharSequence)refundPO.getOrderFlowKey())) {
            throw new FscBusinessException("194309", "\u7ed3\u7b97\u72b6\u6001\u673a\u6ca1\u6709\u67e5\u8be2\u5230\u6d41\u7a0bKEY");
        }
        String stepId = reqBO.getCurStatus().toString();
        if (log.isDebugEnabled()) {
            log.debug("\u72b6\u6001\u673a\u6d41\u8f6c\u72b6\u6001\u5165\u53c2:{} id:{}", (Object)JSON.toJSONString((Object)((Object)reqBO)), (Object)stepId);
        }
        String taskId = null;
        if ("NoneInstance".equals(this.workflowInstEnable)) {
            StepWithOutInstance stepInstance = this.taskService.newTaskCompleteBuilder().procDefId(null).procDefKey(refundPO.getOrderFlowKey()).sysCode("FSC").stepId(stepId).variables(reqBO.getParamMap()).completeWithOutInstance();
            if (log.isDebugEnabled()) {
                log.debug("\u72b6\u6001\u673a\u6d41\u8f6c\u65e0\u5b9e\u4f8b\u56de\u53c2:{} \u5165\u53c2:{} id:{}", new Object[]{JSON.toJSONString((Object)stepInstance), JSON.toJSONString((Object)((Object)reqBO)), stepId});
            }
            if (null == stepInstance) {
                throw new FscBusinessException("194309", "\u65e0\u5b9e\u4f8b\u6d41\u7a0b\u6d41\u8f6c\u670d\u52a1\u8fd4\u56de\u7a7a");
            }
            newStatus = this.string2Integer(stepInstance.getStepId());
            stepType = stepInstance.getStepType();
            isFinish = stepInstance.getIsFinish();
        } else {
            NextStepsResult nextStepsResult = this.taskCompleteBuilder.procDefId(null).procDefKey(refundPO.getOrderFlowKey()).sysCode("FSC").stepId(stepId).variables(reqBO.getParamMap()).taskId(refundPO.getTaskId()).completeWithInstance();
            if (log.isDebugEnabled()) {
                log.debug("\u72b6\u6001\u673a\u6d41\u8f6c\u6709\u5b9e\u4f8b\u56de\u53c2:{} \u5165\u53c2:{} id:{} taskId:{}", new Object[]{JSON.toJSONString((Object)nextStepsResult), JSON.toJSONString((Object)((Object)reqBO)), stepId, refundPO.getTaskId()});
            }
            if (CollectionUtils.isEmpty((Collection)nextStepsResult.getTaskList())) {
                throw new FscBusinessException("194309", "\u6709\u5b9e\u4f8b\u6d41\u7a0b\u6d41\u8f6c\u670d\u52a1\u8fd4\u56de\u7a7a");
            }
            Task task = (Task)nextStepsResult.getTaskList().get(0);
            newStatus = this.string2Integer(task.getStepId());
            stepType = task.getStepType();
            isFinish = nextStepsResult.getIsfinish();
            taskId = task.getTaskId();
        }
        if (!isFinish.booleanValue()) {
            this.updateRefundStatus(reqBO, newStatus, taskId);
        }
        this.writeLog(reqBO, refundPO.getOrderFlow(), refundPO.getRefundStatus(), newStatus);
        FscOrderStatusFlowAtomRspBO rspBO = new FscOrderStatusFlowAtomRspBO();
        rspBO.setIsAuto("AUTO".equals(stepType) ? FscConstants.IsAutoFLow.YES : FscConstants.IsAutoFLow.NO);
        rspBO.setNewStatus(newStatus);
        return rspBO;
    }

    private void val(FscOrderStatusFlowAtomReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u4e2d\u5fc3\u6838\u5fc3\u7ed3\u7b97\u72b6\u6001\u6d41\u8f6c\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getCurStatus()) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u4e2d\u5fc3\u6838\u5fc3\u7ed3\u7b97\u72b6\u6001\u6d41\u8f6c\u539f\u5b50\u670d\u52a1\u5931\u8d25,[curStatus]\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u7ed3\u7b97\u4e2d\u5fc3\u6838\u5fc3\u7ed3\u7b97\u72b6\u6001\u6d41\u8f6c\u539f\u5b50\u670d\u52a1\u5931\u8d25,[OrderId]\u5165\u53c2\u4e3a\u7a7a");
        }
    }

    private Integer string2Integer(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new FscBusinessException("194309", "\u72b6\u6001\u673a\u539f\u5b50\u670d\u52a1\u7ed3\u7b97\u4e3b\u5355\u72b6\u6001\u8f6c\u6362\u5f02\u5e38");
        }
    }

    private void updateStatus(FscOrderStatusFlowAtomReqBO reqBO, Integer newStatus, String taskId) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPo.setOrderState(newStatus);
        if (null != reqBO.getUserId()) {
            fscOrderPo.setUpdateOperId(reqBO.getUserId().toString());
        }
        fscOrderPo.setUpdateOperName(reqBO.getUserName());
        fscOrderPo.setUpdateTime(new Date());
        fscOrderPo.setUpdateTimeEnd(new Date());
        fscOrderPo.setTaskId(taskId);
        this.fscOrderMapper.updateById(fscOrderPo);
    }

    private void updateRefundStatus(FscOrderStatusFlowAtomReqBO reqBO, Integer newStatus, String taskId) {
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getOrderId());
        refundPO.setRefundStatus(newStatus);
        refundPO.setUpdateTime(new Date());
        refundPO.setTaskId(taskId);
        this.fscOrderRefundMapper.updateById(refundPO);
    }

    private void writeLog(FscOrderStatusFlowAtomReqBO reqBO, Integer orderFlow, Integer oldStatus, Integer newStatus) {
        FscLogOrdBusiPO fscLogOrdBusiPo = new FscLogOrdBusiPO();
        fscLogOrdBusiPo.setBusiName(reqBO.getBusiName());
        fscLogOrdBusiPo.setBusiType(orderFlow);
        fscLogOrdBusiPo.setCreateCompanyId(reqBO.getCompanyId());
        fscLogOrdBusiPo.setCreateCompanyName(reqBO.getCompanyName());
        fscLogOrdBusiPo.setCreateOperId(reqBO.getUserId());
        fscLogOrdBusiPo.setCreateOperName(reqBO.getName());
        fscLogOrdBusiPo.setCreateOrgId(reqBO.getOrgId());
        fscLogOrdBusiPo.setCreateOrgName(reqBO.getOrgName());
        fscLogOrdBusiPo.setCreateTime(new Date());
        fscLogOrdBusiPo.setFscOrderId(reqBO.getOrderId());
        this.fscLogOrdBusiMapper.insert(fscLogOrdBusiPo);
        FscOrdStateChgLogPO fscOrdStateChgLogPo = new FscOrdStateChgLogPO();
        fscOrdStateChgLogPo.setFscOrderId(reqBO.getOrderId());
        fscOrdStateChgLogPo.setOldState(oldStatus);
        fscOrdStateChgLogPo.setNewState(newStatus);
        fscOrdStateChgLogPo.setChgTime(new Date());
        if (null != reqBO.getUserId()) {
            fscOrdStateChgLogPo.setOperId(reqBO.getUserId().toString());
        }
        fscOrdStateChgLogPo.setChgDesc(reqBO.getBusiName());
        this.fscOrdStateChgLogMapper.insert(fscOrdStateChgLogPo);
    }
}

