/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscCreditDeductAtomBO;
import com.tydic.fsc.bo.FscPayShouldRefundBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscCreditDeductAtomService;
import com.tydic.fsc.busibase.atom.api.FscPayShouldPayRefundCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscSaleOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscSettleRefundShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscCreditDeductAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscCreditDeductAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayRefundCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayRefundCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSettleRefundShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSettleRefundShouldPayCreateAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscRefundReasonEnum;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayDetailMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderPaymentDetailMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRefundPayRelationMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscOrderShouldAmountMapper;
import com.tydic.fsc.dao.FscOrderWriteRelationMapper;
import com.tydic.fsc.dao.FscPurOrderRefundAmtMapper;
import com.tydic.fsc.dao.FscRefundChangeItemMapper;
import com.tydic.fsc.dao.FscRefundPaymentDetailMapper;
import com.tydic.fsc.dao.FscRefundShouldAmountMapper;
import com.tydic.fsc.dao.FscRefundWriteRelationMapper;
import com.tydic.fsc.dao.FscShouldPayDetailMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayDetailPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderPaymentDetailPO;
import com.tydic.fsc.po.FscOrderRefundBO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRefundPayRelationPo;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscOrderShouldAmountPO;
import com.tydic.fsc.po.FscOrderWriteRelationPO;
import com.tydic.fsc.po.FscPurOrderRefundAmtPO;
import com.tydic.fsc.po.FscRefundChangeItemPO;
import com.tydic.fsc.po.FscRefundPaymentDetailPO;
import com.tydic.fsc.po.FscRefundShouldAmountPO;
import com.tydic.fsc.po.FscRefundWriteRelationPO;
import com.tydic.fsc.po.FscShouldPayDetailPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import com.tydic.uoc.common.ability.api.PebExtMainOrderDetailQueryAbilityService;
import com.tydic.uoc.common.ability.api.UocOrderInfoQueryAbilityService;
import com.tydic.uoc.common.ability.bo.OrdItemRspBO;
import com.tydic.uoc.common.ability.bo.PebExtMainOrderDetailQueryReqBO;
import com.tydic.uoc.common.ability.bo.PebExtMainOrderDetailQueryRspBO;
import com.tydic.uoc.common.ability.bo.PebOrdAgreementRspBO;
import com.tydic.uoc.common.ability.bo.UocOrderInfoQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocOrderInfoQueryRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscSettleRefundShouldPayCreateAtomServiceImpl
implements FscSettleRefundShouldPayCreateAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscSettleRefundShouldPayCreateAtomServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private UocOrderInfoQueryAbilityService uocOrderInfoQueryAbilityService;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscOrderPayDetailMapper fscOrderPayDetailMapper;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscSaleOrderListQueryAtomService fscSaleOrderListQueryAtomService;
    @Autowired
    private FscOrderRefundPayRelationMapper fscOrderRefundPayRelationMapper;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private FscPayShouldPayRefundCreateAtomService fscPayShouldPayRefundCreateAtomService;
    @Autowired
    private FscCreditDeductAtomService fscCreditDeductAtomService;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscPurOrderRefundAmtMapper fscPurOrderRefundAmtMapper;
    @Value(value="${OPERATION_SUP_ID:1001693}")
    private String operationSupId;
    @Autowired
    private PebExtMainOrderDetailQueryAbilityService pebExtMainOrderDetailQueryAbilityService;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscRefundChangeItemMapper fscRefundChangeItemMapper;
    @Autowired
    private FscRefundWriteRelationMapper fscRefundWriteRelationMapper;
    @Autowired
    private FscOrderWriteRelationMapper fscOrderWriteRelationMapper;
    @Autowired
    private FscRefundShouldAmountMapper fscRefundShouldAmountMapper;
    @Autowired
    private FscOrderShouldAmountMapper fscOrderShouldAmountMapper;
    @Autowired
    private FscOrderPaymentDetailMapper fscOrderPaymentDetailMapper;
    @Autowired
    private FscRefundPaymentDetailMapper fscRefundPaymentDetailMapper;
    @Autowired
    private FscShouldPayDetailMapper fscShouldPayDetailMapper;

    @Override
    public FscSettleRefundShouldPayCreateAtomRspBO createSettleRefundShouldPay(FscSettleRefundShouldPayCreateAtomReqBO reqBO) {
        this.dealCreateRefundShould(reqBO.getOrderRefundPO(), reqBO);
        FscSettleRefundShouldPayCreateAtomRspBO rspBO = new FscSettleRefundShouldPayCreateAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealCreateRefundShould(FscOrderRefundPO orderRefundPO, FscSettleRefundShouldPayCreateAtomReqBO reqBO) {
        if (!FscRefundReasonEnum.RETURN_OR_EXCHANGE_PROBLEM.getCode().equals(orderRefundPO.getRefundReasonType().toString())) {
            return;
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(orderRefundPO.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        BigDecimal refundAmount = orderRefundPO.getRefundAmount();
        if (refundAmount == null || refundAmount.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        Integer tradeMode = fscOrderPO.getTradeMode();
        Long supplierId = fscOrderPO.getSupplierId();
        FscOrderRelationPO relationPO = new FscOrderRelationPO();
        relationPO.setRefundId(orderRefundPO.getRefundId());
        List<FscOrderRelationPO> fscOrderRelationPOS = this.fscOrderRelationMapper.getListNoPage(relationPO);
        if (CollectionUtils.isEmpty(fscOrderRelationPOS)) {
            return;
        }
        ArrayList orderIdList = new ArrayList();
        HashMap<Long, BigDecimal> orderIdMaxRefundAmtMap = new HashMap<Long, BigDecimal>();
        for (FscOrderRelationPO orderRelationPO : fscOrderRelationPOS) {
            if (orderRelationPO.getOrderId() == null || orderRelationPO.getSettleAmt() == null) continue;
            if (orderIdMaxRefundAmtMap.containsKey(orderRelationPO.getOrderId())) {
                BigDecimal amt = ((BigDecimal)orderIdMaxRefundAmtMap.get(orderRelationPO.getOrderId())).add(orderRelationPO.getSettleAmt());
                orderIdMaxRefundAmtMap.put(orderRelationPO.getOrderId(), amt);
                continue;
            }
            orderIdMaxRefundAmtMap.put(orderRelationPO.getOrderId(), orderRelationPO.getSettleAmt());
        }
        orderIdList.addAll(orderIdMaxRefundAmtMap.keySet());
        if (CollectionUtils.isEmpty(orderIdList)) {
            return;
        }
        UocOrderInfoQueryReqBO uocOrderInfoQueryReqBO = new UocOrderInfoQueryReqBO();
        uocOrderInfoQueryReqBO.setOrderIdList(orderIdList);
        log.debug("\u67e5\u8be2\u8ba2\u5355\u5e94\u4ed8\u91d1\u989d\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocOrderInfoQueryReqBO));
        UocOrderInfoQueryRspBO uocOrderInfoQueryRspBO = this.uocOrderInfoQueryAbilityService.getOrderInfoCode(uocOrderInfoQueryReqBO);
        log.debug("\u67e5\u8be2\u8ba2\u5355\u5e94\u4ed8\u91d1\u989d\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocOrderInfoQueryRspBO));
        if (!"0000".equals(uocOrderInfoQueryRspBO.getRespCode())) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u7ed3\u7b97\u5355\u4e0b\u8ba2\u5355\u91d1\u989d\u5931\u8d25\uff1a" + uocOrderInfoQueryRspBO.getRespDesc());
        }
        Map orderMap = uocOrderInfoQueryRspBO.getOrdItemRspBOList().stream().collect(Collectors.toMap(OrdItemRspBO::getOrderId, Function.identity()));
        Map<Long, BigDecimal> orderIdPaidAmt = this.getOrderIdPaidAmt(orderRefundPO, tradeMode, supplierId, orderIdMaxRefundAmtMap);
        if (FscConstants.FscTradeMode.TRADE_MODEL.equals(tradeMode)) {
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(orderRefundPO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(orderRefundPO.getMakeType())) {
                this.buildRefundShouldCreateByClaim(orderRefundPO, reqBO, orderIdPaidAmt);
            } else {
                this.buildRefundShouldCreateByPay(orderRefundPO, reqBO, orderIdPaidAmt);
            }
        } else if (this.operationSupId.equals(String.valueOf(supplierId))) {
            this.buildRefundShouldCreateByClaim(orderRefundPO, reqBO, orderIdPaidAmt);
        } else {
            this.buildRefundShouldCreateByPay(orderRefundPO, reqBO, orderIdPaidAmt);
        }
    }

    private Map<Long, BigDecimal> getOrderIdPaidAmt(FscOrderRefundPO orderRefundPO, Integer tradeMode, Long supplierId, Map<Long, BigDecimal> orderIdMaxRefundAmtMap) {
        Map<Object, Object> orderIdPaidAmt = new HashMap();
        FscShouldPayPO shouldPayPO = new FscShouldPayPO();
        shouldPayPO.setObjectId(orderRefundPO.getFscOrderId());
        orderIdPaidAmt = FscConstants.FscTradeMode.TRADE_MODEL.equals(tradeMode) ? (FscConstants.FscOrderReceiveType.PURCHASE.equals(orderRefundPO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(orderRefundPO.getMakeType()) ? this.getOrderIdPaidAmtByClaim(orderRefundPO, tradeMode, supplierId, orderIdMaxRefundAmtMap) : this.getOrderIdPaidAmtByPay(orderRefundPO, tradeMode, supplierId, orderIdMaxRefundAmtMap)) : (this.operationSupId.equals(String.valueOf(supplierId)) ? this.getOrderIdPaidAmtByClaim(orderRefundPO, tradeMode, supplierId, orderIdMaxRefundAmtMap) : this.getOrderIdPaidAmtByPay(orderRefundPO, tradeMode, supplierId, orderIdMaxRefundAmtMap));
        return orderIdPaidAmt;
    }

    private Map<Long, BigDecimal> getOrderIdPaidAmtByClaim(FscOrderRefundPO orderRefundPO, Integer tradeMode, Long supplierId, Map<Long, BigDecimal> orderIdMaxRefundAmtMap) {
        Long orderId;
        HashMap<Long, BigDecimal> orderIdPaidAmt = new HashMap();
        List<FscClaimDetailPO> claimDetailPOS = this.fscClaimDetailMapper.sumPayPaidAmtGroup(orderRefundPO.getFscOrderId());
        if (!CollectionUtils.isEmpty(claimDetailPOS)) {
            orderIdPaidAmt = claimDetailPOS.stream().filter(e -> e.getOrderId() != null && e.getAmount() != null).collect(Collectors.toMap(FscClaimDetailPO::getOrderId, FscClaimDetailPO::getAmount));
        }
        Map<Object, Object> writeOffMap = new HashMap();
        FscOrderWriteRelationPO writeRelationPO = new FscOrderWriteRelationPO();
        writeRelationPO.setFscOrderId(orderRefundPO.getFscOrderId());
        writeRelationPO.setOrderIds(orderIdMaxRefundAmtMap.keySet());
        List<FscOrderWriteRelationPO> writeOffList = this.fscOrderWriteRelationMapper.getRefundList(writeRelationPO);
        if (!CollectionUtils.isEmpty(writeOffList)) {
            writeOffMap = writeOffList.stream().filter(e -> e.getClaimDetailId() != null && e.getWriteOffAmount() != null).collect(Collectors.toMap(FscOrderWriteRelationPO::getClaimDetailId, FscOrderWriteRelationPO::getWriteOffAmount));
        }
        Map<Object, Object> refundChangeMap = new HashMap();
        FscRefundChangeItemPO fscRefundChangeItemPO = new FscRefundChangeItemPO();
        fscRefundChangeItemPO.setRefundId(orderRefundPO.getRefundId());
        List<FscRefundChangeItemPO> changeItemPOList = this.fscRefundChangeItemMapper.getList(fscRefundChangeItemPO);
        if (!CollectionUtils.isEmpty(changeItemPOList)) {
            refundChangeMap = changeItemPOList.stream().filter(e -> e.getPreClaimDetailId() != null && e.getChangeAmt() != null).collect(Collectors.toMap(FscRefundChangeItemPO::getPreClaimDetailId, FscRefundChangeItemPO::getChangeAmt));
        }
        Map<Object, Object> detailIdMap = new HashMap();
        if (!CollectionUtils.isEmpty(refundChangeMap) || !CollectionUtils.isEmpty(writeOffMap)) {
            HashSet<Long> claimDetailIds = new HashSet<Long>();
            claimDetailIds.addAll(refundChangeMap.keySet());
            claimDetailIds.addAll(writeOffMap.keySet());
            FscClaimDetailPO fscClaimDetailPO = new FscClaimDetailPO();
            fscClaimDetailPO.setClaimDetailIds(claimDetailIds);
            List<FscClaimDetailPO> detailPOS = this.fscClaimDetailMapper.getList(fscClaimDetailPO);
            if (!CollectionUtils.isEmpty(detailPOS)) {
                detailIdMap = detailPOS.stream().filter(e -> e.getOrderId() != null).collect(Collectors.toMap(FscClaimDetailPO::getClaimDetailId, FscClaimDetailPO::getOrderId));
            }
        }
        if (!CollectionUtils.isEmpty(writeOffMap)) {
            for (Long l : writeOffMap.keySet()) {
                BigDecimal writeOffAmt = (BigDecimal)writeOffMap.get(l);
                if (!detailIdMap.containsKey(l)) continue;
                orderId = (Long)detailIdMap.get(l);
                if (orderIdPaidAmt.containsKey(orderId)) {
                    orderIdPaidAmt.put(orderId, ((BigDecimal)orderIdPaidAmt.get(orderId)).add(writeOffAmt));
                    continue;
                }
                orderIdPaidAmt.put(orderId, writeOffAmt);
            }
        }
        if (!CollectionUtils.isEmpty(refundChangeMap)) {
            for (Long l : refundChangeMap.keySet()) {
                BigDecimal changeAmt = (BigDecimal)refundChangeMap.get(l);
                if (!detailIdMap.containsKey(l)) continue;
                orderId = (Long)detailIdMap.get(l);
                if (orderIdPaidAmt.containsKey(orderId)) {
                    orderIdPaidAmt.put(orderId, ((BigDecimal)orderIdPaidAmt.get(orderId)).add(changeAmt));
                    continue;
                }
                orderIdPaidAmt.put(orderId, changeAmt);
            }
        }
        return orderIdPaidAmt;
    }

    private Map<Long, BigDecimal> getOrderIdPaidAmtByPay(FscOrderRefundPO orderRefundPO, Integer tradeMode, Long supplierId, Map<Long, BigDecimal> orderIdMaxRefundAmtMap) {
        HashMap<Long, BigDecimal> orderIdPaidAmt = new HashMap<Long, BigDecimal>();
        List<Object> payDetailPOList = new ArrayList();
        payDetailPOList = orderRefundPO.getSettleType().equals(FscConstants.SettleType.INSPECTION) ? this.fscShouldPayDetailMapper.qryRefundList(orderRefundPO.getFscOrderId(), orderIdMaxRefundAmtMap.keySet()) : this.fscShouldPayDetailMapper.qryOrderRefundList(orderRefundPO.getFscOrderId(), orderIdMaxRefundAmtMap.keySet());
        for (FscShouldPayDetailPO fscShouldPayDetailPO : payDetailPOList) {
            BigDecimal paidAmt = fscShouldPayDetailPO.getPayAmount().subtract(fscShouldPayDetailPO.getRefundAmount());
            if (orderIdPaidAmt.containsKey(fscShouldPayDetailPO.getOrderId())) {
                orderIdPaidAmt.put(fscShouldPayDetailPO.getOrderId(), ((BigDecimal)orderIdPaidAmt.get(fscShouldPayDetailPO.getOrderId())).add(paidAmt));
                continue;
            }
            orderIdPaidAmt.put(fscShouldPayDetailPO.getOrderId(), paidAmt);
        }
        FscOrderShouldAmountPO shouldAmountPO = new FscOrderShouldAmountPO();
        shouldAmountPO.setFscOrderId(orderRefundPO.getFscOrderId());
        shouldAmountPO.setOrderIds(orderIdMaxRefundAmtMap.keySet());
        List<FscOrderShouldAmountPO> list = this.fscOrderShouldAmountMapper.getRefundList(shouldAmountPO);
        if (!CollectionUtils.isEmpty(list)) {
            for (FscOrderShouldAmountPO fscOrderShouldAmountPO : list) {
                fscOrderShouldAmountPO.setWriteOffAmount(fscOrderShouldAmountPO.getWriteOffAmount().subtract(fscOrderShouldAmountPO.getRefundAmt()));
                if (fscOrderShouldAmountPO.getWriteOffAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal writeOffAmount = fscOrderShouldAmountPO.getWriteOffAmount();
                if (orderIdPaidAmt.containsKey(fscOrderShouldAmountPO.getOrderId())) {
                    orderIdPaidAmt.put(fscOrderShouldAmountPO.getOrderId(), ((BigDecimal)orderIdPaidAmt.get(fscOrderShouldAmountPO.getOrderId())).add(writeOffAmount));
                    continue;
                }
                orderIdPaidAmt.put(fscOrderShouldAmountPO.getOrderId(), writeOffAmount);
            }
        }
        FscRefundPaymentDetailPO searchPaymentDetailPO = new FscRefundPaymentDetailPO();
        searchPaymentDetailPO.setRefundId(orderRefundPO.getRefundId());
        searchPaymentDetailPO.setFscOrderId(orderRefundPO.getFscOrderId());
        List<FscRefundPaymentDetailPO> detailPOS = this.fscRefundPaymentDetailMapper.getList(searchPaymentDetailPO);
        if (!CollectionUtils.isEmpty(detailPOS)) {
            for (FscRefundPaymentDetailPO detailPO : detailPOS) {
                BigDecimal amount = detailPO.getAmount();
                if (orderIdPaidAmt.containsKey(detailPO.getOrderId())) {
                    orderIdPaidAmt.put(detailPO.getOrderId(), ((BigDecimal)orderIdPaidAmt.get(detailPO.getOrderId())).add(amount));
                    continue;
                }
                orderIdPaidAmt.put(detailPO.getOrderId(), amount);
            }
        }
        FscRefundShouldAmountPO searchWritePO = new FscRefundShouldAmountPO();
        searchWritePO.setRefundId(orderRefundPO.getRefundId());
        List<FscRefundShouldAmountPO> writeRelationPOS = this.fscRefundShouldAmountMapper.getList(searchWritePO);
        if (!CollectionUtils.isEmpty(writeRelationPOS)) {
            for (FscRefundShouldAmountPO writeRelationPO : writeRelationPOS) {
                BigDecimal amount = writeRelationPO.getAmount();
                if (StringUtils.isEmpty((Object)writeRelationPO.getExt1())) continue;
                try {
                    Long orderId = Long.valueOf(writeRelationPO.getExt1());
                    if (orderIdPaidAmt.containsKey(orderId)) {
                        orderIdPaidAmt.put(orderId, ((BigDecimal)orderIdPaidAmt.get(orderId)).add(amount));
                        continue;
                    }
                    orderIdPaidAmt.put(orderId, amount);
                }
                catch (Exception exception) {}
            }
        }
        return orderIdPaidAmt;
    }

    private void buildRefundShouldCreateByPay(FscOrderRefundPO orderRefundPO, FscSettleRefundShouldPayCreateAtomReqBO reqBO, Map<Long, BigDecimal> orderIdPaidAmt) {
        HashMap<Long, BigDecimal> orderAmtMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, String> orderCodeMap = new HashMap<Long, String>();
        this.getOrderAmtMap(orderRefundPO, orderAmtMap, orderCodeMap);
        List<FscOrderRefundBO> orderList = this.fscOrderItemMapper.sumOrderAmtByRefundId(orderRefundPO.getRefundId());
        Map<Long, BigDecimal> orderMaxMap = orderList.stream().collect(Collectors.toMap(FscOrderRefundBO::getOrderId, FscOrderRefundBO::getRefundAmt));
        ArrayList<Long> payOrderIdList = new ArrayList<Long>();
        Map<Object, Object> orderIdPaidMap = new HashMap();
        FscRefundPaymentDetailPO searchPaymentDetailPO = new FscRefundPaymentDetailPO();
        searchPaymentDetailPO.setRefundId(orderRefundPO.getRefundId());
        searchPaymentDetailPO.setFscOrderId(orderRefundPO.getFscOrderId());
        List<FscRefundPaymentDetailPO> detailPOS = this.fscRefundPaymentDetailMapper.getList(searchPaymentDetailPO);
        ArrayList<Long> shouldPayIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(detailPOS)) {
            orderIdPaidMap = detailPOS.stream().filter(e -> e.getOrderId() != null).collect(Collectors.groupingBy(FscRefundPaymentDetailPO::getOrderId));
            Set payOrderIdSet = detailPOS.stream().filter(e -> e.getPayOrderId() != null).map(FscRefundPaymentDetailPO::getPayOrderId).collect(Collectors.toSet());
            payOrderIdList.addAll(payOrderIdSet);
        }
        Map<Object, Object> orderIdWriteMap = new HashMap();
        FscRefundShouldAmountPO searchWritePO = new FscRefundShouldAmountPO();
        searchWritePO.setRefundId(orderRefundPO.getRefundId());
        List<FscRefundShouldAmountPO> writeRelationPOS = this.fscRefundShouldAmountMapper.getList(searchWritePO);
        if (!CollectionUtils.isEmpty(writeRelationPOS)) {
            orderIdWriteMap = writeRelationPOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getExt1())).collect(Collectors.groupingBy(FscRefundShouldAmountPO::getExt1));
            Set payOrderIdSet = writeRelationPOS.stream().filter(e -> e.getPayOrderId() != null).map(FscRefundShouldAmountPO::getPayOrderId).collect(Collectors.toSet());
            payOrderIdList.addAll(payOrderIdSet);
        }
        Map<Object, Object> payOrderIdMap = new HashMap();
        if (!CollectionUtils.isEmpty(payOrderIdList)) {
            FscOrderPO searchShouldPayPO = new FscOrderPO();
            searchShouldPayPO.setFscOrderIds(payOrderIdList);
            List<FscOrderPO> payOrderPOS = this.fscOrderMapper.getList(searchShouldPayPO);
            if (!CollectionUtils.isEmpty(payOrderPOS)) {
                payOrderIdMap = payOrderPOS.stream().collect(Collectors.toMap(FscOrderPO::getFscOrderId, FscOrderPO::getOrderNo));
            }
        }
        if (!CollectionUtils.isEmpty(orderIdPaidMap) || !CollectionUtils.isEmpty(orderIdWriteMap)) {
            HashMap<Long, BigDecimal> orderIdPayAmountMap = new HashMap<Long, BigDecimal>();
            this.getOrderIdPayAmountMapByPay(orderIdPayAmountMap, orderRefundPO, orderMaxMap, shouldPayIds);
            ArrayList<FscOrderRefundPayRelationPo> fscOrderRefundPayRelationPoList = new ArrayList<FscOrderRefundPayRelationPo>();
            block0: for (Long orderId : orderMaxMap.keySet()) {
                FscPurOrderRefundAmtPO fscPurOrderRefundAmtPO;
                FscOrderRefundPayRelationPo fscOrderRefundPayRelationPo;
                BigDecimal releaseRefundAmt;
                String orderCode;
                FscOrderPayDetailPO fscOrderPayDetailPO;
                BigDecimal refundAmt = orderMaxMap.get(orderId);
                if (orderIdPaidMap.containsKey(orderId)) {
                    for (FscRefundPaymentDetailPO changeItemPO : (List)orderIdPaidMap.get(orderId)) {
                        if (refundAmt.compareTo(BigDecimal.ZERO) <= 0) break;
                        fscOrderPayDetailPO = new FscOrderPayDetailPO();
                        fscOrderPayDetailPO.setPayAmount((BigDecimal)orderIdPayAmountMap.get(orderId));
                        fscOrderPayDetailPO.setOrderId(orderId);
                        fscOrderPayDetailPO.setFscOrderId(changeItemPO.getPayOrderId());
                        fscOrderPayDetailPO.setFscOrderNo((String)payOrderIdMap.get(changeItemPO.getPayOrderId()));
                        orderCode = (String)orderCodeMap.get(orderId);
                        releaseRefundAmt = BigDecimal.ZERO;
                        releaseRefundAmt = changeItemPO.getAmount().compareTo(refundAmt) >= 0 ? refundAmt : changeItemPO.getAmount();
                        fscOrderRefundPayRelationPo = this.buildOrderRefundPayRelation(orderRefundPO, fscOrderPayDetailPO, orderCode, releaseRefundAmt, reqBO);
                        fscOrderRefundPayRelationPoList.add(fscOrderRefundPayRelationPo);
                        fscPurOrderRefundAmtPO = new FscPurOrderRefundAmtPO();
                        fscPurOrderRefundAmtPO.setId(Sequence.getInstance().nextId());
                        fscPurOrderRefundAmtPO.setOrderId(orderId);
                        fscPurOrderRefundAmtPO.setRefundAmt(releaseRefundAmt);
                        refundAmt = refundAmt.subtract(releaseRefundAmt);
                    }
                }
                if (refundAmt.compareTo(BigDecimal.ZERO) <= 0 || !orderIdWriteMap.containsKey(orderId.toString())) continue;
                for (FscRefundShouldAmountPO writeRelationPO : (List)orderIdWriteMap.get(orderId.toString())) {
                    if (refundAmt.compareTo(BigDecimal.ZERO) <= 0) continue block0;
                    fscOrderPayDetailPO = new FscOrderPayDetailPO();
                    fscOrderPayDetailPO.setPayAmount((BigDecimal)orderIdPayAmountMap.get(orderId));
                    fscOrderPayDetailPO.setOrderId(orderId);
                    fscOrderPayDetailPO.setFscOrderId(writeRelationPO.getPayOrderId());
                    fscOrderPayDetailPO.setFscOrderNo((String)payOrderIdMap.get(writeRelationPO.getPayOrderId()));
                    orderCode = (String)orderCodeMap.get(orderId);
                    releaseRefundAmt = BigDecimal.ZERO;
                    releaseRefundAmt = writeRelationPO.getAmount().compareTo(refundAmt) >= 0 ? refundAmt : writeRelationPO.getAmount();
                    fscOrderRefundPayRelationPo = this.buildOrderRefundPayRelation(orderRefundPO, fscOrderPayDetailPO, orderCode, releaseRefundAmt, reqBO);
                    fscOrderRefundPayRelationPoList.add(fscOrderRefundPayRelationPo);
                    fscPurOrderRefundAmtPO = new FscPurOrderRefundAmtPO();
                    fscPurOrderRefundAmtPO.setId(Sequence.getInstance().nextId());
                    fscPurOrderRefundAmtPO.setOrderId(orderId);
                    fscPurOrderRefundAmtPO.setRefundAmt(releaseRefundAmt);
                    refundAmt = refundAmt.subtract(releaseRefundAmt);
                }
            }
            if (!CollectionUtils.isEmpty(fscOrderRefundPayRelationPoList)) {
                this.buildShouldPayRefund(fscOrderRefundPayRelationPoList, orderRefundPO, reqBO, orderAmtMap, orderIdPaidAmt);
                Map<Long, List<FscOrderRefundPayRelationPo>> orderIdRelationMap = fscOrderRefundPayRelationPoList.stream().collect(Collectors.groupingBy(FscOrderRefundPayRelationPo::getOrderId));
                ArrayList<FscOrderRefundPayRelationPo> insertOrderRefundPayRelationPoList = new ArrayList<FscOrderRefundPayRelationPo>();
                for (Long orderId : orderIdRelationMap.keySet()) {
                    FscOrderRefundPayRelationPo refundPayRelationPo = orderIdRelationMap.get(orderId).get(0);
                    FscOrderRefundPayRelationPo insertOrderRefundPayRelationPo = (FscOrderRefundPayRelationPo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)refundPayRelationPo), FscOrderRefundPayRelationPo.class);
                    BigDecimal refundAmount = BigDecimal.ZERO;
                    BigDecimal payAmount = BigDecimal.ZERO;
                    for (FscOrderRefundPayRelationPo payRelationPo : orderIdRelationMap.get(orderId)) {
                        refundAmount = refundAmount.add(payRelationPo.getRefundAmount());
                        if (payRelationPo.getPayAmount() == null) continue;
                        payAmount = payAmount.add(payRelationPo.getPayAmount());
                    }
                    insertOrderRefundPayRelationPo.setRefundAmount(refundAmount);
                    insertOrderRefundPayRelationPo.setPayAmount(refundAmount);
                    insertOrderRefundPayRelationPoList.add(insertOrderRefundPayRelationPo);
                }
                this.fscOrderRefundPayRelationMapper.insertBatch(insertOrderRefundPayRelationPoList);
            }
        }
    }

    private void refundShouldCreateByClaim(List<Long> orderIdList, UocOrderInfoQueryRspBO uocOrderInfoQueryRspBO, FscOrderRefundPO orderRefundPO, FscOrderPO fscOrderPO, Map<Long, OrdItemRspBO> orderMap, FscSettleRefundShouldPayCreateAtomReqBO reqBO, Integer isSup, Map<Long, BigDecimal> orderIdMaxRefundAmtMap, Map<Long, BigDecimal> orderIdPaidAmt) {
        List<FscPurOrderRefundAmtPO> purOrderRefundAmtPOS;
        HashMap<Long, BigDecimal> orderIdRefundAmtMap = new HashMap<Long, BigDecimal>();
        ArrayList<FscOrderPayDetailPO> fscOrderPayDetailPOList = new ArrayList<FscOrderPayDetailPO>();
        FscClaimDetailPO searchClaimDetailPO = new FscClaimDetailPO();
        searchClaimDetailPO.setOrderIds(orderIdList.stream().collect(Collectors.toSet()));
        searchClaimDetailPO.setIsSup(isSup);
        List<FscClaimDetailPO> fscClaimDetailPOList = this.fscClaimDetailMapper.getClaimedByOrderIds(searchClaimDetailPO);
        if (!CollectionUtils.isEmpty(fscClaimDetailPOList)) {
            for (FscClaimDetailPO fscClaimDetailPO : fscClaimDetailPOList) {
                FscOrderPayDetailPO orderPayDetailPO = new FscOrderPayDetailPO();
                orderPayDetailPO.setOrderId(fscClaimDetailPO.getOrderId());
                orderPayDetailPO.setPayAmount(fscClaimDetailPO.getClaimAmt());
                orderPayDetailPO.setClaimDetailId(fscClaimDetailPO.getClaimDetailId());
                orderPayDetailPO.setClaimType(fscClaimDetailPO.getClaimType());
                fscOrderPayDetailPOList.add(orderPayDetailPO);
            }
        }
        if (!CollectionUtils.isEmpty(purOrderRefundAmtPOS = this.fscPurOrderRefundAmtMapper.getListByOrderIds(orderIdList))) {
            for (FscPurOrderRefundAmtPO refundAmtPO : purOrderRefundAmtPOS) {
                Long orderId = refundAmtPO.getOrderId();
                if (orderId == null || refundAmtPO.getRefundAmt() == null) continue;
                if (orderIdRefundAmtMap.containsKey(orderId)) {
                    orderIdRefundAmtMap.put(orderId, ((BigDecimal)orderIdRefundAmtMap.get(orderId)).add(refundAmtPO.getRefundAmt()));
                    continue;
                }
                orderIdRefundAmtMap.put(orderId, refundAmtPO.getRefundAmt());
            }
            log.debug("++++orderIdRefundAmtMap:{}", (Object)JSON.toJSONString(orderIdRefundAmtMap));
        }
        if (CollectionUtils.isEmpty(fscOrderPayDetailPOList)) {
            return;
        }
        for (FscOrderPayDetailPO fscOrderPayDetailPO : fscOrderPayDetailPOList) {
            if (fscOrderPayDetailPO.getRefundAmt() != null) continue;
            fscOrderPayDetailPO.setRefundAmt(BigDecimal.ZERO);
        }
        HashMap<Long, BigDecimal> hashMap = new HashMap<Long, BigDecimal>();
        Map<Long, List<FscOrderPayDetailPO>> fscOrderPayDetailMap = fscOrderPayDetailPOList.stream().collect(Collectors.groupingBy(FscOrderPayDetailPO::getOrderId));
        log.debug("++++fscOrderPayDetailMap:{}", (Object)JSON.toJSONString(fscOrderPayDetailMap));
        if (!CollectionUtils.isEmpty((Collection)uocOrderInfoQueryRspBO.getOrdItemRspBOList())) {
            Long key;
            BigDecimal refundAmount;
            ArrayList<FscOrderPayItemPO> updatePayItemList = new ArrayList<FscOrderPayItemPO>();
            ArrayList<FscPurOrderRefundAmtPO> insertRefundAmtPOS = new ArrayList<FscPurOrderRefundAmtPO>();
            ArrayList<FscOrderRefundPayRelationPo> fscOrderRefundPayRelationPoList = new ArrayList<FscOrderRefundPayRelationPo>();
            ArrayList<FscOrderPayDetailPO> updateRefundAmtPoList = new ArrayList<FscOrderPayDetailPO>();
            ArrayList<FscShouldPayPO> fscShouldPayPOList = new ArrayList<FscShouldPayPO>();
            Iterator<Long> iterator = fscOrderPayDetailMap.keySet().iterator();
            while (iterator.hasNext() && (refundAmount = orderIdMaxRefundAmtMap.get(key = iterator.next())) != null && refundAmount.compareTo(BigDecimal.ZERO) > 0) {
                List<FscOrderPayDetailPO> fscOrderPayDetailPOS = fscOrderPayDetailMap.get(key);
                BigDecimal payAmt = fscOrderPayDetailPOS.stream().map(FscOrderPayDetailPO::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal payRefundAmt = BigDecimal.ZERO;
                if (orderIdRefundAmtMap.containsKey(key)) {
                    payRefundAmt = payRefundAmt.add((BigDecimal)orderIdRefundAmtMap.get(key));
                }
                OrdItemRspBO ordItemRspBO = orderMap.get(key);
                BigDecimal orderAmt = FscConstants.FscOrderReceiveType.OPERATION.equals(orderRefundPO.getReceiveType()) && FscConstants.FscOrderMakeType.SUPPLIER.equals(orderRefundPO.getMakeType()) ? (ordItemRspBO == null ? BigDecimal.ZERO : ordItemRspBO.getTotalPurchaseMoney()) : (ordItemRspBO == null ? BigDecimal.ZERO : ordItemRspBO.getTotalSaleMoney());
                hashMap.put(key, orderAmt);
                log.debug("+++++\u91d1\u989d\uff1a{},{},{}", new Object[]{payAmt, orderAmt, payRefundAmt});
                if ((payAmt = payAmt.subtract(payRefundAmt)).compareTo(orderAmt) <= 0) continue;
                BigDecimal releaseRefundAmt = payAmt.subtract(orderAmt);
                if (releaseRefundAmt.compareTo(refundAmount) >= 0) {
                    releaseRefundAmt = refundAmount;
                }
                FscOrderPayDetailPO fscOrderPayDetailPO = new FscOrderPayDetailPO();
                fscOrderPayDetailPO.setPayAmount(payAmt.add(payRefundAmt));
                fscOrderPayDetailPO.setOrderId(key);
                String orderCode = null;
                if (ordItemRspBO != null && !StringUtils.isEmpty((Object)ordItemRspBO.getOrderCode())) {
                    orderCode = ordItemRspBO.getOrderCode();
                }
                FscOrderRefundPayRelationPo fscOrderRefundPayRelationPo = this.buildOrderRefundPayRelation(orderRefundPO, fscOrderPayDetailPO, orderCode, releaseRefundAmt, reqBO);
                fscOrderRefundPayRelationPoList.add(fscOrderRefundPayRelationPo);
                FscPurOrderRefundAmtPO fscPurOrderRefundAmtPO = new FscPurOrderRefundAmtPO();
                fscPurOrderRefundAmtPO.setId(Sequence.getInstance().nextId());
                fscPurOrderRefundAmtPO.setOrderId(key);
                fscPurOrderRefundAmtPO.setRefundAmt(releaseRefundAmt);
                insertRefundAmtPOS.add(fscPurOrderRefundAmtPO);
                refundAmount = refundAmount.subtract(releaseRefundAmt);
            }
            log.debug("++++fscOrderRefundPayRelationPoList:{}", (Object)JSON.toJSONString(fscOrderRefundPayRelationPoList));
            if (!CollectionUtils.isEmpty(fscOrderRefundPayRelationPoList)) {
                this.claimBuildShouldPayRefund(fscOrderRefundPayRelationPoList, orderRefundPO, reqBO, insertRefundAmtPOS, hashMap, orderIdPaidAmt);
                this.fscOrderRefundPayRelationMapper.insertBatch(fscOrderRefundPayRelationPoList);
            }
            this.dealShouldRefundUpdate(updateRefundAmtPoList, updatePayItemList, fscShouldPayPOList, insertRefundAmtPOS);
        }
    }

    private void buildRefundShouldCreateByClaim(FscOrderRefundPO orderRefundPO, FscSettleRefundShouldPayCreateAtomReqBO reqBO, Map<Long, BigDecimal> orderIdPaidAmt) {
        HashMap<Long, BigDecimal> orderAmtMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, String> orderCodeMap = new HashMap<Long, String>();
        this.getOrderAmtMap(orderRefundPO, orderAmtMap, orderCodeMap);
        List<FscOrderRefundBO> orderList = this.fscOrderItemMapper.sumOrderAmtByRefundId(orderRefundPO.getRefundId());
        Map<Long, BigDecimal> orderMaxMap = orderList.stream().collect(Collectors.toMap(FscOrderRefundBO::getOrderId, FscOrderRefundBO::getRefundAmt));
        Map<Object, Object> orderIdPaidMap = new HashMap();
        FscRefundChangeItemPO searchChangeItemPO = new FscRefundChangeItemPO();
        searchChangeItemPO.setRefundId(orderRefundPO.getRefundId());
        searchChangeItemPO.setPreFscOrderId(orderRefundPO.getFscOrderId());
        List<FscRefundChangeItemPO> changeItemPOS = this.fscRefundChangeItemMapper.getList(searchChangeItemPO);
        if (!CollectionUtils.isEmpty(changeItemPOS)) {
            orderIdPaidMap = changeItemPOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getExt1())).collect(Collectors.groupingBy(FscRefundChangeItemPO::getExt1));
        }
        Map<Object, Object> orderIdWriteMap = new HashMap();
        FscRefundWriteRelationPO searchWritePO = new FscRefundWriteRelationPO();
        searchWritePO.setRefundId(orderRefundPO.getRefundId());
        List<FscRefundWriteRelationPO> writeRelationPOS = this.fscRefundWriteRelationMapper.getList(searchWritePO);
        if (!CollectionUtils.isEmpty(writeRelationPOS)) {
            orderIdWriteMap = writeRelationPOS.stream().filter(e -> e.getOrderId() != null).collect(Collectors.groupingBy(FscRefundWriteRelationPO::getOrderId));
        }
        if (!CollectionUtils.isEmpty(orderIdPaidMap) || !CollectionUtils.isEmpty(orderIdWriteMap)) {
            HashMap<Long, BigDecimal> orderIdPayAmountMap = new HashMap<Long, BigDecimal>();
            this.getOrderIdPayAmountMap(orderIdPayAmountMap, orderRefundPO, orderMaxMap);
            ArrayList<FscOrderRefundPayRelationPo> fscOrderRefundPayRelationPoList = new ArrayList<FscOrderRefundPayRelationPo>();
            block0: for (Long orderId : orderMaxMap.keySet()) {
                FscPurOrderRefundAmtPO fscPurOrderRefundAmtPO;
                FscOrderRefundPayRelationPo fscOrderRefundPayRelationPo;
                BigDecimal releaseRefundAmt;
                String orderCode;
                FscOrderPayDetailPO fscOrderPayDetailPO;
                BigDecimal refundAmt = orderMaxMap.get(orderId);
                if (orderIdPaidMap.containsKey(orderId.toString())) {
                    for (FscRefundChangeItemPO changeItemPO : (List)orderIdPaidMap.get(orderId.toString())) {
                        if (refundAmt.compareTo(BigDecimal.ZERO) <= 0) break;
                        fscOrderPayDetailPO = new FscOrderPayDetailPO();
                        fscOrderPayDetailPO.setPayAmount((BigDecimal)orderIdPayAmountMap.get(orderId));
                        fscOrderPayDetailPO.setOrderId(orderId);
                        orderCode = (String)orderCodeMap.get(orderId);
                        releaseRefundAmt = BigDecimal.ZERO;
                        releaseRefundAmt = changeItemPO.getChangeAmt().compareTo(refundAmt) >= 0 ? refundAmt : changeItemPO.getChangeAmt();
                        fscOrderRefundPayRelationPo = this.buildOrderRefundPayRelation(orderRefundPO, fscOrderPayDetailPO, orderCode, releaseRefundAmt, reqBO);
                        fscOrderRefundPayRelationPoList.add(fscOrderRefundPayRelationPo);
                        fscPurOrderRefundAmtPO = new FscPurOrderRefundAmtPO();
                        fscPurOrderRefundAmtPO.setId(Sequence.getInstance().nextId());
                        fscPurOrderRefundAmtPO.setOrderId(orderId);
                        fscPurOrderRefundAmtPO.setRefundAmt(releaseRefundAmt);
                        refundAmt = refundAmt.subtract(releaseRefundAmt);
                    }
                }
                if (refundAmt.compareTo(BigDecimal.ZERO) <= 0 || !orderIdWriteMap.containsKey(orderId)) continue;
                for (FscRefundWriteRelationPO writeRelationPO : (List)orderIdWriteMap.get(orderId)) {
                    if (refundAmt.compareTo(BigDecimal.ZERO) <= 0) continue block0;
                    fscOrderPayDetailPO = new FscOrderPayDetailPO();
                    fscOrderPayDetailPO.setPayAmount((BigDecimal)orderIdPayAmountMap.get(orderId));
                    fscOrderPayDetailPO.setOrderId(orderId);
                    orderCode = (String)orderCodeMap.get(orderId);
                    releaseRefundAmt = BigDecimal.ZERO;
                    releaseRefundAmt = writeRelationPO.getWriteOffAmount().compareTo(refundAmt) >= 0 ? refundAmt : writeRelationPO.getWriteOffAmount();
                    fscOrderRefundPayRelationPo = this.buildOrderRefundPayRelation(orderRefundPO, fscOrderPayDetailPO, orderCode, releaseRefundAmt, reqBO);
                    fscOrderRefundPayRelationPoList.add(fscOrderRefundPayRelationPo);
                    fscPurOrderRefundAmtPO = new FscPurOrderRefundAmtPO();
                    fscPurOrderRefundAmtPO.setId(Sequence.getInstance().nextId());
                    fscPurOrderRefundAmtPO.setOrderId(orderId);
                    fscPurOrderRefundAmtPO.setRefundAmt(releaseRefundAmt);
                    refundAmt = refundAmt.subtract(releaseRefundAmt);
                }
            }
            if (!CollectionUtils.isEmpty(fscOrderRefundPayRelationPoList)) {
                this.claimBuildShouldPayRefund(fscOrderRefundPayRelationPoList, orderRefundPO, reqBO, null, orderAmtMap, orderIdPaidAmt);
                Map<Long, List<FscOrderRefundPayRelationPo>> orderIdRelationMap = fscOrderRefundPayRelationPoList.stream().collect(Collectors.groupingBy(FscOrderRefundPayRelationPo::getOrderId));
                ArrayList<FscOrderRefundPayRelationPo> insertOrderRefundPayRelationPoList = new ArrayList<FscOrderRefundPayRelationPo>();
                for (Long orderId : orderIdRelationMap.keySet()) {
                    FscOrderRefundPayRelationPo refundPayRelationPo = orderIdRelationMap.get(orderId).get(0);
                    FscOrderRefundPayRelationPo insertOrderRefundPayRelationPo = (FscOrderRefundPayRelationPo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)refundPayRelationPo), FscOrderRefundPayRelationPo.class);
                    BigDecimal refundAmount = BigDecimal.ZERO;
                    BigDecimal payAmount = BigDecimal.ZERO;
                    for (FscOrderRefundPayRelationPo payRelationPo : orderIdRelationMap.get(orderId)) {
                        refundAmount = refundAmount.add(payRelationPo.getRefundAmount());
                        if (payRelationPo.getPayAmount() == null) continue;
                        payAmount = payAmount.add(payRelationPo.getPayAmount());
                    }
                    insertOrderRefundPayRelationPo.setRefundAmount(refundAmount);
                    insertOrderRefundPayRelationPo.setPayAmount(refundAmount);
                    insertOrderRefundPayRelationPoList.add(insertOrderRefundPayRelationPo);
                }
                this.fscOrderRefundPayRelationMapper.insertBatch(insertOrderRefundPayRelationPoList);
            }
        }
    }

    private void getOrderIdPayAmountMapByPay(Map<Long, BigDecimal> orderIdPayAmountMap, FscOrderRefundPO orderRefundPO, Map<Long, BigDecimal> orderMaxMap, List<Long> shouldPayIds) {
        if (!CollectionUtils.isEmpty(shouldPayIds)) {
            FscOrderPaymentDetailPO fscOrderPaymentDetailPO = new FscOrderPaymentDetailPO();
            fscOrderPaymentDetailPO.setShouldPayIds(shouldPayIds);
            fscOrderPaymentDetailPO.setOrderIds(orderMaxMap.keySet());
            List<FscOrderPaymentDetailPO> paymentDetailPOList = this.fscOrderPaymentDetailMapper.getPaidRefundList(fscOrderPaymentDetailPO);
            if (!CollectionUtils.isEmpty(paymentDetailPOList)) {
                for (FscOrderPaymentDetailPO paymentDetailPO : paymentDetailPOList) {
                    if (orderIdPayAmountMap.containsKey(paymentDetailPO.getOrderId())) {
                        orderIdPayAmountMap.put(paymentDetailPO.getOrderId(), orderIdPayAmountMap.get(paymentDetailPO.getOrderId()).add(paymentDetailPO.getPayAmount()));
                        continue;
                    }
                    orderIdPayAmountMap.put(paymentDetailPO.getOrderId(), paymentDetailPO.getPayAmount());
                }
            }
        }
        FscOrderShouldAmountPO shouldAmountPO = new FscOrderShouldAmountPO();
        shouldAmountPO.setFscOrderId(orderRefundPO.getFscOrderId());
        shouldAmountPO.setOrderIds(orderMaxMap.keySet());
        List<FscOrderShouldAmountPO> writeOffList = this.fscOrderShouldAmountMapper.getPaidRefundList(shouldAmountPO);
        if (!CollectionUtils.isEmpty(writeOffList)) {
            for (FscOrderShouldAmountPO fscOrderWriteRelationPO : writeOffList) {
                if (orderIdPayAmountMap.containsKey(fscOrderWriteRelationPO.getOrderId())) {
                    orderIdPayAmountMap.put(fscOrderWriteRelationPO.getOrderId(), orderIdPayAmountMap.get(fscOrderWriteRelationPO.getOrderId()).add(fscOrderWriteRelationPO.getWriteOffAmount()));
                    continue;
                }
                orderIdPayAmountMap.put(fscOrderWriteRelationPO.getOrderId(), fscOrderWriteRelationPO.getWriteOffAmount());
            }
        }
    }

    private void getOrderIdPayAmountMap(Map<Long, BigDecimal> orderIdPayAmountMap, FscOrderRefundPO orderRefundPO, Map<Long, BigDecimal> orderMaxMap) {
        List<FscClaimDetailPO> payPaidList = this.fscClaimDetailMapper.qryPaidListByFscOrderId(orderRefundPO.getFscOrderId(), orderMaxMap.keySet());
        FscOrderWriteRelationPO searchFscWriteRelationPO = new FscOrderWriteRelationPO();
        searchFscWriteRelationPO.setFscOrderId(orderRefundPO.getFscOrderId());
        searchFscWriteRelationPO.setOrderIds(orderMaxMap.keySet());
        List<FscOrderWriteRelationPO> writeOffList = this.fscOrderWriteRelationMapper.getPaidList(searchFscWriteRelationPO);
        if (!CollectionUtils.isEmpty(payPaidList)) {
            for (FscClaimDetailPO fscClaimDetailPO : payPaidList) {
                if (orderIdPayAmountMap.containsKey(fscClaimDetailPO.getOrderId())) {
                    orderIdPayAmountMap.put(fscClaimDetailPO.getOrderId(), orderIdPayAmountMap.get(fscClaimDetailPO.getOrderId()).add(fscClaimDetailPO.getClaimAmt()));
                    continue;
                }
                orderIdPayAmountMap.put(fscClaimDetailPO.getOrderId(), fscClaimDetailPO.getClaimAmt());
            }
        }
        if (!CollectionUtils.isEmpty(writeOffList)) {
            for (FscOrderWriteRelationPO fscOrderWriteRelationPO : writeOffList) {
                if (orderIdPayAmountMap.containsKey(fscOrderWriteRelationPO.getOrderId())) {
                    orderIdPayAmountMap.put(fscOrderWriteRelationPO.getOrderId(), orderIdPayAmountMap.get(fscOrderWriteRelationPO.getOrderId()).add(fscOrderWriteRelationPO.getWriteOffAmount()));
                    continue;
                }
                orderIdPayAmountMap.put(fscOrderWriteRelationPO.getOrderId(), fscOrderWriteRelationPO.getWriteOffAmount());
            }
        }
    }

    private void getOrderAmtMap(FscOrderRefundPO orderRefundPO, Map<Long, BigDecimal> orderAmtMap, Map<Long, String> orderCodeMap) {
        FscOrderItemPO fscOrderItemPo = new FscOrderItemPO();
        fscOrderItemPo.setFscOrderId(orderRefundPO.getFscOrderId());
        List<FscOrderItemPO> fscOrderItemPOS = this.fscOrderItemMapper.getList(fscOrderItemPo);
        for (FscOrderItemPO fscOrderItemPO : fscOrderItemPOS) {
            if (orderAmtMap.containsKey(fscOrderItemPO.getOrderId())) {
                orderAmtMap.put(fscOrderItemPO.getOrderId(), orderAmtMap.get(fscOrderItemPO.getOrderId()).add(fscOrderItemPO.getAmt()));
                continue;
            }
            orderCodeMap.put(fscOrderItemPO.getOrderId(), fscOrderItemPO.getOrderCode());
            orderAmtMap.put(fscOrderItemPO.getOrderId(), fscOrderItemPO.getAmt());
        }
    }

    private void dealShouldRefundUpdate(List<FscOrderPayDetailPO> updateRefundAmtPoList, List<FscOrderPayItemPO> updatePayItemList, List<FscShouldPayPO> fscShouldPayPOList, List<FscPurOrderRefundAmtPO> insertRefundAmtPOS) {
        int count;
        log.debug("++++updateRefundAmtPoList:{}", (Object)JSON.toJSONString(updateRefundAmtPoList));
        if (!CollectionUtils.isEmpty(updateRefundAmtPoList) && (count = this.fscOrderPayDetailMapper.updateRefundAmtBatchAdd(updateRefundAmtPoList)) != updateRefundAmtPoList.size()) {
            throw new FscBusinessException("198888", "\u521b\u5efa\u5e94\u9000\u6570\u636e\u5931\u8d25,\u66f4\u65b0\u652f\u4ed8\u660e\u7ec6\u6570\u636e\u5931\u8d25\uff01");
        }
        log.debug("++++updatePayItemList:{}", (Object)JSON.toJSONString(updatePayItemList));
        if (!CollectionUtils.isEmpty(updatePayItemList) && (count = this.fscOrderPayItemMapper.updateRefundAmtBatch(updatePayItemList)) != updatePayItemList.size()) {
            throw new FscBusinessException("198888", "\u521b\u5efa\u5e94\u9000\u6570\u636e\u5931\u8d25,\u66f4\u65b0\u5e94\u4ed8\u5173\u8054\u6570\u636e\u5931\u8d25\uff01");
        }
        log.debug("++++fscShouldPayPOList:{}", (Object)JSON.toJSONString(fscShouldPayPOList));
        if (!CollectionUtils.isEmpty(fscShouldPayPOList) && (count = this.fscShouldPayMapper.updateRefundAmtBatch(fscShouldPayPOList)) != fscShouldPayPOList.size()) {
            throw new FscBusinessException("198888", "\u521b\u5efa\u5e94\u9000\u6570\u636e\u5931\u8d25,\u66f4\u65b0\u5e94\u4ed8\u6570\u636e\u5931\u8d25\uff01");
        }
        log.debug("++++insertRefundAmtPOS:{}", (Object)JSON.toJSONString(insertRefundAmtPOS));
        if (!CollectionUtils.isEmpty(insertRefundAmtPOS) && (count = this.fscPurOrderRefundAmtMapper.insertBatch(insertRefundAmtPOS)) != 1) {
            throw new FscBusinessException("198888", "\u521b\u5efa\u8ba2\u5355\u9000\u6b3e\u8bb0\u5f55\u6570\u636e\u5931\u8d25\uff01");
        }
    }

    private void buildShouldPayRefund(List<FscOrderRefundPayRelationPo> relationPoList, FscOrderRefundPO orderRefundPO, FscSettleRefundShouldPayCreateAtomReqBO reqBO, Map<Long, BigDecimal> orderAmtMap, Map<Long, BigDecimal> orderIdPaidAmt) {
        Map<Long, List<FscOrderRefundPayRelationPo>> orderPayMap = relationPoList.stream().collect(Collectors.groupingBy(FscOrderRefundPayRelationPo::getFscOrderPayId));
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(new ArrayList<Long>(orderPayMap.keySet()));
        List<FscOrderPO> fscOrderPOList = this.fscOrderMapper.getList(fscOrderPO);
        Map fscOrderPOMap = fscOrderPOList.stream().collect(Collectors.toMap(FscOrderPO::getFscOrderId, Function.identity()));
        for (Long key : orderPayMap.keySet()) {
            BigDecimal paidAmt;
            List<FscOrderRefundPayRelationPo> payRefundPayRelationPoList = orderPayMap.get(key);
            Map<Long, List<FscOrderRefundPayRelationPo>> orderIdMap = payRefundPayRelationPoList.stream().collect(Collectors.groupingBy(FscOrderRefundPayRelationPo::getOrderId));
            BigDecimal refundAmt = BigDecimal.ZERO;
            BigDecimal orderAmt = BigDecimal.ZERO;
            FscOrderPO orderPO = (FscOrderPO)fscOrderPOMap.get(key);
            for (Long orderId : orderIdMap.keySet()) {
                List<FscOrderRefundPayRelationPo> orderRefundPayRelationPoList = orderIdMap.get(orderId);
                refundAmt = refundAmt.add(orderRefundPayRelationPoList.stream().map(FscOrderRefundPayRelationPo::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                orderAmt = orderAmtMap.get(key);
            }
            if (orderIdPaidAmt.containsKey(key) && (paidAmt = orderIdPaidAmt.get(key)).compareTo(refundAmt) >= 0) {
                orderPO.setTotalCharge(paidAmt);
            }
            Long orderId = payRefundPayRelationPoList.get(0).getOrderId();
            String orderNo = payRefundPayRelationPoList.get(0).getOrderNo();
            Long shouldPayRefundId = this.createShouldPay(orderRefundPO, reqBO, orderPO, refundAmt, orderAmt, null, null, null);
            for (FscOrderRefundPayRelationPo fscOrderRefundPayRelationPo : payRefundPayRelationPoList) {
                fscOrderRefundPayRelationPo.setRefundShouldPayId(shouldPayRefundId);
                fscOrderRefundPayRelationPo.setFscOrderPayId(orderPO.getFscOrderId());
                fscOrderRefundPayRelationPo.setFscOrderPayNo(orderPO.getOrderNo());
            }
        }
    }

    private void claimBuildShouldPayRefund(List<FscOrderRefundPayRelationPo> relationPoList, FscOrderRefundPO orderRefundPO, FscSettleRefundShouldPayCreateAtomReqBO reqBO, List<FscPurOrderRefundAmtPO> insertRefundAmtPOS, Map<Long, BigDecimal> orderAmtMap, Map<Long, BigDecimal> orderIdPaidAmt) {
        Map<Long, List<FscOrderRefundPayRelationPo>> orderPayMap = relationPoList.stream().collect(Collectors.groupingBy(FscOrderRefundPayRelationPo::getOrderId));
        PebExtMainOrderDetailQueryReqBO pebExtMainOrderDetailQueryReqBO = new PebExtMainOrderDetailQueryReqBO();
        pebExtMainOrderDetailQueryReqBO.setOrderId(relationPoList.get(0).getOrderId());
        PebExtMainOrderDetailQueryRspBO pebExtMainOrderDetailQuery = this.pebExtMainOrderDetailQueryAbilityService.getPebExtMainOrderDetailQuery(pebExtMainOrderDetailQueryReqBO);
        if (!"0000".equals(pebExtMainOrderDetailQuery.getRespCode())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff1a" + pebExtMainOrderDetailQuery.getRespDesc());
        }
        HashMap<Long, Long> orderIdShouldPayMap = new HashMap<Long, Long>();
        for (Long key : orderPayMap.keySet()) {
            BigDecimal paidAmt;
            List<FscOrderRefundPayRelationPo> orderRefundPayRelationPoList = orderPayMap.get(key);
            BigDecimal refundAmt = orderRefundPayRelationPoList.stream().map(FscOrderRefundPayRelationPo::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal payAmt = orderRefundPayRelationPoList.stream().map(FscOrderRefundPayRelationPo::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            FscOrderPO orderPO = new FscOrderPO();
            orderPO.setTotalCharge(payAmt);
            if (orderIdPaidAmt.containsKey(key) && (paidAmt = orderIdPaidAmt.get(key)).compareTo(refundAmt) >= 0) {
                orderPO.setTotalCharge(paidAmt);
            }
            Long orderId = orderRefundPayRelationPoList.get(0).getOrderId();
            String orderNo = orderRefundPayRelationPoList.get(0).getOrderNo();
            orderPO.setPayeeId(this.operationOrgId);
            BigDecimal orderAmt = orderAmtMap.get(key);
            Long shouldPayRefundId = this.createShouldPay(orderRefundPO, reqBO, orderPO, refundAmt, orderAmt, pebExtMainOrderDetailQuery.getOrdAgreementRspBO(), orderId, orderNo);
            for (FscOrderRefundPayRelationPo fscOrderRefundPayRelationPo : orderRefundPayRelationPoList) {
                fscOrderRefundPayRelationPo.setRefundShouldPayId(shouldPayRefundId);
                fscOrderRefundPayRelationPo.setFscOrderPayId(orderPO.getFscOrderId());
                fscOrderRefundPayRelationPo.setFscOrderPayNo(orderPO.getOrderNo());
            }
            orderIdShouldPayMap.put(key, shouldPayRefundId);
        }
        if (!CollectionUtils.isEmpty(insertRefundAmtPOS)) {
            for (FscPurOrderRefundAmtPO insertRefundAmtPO : insertRefundAmtPOS) {
                if (!orderIdShouldPayMap.containsKey(insertRefundAmtPO.getOrderId())) continue;
                insertRefundAmtPO.setRefundShouldPayId((Long)orderIdShouldPayMap.get(insertRefundAmtPO.getOrderId()));
            }
        }
    }

    private void dealCreditDeduct(FscOrderPO fscOrderPO, FscOrderRefundPayRelationPo fscOrderRefundPayRelationPo, FscSettleRefundShouldPayCreateAtomReqBO reqBO) {
        FscCreditDeductAtomReqBO fscCreditDeductAtomReqBO = new FscCreditDeductAtomReqBO();
        FscCreditDeductAtomBO fscCreditDeductAtomBO = new FscCreditDeductAtomBO();
        fscCreditDeductAtomBO.setAmount(fscOrderRefundPayRelationPo.getRefundAmount().negate());
        fscCreditDeductAtomBO.setOrderNo(fscOrderRefundPayRelationPo.getOrderNo());
        fscCreditDeductAtomBO.setOrderType(FscConstants.CreditOrderType.ORDER);
        fscCreditDeductAtomBO.setObjId(fscOrderRefundPayRelationPo.getOrderId());
        ArrayList<FscCreditDeductAtomBO> fscCreditDeductAtomBOList = new ArrayList<FscCreditDeductAtomBO>();
        fscCreditDeductAtomBOList.add(fscCreditDeductAtomBO);
        fscCreditDeductAtomReqBO.setCreditOrgId(fscOrderPO.getPurchaserId());
        fscCreditDeductAtomReqBO.setSupId(fscOrderPO.getSupplierId());
        if (fscOrderPO.getOrderSource().toString().equals("1")) {
            fscCreditDeductAtomReqBO.setPayBusiness("2");
        } else if (fscOrderPO.getOrderSource().toString().equals("2")) {
            fscCreditDeductAtomReqBO.setPayBusiness("1");
        } else if (fscOrderPO.getOrderSource().toString().equals("3")) {
            fscCreditDeductAtomReqBO.setPayBusiness("3");
        }
        fscCreditDeductAtomReqBO.setCreditOrgCode(fscOrderPO.getBuynerNo());
        if (!StringUtils.isEmpty((Object)fscCreditDeductAtomReqBO.getCreditOrgCode())) {
            UmcEnterpriseOrgQryDetailAbilityReqBO abilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
            abilityReqBO.setOrgCode(fscCreditDeductAtomReqBO.getCreditOrgCode());
            UmcEnterpriseOrgQryDetailAbilityRspBO abilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(abilityReqBO);
            if (!abilityRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(abilityRspBO.getRespCode(), "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5931\u8d25\uff01" + abilityRspBO.getRespDesc());
            }
            if (abilityRspBO.getUmcEnterpriseOrgDetailBO() == null) {
                throw new FscBusinessException("198888", "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            fscCreditDeductAtomReqBO.setCreditOrgId(abilityRspBO.getUmcEnterpriseOrgDetailBO().getOrgId());
        }
        fscCreditDeductAtomReqBO.setFscCreditDeductAtomBOS(fscCreditDeductAtomBOList);
        fscCreditDeductAtomReqBO.setName(reqBO.getName());
        fscCreditDeductAtomReqBO.setUserId(reqBO.getUserId());
        fscCreditDeductAtomReqBO.setOrderType(fscOrderPO.getOrderType());
        fscCreditDeductAtomReqBO.setTradeMode(fscOrderPO.getTradeMode());
        fscCreditDeductAtomReqBO.setBusiCategory(FscConstants.FscBusiCategory.ORDER_REFUND_RETURN);
        log.info("\u9000\u7968\u9000\u6b3e\u8fd4\u8fd8\u6388\u4fe1\u5165\u53c2:" + JSONObject.toJSONString((Object)((Object)fscCreditDeductAtomReqBO)));
        FscCreditDeductAtomRspBO atomRspBO = this.fscCreditDeductAtomService.dealAccountDeduct(fscCreditDeductAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException("193113", atomRspBO.getRespDesc());
        }
    }

    private Long createShouldPay(FscOrderRefundPO orderRefundPO, FscSettleRefundShouldPayCreateAtomReqBO reqBO, FscOrderPO fscOrderPO, BigDecimal refundAmt, BigDecimal orderAmt, PebOrdAgreementRspBO agreementRspBO, Long orderId, String orderNo) {
        String refundBillDate = this.fscInvoiceMapper.getRefundBillDate(orderRefundPO.getRefundId());
        FscPayShouldPayRefundCreateAtomReqBO atomReqBO = new FscPayShouldPayRefundCreateAtomReqBO();
        ArrayList<FscPayShouldRefundBO> fscPayShouldRefundBOS = new ArrayList<FscPayShouldRefundBO>();
        FscPayShouldRefundBO fscPayShouldRefundBO = new FscPayShouldRefundBO();
        fscPayShouldRefundBO.setRefundShouldPayNo(orderRefundPO.getFscOrderNo());
        fscPayShouldRefundBO.setPayerId(orderRefundPO.getPayerId());
        fscPayShouldRefundBO.setPayerName(orderRefundPO.getPayerName());
        fscPayShouldRefundBO.setPayeeId(orderRefundPO.getPayeeId());
        fscPayShouldRefundBO.setPayeeName(orderRefundPO.getPayeeName());
        fscPayShouldRefundBO.setRefundNo(orderRefundPO.getRefundNo());
        fscPayShouldRefundBO.setRefundId(orderRefundPO.getRefundId());
        fscPayShouldRefundBO.setSupplierName(orderRefundPO.getSupplierName());
        fscPayShouldRefundBO.setSupplierId(orderRefundPO.getSupplierId());
        fscPayShouldRefundBO.setOrderSource(orderRefundPO.getOrderSource());
        fscPayShouldRefundBO.setOrderType(orderRefundPO.getOrderType());
        fscPayShouldRefundBO.setRefundType(FscConstants.RefundType.REFUND_INVOICE);
        fscPayShouldRefundBO.setGenerateType(FscConstants.FscRefundGenerateType.AUTO);
        fscPayShouldRefundBO.setTotalPaidAmount(fscOrderPO.getTotalCharge());
        fscPayShouldRefundBO.setRefundAmount(refundAmt);
        fscPayShouldRefundBO.setBillDate(refundBillDate);
        fscPayShouldRefundBO.setRefundShouldPayById(orderRefundPO.getFscOrderId());
        fscPayShouldRefundBO.setFscOrderId(orderRefundPO.getFscOrderId());
        fscPayShouldRefundBO.setFscOrderNo(orderRefundPO.getFscOrderNo());
        fscPayShouldRefundBO.setBuynerNo(orderRefundPO.getBuynerNo());
        fscPayShouldRefundBO.setBuynerName(orderRefundPO.getBuynerName());
        fscPayShouldRefundBO.setOperatorId(orderRefundPO.getOperatorId());
        fscPayShouldRefundBO.setOperatorName(orderRefundPO.getOperatorName());
        fscPayShouldRefundBO.setOperatorDeptId(orderRefundPO.getOperationId());
        fscPayShouldRefundBO.setOperatorDeptName(orderRefundPO.getOperationName());
        fscPayShouldRefundBO.setCreateUserId(reqBO.getUserId());
        fscPayShouldRefundBO.setCreateUserName(reqBO.getUserName());
        fscPayShouldRefundBO.setCreateTime(new Date());
        fscPayShouldRefundBO.setCreateOrgId(reqBO.getOrgId());
        fscPayShouldRefundBO.setCreateOrgName(reqBO.getOrgName());
        fscPayShouldRefundBO.setRefundPayStatus(FscConstants.RefundPayStatus.DRAFT);
        fscPayShouldRefundBO.setPayOrderId(fscOrderPO.getFscOrderId());
        fscPayShouldRefundBO.setPayOrderNo(fscOrderPO.getOrderNo());
        fscPayShouldRefundBO.setPayingAmount(BigDecimal.ZERO);
        fscPayShouldRefundBO.setPaidAmount(BigDecimal.ZERO);
        fscPayShouldRefundBO.setOrderAmount(orderAmt);
        if (agreementRspBO != null && !StringUtils.isEmpty((Object)agreementRspBO.getAgreementId())) {
            fscPayShouldRefundBO.setContractId(Long.valueOf(agreementRspBO.getAgreementId()));
            fscPayShouldRefundBO.setContractNo(agreementRspBO.getEntAgreementCode());
        }
        if (this.operationOrgId.equals(fscOrderPO.getPayeeId())) {
            fscPayShouldRefundBO.setUserType(FscConstants.RefundUserType.PURCHASE);
        } else {
            fscPayShouldRefundBO.setUserType(FscConstants.RefundUserType.OPERATION);
        }
        fscPayShouldRefundBO.setTradeMode(orderRefundPO.getTradeMode());
        fscPayShouldRefundBO.setOrderCode(orderNo);
        fscPayShouldRefundBO.setOrderId(orderId);
        fscPayShouldRefundBOS.add(fscPayShouldRefundBO);
        atomReqBO.setFscPayShouldRefundBOS(fscPayShouldRefundBOS);
        FscPayShouldPayRefundCreateAtomRspBO atomRspBO = this.fscPayShouldPayRefundCreateAtomService.dealShouldPayRefundCreate(atomReqBO);
        if (!atomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("190000", "\u9000\u7968\u5355\u521b\u5efa\u9000\u6b3e\u5e94\u4ed8\u5931\u8d25\uff1a" + atomRspBO.getRespDesc());
        }
        return atomRspBO.getRefundShouldPayIdList().get(0);
    }

    private FscOrderRefundPayRelationPo buildOrderRefundPayRelation(FscOrderRefundPO orderRefundPO, FscOrderPayDetailPO payDetailPO, String orderCode, BigDecimal refundAmt, FscSettleRefundShouldPayCreateAtomReqBO reqBO) {
        FscOrderRefundPayRelationPo fscOrderRefundPayRelationPo = new FscOrderRefundPayRelationPo();
        fscOrderRefundPayRelationPo.setId(Sequence.getInstance().nextId());
        fscOrderRefundPayRelationPo.setFscOrderId(orderRefundPO.getFscOrderId());
        fscOrderRefundPayRelationPo.setFscOrderNo(orderRefundPO.getFscOrderNo());
        fscOrderRefundPayRelationPo.setOrderId(payDetailPO.getOrderId());
        fscOrderRefundPayRelationPo.setOrderNo(orderCode);
        fscOrderRefundPayRelationPo.setPayAmount(payDetailPO.getPayAmount());
        fscOrderRefundPayRelationPo.setRefundAmount(refundAmt);
        fscOrderRefundPayRelationPo.setCreateId(reqBO.getUserId());
        fscOrderRefundPayRelationPo.setCreateName(reqBO.getUserName());
        fscOrderRefundPayRelationPo.setCreateTime(new Date());
        fscOrderRefundPayRelationPo.setPayOrderId(payDetailPO.getFscOrderId());
        fscOrderRefundPayRelationPo.setPayOrderNo(payDetailPO.getFscOrderNo());
        fscOrderRefundPayRelationPo.setFscOrderPayId(payDetailPO.getFscOrderId());
        fscOrderRefundPayRelationPo.setFscOrderPayNo(payDetailPO.getFscOrderNo());
        fscOrderRefundPayRelationPo.setPayingAmount(BigDecimal.ZERO);
        fscOrderRefundPayRelationPo.setRefundedAmount(BigDecimal.ZERO);
        String fscOrderBillDate = this.fscInvoiceMapper.getFscOrderBillDate(orderRefundPO.getFscOrderId());
        fscOrderRefundPayRelationPo.setBillDate(fscOrderBillDate);
        return fscOrderRefundPayRelationPo;
    }
}

