/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.utils;

import com.tydic.fsc.utils.EncryptUtil;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SSLClient
extends DefaultHttpClient {
    private static final Logger log = LoggerFactory.getLogger(SSLClient.class);

    public SSLClient() throws Exception {
        SSLContext ctx = SSLContext.getInstance("TLS");
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        ctx.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory ssf = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        ClientConnectionManager ccm = this.getConnectionManager();
        SchemeRegistry sr = ccm.getSchemeRegistry();
        sr.register(new Scheme("https", 443, (SchemeSocketFactory)ssf));
    }

    public static String doGet(String url) {
        String charset = "utf-8";
        SSLClient httpClient = null;
        HttpGet httpGet = null;
        String result = null;
        try {
            HttpEntity resEntity;
            httpClient = new SSLClient();
            httpGet = new HttpGet(url);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("GET\u8bf7\u6c42\u5f02\u5e38:{}", (Object)ex.getMessage());
        }
        return result;
    }

    public static String doPost(String url) {
        String charset = "utf-8";
        SSLClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        try {
            HttpEntity resEntity;
            httpClient = new SSLClient();
            httpPost = new HttpPost(url);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("POST\u8bf7\u6c42\u5f02\u5e38:{}", (Object)ex.getMessage());
        }
        return result;
    }

    public static String doPost(String url, Map<String, String> map) {
        String charset = "utf-8";
        SSLClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        try {
            HttpEntity resEntity;
            HttpResponse response;
            httpClient = new SSLClient();
            httpPost = new HttpPost(url);
            if (null != map) {
                ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> elem : map.entrySet()) {
                    list.add(new BasicNameValuePair(elem.getKey(), elem.getValue()));
                }
                if (list.size() > 0) {
                    UrlEncodedFormEntity entity = new UrlEncodedFormEntity(list, charset);
                    entity.setContentType("application/x-www-form-urlencoded");
                    httpPost.setHeader("Cookie", "JSESSIONID=" + UUID.randomUUID().toString());
                    httpPost.setHeader("Content-type", "application/x-www-form-urlencoded; charset=utf-8");
                    httpPost.setHeader("stamp", EncryptUtil.getStamp());
                    httpPost.setEntity((HttpEntity)entity);
                }
            }
            if ((response = httpClient.execute((HttpUriRequest)httpPost)) != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("POST\u8bf7\u6c42\u5f02\u5e38:{}", (Object)ex.getMessage());
        }
        return result;
    }

    public static String doPost(String url, Map<String, String> map, Map<String, String> headerMap) {
        String charset = "utf-8";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = null;
        String result = null;
        try {
            HttpEntity resEntity;
            CloseableHttpResponse response;
            httpPost = new HttpPost(url);
            if (null != map) {
                ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> elem : map.entrySet()) {
                    list.add(new BasicNameValuePair(elem.getKey(), elem.getValue()));
                }
                if (list.size() > 0) {
                    UrlEncodedFormEntity entity = new UrlEncodedFormEntity(list, charset);
                    entity.setContentType("application/x-www-form-urlencoded");
                    httpPost.setHeader("Cookie", "JSESSIONID=" + UUID.randomUUID().toString());
                    httpPost.setHeader("Content-type", "application/x-www-form-urlencoded; charset=utf-8");
                    httpPost.setHeader("stamp", EncryptUtil.getStamp());
                    httpPost.setEntity((HttpEntity)entity);
                }
                if (!CollectionUtils.isEmpty(headerMap)) {
                    for (String key : headerMap.keySet()) {
                        httpPost.setHeader(key, headerMap.get(key));
                    }
                }
            }
            if ((response = httpClient.execute((HttpUriRequest)httpPost)) != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("POST\u8bf7\u6c42\u5f02\u5e38:{}", (Object)ex.getMessage());
        }
        return result;
    }

    public static String doPostNew(String url, Map<String, String> map, Map<String, String> headerMap) {
        StringBuilder result = new StringBuilder();
        try {
            URL httpUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)httpUrl.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            connection.setRequestProperty("Cookie", "JSESSIONID=" + UUID.randomUUID().toString());
            connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded; charset=utf-8");
            connection.setRequestProperty("stamp", EncryptUtil.getStamp());
            StringBuilder params = new StringBuilder();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (params.length() > 0) {
                    params.append("&");
                }
                params.append(entry.getKey()).append("=").append(entry.getValue());
            }
            DataOutputStream dataOutputStream = new DataOutputStream(connection.getOutputStream());
            dataOutputStream.writeBytes(params.toString());
            int n = connection.getResponseCode();
            if (n == 200) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    result.append(line);
                }
                reader.close();
            } else {
                result.append("Error: ").append(n);
            }
            dataOutputStream.flush();
            dataOutputStream.close();
            connection.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    public static String doPost(String url, String body) {
        String charset = "utf-8";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = null;
        String result = null;
        StringEntity stringEntity = null;
        try {
            HttpEntity resEntity;
            if (!StringUtils.isEmpty((Object)body)) {
                stringEntity = new StringEntity(body, Charset.forName("UTF-8"));
            }
            httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(20000).setSocketTimeout(20000).setConnectTimeout(20000).build();
            httpPost.setConfig(requestConfig);
            httpPost.setHeader("Content-type", "application/json;charset=UTF-8");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("stamp", com.tydic.uoc.base.utils.EncryptUtil.getStamp());
            httpPost.setEntity((HttpEntity)stringEntity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("HTTP\u8bf7\u6c42\u5f02\u5e38:{}", (Throwable)ex);
        }
        return result;
    }

    public static String doPost(String url, String body, String headKey, String headValue) {
        String charset = "utf-8";
        SSLClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        try {
            HttpEntity resEntity;
            httpClient = new SSLClient();
            httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(body, charset);
            entity.setContentType("application/json");
            httpPost.setHeader("Content-type", "application/json; charset=utf-8");
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)headKey) && !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)headValue)) {
                httpPost.setHeader(headKey, headValue);
            }
            httpPost.setEntity((HttpEntity)entity);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("POST\u8bf7\u6c42\u5f02\u5e38:{}", (Object)ex.getMessage());
        }
        return result;
    }

    public static String doPostWithHeadMap(String url, String body, Map<String, String> headMap) {
        String charset = "utf-8";
        SSLClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        try {
            HttpEntity resEntity;
            httpClient = new SSLClient();
            httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(body, charset);
            entity.setContentType("application/json");
            httpPost.setHeader("Content-type", "application/json; charset=utf-8");
            if (headMap != null) {
                for (String key : headMap.keySet()) {
                    httpPost.setHeader(key, headMap.get(key));
                }
            }
            httpPost.setEntity((HttpEntity)entity);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("POST\u8bf7\u6c42\u5f02\u5e38:{}", (Object)ex.getMessage());
        }
        return result;
    }
}

