/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.fsc.busibase.atom.api.FscRefundCheckPayInfoAtomService;
import com.tydic.fsc.busibase.atom.bo.FscRefundCheckPayInfoAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscRefundCheckPayInfoAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.enums.FscClaimStatusEnum;
import com.tydic.fsc.enums.FscPostingStatusEnum;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscRefundCheckPayInfoAtomServiceImpl
implements FscRefundCheckPayInfoAtomService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Value(value="${OPERATION_SUP_ID:1001693}")
    private String operationSupId;

    @Override
    public FscRefundCheckPayInfoAtomRspBO checkPayInfo(FscRefundCheckPayInfoAtomReqBO reqBO) {
        FscRefundCheckPayInfoAtomRspBO rspBO = new FscRefundCheckPayInfoAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getFscOrderId() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u7ed3\u7b97\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        Integer tradeMode = fscOrderPO.getTradeMode();
        Long supplierId = fscOrderPO.getSupplierId();
        ArrayList<Long> fscOrderIdList = new ArrayList<Long>(1);
        fscOrderIdList.add(reqBO.getFscOrderId());
        List<Long> orderIdList = this.fscOrderRelationMapper.getOrderIdList(fscOrderIdList);
        if (CollectionUtils.isEmpty(orderIdList)) {
            throw new ZTBusinessException("\u7ed3\u7b97\u5355\u6ca1\u6709\u5173\u7cfb\u8ba2\u5355");
        }
        if (FscConstants.FscTradeMode.TRADE_MODEL.equals(tradeMode)) {
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType())) {
                List<String> failClaimNoList = this.checkByClaim(orderIdList, FscConstants.IsSup.ORG);
                rspBO.setFailClaimNoList(failClaimNoList);
            } else {
                List<String> failPayNoList = this.checkByPay(orderIdList, this.operationOrgId);
                rspBO.setFailPayNoList(failPayNoList);
            }
        } else if (this.operationSupId.equals(String.valueOf(supplierId))) {
            List<String> failClaimNoList = this.checkByClaim(orderIdList, FscConstants.IsSup.SUP);
            rspBO.setFailClaimNoList(failClaimNoList);
        } else {
            List<String> failPayNoList = this.checkByPay(orderIdList, null);
            rspBO.setFailPayNoList(failPayNoList);
        }
        return rspBO;
    }

    private List<String> checkByPay(List<Long> orderIdList, Long payerId) {
        ArrayList<String> failPayNoList = new ArrayList<String>();
        HashSet<String> failPayNoSet = new HashSet<String>();
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setOrderIdList(orderIdList);
        orderPO.setPayerId(payerId);
        List<FscOrderPO> fscOrderPOList = this.fscOrderMapper.getAllPayInfo(orderPO);
        if (!CollectionUtils.isEmpty(fscOrderPOList)) {
            for (FscOrderPO po : fscOrderPOList) {
                if (FscConstants.FscPayOrderState.PAY_DISABLE.equals(po.getOrderState()) || FscConstants.RefundInvoiceStatus.SAVE.equals(po.getOrderState()) || FscConstants.FscPayOrderState.DELETE.equals(po.getOrderState()) || FscConstants.FscPayOrderState.PAIED.equals(po.getOrderState())) continue;
                failPayNoSet.add(po.getOrderNo());
            }
        }
        failPayNoList.addAll(failPayNoSet);
        return failPayNoList;
    }

    private List<String> checkByClaim(List<Long> orderIdList, Integer isSup) {
        ArrayList<String> failClaimNoList = new ArrayList<String>();
        FscRecvClaimPO searRecvClaimPO = new FscRecvClaimPO();
        searRecvClaimPO.setOrderIdList(orderIdList);
        searRecvClaimPO.setIsSup(isSup);
        List<FscRecvClaimPO> recvClaimPOS = this.fscRecvClaimMapper.getClaimListByOrderIds(searRecvClaimPO);
        if (!CollectionUtils.isEmpty(recvClaimPOS)) {
            for (FscRecvClaimPO recvClaimPO : recvClaimPOS) {
                if (!FscClaimStatusEnum.CLAIM.getCode().equals(recvClaimPO.getClaimStatus()) && !FscClaimStatusEnum.PRE_CLAIM.getCode().equals(recvClaimPO.getClaimStatus())) {
                    failClaimNoList.add(recvClaimPO.getClaimNo());
                    continue;
                }
                if (FscPostingStatusEnum.EFFECTIVE.getCode().equals(recvClaimPO.getPostingStatus())) continue;
                failClaimNoList.add(recvClaimPO.getClaimNo());
            }
        }
        return failClaimNoList;
    }
}

