/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.external.api.bo.FscNewYcUpdateCashBO;
import com.tydic.fsc.busibase.external.api.bo.FscNewYcUpdateCashReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscNewYcUpdateCashRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleDecryptionRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleEncryPtionReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUnifySettleEncryPtionRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscNewYcUpdateCashService;
import com.tydic.fsc.busibase.external.api.esb.FscUnifySettleRelatedInterfacesAtomService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.SSLClient;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscNewYcUpdateCashServiceImpl
implements FscNewYcUpdateCashService {
    private static final Logger log = LoggerFactory.getLogger(FscNewYcUpdateCashServiceImpl.class);
    @Value(value="${esb.yc.update.cash.url:http://172.16.11.136:30000/eip-zcht/service/updateCash}")
    private String updateCashUrl;
    @Autowired
    private FscUnifySettleRelatedInterfacesAtomService fscUnifySettleRelatedInterfacesAtomService;

    @Override
    public FscNewYcUpdateCashRspBO updateCash(FscNewYcUpdateCashReqBO reqBO) {
        String reqData = this.initParam(reqBO);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Authorization", reqBO.getToken());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("cipherCode", reqData);
        String returnString = SSLClient.doPost(this.updateCashUrl, paramMap, headerMap);
        log.info("\u4e1a\u8d22\u94f6\u884c\u6d41\u6c34\u5360\u7528\u91ca\u653e\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)returnString);
        if (StringUtils.isEmpty((Object)returnString)) {
            throw new FscBusinessException("194317", "\u4e1a\u8d22\u94f6\u884c\u6d41\u6c34\u5360\u7528\u91ca\u653e\u54cd\u5e94\u62a5\u6587\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        FscNewYcUpdateCashRspBO rspBO = this.resolvePreRsp(returnString);
        FscUnifySettleDecryptionReqBO decryptionReqBO = new FscUnifySettleDecryptionReqBO();
        decryptionReqBO.setData("200".equals(rspBO.getCode()) ? rspBO.getData() : rspBO.getMsg());
        FscUnifySettleDecryptionRspBO decryptionRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealParamDecryption(decryptionReqBO);
        if (!decryptionRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u65b0\u4e1a\u8d22\u89e3\u5bc6\u63a5\u53e3\u5931\u8d25\uff1a" + decryptionRspBO.getRespDesc());
        }
        rspBO.setRespParseData("0000".equals(rspBO.getCode()) ? rspBO.getData() : rspBO.getMsg());
        rspBO.setRspData(decryptionRspBO.getData());
        return rspBO;
    }

    private String initParam(FscNewYcUpdateCashReqBO reqBO) {
        JSONArray jsonArray = new JSONArray();
        for (FscNewYcUpdateCashBO bo : reqBO.getBos()) {
            JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)bo));
            jsonArray.add((Object)jsonObject);
        }
        log.debug("\u4e1a\u8d22\u94f6\u884c\u6d41\u6c34\u5360\u7528\u91ca\u653e\u8bf7\u6c42\u62a5\u6587\uff1a{}, \u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)jsonArray.toJSONString(), (Object)this.updateCashUrl);
        FscUnifySettleEncryPtionReqBO encryptionReqBO = new FscUnifySettleEncryPtionReqBO();
        encryptionReqBO.setData(jsonArray.toJSONString());
        FscUnifySettleEncryPtionRspBO encryptionRspBO = this.fscUnifySettleRelatedInterfacesAtomService.dealArrayEncryption(encryptionReqBO);
        if (!encryptionRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u65b0\u4e1a\u8d22\u52a0\u5bc6\u63a5\u53e3\u5931\u8d25\uff1a" + encryptionRspBO.getRespDesc());
        }
        return encryptionRspBO.getData();
    }

    private FscNewYcUpdateCashRspBO resolvePreRsp(String respStr) {
        FscNewYcUpdateCashRspBO rspBO = new FscNewYcUpdateCashRspBO();
        try {
            rspBO = (FscNewYcUpdateCashRspBO)((Object)JSONObject.parseObject((String)respStr, FscNewYcUpdateCashRspBO.class));
            if (rspBO.getCode().equals("200")) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            } else {
                rspBO.setRespCode("190000");
                rspBO.setRespDesc("\u8c03\u7528\u65b0\u4e1a\u8d22\u52a0\u5bc6\u63a5\u53e3\u5931\u8d25:" + respStr);
            }
        }
        catch (Exception e) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u89e3\u6790\u8c03\u7528\u65b0\u4e1a\u8d22\u52a0\u5bc6\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u5931\u8d25:" + respStr);
            log.error("\u89e3\u6790\u8c03\u7528\u65b0\u4e1a\u8d22\u52a0\u5bc6\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u5931\u8d25\uff01");
            e.printStackTrace();
        }
        rspBO.setRspData(respStr);
        return rspBO;
    }
}

