/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.external.impl.esb.tjz;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.external.api.bo.tjz.FscTjzSyncBillStatusReqBO;
import com.tydic.fsc.busibase.external.api.bo.tjz.FscTjzSyncBillStatusRspBO;
import com.tydic.fsc.busibase.external.api.esb.tjz.FscTjzSyncBillStatusService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.SSLClient;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscTjzSyncBillStatusServiceImpl
implements FscTjzSyncBillStatusService {
    private static final Logger log = LoggerFactory.getLogger(FscTjzSyncBillStatusServiceImpl.class);
    @Value(value="${tjz.sync.bill.status.url:http://12314234/111}")
    private String billStatusUrl;
    @Value(value="${tjz_client_secret:UG93ZXJNSldZSg==}")
    private String clientSecret;
    @Value(value="${tjz_client_id:puhua}")
    private String clientId;

    @Override
    public FscTjzSyncBillStatusRspBO syncBillStatusToTjz(FscTjzSyncBillStatusReqBO reqBO) {
        log.debug("\u8c03\u7528\u540c\u6b65\u8fc7\u8d26\u72b6\u6001\u5230\u6295\u5efa\u8f6c\u5165\u53c2:{}", (Object)reqBO.getReqData());
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("client_secret", this.clientSecret);
        headerMap.put("client_id", this.clientId);
        log.info("\u8bf7\u6c42\u8def\u5f84\uff1a" + this.billStatusUrl);
        String respStr = SSLClient.doPostWithHeadMap(this.billStatusUrl, reqBO.getReqData(), headerMap);
        if (StringUtils.isEmpty((CharSequence)respStr)) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u540c\u6b65\u8fc7\u8d26\u72b6\u6001\u5230\u6295\u5efa\u8f6c\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        log.debug("\u8c03\u7528\u540c\u6b65\u8fc7\u8d26\u72b6\u6001\u5230\u6295\u5efa\u8f6c\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587:{}", (Object)respStr);
        FscTjzSyncBillStatusRspBO rspBO = new FscTjzSyncBillStatusRspBO();
        rspBO.setRespStr(respStr);
        try {
            JSONObject respObj = JSONObject.parseObject((String)respStr);
            if (StringUtils.isEmpty((CharSequence)respObj.getString("code"))) {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u8c03\u7528\u540c\u6b65\u8fc7\u8d26\u72b6\u6001\u5230\u6295\u5efa\u8f6c\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u72b6\u6001\u7801code\u4e3a\u7a7a\uff01");
                return rspBO;
            }
            if (!"0".equals(respObj.getString("code"))) {
                String msg = respObj.getString("msg");
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u8c03\u7528\u540c\u6b65\u8fc7\u8d26\u72b6\u6001\u5230\u6295\u5efa\u8f6c\u63a5\u53e3\u8fd4\u56de\u5904\u7406\u5931\u8d25\u4fe1\u606f\uff1a" + msg);
                return rspBO;
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc(respObj.getString("msg"));
            return rspBO;
        }
        catch (Exception e) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc("\u89e3\u6790\u540c\u6b65\u8fc7\u8d26\u72b6\u6001\u5230\u6295\u5efa\u8f6c\u63a5\u53e3\u4e0b\u53d1\u54cd\u5e94\u62a5\u6587\u5931\u8d25" + respStr);
            return rspBO;
        }
    }
}

