/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.finance.FscFinanceSettleRefundShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSettleRefundShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSettleRefundShouldPayCreateAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscRefundReasonEnum;
import com.tydic.fsc.dao.FscFinanceWriteOffMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundPayRelationMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscPayShouldRefundMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscPayTypeEnum;
import com.tydic.fsc.enums.FscRefundShouldPayFlowEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinanceWriteOffPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRefundPayRelationPo;
import com.tydic.fsc.po.FscPayShouldRefundPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscFinanceSettleRefundShouldPayCreateAtomServiceImpl
implements FscFinanceSettleRefundShouldPayCreateAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceSettleRefundShouldPayCreateAtomServiceImpl.class);
    @Resource
    private FscOrderMapper fscOrderMapper;
    @Resource
    private FscOrderItemMapper fscOrderItemMapper;
    @Resource
    private FscShouldPayMapper fscShouldPayMapper;
    @Resource
    private FscOrderRefundPayRelationMapper fscOrderRefundPayRelationMapper;
    @Resource
    private FscPayShouldRefundMapper fscPayShouldRefundMapper;
    @Resource
    private FscInvoiceMapper fscInvoiceMapper;
    @Resource
    private FscFinanceWriteOffMapper fscFinanceWriteOffMapper;
    @Resource
    private FscOrderRelationMapper fscOrderRelationMapper;

    @Override
    public FscSettleRefundShouldPayCreateAtomRspBO createFinanceSettleRefundShouldPay(FscSettleRefundShouldPayCreateAtomReqBO reqBO) {
        FscSettleRefundShouldPayCreateAtomRspBO rspBO = new FscSettleRefundShouldPayCreateAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscOrderRefundPO orderRefundPO = reqBO.getOrderRefundPO();
        if (Objects.isNull(orderRefundPO)) {
            throw new FscBusinessException("190000", "\u751f\u6210\u9000\u6b3e\u5e94\u4ed8\u65f6\u5165\u53c2\u9000\u6b3e\u5355\u4fe1\u606f\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (Objects.nonNull(orderRefundPO.getRefundReasonType()) && FscRefundReasonEnum.INVOICE_ERROR.getCode().equals(orderRefundPO.getRefundReasonType().toString())) {
            log.info("\u53d1\u7968\u95ee\u9898(\u6362\u7968)\u4e0d\u751f\u6210\u9000\u7968\u5e94\u4ed8\uff01");
            return rspBO;
        }
        FscPayShouldRefundPO shouldRefundPO = new FscPayShouldRefundPO();
        shouldRefundPO.setRefundId(orderRefundPO.getRefundId());
        List<FscOrderRefundPayRelationPo> refundPayRelationPoList = this.fscPayShouldRefundMapper.getList(shouldRefundPO);
        if (!CollectionUtils.isEmpty(refundPayRelationPoList)) {
            log.info("\u5f53\u524d\u9000\u7968\u5355\u636e\u5df2\u751f\u6210\u9000\u6b3e\u5e94\u4ed8\uff0c\u4e0d\u5728\u751f\u6210\u65b0\u7684\u9000\u6b3e\u5e94\u4ed8, \u9000\u7968\u5355ID:" + orderRefundPO.getRefundId());
            return rspBO;
        }
        FscOrderItemPO refundItemPO = new FscOrderItemPO();
        refundItemPO.setRefundId(orderRefundPO.getRefundId());
        List<FscOrderItemPO> refundItemList = this.fscOrderItemMapper.getRefundList(refundItemPO);
        if (CollectionUtils.isEmpty(refundItemList)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u9000\u7968\u660e\u7ec6\u6570\u636e\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u8bd5\uff01");
        }
        List<Long> detailIds = refundItemList.stream().map(FscOrderItemPO::getOrderId).distinct().collect(Collectors.toList());
        HashMap<Long, FscShouldPayPO> payMap = new HashMap<Long, FscShouldPayPO>();
        this.handleShouldPay(orderRefundPO, detailIds, payMap);
        Map<Long, List<FscFinanceWriteOffPO>> writeOffMap = this.handelPreWriteOff(orderRefundPO, detailIds, payMap);
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(orderRefundPO.getFscOrderId());
        fscOrderItemPO.setOrderIds(detailIds);
        List<FscOrderItemPO> fscOrderItemPOList = this.fscOrderItemMapper.getFinanceList(fscOrderItemPO);
        if (CollectionUtils.isEmpty(fscOrderItemPOList)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u539f\u7ed3\u7b97\u660e\u7ec6\u6570\u636e\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u8bd5\uff01");
        }
        Map fscOrderItemPOMap = fscOrderItemPOList.stream().collect(Collectors.toMap(FscOrderItemPO::getOrderId, Function.identity(), (k1, k2) -> k1));
        String fscOrderBillDate = this.fscInvoiceMapper.getFscOrderBillDate(orderRefundPO.getFscOrderId());
        String refundBillDate = this.fscInvoiceMapper.getRefundBillDate(orderRefundPO.getRefundId());
        ArrayList<FscPayShouldRefundPO> fscPayShouldRefundPOList = new ArrayList<FscPayShouldRefundPO>();
        ArrayList<FscOrderRefundPayRelationPo> fscOrderRefundPayRelationPoList = new ArrayList<FscOrderRefundPayRelationPo>();
        ArrayList<FscShouldPayPO> updateShouldPayList = new ArrayList<FscShouldPayPO>();
        ArrayList<FscFinanceWriteOffPO> updateWriteOffPOList = new ArrayList<FscFinanceWriteOffPO>();
        FscOrderItemPO actualRefundItemPO = new FscOrderItemPO();
        actualRefundItemPO.setFscOrderId(orderRefundPO.getFscOrderId());
        List<FscOrderItemPO> actualRefundAmtList = this.fscOrderItemMapper.getActualRefundAmt(actualRefundItemPO);
        Map<Object, Object> actualRefundAmtMap = !CollectionUtils.isEmpty(actualRefundAmtList) ? actualRefundAmtList.stream().collect(Collectors.toMap(FscOrderItemPO::getOrderId, FscOrderItemPO::getAmt, (k1, k2) -> k1)) : new HashMap();
        refundItemList.forEach(e -> {
            if (CollectionUtils.isEmpty((Map)fscOrderItemPOMap) || CollectionUtils.isEmpty((Map)payMap) || !fscOrderItemPOMap.containsKey(e.getOrderId()) || !payMap.containsKey(e.getOrderId())) {
                return;
            }
            FscOrderItemPO orderItemPO = (FscOrderItemPO)fscOrderItemPOMap.get(e.getOrderId());
            FscShouldPayPO shouldPayPO = (FscShouldPayPO)payMap.get(e.getOrderId());
            if (!CollectionUtils.isEmpty((Map)actualRefundAmtMap) && actualRefundAmtMap.containsKey(e.getOrderId())) {
                orderItemPO.setRefundAmt((BigDecimal)actualRefundAmtMap.get(e.getOrderId()));
            }
            if (orderItemPO.getAmt().subtract(orderItemPO.getRefundAmt()).compareTo(shouldPayPO.getPaidAmount().subtract(shouldPayPO.getRefundAmt())) >= 0) {
                return;
            }
            BigDecimal shouldRefundPayAmount = shouldPayPO.getPaidAmount().subtract(shouldPayPO.getRefundAmt()).subtract(orderItemPO.getAmt().subtract(orderItemPO.getRefundAmt()));
            BigDecimal refundAmt = shouldRefundPayAmount.compareTo(e.getAmt()) >= 0 ? e.getAmt() : shouldRefundPayAmount;
            FscPayShouldRefundPO fscPayShouldRefundPO = this.createShouldPay(orderRefundPO, reqBO, refundAmt, refundBillDate, shouldPayPO);
            FscOrderRefundPayRelationPo fscOrderRefundPayRelationPo = this.buildOrderRefundPayRelation(orderRefundPO, refundAmt, reqBO, fscPayShouldRefundPO, shouldPayPO, fscOrderBillDate);
            fscOrderRefundPayRelationPoList.add(fscOrderRefundPayRelationPo);
            fscPayShouldRefundPOList.add(fscPayShouldRefundPO);
            FscShouldPayPO updatePO = new FscShouldPayPO();
            updatePO.setShouldPayId(shouldPayPO.getShouldPayId());
            updatePO.setRefundAmt(refundAmt);
            updateShouldPayList.add(updatePO);
            if (!CollectionUtils.isEmpty((Map)writeOffMap) && writeOffMap.containsKey(e.getOrderId())) {
                List financeWriteOffPOList = (List)writeOffMap.get(e.getOrderId());
                BigDecimal[] writeAmount = new BigDecimal[]{refundAmt};
                financeWriteOffPOList.forEach(item -> {
                    if (item.getWriteOffAmt().compareTo(BigDecimal.ZERO) == 0 || writeAmount[0].compareTo(BigDecimal.ZERO) == 0) {
                        return;
                    }
                    FscFinanceWriteOffPO updateWriteOffPO = new FscFinanceWriteOffPO();
                    updateWriteOffPO.setWriteOffId(item.getWriteOffId());
                    if (item.getWriteOffAmt().compareTo(writeAmount[0]) >= 0) {
                        updateWriteOffPO.setRefundAmt(writeAmount[0]);
                        writeAmount[0] = BigDecimal.ZERO;
                    } else {
                        updateWriteOffPO.setRefundAmt(item.getWriteOffAmt());
                        writeAmount[0] = writeAmount[0].subtract(item.getWriteOffAmt());
                    }
                    updateWriteOffPOList.add(updateWriteOffPO);
                });
            }
        });
        if (!CollectionUtils.isEmpty(fscOrderRefundPayRelationPoList)) {
            this.fscOrderRefundPayRelationMapper.insertBatch(fscOrderRefundPayRelationPoList);
        }
        if (!CollectionUtils.isEmpty(fscPayShouldRefundPOList)) {
            this.fscPayShouldRefundMapper.insertBatch(fscPayShouldRefundPOList);
        }
        if (!CollectionUtils.isEmpty(updateShouldPayList)) {
            this.fscShouldPayMapper.updateRefundAmtBatch(updateShouldPayList);
        }
        if (!CollectionUtils.isEmpty(updateWriteOffPOList)) {
            this.fscFinanceWriteOffMapper.updateRefundAmtBatch(updateWriteOffPOList);
        }
        return rspBO;
    }

    private Map<Long, List<FscFinanceWriteOffPO>> handelPreWriteOff(FscOrderRefundPO orderRefundPO, List<Long> detailIds, Map<Long, FscShouldPayPO> payMap) {
        FscFinanceWriteOffPO fscFinanceWriteOffPO = new FscFinanceWriteOffPO();
        fscFinanceWriteOffPO.setFscOrderId(orderRefundPO.getFscOrderId());
        fscFinanceWriteOffPO.setOrderIds(new HashSet<Long>(detailIds));
        List<FscFinanceWriteOffPO> financeWriteOffPOList = this.fscFinanceWriteOffMapper.getEngineeringRefundList(fscFinanceWriteOffPO);
        if (CollectionUtils.isEmpty(financeWriteOffPOList)) {
            return null;
        }
        List<Long> shouldPayIdList = financeWriteOffPOList.stream().map(FscFinanceWriteOffPO::getShouldPayId).distinct().collect(Collectors.toList());
        FscShouldPayPO preShouldPayPO = new FscShouldPayPO();
        preShouldPayPO.setShouldPayIds(shouldPayIdList);
        List<FscShouldPayPO> preFscShouldPayPOList = this.fscShouldPayMapper.getShouldPayList(preShouldPayPO);
        if (CollectionUtils.isEmpty(preFscShouldPayPOList)) {
            log.error("\u672a\u67e5\u8be2\u5230\u6838\u9500\u5bf9\u5e94\u7684\u9884\u4ed8\u6b3e\u5355\u636e\uff0c \u5355\u636eid\uff1a" + JSON.toJSONString(shouldPayIdList));
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u6838\u9500\u5bf9\u5e94\u7684\u9884\u4ed8\u6b3e\u5355\u636e\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u8bd5\uff01");
        }
        Map<Long, BigDecimal> financeWriteOffPOMap = financeWriteOffPOList.stream().collect(Collectors.groupingBy(FscFinanceWriteOffPO::getOrderId, Collectors.reducing(BigDecimal.ZERO, FscFinanceWriteOffPO::getWriteOffAmt, BigDecimal::add)));
        Map prePayMap = preFscShouldPayPOList.stream().collect(Collectors.toMap(FscShouldPayPO::getObjectId, Function.identity(), (k1, k2) -> k1));
        prePayMap.forEach((key, value) -> {
            if (!CollectionUtils.isEmpty((Map)financeWriteOffPOMap) && financeWriteOffPOMap.containsKey(key)) {
                value.setPaidAmount((BigDecimal)financeWriteOffPOMap.get(key));
            }
        });
        payMap.putAll(prePayMap);
        return financeWriteOffPOList.stream().collect(Collectors.groupingBy(FscFinanceWriteOffPO::getOrderId));
    }

    private void handleShouldPay(FscOrderRefundPO orderRefundPO, List<Long> detailIds, Map<Long, FscShouldPayPO> payMap) {
        FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
        fscShouldPayPO.setObjectId(orderRefundPO.getFscOrderId());
        fscShouldPayPO.setOrderIds(detailIds);
        List<FscShouldPayPO> fscShouldPayPOList = this.fscShouldPayMapper.getShouldPayList(fscShouldPayPO);
        if (CollectionUtils.isEmpty(fscShouldPayPOList)) {
            return;
        }
        Map shouldPayMap = fscShouldPayPOList.stream().collect(Collectors.toMap(FscShouldPayPO::getOrderId, Function.identity(), (k1, k2) -> k1));
        payMap.putAll(shouldPayMap);
    }

    private FscOrderRefundPayRelationPo buildOrderRefundPayRelation(FscOrderRefundPO orderRefundPO, BigDecimal refundAmt, FscSettleRefundShouldPayCreateAtomReqBO reqBO, FscPayShouldRefundPO fscPayShouldRefundPO, FscShouldPayPO shouldPayPO, String fscOrderBillDate) {
        FscOrderRefundPayRelationPo fscOrderRefundPayRelationPo = new FscOrderRefundPayRelationPo();
        fscOrderRefundPayRelationPo.setId(Sequence.getInstance().nextId());
        fscOrderRefundPayRelationPo.setRefundShouldPayId(fscPayShouldRefundPO.getRefundShouldPayId());
        fscOrderRefundPayRelationPo.setFscOrderId(orderRefundPO.getFscOrderId());
        fscOrderRefundPayRelationPo.setFscOrderNo(orderRefundPO.getFscOrderNo());
        fscOrderRefundPayRelationPo.setOrderId(Objects.nonNull(shouldPayPO.getOrderId()) ? shouldPayPO.getOrderId() : shouldPayPO.getObjectId());
        fscOrderRefundPayRelationPo.setOrderNo(null);
        fscOrderRefundPayRelationPo.setPayAmount(shouldPayPO.getPaidAmount());
        fscOrderRefundPayRelationPo.setRefundAmount(refundAmt);
        fscOrderRefundPayRelationPo.setCreateId(reqBO.getUserId());
        fscOrderRefundPayRelationPo.setCreateName(reqBO.getUserName());
        fscOrderRefundPayRelationPo.setCreateTime(new Date());
        fscOrderRefundPayRelationPo.setUpdateId(reqBO.getUserId());
        fscOrderRefundPayRelationPo.setUpdateName(reqBO.getUserName());
        fscOrderRefundPayRelationPo.setUpdateTime(new Date());
        fscOrderRefundPayRelationPo.setPayOrderId(shouldPayPO.getFscOrderId());
        fscOrderRefundPayRelationPo.setPayOrderNo(shouldPayPO.getOrderNo());
        fscOrderRefundPayRelationPo.setPayingAmount(BigDecimal.ZERO);
        fscOrderRefundPayRelationPo.setRefundedAmount(BigDecimal.ZERO);
        if (!StringUtils.isEmpty((Object)fscOrderBillDate)) {
            fscOrderRefundPayRelationPo.setBillDate(fscOrderBillDate);
        }
        return fscOrderRefundPayRelationPo;
    }

    private FscPayShouldRefundPO createShouldPay(FscOrderRefundPO orderRefundPO, FscSettleRefundShouldPayCreateAtomReqBO reqBO, BigDecimal refundAmt, String refundBillDate, FscShouldPayPO shouldPayPO) {
        FscPayShouldRefundPO fscPayShouldRefundBO = new FscPayShouldRefundPO();
        fscPayShouldRefundBO.setRefundShouldPayId(Sequence.getInstance().nextId());
        fscPayShouldRefundBO.setSettlePlatform(orderRefundPO.getSettlePlatform());
        fscPayShouldRefundBO.setRefundShouldPayNo(orderRefundPO.getFscOrderNo());
        fscPayShouldRefundBO.setPayerId(orderRefundPO.getPayerId());
        fscPayShouldRefundBO.setPayerName(orderRefundPO.getPayerName());
        fscPayShouldRefundBO.setPayeeId(orderRefundPO.getPayeeId());
        fscPayShouldRefundBO.setPayeeName(orderRefundPO.getPayeeName());
        fscPayShouldRefundBO.setRefundNo(orderRefundPO.getRefundNo());
        fscPayShouldRefundBO.setRefundId(orderRefundPO.getRefundId());
        fscPayShouldRefundBO.setSupplierName(orderRefundPO.getSupplierName());
        fscPayShouldRefundBO.setSupplierId(orderRefundPO.getSupplierId());
        fscPayShouldRefundBO.setOrderSource(orderRefundPO.getOrderSource());
        fscPayShouldRefundBO.setOrderType(orderRefundPO.getOrderType());
        fscPayShouldRefundBO.setRefundType(orderRefundPO.getRefundReasonType());
        fscPayShouldRefundBO.setGenerateType(FscConstants.FscRefundGenerateType.AUTO);
        fscPayShouldRefundBO.setTotalPaidAmount(shouldPayPO.getPaidAmount());
        fscPayShouldRefundBO.setRefundAmount(refundAmt);
        if (!StringUtils.isEmpty((Object)refundBillDate)) {
            fscPayShouldRefundBO.setBillDate(refundBillDate);
        }
        fscPayShouldRefundBO.setRefundShouldPayById(orderRefundPO.getFscOrderId());
        fscPayShouldRefundBO.setFscOrderId(orderRefundPO.getFscOrderId());
        fscPayShouldRefundBO.setFscOrderNo(orderRefundPO.getFscOrderNo());
        fscPayShouldRefundBO.setBuynerNo(orderRefundPO.getBuynerNo());
        fscPayShouldRefundBO.setBuynerName(orderRefundPO.getBuynerName());
        fscPayShouldRefundBO.setOperatorId(orderRefundPO.getOperatorId());
        fscPayShouldRefundBO.setOperatorName(orderRefundPO.getOperatorName());
        fscPayShouldRefundBO.setOperatorDeptId(orderRefundPO.getOperationId());
        fscPayShouldRefundBO.setOperatorDeptName(orderRefundPO.getOperationName());
        fscPayShouldRefundBO.setCreateUserId(reqBO.getUserId());
        fscPayShouldRefundBO.setCreateUserName(reqBO.getUserName());
        fscPayShouldRefundBO.setCreateTime(new Date());
        fscPayShouldRefundBO.setCreateOrgId(reqBO.getOrgId());
        fscPayShouldRefundBO.setCreateOrgName(reqBO.getOrgName());
        fscPayShouldRefundBO.setRefundPayStatus(FscConstants.RefundPayStatus.DRAFT);
        fscPayShouldRefundBO.setPayOrderId(shouldPayPO.getFscOrderId());
        fscPayShouldRefundBO.setPayOrderNo(shouldPayPO.getOrderNo());
        fscPayShouldRefundBO.setPayingAmount(BigDecimal.ZERO);
        fscPayShouldRefundBO.setPaidAmount(BigDecimal.ZERO);
        fscPayShouldRefundBO.setOrderAmount(null);
        fscPayShouldRefundBO.setRefundMethod(FscPayTypeEnum.SHOULD_PAY.getCode() + "");
        fscPayShouldRefundBO.setUserType(FscConstants.RefundUserType.PURCHASE);
        fscPayShouldRefundBO.setContractId(shouldPayPO.getContractId());
        fscPayShouldRefundBO.setContractNo(shouldPayPO.getContractNo());
        fscPayShouldRefundBO.setUserType(FscConstants.RefundUserType.PURCHASE);
        fscPayShouldRefundBO.setTradeMode(orderRefundPO.getTradeMode());
        fscPayShouldRefundBO.setOrderId(Objects.nonNull(shouldPayPO.getOrderId()) ? shouldPayPO.getOrderId() : shouldPayPO.getObjectId());
        fscPayShouldRefundBO.setExt1(FscRefundShouldPayFlowEnum.ENGINEERING.getCode());
        fscPayShouldRefundBO.setBusinessType(shouldPayPO.getBusinessType());
        fscPayShouldRefundBO.setContractName(shouldPayPO.getContractName());
        fscPayShouldRefundBO.setContractType(Objects.nonNull(shouldPayPO.getContractType()) ? shouldPayPO.getContractType().toString() : null);
        if (!StringUtils.isEmpty((Object)shouldPayPO.getCcProjectCode())) {
            fscPayShouldRefundBO.setCcProjectCode(shouldPayPO.getCcProjectCode());
            fscPayShouldRefundBO.setCcProjectName(shouldPayPO.getCcProjectName());
        }
        return fscPayShouldRefundBO;
    }
}

