/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bo.FscComOrderListBO;
import com.tydic.fsc.bo.FscComRefundListBO;
import com.tydic.fsc.busibase.busi.api.FscEsQryComOrderListByTjzBusiService;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryByTjzBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryByTjzBusiRspBO;
import com.tydic.fsc.busibase.busi.bo.FscComRefundListPageQueryByTjzBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscComRefundListPageQueryByTjzBusiRspBO;
import com.tydic.fsc.busibase.config.FscEsConfig;
import com.tydic.fsc.utils.FscBuildEsQrySqlByTjzConditionUtil;
import com.tydic.fsc.utils.FscElasticsearchUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscEsQryComOrderListByTjzBusiServiceImpl
implements FscEsQryComOrderListByTjzBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscEsQryComOrderListByTjzBusiServiceImpl.class);
    private final FscEsConfig fscEsConfig;
    private final FscElasticsearchUtil fscElasticsearchUtil;
    private final FscBuildEsQrySqlByTjzConditionUtil buildEsQrySqlByTjzConditionUtil;
    private static final String REGEX = "^,*|,*$";

    @Autowired
    public FscEsQryComOrderListByTjzBusiServiceImpl(FscEsConfig fscEsConfig, FscElasticsearchUtil fscElasticsearchUtil) {
        this.fscEsConfig = fscEsConfig;
        this.fscElasticsearchUtil = fscElasticsearchUtil;
        this.buildEsQrySqlByTjzConditionUtil = new FscBuildEsQrySqlByTjzConditionUtil();
    }

    @Override
    public FscComOrderListPageQueryByTjzBusiRspBO esQryComOrderListByTjz(FscComOrderListPageQueryByTjzBusiReqBO reqBO) {
        FscComOrderListPageQueryByTjzBusiRspBO rspBO = new FscComOrderListPageQueryByTjzBusiRspBO();
        String qryString = this.buildEsQrySqlByTjzConditionUtil.buildComOrderEsSqlByTjz(reqBO);
        log.debug("\u6295\u5efa\u8f6cES\u67e5\u8be2\u7ed3\u7b97\u4e3b\u5355\u67e5\u8be2\u6761\u4ef6---->" + qryString);
        String endPoint = "/" + this.fscEsConfig.getOrderIndexName() + "/" + this.fscEsConfig.getOrderIndexType() + "/_search";
        NStringEntity entity = new NStringEntity(qryString, ContentType.APPLICATION_JSON);
        String result = null;
        try {
            Response response = this.fscElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            String ioExceptionStr = JSON.toJSONString((Object)e.getCause());
            if (ioExceptionStr.contains("index_not_found_exception")) {
                boolean index = this.fscElasticsearchUtil.createIndex(this.fscEsConfig.getOrderIndexName());
                if (!index) {
                    log.error("\u81ea\u52a8\u521b\u5efa\u9a8c\u6536\u7d22\u5f15\u5931\u8d25");
                    rspBO.setRespCode("191001");
                    rspBO.setRespDesc("\u81ea\u52a8\u521b\u5efa\u9a8c\u6536\u7d22\u5f15\u5931\u8d25");
                    return rspBO;
                }
                try {
                    Response response = this.fscElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
                    result = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (IOException childE) {
                    log.error("ioException", (Throwable)childE);
                    rspBO.setRespCode("\u5931\u8d25");
                    rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u7ed3\u7b97\u4e3b\u5355\u5931\u8d25!");
                    return rspBO;
                }
            }
            log.error("ioException", (Throwable)e);
            rspBO.setRespCode("\u5931\u8d25");
            rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u7ed3\u7b97\u4e3b\u5355\u5217\u8868\u4fe1\u606f\u9a8c\u6536!");
            return rspBO;
        }
        System.out.println("ES\u67e5\u8be2\u7ed3\u7b97\u4e3b\u5355result---->" + result);
        rspBO = this.resolveReturnData(result, rspBO, reqBO.getPageSize(), reqBO.getPageNo());
        return rspBO;
    }

    @Override
    public FscComRefundListPageQueryByTjzBusiRspBO esQryComRefundListByTjz(FscComRefundListPageQueryByTjzBusiReqBO reqBO) {
        FscComRefundListPageQueryByTjzBusiRspBO rspBO = new FscComRefundListPageQueryByTjzBusiRspBO();
        String qryString = this.buildEsQrySqlByTjzConditionUtil.buildComRefundEsSqlByTjz(reqBO);
        log.debug("ES\u67e5\u8be2\u9000\u7968\u4e3b\u5355\u67e5\u8be2\u6761\u4ef6---->" + qryString);
        String endPoint = "/" + this.fscEsConfig.getRefundIndexName() + "/" + this.fscEsConfig.getRefundIndexType() + "/_search";
        NStringEntity entity = new NStringEntity(qryString, ContentType.APPLICATION_JSON);
        String result = null;
        try {
            Response response = this.fscElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            String ioExceptionStr = JSON.toJSONString((Object)e.getCause());
            if (ioExceptionStr.contains("index_not_found_exception")) {
                boolean index = this.fscElasticsearchUtil.createIndex(this.fscEsConfig.getOrderIndexName());
                if (!index) {
                    log.error("\u81ea\u52a8\u521b\u5efa\u9a8c\u6536\u7d22\u5f15\u5931\u8d25");
                    rspBO.setRespCode("191001");
                    rspBO.setRespDesc("\u81ea\u52a8\u521b\u5efa\u9a8c\u6536\u7d22\u5f15\u5931\u8d25");
                    return rspBO;
                }
                try {
                    Response response = this.fscElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
                    result = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (IOException childE) {
                    log.error("ioException", (Throwable)childE);
                    rspBO.setRespCode("\u5931\u8d25");
                    rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u7ed3\u7b97\u4e3b\u5355\u5931\u8d25!");
                    return rspBO;
                }
            }
            log.error("ioException", (Throwable)e);
            rspBO.setRespCode("\u5931\u8d25");
            rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u7ed3\u7b97\u4e3b\u5355\u5217\u8868\u4fe1\u606f\u9a8c\u6536!");
            return rspBO;
        }
        System.out.println("ES\u67e5\u8be2\u7ed3\u7b97\u4e3b\u5355result---->" + result);
        rspBO = this.resolveRefundReturnData(result, rspBO, reqBO.getPageSize(), reqBO.getPageNo());
        return rspBO;
    }

    private FscComOrderListPageQueryByTjzBusiRspBO resolveReturnData(String result, FscComOrderListPageQueryByTjzBusiRspBO rspBO, Integer pageSize, Integer pageNo) {
        rspBO.setRespCode("0000");
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject == null || listObject.size() < 1) {
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(total);
            rspBO.setRows(new ArrayList());
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u4e3b\u5355\u4fe1\u606f!");
            return rspBO;
        }
        ArrayList<FscComOrderListBO> rows = new ArrayList<FscComOrderListBO>();
        for (int i = 0; i < listObject.size(); ++i) {
            JSONObject hitObj = listObject.getJSONObject(i);
            JSONObject data = (JSONObject)hitObj.get((Object)"_source");
            String objJsonStr = data.getString("objJson");
            JSONObject objJson = JSONObject.parseObject((String)objJsonStr);
            FscComOrderListBO fscComOrderListBO = (FscComOrderListBO)JSON.toJavaObject((JSON)objJson, FscComOrderListBO.class);
            rows.add(fscComOrderListBO);
        }
        Integer totalPageNo = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        rspBO.setTotal(totalPageNo);
        rspBO.setRecordsTotal(total);
        rspBO.setPageNo(pageNo);
        rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u7b97\u5355\u5217\u8868\u4fe1\u606f\u6210\u529f");
        rspBO.setRows(rows);
        return rspBO;
    }

    private FscComRefundListPageQueryByTjzBusiRspBO resolveRefundReturnData(String result, FscComRefundListPageQueryByTjzBusiRspBO rspBO, Integer pageSize, Integer pageNo) {
        rspBO.setRespCode("0000");
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject == null || listObject.size() < 1) {
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(total);
            rspBO.setRows(new ArrayList());
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u4e3b\u5355\u4fe1\u606f!");
            return rspBO;
        }
        ArrayList<FscComRefundListBO> rows = new ArrayList<FscComRefundListBO>();
        for (int i = 0; i < listObject.size(); ++i) {
            JSONObject hitObj = listObject.getJSONObject(i);
            JSONObject data = (JSONObject)hitObj.get((Object)"_source");
            String objJsonStr = data.getString("objJson");
            JSONObject objJson = JSONObject.parseObject((String)objJsonStr);
            FscComRefundListBO fscComRefundListBO = (FscComRefundListBO)JSON.toJavaObject((JSON)objJson, FscComRefundListBO.class);
            rows.add(fscComRefundListBO);
        }
        Integer totalPageNo = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        rspBO.setTotal(totalPageNo);
        rspBO.setRecordsTotal(total);
        rspBO.setPageNo(pageNo);
        rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u7b97\u5355\u5217\u8868\u4fe1\u606f\u6210\u529f");
        rspBO.setRows(rows);
        return rspBO;
    }
}

