/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscComOrderListBO;
import com.tydic.fsc.common.ability.api.FscPayVerificationAbilityService;
import com.tydic.fsc.common.ability.bo.FscPayVerificationAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPayVerificationAbilityRspBO;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscPayVerificationAbilityService"})
public class FscPayVerificationAbilityServiceImpl
implements FscPayVerificationAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @PostMapping(value={"queryPayVerificationPageList"})
    public FscPayVerificationAbilityRspBO queryPayVerificationPageList(@RequestBody FscPayVerificationAbilityReqBO reqBO) {
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u7ed3\u7b97\u5355id[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getPageNo() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2[pageNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getPageSize() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2[pageSize]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscPayVerificationAbilityRspBO rspBO = new FscPayVerificationAbilityRspBO();
        List orderIds = this.fscOrderMapper.selectOrderIds(reqBO.getFscOrderId());
        if (CollectionUtils.isEmpty((Collection)orderIds)) {
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(Integer.valueOf(0));
            rspBO.setTotal(Integer.valueOf(0));
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        FscOrderPO queryVo = new FscOrderPO();
        queryVo.setPayTimeStart(reqBO.getPayTimeStart());
        queryVo.setPayTimeEnd(reqBO.getPayTimeEnd());
        queryVo.setOrderNo(reqBO.getOrderNo());
        queryVo.setPayOperName(reqBO.getPayOperName());
        queryVo.setPayAmountStart(reqBO.getPayAmountStart());
        queryVo.setPayAmountEnd(reqBO.getPayAmountEnd());
        queryVo.setOrderIds(orderIds);
        List orderList = this.fscOrderMapper.selectPrePayVerification(queryVo, page);
        ArrayList<FscComOrderListBO> orderInfoList = new ArrayList<FscComOrderListBO>(orderList.size());
        for (FscOrderPO fscOrderPo : orderList) {
            FscComOrderListBO infoBo = new FscComOrderListBO();
            BeanUtils.copyProperties((Object)fscOrderPo, (Object)infoBo);
            orderInfoList.add(infoBo);
        }
        rspBO.setRows(orderInfoList);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

