/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscComOrderListBO;
import com.tydic.fsc.bo.InvoiceBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.busi.api.FscEsQryComOrderListBusiService;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscComOrderListPageQueryBusiRspBO;
import com.tydic.fsc.common.busi.api.FscComInvoiceListQueryBusiService;
import com.tydic.fsc.common.busi.bo.FscComInvoiceListQueryBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComInvoiceListQueryBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoicePostMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoicePostPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscComInvoiceListQueryBusiServiceImpl
implements FscComInvoiceListQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscComInvoiceListQueryBusiServiceImpl.class);
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscEsQryComOrderListBusiService fscEsQryComOrderListBusiService;
    @Autowired
    private FscInvoicePostMapper fscInvoicePostMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;

    @Override
    public FscComInvoiceListQueryBusiRspBO qryInvoiceList(FscComInvoiceListQueryBusiReqBO reqBO) {
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        String orderBy = "bill_date desc";
        FscInvoicePO fscInvoicePo = new FscInvoicePO();
        fscInvoicePo.setOrderBy(orderBy);
        fscInvoicePo.setFscOrderId(reqBO.getFscOrderId());
        fscInvoicePo.setInvoiceId(reqBO.getInvoiceId());
        fscInvoicePo.setInvoiceIds(reqBO.getInvoiceIds());
        fscInvoicePo.setFscOrderIds(reqBO.getFscOrderIds());
        List fscInvoicePos = this.fscInvoiceMapper.getListPage(fscInvoicePo, page);
        FscComInvoiceListQueryBusiRspBO busiRspBO = new FscComInvoiceListQueryBusiRspBO();
        if (!CollectionUtils.isEmpty((Collection)fscInvoicePos)) {
            ArrayList<InvoiceBO> invoiceBos = new ArrayList<InvoiceBO>();
            Map invoiceTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_TYPE");
            Map invoiceCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_CATEGORY");
            List invoiceIdList = fscInvoicePos.stream().map(FscInvoicePO::getInvoiceId).collect(Collectors.toList());
            FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
            fscAttachmentPo.setObjType(FscConstants.AttachmentType.INVOICE);
            fscAttachmentPo.setObjIds(invoiceIdList);
            List attachmentPoList = this.fscAttachmentMapper.getList(fscAttachmentPo);
            List mailIdList = fscInvoicePos.stream().map(FscInvoicePO::getMailId).collect(Collectors.toList());
            FscInvoicePostPO fscInvoicePostPo = new FscInvoicePostPO();
            fscInvoicePostPo.setIds(mailIdList);
            List invoicePostList = this.fscInvoicePostMapper.getList(fscInvoicePostPo);
            Map<Long, FscInvoicePostPO> invoicePostPoMap = invoicePostList.stream().collect(Collectors.toMap(FscInvoicePostPO::getId, v -> v));
            List fscOrderIdList = fscInvoicePos.stream().map(FscInvoicePO::getFscOrderId).distinct().collect(Collectors.toList());
            FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
            fscOrderRelationPo.setFscOrderIds(fscOrderIdList);
            List fscOrderRelationPoList = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
            FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
            fscOrderInvoicePo.setFscOrderIdList(fscOrderIdList);
            List fscOrderInvoicePoList = this.fscOrderInvoiceMapper.getList(fscOrderInvoicePo);
            Map<Long, FscOrderInvoicePO> fscOrderInvoicePoMap = fscOrderInvoicePoList.stream().collect(Collectors.toMap(FscOrderInvoicePO::getFscOrderId, v -> v));
            FscComOrderListPageQueryBusiReqBO fscComOrderListPageQueryBusiReqBO = new FscComOrderListPageQueryBusiReqBO();
            fscComOrderListPageQueryBusiReqBO.setFscOrderIds(fscOrderIdList);
            fscComOrderListPageQueryBusiReqBO.setPageSize(Integer.valueOf(-1));
            if (log.isDebugEnabled()) {
                log.debug("\u67e5\u8be2es\u4e3b\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscComOrderListPageQueryBusiReqBO));
            }
            FscComOrderListPageQueryBusiRspBO fscComOrderListPageQueryBusiRspBO = this.fscEsQryComOrderListBusiService.esQryComOrderList(fscComOrderListPageQueryBusiReqBO);
            if (log.isDebugEnabled()) {
                log.debug("\u67e5\u8be2es\u4e3b\u5355\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscComOrderListPageQueryBusiRspBO));
            }
            if (!"0000".equals(fscComOrderListPageQueryBusiRspBO.getRespCode())) {
                throw new FscBusinessException("193126", fscComOrderListPageQueryBusiRspBO.getRespDesc());
            }
            List fscComOrderListBos = fscComOrderListPageQueryBusiRspBO.getRows();
            Map<Long, FscComOrderListBO> fscComOrderMap = fscComOrderListBos.stream().collect(Collectors.toMap(FscComOrderListBO::getFscOrderId, f -> f));
            for (FscInvoicePO invoicePo : fscInvoicePos) {
                List invoiceAttachment = attachmentPoList.stream().filter(fscAttachment -> invoicePo.getInvoiceId().equals(fscAttachment.getObjId())).collect(Collectors.toList());
                List orderNoList = fscOrderRelationPoList.stream().filter(fscOrderRelation -> invoicePo.getFscOrderId().equals(fscOrderRelation.getOrderId())).map(FscOrderRelationPO::getOrderNo).collect(Collectors.toList());
                List bos = JSON.parseArray((String)JSON.toJSONString(invoiceAttachment), AttachmentBO.class);
                InvoiceBO invoiceBo = new InvoiceBO();
                BeanUtils.copyProperties((Object)invoicePo, (Object)invoiceBo);
                invoiceBo.setOrderNos(orderNoList);
                invoiceBo.setInvoiceCategoryStr((String)invoiceCategoryMap.get(String.valueOf(invoiceBo.getInvoiceCategory())));
                invoiceBo.setInvoiceTypeStr((String)invoiceTypeMap.get(invoiceBo.getInvoiceType()));
                invoiceBo.setAttachmentList(bos);
                if (!CollectionUtils.isEmpty(fscOrderInvoicePoMap)) {
                    invoiceBo.setBillTime(fscOrderInvoicePoMap.get(invoicePo.getFscOrderId()).getBillTime());
                }
                if (!CollectionUtils.isEmpty(fscComOrderMap)) {
                    invoiceBo.setFscOrderNo(fscComOrderMap.get(invoiceBo.getFscOrderId()).getFscOrderNo());
                    invoiceBo.setSupplierId(fscComOrderMap.get(invoiceBo.getFscOrderId()).getSupplierId());
                    invoiceBo.setPurchaserId(fscComOrderMap.get(invoiceBo.getFscOrderId()).getPurchaserId());
                    invoiceBo.setMakeType(fscComOrderMap.get(invoiceBo.getFscOrderId()).getMakeType());
                    invoiceBo.setReceiveType(fscComOrderMap.get(invoiceBo.getFscOrderId()).getReceiveType());
                    FscComOrderListBO fscComOrderListBO = fscComOrderMap.get(invoiceBo.getFscOrderId());
                    if (null != fscComOrderListBO.getReceiveType()) {
                        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscComOrderListBO.getReceiveType())) {
                            invoiceBo.setReceiveName(fscComOrderListBO.getPurchaserName());
                        }
                        if (FscConstants.FscOrderReceiveType.OPERATION.equals(fscComOrderListBO.getReceiveType())) {
                            invoiceBo.setReceiveName(fscComOrderListBO.getProOrgName());
                        }
                        if (FscConstants.FscOrderReceiveType.SUPPLIER.equals(fscComOrderListBO.getReceiveType())) {
                            invoiceBo.setReceiveName(fscComOrderListBO.getSupplierName());
                        }
                    }
                }
                if (!CollectionUtils.isEmpty(invoicePostPoMap)) {
                    invoiceBo.setSignTime(invoicePostPoMap.get(invoicePo.getMailId()).getSignTime());
                    invoiceBo.setMailDesc(this.assembly(invoicePostPoMap.get(invoicePo.getMailId())));
                    invoiceBo.setSignOperId(invoicePostPoMap.get(invoicePo.getMailId()).getSignOperId());
                    invoiceBo.setSignOperName(invoicePostPoMap.get(invoicePo.getMailId()).getSignOperName());
                }
                invoiceBos.add(invoiceBo);
            }
            busiRspBO.setRows(invoiceBos);
            busiRspBO.setTotal(page.getTotalPages());
            busiRspBO.setRecordsTotal(page.getTotalCount());
            busiRspBO.setPageNo(page.getPageNo());
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }

    private String assembly(FscInvoicePostPO fscInvoicePostPO) {
        if (StringUtils.isNotBlank((CharSequence)fscInvoicePostPO.getSendCompany()) && StringUtils.isNotBlank((CharSequence)fscInvoicePostPO.getSendOrder())) {
            StringBuffer sb = new StringBuffer();
            sb.append("\u5feb\u9012\u516c\u53f8\uff1a").append(fscInvoicePostPO.getSendCompany()).append("\n").append("\u5feb\u9012\u5355\u53f7\uff1a").append(fscInvoicePostPO.getSendOrder());
            return sb.toString();
        }
        return "";
    }
}

