/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscPurchasePaymentBO;
import com.tydic.fsc.busibase.external.api.bo.FscPurchasePaymentLineBO;
import com.tydic.fsc.busibase.external.api.bo.FscPurchasePaymentSettleBO;
import com.tydic.fsc.busibase.external.api.bo.FscPurchasePrePaymentBO;
import com.tydic.fsc.busibase.external.api.bo.FscPurchasePrePaymentLineBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcPayBillReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcPayBillRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcPrePayBillReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcPrePayBillRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscPushYcPayBillService;
import com.tydic.fsc.busibase.external.api.uoc.FscUocInspectionDetailsListPageQueryService;
import com.tydic.fsc.common.busi.api.FscPushYcPayBillBusiService;
import com.tydic.fsc.common.busi.bo.FscPushYcPayBillBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushYcPayBillBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import com.tydic.uoc.common.ability.api.UocPrePayOrderInfoQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocPrePayOrderInfoQueryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocPrePayOrderInfoQueryAbilityRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class FscPushYcPayBillBusiServiceImpl
implements FscPushYcPayBillBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPushYcPayBillBusiServiceImpl.class);
    @Autowired
    private FscPushYcPayBillService fscPushYcPayBillService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Value(value="${OPER_ORG_ID}")
    private String operationOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operationOrgName;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Autowired
    private FscUocInspectionDetailsListPageQueryService fscUocInspectionDetailsListPageQueryService;
    @Autowired
    private UocPrePayOrderInfoQueryAbilityService uocPrePayOrderInfoQueryAbilityService;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    public static final String BUSI_NAME = "\u4ed8\u6b3e\u767b\u8bb0";
    public static final String BUSI_CODE = "1080";
    public static final String BUSI_NAME_MAIN = "\u63a8\u9001\u5931\u8d25";
    public static final String BUSI_CODE_MAIN = "1083";

    @Override
    public FscPushYcPayBillBusiRspBO pushYcPayBill(FscPushYcPayBillBusiReqBO reqBO) {
        FscPushYcPayBillBusiRspBO rspBO = new FscPushYcPayBillBusiRspBO();
        if (reqBO.getOrderId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2[orderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (fscOrder == null) {
            throw new FscBusinessException("190000", "\u4ed8\u6b3e\u5355\u4e0d\u5b58\u5728\uff01");
        }
        rspBO = fscOrder.getShouldPayType().equals(FscConstants.ShouldPayType.ADVANCE_PAY) || fscOrder.getShouldPayType().equals(FscConstants.ShouldPayType.ARRIVAL_SHOULD_PAY) || fscOrder.getShouldPayType().equals(FscConstants.ShouldPayType.ACCEPT_SHOULD_PAY) ? this.dealPrePayBill(fscOrder) : this.dealPayBill(fscOrder);
        return rspBO;
    }

    private FscPushYcPayBillBusiRspBO dealPrePayBill(FscOrderPO fscOrderPo) {
        List list = this.fscShouldPayMapper.getByFscOrderId(fscOrderPo.getFscOrderId());
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5e94\u4ed8\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        UocPrePayOrderInfoQueryAbilityReqBO uocPrePayOrderInfoQueryAbilityReqBO = new UocPrePayOrderInfoQueryAbilityReqBO();
        uocPrePayOrderInfoQueryAbilityReqBO.setOrderId(((FscShouldPayPO)list.get(0)).getOrderId());
        UocPrePayOrderInfoQueryAbilityRspBO uocPrePayOrderInfoQueryAbilityRspBO = this.uocPrePayOrderInfoQueryAbilityService.queryOrderInfo(uocPrePayOrderInfoQueryAbilityReqBO);
        if (!uocPrePayOrderInfoQueryAbilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        UmcEnterpriseOrgQryDetailAbilityReqBO umcEnterpriseOrgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
        umcEnterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(fscOrderPo.getPayeeId());
        UmcEnterpriseOrgQryDetailAbilityRspBO umcEnterpriseOrgQryDetailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(umcEnterpriseOrgQryDetailAbilityReqBO);
        if (!umcEnterpriseOrgQryDetailAbilityRspBO.getRespCode().equals("0000") || ObjectUtils.isEmpty((Object)umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO())) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscPushYcPrePayBillReqBO prePayBillReqBO = new FscPushYcPrePayBillReqBO();
        FscPurchasePrePaymentBO prePaymentBO = new FscPurchasePrePaymentBO();
        prePaymentBO.setORG_ID(this.operationOrgId);
        prePaymentBO.setORG_NAME(this.operationOrgName);
        prePaymentBO.setDEPT_ID(fscOrderPo.getYcDeptId());
        prePaymentBO.setDEPT_NAME(fscOrderPo.getYcDeptName());
        prePaymentBO.setPERSON_ID(fscOrderPo.getYcUserId());
        prePaymentBO.setPERSON_NAME(fscOrderPo.getYcUserName());
        prePaymentBO.setPREPAY_NUMBER(fscOrderPo.getOrderNo());
        prePaymentBO.setPREPAY_NAME("");
        FscDicDictionaryExernalPO eternalPo = new FscDicDictionaryExernalPO();
        eternalPo.setPCode("FSC_PAY_TYPE");
        Map<String, String> dicMap = this.getDicMap(eternalPo);
        prePaymentBO.setPREPAY_TYPE(dicMap.get(uocPrePayOrderInfoQueryAbilityRspBO.getOrderType().toString()));
        prePaymentBO.setCONTRACT_NUMBER(fscOrderPo.getContractNo());
        prePaymentBO.setPREPAY_DATE(DateFormatUtils.format((Date)fscOrderPo.getCreateTime(), (String)"yyyy-MM-dd"));
        prePaymentBO.setCOMMENTS("");
        prePaymentBO.setCONTRACT_NAME("");
        prePaymentBO.setVENDOR_NUMBER(Long.valueOf(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode()));
        prePaymentBO.setVENDOR_NAME(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgName());
        prePaymentBO.setAMOUNT(this.dealAmount(fscOrderPo.getToPayAmount()));
        prePaymentBO.setTESCO_ID(fscOrderPo.getFscOrderId());
        LinkedList<FscPurchasePrePaymentLineBO> paymentLineBoList = new LinkedList<FscPurchasePrePaymentLineBO>();
        FscPurchasePrePaymentLineBO prePaymentLineBO = new FscPurchasePrePaymentLineBO();
        prePaymentLineBO.setVENDOR_NUMBER(Long.valueOf(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode()));
        prePaymentLineBO.setVENDOR_NAME(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgName());
        prePaymentLineBO.setBANK_ACCOUNT_NAME(fscOrderPo.getPayeeAccountName());
        prePaymentLineBO.setBANK_NAME(fscOrderPo.getPayeeBankName());
        prePaymentLineBO.setBANK_ACCOUNT_NUM(Long.valueOf(fscOrderPo.getPayeeBankAccount() == null ? "0" : fscOrderPo.getPayeeBankAccount()));
        prePaymentLineBO.setAMOUNT(this.dealAmount(fscOrderPo.getToPayAmount()));
        prePaymentLineBO.setTESCO_ID(fscOrderPo.getFscOrderId());
        paymentLineBoList.add(prePaymentLineBO);
        prePayBillReqBO.setPurchaseAdPayment(prePaymentBO);
        prePayBillReqBO.setPurchaseAdPaymentLine(paymentLineBoList);
        prePayBillReqBO.setUserId(fscOrderPo.getPayerId());
        FscPushYcPrePayBillRspBO rspBO = this.fscPushYcPayBillService.pushYcPrePayBill(prePayBillReqBO);
        if (!rspBO.getRespCode().equals("0000")) {
            this.saveFailLog(fscOrderPo.getFscOrderId(), rspBO.getRespDesc());
            if (!fscOrderPo.getOrderState().equals(FscConstants.FscPayOrderState.PUSH_FAIL)) {
                FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
                flowAtomReqBO.setOrderId(fscOrderPo.getFscOrderId());
                flowAtomReqBO.setCurStatus(fscOrderPo.getOrderState());
                flowAtomReqBO.setBusiName(BUSI_NAME);
                flowAtomReqBO.setBusiCode(BUSI_CODE);
                HashMap<String, Integer> paramMap = new HashMap<String, Integer>(1);
                paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag5);
                flowAtomReqBO.setParamMap(paramMap);
                FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
                if (!"0000".equals(flowAtomRspBO.getRespCode())) {
                    log.error("\u8c03\u7528\u6d41\u7a0b\u6d41\u8f6c\u4ed8\u6b3e\u5355\u72b6\u6001\u4e3a\u4ed8\u6b3e\u72b6\u6001\u5931\u8d25\uff01");
                }
            }
        } else if (fscOrderPo.getOrderState().equals(FscConstants.FscPayOrderState.PUSH_FAIL)) {
            FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            flowAtomReqBO.setOrderId(fscOrderPo.getFscOrderId());
            flowAtomReqBO.setCurStatus(fscOrderPo.getOrderState());
            flowAtomReqBO.setBusiName(BUSI_NAME_MAIN);
            flowAtomReqBO.setBusiCode(BUSI_CODE_MAIN);
            FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
            if (!"0000".equals(flowAtomRspBO.getRespCode())) {
                log.error("\u8c03\u7528\u6d41\u7a0b\u6d41\u8f6c\u4ed8\u6b3e\u5355\u72b6\u6001\u4e3a\u4ed8\u6b3e\u72b6\u6001\u5931\u8d25\uff01");
            }
        }
        return (FscPushYcPayBillBusiRspBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)rspBO), FscPushYcPayBillBusiRspBO.class));
    }

    private FscPushYcPayBillBusiRspBO dealPayBill(FscOrderPO fscOrderPo) {
        FscOrderStatusFlowAtomReqBO flowAtomReqBO;
        FscPushYcPayBillReqBO payBillReqBO = new FscPushYcPayBillReqBO();
        UmcEnterpriseOrgQryDetailAbilityReqBO umcEnterpriseOrgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
        umcEnterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(fscOrderPo.getPayeeId());
        UmcEnterpriseOrgQryDetailAbilityRspBO umcEnterpriseOrgQryDetailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(umcEnterpriseOrgQryDetailAbilityReqBO);
        if (!umcEnterpriseOrgQryDetailAbilityRspBO.getRespCode().equals("0000") || ObjectUtils.isEmpty((Object)umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO())) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u76f8\u5173\u4fe1\u606f\uff01");
        }
        FscPurchasePaymentBO purchasePaymentBO = new FscPurchasePaymentBO();
        purchasePaymentBO.setORG_ID(this.operationOrgId);
        purchasePaymentBO.setORG_NAME(this.operationOrgName);
        purchasePaymentBO.setDEPT_ID(fscOrderPo.getYcDeptId());
        purchasePaymentBO.setDEPT_NAME(fscOrderPo.getYcDeptName());
        purchasePaymentBO.setPERSON_ID(fscOrderPo.getYcUserId());
        purchasePaymentBO.setPERSON_NAME(fscOrderPo.getYcUserName());
        purchasePaymentBO.setPAYMENT_NUMBER(fscOrderPo.getOrderNo());
        purchasePaymentBO.setPAYMENT_NAME("");
        FscDicDictionaryExernalPO eternalPo = new FscDicDictionaryExernalPO();
        eternalPo.setPCode("FSC_PREPAY_TYPE");
        Map<String, String> dicMap = this.getDicMap(eternalPo);
        purchasePaymentBO.setCONTRACT_NUMBER(fscOrderPo.getContractNo());
        purchasePaymentBO.setBRAND("");
        purchasePaymentBO.setACTUAL_PAYEE_NUMBER(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode());
        purchasePaymentBO.setACTUAL_PAYEE_NAME(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgName());
        purchasePaymentBO.setPAYMENT_DATE(DateFormatUtils.format((Date)fscOrderPo.getCreateTime(), (String)"yyyy-MM-dd"));
        purchasePaymentBO.setCOMMENTS("");
        purchasePaymentBO.setTAX_RATE(null);
        purchasePaymentBO.setTESCO_ID(fscOrderPo.getFscOrderId());
        purchasePaymentBO.setPAYMENT_AMT(fscOrderPo.getTotalCharge());
        LinkedList<FscPurchasePaymentSettleBO> settleBOList = new LinkedList<FscPurchasePaymentSettleBO>();
        LinkedList<Long> fscOrderIds = new LinkedList<Long>();
        List relationList = this.fscOrderMapper.getPayOrderShouldPayFscOrder(Collections.singletonList(fscOrderPo.getFscOrderId()));
        HashMap<Long, FscOrderPayRelationPO> payAmountMap = new HashMap<Long, FscOrderPayRelationPO>(relationList.size());
        for (FscOrderPayRelationPO relationPo : relationList) {
            fscOrderIds.add(relationPo.getFscOrderId());
            payAmountMap.put(relationPo.getFscOrderId(), relationPo);
        }
        FscOrderPO queryPo = new FscOrderPO();
        queryPo.setFscOrderIds(fscOrderIds);
        List fscOrderPoList = this.fscOrderMapper.getList(queryPo);
        if (CollectionUtils.isEmpty((Collection)fscOrderPoList)) {
            fscOrderPoList = this.fscOrderMapper.selectSettleInfoByInspectionIds(fscOrderIds, fscOrderPo.getPayeeId());
        }
        for (FscOrderPO fscOrder : fscOrderPoList) {
            FscOrderPayRelationPO payRelation;
            if (fscOrder.getOrderSource() != null && purchasePaymentBO.getPAYMENT_TYPE() == null) {
                purchasePaymentBO.setPAYMENT_TYPE(dicMap.get(fscOrder.getOrderSource().toString()));
            }
            if ((payRelation = (FscOrderPayRelationPO)payAmountMap.get(fscOrder.getFscOrderId())) == null) {
                payRelation = (FscOrderPayRelationPO)payAmountMap.get(fscOrder.getAcceptOrderId());
            }
            FscPurchasePaymentSettleBO settleBO = new FscPurchasePaymentSettleBO();
            settleBO.setPC_SETTLE_NUMBER(fscOrder.getOrderNo());
            settleBO.setPC_SETTLE_NAME("");
            settleBO.setSETTLE_AMT(this.dealAmount(fscOrder.getTotalCharge()));
            settleBO.setPAYMENT_AMT(this.dealAmount(payRelation.getPayingAmount()));
            settleBO.setREM_PAYMENT_AMT(this.dealAmount(fscOrder.getTotalCharge().subtract(fscOrder.getPaidAmount() == null ? BigDecimal.ZERO : fscOrder.getPaidAmount()).subtract(settleBO.getPAYMENT_AMT())));
            settleBO.setTESCO_ID(fscOrder.getFscOrderId());
            settleBOList.add(settleBO);
        }
        ArrayList<FscPurchasePaymentLineBO> paymentLineBOList = new ArrayList<FscPurchasePaymentLineBO>();
        FscPurchasePaymentLineBO paymentLineBO = new FscPurchasePaymentLineBO();
        paymentLineBO.setPAYMENT_MODE(fscOrderPo.getPayMethod());
        paymentLineBO.setPAYEE_ID(Long.valueOf(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode()));
        paymentLineBO.setPAYEE_NAME(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgName());
        paymentLineBO.setBANK_ACCOUNT_ID(null);
        paymentLineBO.setBANK_ACCOUNT_NAME(fscOrderPo.getPayeeAccountName());
        paymentLineBO.setBANK_ACCOUNT_NUM(Long.valueOf(fscOrderPo.getPayeeBankAccount()));
        paymentLineBO.setBANK_NAME(fscOrderPo.getPayeeBankName());
        paymentLineBO.setPAYMENT_AMT(this.dealAmount(fscOrderPo.getTotalCharge()));
        paymentLineBO.setTESCO_ID(fscOrderPo.getFscOrderId());
        paymentLineBOList.add(paymentLineBO);
        payBillReqBO.setPurchasePayment(purchasePaymentBO);
        payBillReqBO.setPurchasePaymentSettlementInfo(paymentLineBOList);
        payBillReqBO.setPurchasePaymentInfo(settleBOList);
        payBillReqBO.setUserId(fscOrderPo.getPayerId());
        FscPushYcPayBillRspBO payBillRspBO = this.fscPushYcPayBillService.pushYcPayBill(payBillReqBO);
        if (!payBillRspBO.getRespCode().equals("0000")) {
            this.saveFailLog(fscOrderPo.getFscOrderId(), payBillRspBO.getRespDesc());
            if (!fscOrderPo.getOrderState().equals(FscConstants.FscPayOrderState.PUSH_FAIL)) {
                flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
                flowAtomReqBO.setOrderId(fscOrderPo.getFscOrderId());
                flowAtomReqBO.setCurStatus(fscOrderPo.getOrderState());
                flowAtomReqBO.setBusiName(BUSI_NAME);
                flowAtomReqBO.setBusiCode(BUSI_CODE);
                HashMap<String, Integer> paramMap = new HashMap<String, Integer>(1);
                paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag5);
                flowAtomReqBO.setParamMap(paramMap);
                FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
                if (!"0000".equals(flowAtomRspBO.getRespCode())) {
                    log.error("\u8c03\u7528\u6d41\u7a0b\u6d41\u8f6c\u4ed8\u6b3e\u5355\u72b6\u6001\u4e3a\u4ed8\u6b3e\u72b6\u6001\u5931\u8d25\uff01");
                }
            }
        } else if (fscOrderPo.getOrderState().equals(FscConstants.FscPayOrderState.PUSH_FAIL)) {
            flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            flowAtomReqBO.setOrderId(fscOrderPo.getFscOrderId());
            flowAtomReqBO.setCurStatus(fscOrderPo.getOrderState());
            flowAtomReqBO.setBusiName(BUSI_NAME_MAIN);
            flowAtomReqBO.setBusiCode(BUSI_CODE_MAIN);
            FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
            if (!"0000".equals(flowAtomRspBO.getRespCode())) {
                log.error("\u8c03\u7528\u6d41\u7a0b\u6d41\u8f6c\u4ed8\u6b3e\u5355\u72b6\u6001\u4e3a\u4ed8\u6b3e\u72b6\u6001\u5931\u8d25\uff01");
            }
        }
        return (FscPushYcPayBillBusiRspBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)payBillRspBO), FscPushYcPayBillBusiRspBO.class));
    }

    private Map<String, String> getDicMap(FscDicDictionaryExernalPO eternalPo) {
        List listByCondition = this.fscDicDictionaryExernalMapper.getListByCondition(eternalPo);
        if (CollectionUtils.isEmpty((Collection)listByCondition)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u7c7b\u578b\u5b57\u5178\uff01");
        }
        return listByCondition.stream().collect(Collectors.toMap(FscDicDictionaryExernalPO::getCode, FscDicDictionaryExernalPO::getExernalCode));
    }

    public void saveFailLog(Long fscOrderId, String failReason) {
        FscOrderPO orderPo = new FscOrderPO();
        orderPo.setFscOrderId(fscOrderId);
        orderPo.setOrderState(FscConstants.FscPayOrderState.PUSH_FAIL);
        orderPo.setFailReason(failReason);
        this.fscOrderMapper.updateById(orderPo);
    }

    public BigDecimal dealAmount(BigDecimal amount) {
        return amount == null ? BigDecimal.ZERO : amount.setScale(2, RoundingMode.DOWN);
    }
}

