/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscAccountCreditInfoListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountCreditInfoListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountCreditInfoListQueryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscAccountCreditInfoListRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.MerchantPayRule;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountCreditPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountCreditInfoListQueryAbilityService"})
public class FscAccountCreditInfoListQueryAbilityServiceImpl
implements FscAccountCreditInfoListQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscAccountCreditInfoListQueryAbilityServiceImpl.class);
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryAccountCreditInfoList"})
    public FscAccountCreditInfoListQueryAbilityRspBO qryAccountCreditInfoList(@RequestBody FscAccountCreditInfoListQueryAbilityReqBO reqBO) {
        this.val(reqBO);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List payObjIds = this.fscMerchantMapper.selectByPayObjId(reqBO.getPayObjId());
        FscAccountCreditPO fscAccountCredit = new FscAccountCreditPO();
        UmcEnterpriseOrgQryDetailAbilityReqBO enterpriseOrgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
        enterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(reqBO.getPayObjId());
        UmcEnterpriseOrgQryDetailAbilityRspBO umcEnterpriseOrgQryDetailAbilityRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(enterpriseOrgQryDetailAbilityReqBO);
        if (umcEnterpriseOrgQryDetailAbilityRspBO.getRespCode().equals("0000") && umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO() != null) {
            if (umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getIsProfessionalOrg().equals("1")) {
                fscAccountCredit.setMerchantCategory(Integer.valueOf(0));
            } else if (umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getIsProfessionalOrg().equals("0")) {
                fscAccountCredit.setMerchantCategory(Integer.valueOf(2));
            }
        }
        fscAccountCredit.setPayObjId(reqBO.getPayObjId());
        fscAccountCredit.setOrgId(reqBO.getCreditOrgId());
        fscAccountCredit.setCreateTimeStart(reqBO.getBeginTime());
        fscAccountCredit.setCreateTimeEnd(reqBO.getEndTime());
        List fscAccountCreditPos = this.fscMerchantMapper.selectCreditInfoPage(fscAccountCredit, page);
        String jsonString = JSON.toJSONString((Object)fscAccountCreditPos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        List rows = JSON.parseArray((String)jsonString, FscAccountCreditInfoListRspBO.class);
        Map payNodeRuleMap = this.fscDictionaryBusiService.queryBypCodeBackMap("MERCHANT_NODE_RULE");
        Map payBusiSceneMap = this.fscDictionaryBusiService.queryBypCodeBackMap("MERCHANT_BUSI_SCENE");
        for (FscAccountCreditInfoListRspBO row : rows) {
            if (row.getExceptionFlag().equals(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION) || !StringUtils.isEmpty((Object)row.getPayBusiness())) {
                row.setPayBusiSceneRange(row.getPayBusiness());
            }
            if (row.getPayType().equals(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE)) {
                row.setPayCreditAmount(row.getOverdraft());
                row.setPayBusiSceneRange("1");
            }
            if (null != row.getPayRule()) {
                row.setPayRuleStr(MerchantPayRule.getInstance((Integer)row.getPayRule()).getDescr());
                if (null != row.getPayNodeRule()) {
                    row.setPayNodeRuleStr((String)payNodeRuleMap.get(row.getPayNodeRule().toString()));
                }
            }
            row.setPayBusiSceneRangeStr((String)payBusiSceneMap.get(row.getPayBusiSceneRange()));
            BigDecimal payBreakScale = row.getPayBreakScale();
            if (null != payBreakScale) {
                StringBuilder sb = new StringBuilder();
                sb.append("\u9a8c\u6536\u5355\u91d1\u989d * ").append(payBreakScale.setScale(2, 4).toString()).append("% * \u903e\u671f\u5929\u6570");
                row.setCalculationFormula(sb.toString());
            }
            row.setCreditDate(row.getCreateTime());
        }
        FscAccountCreditInfoListQueryAbilityRspBO rspBO = new FscAccountCreditInfoListQueryAbilityRspBO();
        rspBO.setRows(rows);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        return rspBO;
    }

    private void val(FscAccountCreditInfoListQueryAbilityReqBO reqBO) {
        if (null == reqBO.getPayObjId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[payObjId]\u4e3a\u7a7a");
        }
    }
}

