/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.common.ability.api.FscMerchantCreateAbilityService;
import com.tydic.fsc.common.ability.bo.FscMerchantCreateAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscMerchantCreateAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscMerchantCreateBusiService;
import com.tydic.fsc.common.busi.api.FscMerchantSubmitBusiService;
import com.tydic.fsc.common.busi.bo.FscMerchantCreateBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscMerchantCreateBusiRspBo;
import com.tydic.fsc.common.busi.bo.FscMerchantSubmitBusiServiceReqBO;
import com.tydic.fsc.common.busi.bo.FscMerchantSubmitBusiServiceRspBO;
import com.tydic.fsc.constants.FscConstants;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscMerchantCreateAbilityService"})
public class FscMerchantCreateAbilityServiceImpl
implements FscMerchantCreateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantCreateAbilityServiceImpl.class);
    @Autowired
    private FscMerchantCreateBusiService fscMerchantCreateBusiService;
    @Autowired
    private FscMerchantSubmitBusiService fscMerchantSubmitBusiService;
    private static final Integer merchantType = 1;

    @PostMapping(value={"dealCreate"})
    public FscMerchantCreateAbilityRspBO dealCreate(@RequestBody FscMerchantCreateAbilityReqBO reqBo) {
        if (log.isDebugEnabled()) {
            log.debug("===\u7ed3\u7b97\u5546\u6237\u521b\u5efa\u5f00\u59cb\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        }
        FscMerchantCreateAbilityRspBO retBo = new FscMerchantCreateAbilityRspBO();
        String validateStr = this.validateReqArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            retBo.setRespCode("191000");
            retBo.setRespDesc(validateStr);
            return retBo;
        }
        FscMerchantCreateBusiReqBO busiReqBo = new FscMerchantCreateBusiReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)((Object)busiReqBo));
        FscMerchantCreateBusiRspBo busiRetBo = this.fscMerchantCreateBusiService.dealCreate(busiReqBo);
        BeanUtils.copyProperties((Object)((Object)busiRetBo), (Object)retBo);
        if (!"0000".equals(busiRetBo.getRespCode()) || FscConstants.MerchanCreateDealType.SAVE.equals(reqBo.getDealType())) {
            if (log.isDebugEnabled()) {
                log.debug("===\u7ed3\u7b97\u5546\u6237\u64cd\u4f5c\u7ed3\u675f\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
            }
            return retBo;
        }
        FscMerchantSubmitBusiServiceReqBO submitBusiReqBo = new FscMerchantSubmitBusiServiceReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)((Object)submitBusiReqBo));
        submitBusiReqBo.setMerchantId(busiRetBo.getMerchantId());
        FscMerchantSubmitBusiServiceRspBO submitBusiRetBo = this.fscMerchantSubmitBusiService.submitMerchant(submitBusiReqBo);
        if (!"0000".equals(submitBusiRetBo.getRespCode())) {
            BeanUtils.copyProperties((Object)((Object)submitBusiRetBo), (Object)retBo);
            log.error("\u63d0\u4ea4\u5546\u6237\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)submitBusiRetBo.getRespDesc());
        }
        if (log.isDebugEnabled()) {
            log.debug("===\u7ed3\u7b97\u5546\u6237\u521b\u5efa\u7ed3\u675f\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
        }
        return retBo;
    }

    private String validateReqArgs(FscMerchantCreateAbilityReqBO reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getName())) {
            return "\u7528\u6237\u540d\u79f0[name]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getUserId())) {
            return "\u7528\u6237ID[userId]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getDealType()) {
            return "\u5904\u7406\u7c7b\u578b[dealType]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getOrgId()) {
            return "\u673a\u6784ID[orgId]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrgName())) {
            return "\u673a\u6784\u540d\u79f0[orgName]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getExceptionFlag() || FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION.equals(reqBo.getExceptionFlag())) {
            reqBo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
            return this.validateMerchantArgs(reqBo);
        }
        if (FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION.equals(reqBo.getExceptionFlag())) {
            return this.validateException(reqBo);
        }
        return "\u662f\u5426\u4f8b\u5916\u914d\u7f6e[exceptionFlag]\uff0c\u4f20\u503c\u975e\u6cd5";
    }

    private String validateException(FscMerchantCreateAbilityReqBO reqBo) {
        if (null == reqBo.getParentId()) {
            return "\u7236\u8282\u70b9[parentId]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getExceptionUserLatitude()) {
            return "\u4f8b\u5916\u7528\u6237\u7ef4\u5ea6[exceptionUserLatitude]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getExceptionCategory()) {
            return "\u4f8b\u5916\u914d\u7f6e\u7c7b\u522b[exceptionCategory]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_PAY.equals(reqBo.getExceptionCategory())) {
            if (null == reqBo.getPayObjId() || StringUtils.isEmpty((Object)reqBo.getPayObjName())) {
                return "\u652f\u4ed8\u4f8b\u5916\u914d\u7f6e\u65f6\uff0c[payObjId]\u548c[payObjName]\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (null == reqBo.getPayBusiSceneRange()) {
                return "\u4e1a\u52a1\u573a\u666f\u8303\u56f4[payBusiSceneRange]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (FscConstants.MerchantExceptionLatitude.BY_TYPE.equals(reqBo.getExceptionUserLatitude())) {
                reqBo.setPayUserIdentity(Integer.valueOf(reqBo.getPayObjId().intValue()));
            }
            return this.validatePayTypePeriod(reqBo);
        }
        if (FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_MODEL.equals(reqBo.getExceptionCategory())) {
            if (StringUtils.isEmpty((Object)reqBo.getModelObjId())) {
                return "\u6a21\u5f0f\u5bf9\u8c61ID[modelObjId]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (StringUtils.isEmpty((Object)reqBo.getModelObjName())) {
                return "\u6a21\u5f0f\u914d\u7f6e\u5bf9\u8c61\u540d\u79f0[modelObjName]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (FscConstants.MerchantExceptionLatitude.BY_TYPE.equals(reqBo.getExceptionUserLatitude())) {
                reqBo.setModelUserIdentity(Integer.valueOf(reqBo.getModelObjId().intValue()));
            }
            if (null == reqBo.getModelSceneRange()) {
                return "\u6a21\u5f0f\u9002\u7528\u8303\u56f4[modelSceneRange]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (FscConstants.MerchantModelSceneRange.CONTRACT.equals(reqBo.getModelSceneRange())) {
                if (StringUtils.isEmpty((Object)reqBo.getModelContractNo())) {
                    return "\u7b7e\u7ea6\u7533\u8bf7\u7f16\u53f7[modelContractNo]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (null == reqBo.getModelContractId()) {
                    return "\u7b7e\u7ea6\u7533\u8bf7ID[modelContractId]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (StringUtils.isEmpty((Object)reqBo.getModelContractName())) {
                    return "\u7b7e\u7ea6\u7533\u8bf7\u540d\u79f0[modelContractName]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
                }
            } else if (CollectionUtils.isEmpty((Collection)reqBo.getCategoryTrees())) {
                return "\u5546\u54c1\u7c7b\u578b[categoryTrees]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (null == reqBo.getModelSettle()) {
                return "\u7ed3\u7b97\u6a21\u5f0f\u914d\u7f6e-\u7ed3\u7b97\u6a21\u5f0f[modelSettle]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
        }
        return null;
    }

    private String validateMerchantArgs(FscMerchantCreateAbilityReqBO reqBo) {
        if (null == reqBo.getMerchantType()) {
            return "\u5546\u6237\u7c7b\u578b[merchantType]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getMerchantCategory()) {
            return "\u5546\u6237\u7c7b\u522b[merchantCategory]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getContactName())) {
            return "\u8054\u7cfb\u4eba\u540d\u79f0[contactName]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getContactPhone())) {
            return "\u8054\u7cfb\u7535\u8bdd[contactPhone]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getContactPhoneBak())) {
            return "\u5907\u7528\u8054\u7cfb\u7535\u8bdd[contactPhoneBak],\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!StringUtils.isEmpty((Object)reqBo.getPayBusiSceneRange())) {
            if (null == reqBo.getPayUserIdentity()) {
                return "\u652f\u4ed8\u914d\u7f6e\u9002\u7528\u5e73\u53f0\u8eab\u4efd[payUserIdentity]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (null == reqBo.getPayAllowExceptionFlag()) {
                return "\u652f\u4ed8\u914d\u7f6e\u662f\u5426\u5141\u8bb8\u4f8b\u5916[payAllowExceptionFlag]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            return this.validatePayTypePeriod(reqBo);
        }
        if (null != reqBo.getModelSceneRange()) {
            if (null == reqBo.getModelUserIdentity()) {
                return "\u7ed3\u7b97\u6a21\u5f0f\u914d\u7f6e-\u9002\u7528\u5e73\u53f0\u8eab\u4efd[modelUserIdentity]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (null == reqBo.getModelAllowExceptionFlag()) {
                return "\u7ed3\u7b97\u6a21\u5f0f\u914d\u7f6e-\u662f\u5426\u5141\u8bb8\u4f8b\u5916[modelAllowExceptionFlag]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (null == reqBo.getModelSettle()) {
                return "\u7ed3\u7b97\u6a21\u5f0f\u914d\u7f6e-\u7ed3\u7b97\u6a21\u5f0f[modelSettle]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
        }
        return null;
    }

    private String validatePayTypePeriod(FscMerchantCreateAbilityReqBO reqBo) {
        if (null == reqBo.getPayType() && !reqBo.getMerchantType().equals(merchantType) && !"2".equals(reqBo.getPayBusiSceneRange())) {
            return "\u652f\u4ed8\u914d\u7f6e\u4ed8\u6b3e\u65b9\u5f0f[payType]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(reqBo.getPayType())) {
            if (null == reqBo.getPayCreditAmount() && !reqBo.getMerchantType().equals(merchantType)) {
                return "\u6388\u4fe1\u989d\u5ea6[payCreditAmount]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (null == reqBo.getPayBreakScale() && !reqBo.getMerchantType().equals(merchantType)) {
                return "\u8fdd\u7ea6\u91d1\u989d\u6bd4\u4f8b[payBreakScale]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (null == reqBo.getPayRule() && !reqBo.getMerchantType().equals(merchantType) && !"2".equals(reqBo.getPayBusiSceneRange())) {
                return "\u8d26\u671f\u652f\u4ed8\u7ed3\u7b97\u89c4\u5219[payRule]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(reqBo.getPayRule())) {
                if (null == reqBo.getPayAccountDay()) {
                    return "\u6307\u5b9a\u8d26\u671f\u65e5[payAccountDay]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (null == reqBo.getPayAccountDayRule()) {
                    return "\u8d26\u671f\u65e5\u7ed3\u7b97\u8ba2\u5355\u89c4\u5219[payAccountDayRule]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
                }
            } else if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(reqBo.getPayRule())) {
                if (null == reqBo.getPayNodeAccountDays() && !"2".equals(reqBo.getPayBusiSceneRange())) {
                    return "\u8d26\u671f\u5929\u6570[payNodeAccountDays]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
                }
                if (null == reqBo.getPayNodeRule() && !"2".equals(reqBo.getPayBusiSceneRange())) {
                    return "\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9[payNodeRule]\uff0c\u4e0d\u80fd\u4e3a\u7a7a";
                }
            }
        }
        return null;
    }
}

