/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bo.FscMerchantPayeeBO;
import com.tydic.fsc.busibase.atom.api.FscMerchantPayeeCreateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscMerchantPayeeCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscMerchantPayeeCreateAtomRspBO;
import com.tydic.fsc.common.ability.api.FscMerchantPayeeCreateAbilityService;
import com.tydic.fsc.common.ability.bo.FscMerchantPayeeCreateAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscMerchantPayeeCreateAbilityRspBO;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscMerchantPayeeCreateAbilityService"})
public class FscMerchantPayeeCreateAbilityServiceImpl
implements FscMerchantPayeeCreateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantPayeeCreateAbilityServiceImpl.class);
    @Autowired
    private FscMerchantPayeeCreateAtomService fscMerchantPayeeCreateAtomService;

    @PostMapping(value={"createPayee"})
    public FscMerchantPayeeCreateAbilityRspBO createPayee(@RequestBody FscMerchantPayeeCreateAbilityReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("===\u7ed3\u7b97\u6536\u6b3e\u8d26\u6237\u7f16\u8f91\u670d\u52a1\u5f00\u59cb\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        }
        FscMerchantPayeeCreateAbilityRspBO rspBo = new FscMerchantPayeeCreateAbilityRspBO();
        String validateStr = this.validateArgs(reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            rspBo.setRespCode("191000");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return rspBo;
        }
        FscMerchantPayeeCreateAtomReqBO atomReqBo = (FscMerchantPayeeCreateAtomReqBO)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscMerchantPayeeCreateAtomReqBO.class);
        FscMerchantPayeeCreateAtomRspBO atomRspBO = this.fscMerchantPayeeCreateAtomService.createPayee(atomReqBo);
        rspBo = (FscMerchantPayeeCreateAbilityRspBO)JSON.parseObject((String)JSONObject.toJSONString((Object)atomRspBO), FscMerchantPayeeCreateAbilityRspBO.class);
        if (log.isDebugEnabled()) {
            log.debug("===\u7ed3\u7b97\u6536\u6b3e\u8d26\u6237\u7f16\u8f91\u670d\u52a1\u7ed3\u675f\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)rspBo));
        }
        return rspBo;
    }

    private String validateArgs(FscMerchantPayeeCreateAbilityReqBO reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getCreatePayeeBOS())) {
            return "\u5165\u53c2[createPayeeBOS]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        for (FscMerchantPayeeBO payeeBO : reqBo.getCreatePayeeBOS()) {
            if (payeeBO.getMerchantId() == null) {
                return "\u5165\u53c2[merchantId]\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (payeeBO.getPayeeAccountName() == null) {
                return "\u5165\u53c2[payeeAccountName]\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (payeeBO.getPayeeBankAccount() == null) {
                return "\u5165\u53c2[payeeBankAccount]\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (payeeBO.getPayeeBankName() != null) continue;
            return "\u5165\u53c2[payeeBankName]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

