/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.common.busi.api.FscAccountRegulationApprovalBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountRegulationApprovalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountRegulationApprovalBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountRegulationMapper;
import com.tydic.fsc.enums.FscRegulationStatusEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountRegulationPO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.bo.common.UacNoneInstanceBO;
import com.tydic.uac.constant.UacCommConstant;
import java.util.Date;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscAccountRegulationApprovalBusiServiceImpl
implements FscAccountRegulationApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscAccountRegulationApprovalBusiServiceImpl.class);
    private FscAccountRegulationMapper fscAccountRegulationMapper;
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    public static final String PASS = "0";

    @Override
    public FscAccountRegulationApprovalBusiRspBO dealRegulationApproval(FscAccountRegulationApprovalBusiReqBO reqBO) {
        this.valid(reqBO);
        FscAccountRegulationPO fscAccountRegulationPo = new FscAccountRegulationPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)fscAccountRegulationPo);
        UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO = this.dealApprovalResult(reqBO);
        UacNoneInstanceBO noneInstanceBO = uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO();
        String auditResult = noneInstanceBO.getAuditResult();
        Boolean finish = noneInstanceBO.getFinish();
        if (finish.booleanValue()) {
            if (PASS.equals(auditResult)) {
                fscAccountRegulationPo.setStatus(FscRegulationStatusEnum.APPROVED.getCode());
            } else {
                fscAccountRegulationPo.setStatus(FscRegulationStatusEnum.NOT_APPROVED.getCode());
            }
            fscAccountRegulationPo.setAuditTime(new Date());
            fscAccountRegulationPo.setAuditUserId(reqBO.getUserId());
            fscAccountRegulationPo.setAuditUserName(reqBO.getName());
            this.fscAccountRegulationMapper.update(fscAccountRegulationPo);
        }
        FscAccountRegulationApprovalBusiRspBO rspBO = new FscAccountRegulationApprovalBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setFinish(finish);
        return rspBO;
    }

    private UacNoTaskAuditOrderAuditRspBO dealApprovalResult(FscAccountRegulationApprovalBusiReqBO reqBO) {
        String stepId = this.fscAccountRegulationMapper.selectStepId(reqBO.getRegulationId(), FscConstants.AuditObjType.ACCOUNT_REGULATION_APPROVAL, UacCommConstant.STATUS.UNDER_REVIEW);
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        auditReqBO.setObjId(Stream.of(reqBO.getRegulationId()).collect(Collectors.toList()));
        auditReqBO.setStepId(stepId);
        auditReqBO.setAuditResult(reqBO.getAuditResult());
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setUsername(reqBO.getName());
        auditReqBO.setObjType(FscConstants.AuditObjType.ACCOUNT_REGULATION_APPROVAL);
        auditReqBO.setOperDept(reqBO.getOrgName());
        if (StringUtils.hasText((String)reqBO.getAuditMsg())) {
            auditReqBO.setAuditAdvice(reqBO.getAuditMsg());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u8d26\u5ba1\u6279\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditReqBO));
        }
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u8d26\u5ba1\u6279\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditRspBO));
        }
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new FscBusinessException("193108", auditRspBO.getRespDesc());
        }
        return auditRspBO;
    }

    public void valid(FscAccountRegulationApprovalBusiReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getRegulationId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u8c03\u8d26\u5355id[regulationId]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((Object)reqBO.getAuditResult())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5ba1\u6838\u7ed3\u679c[auditResult]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((Object)reqBO.getAuditMsg())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5ba1\u6279\u610f\u89c1[auditMsg]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }

    @Autowired
    public void setFscAccountRegulationMapper(FscAccountRegulationMapper fscAccountRegulationMapper) {
        this.fscAccountRegulationMapper = fscAccountRegulationMapper;
    }

    @Autowired
    public void setUacNoTaskAuditOrderAuditAbilityService(UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService) {
        this.uacNoTaskAuditOrderAuditAbilityService = uacNoTaskAuditOrderAuditAbilityService;
    }
}

