/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimBillBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimBillLineBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimBillReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushYcRecvClaimBillRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscPushYcRecvClaimBillService;
import com.tydic.fsc.common.busi.api.FscPushYcRecvClaimBillBusiService;
import com.tydic.fsc.common.busi.bo.FscPushYcRecvClaimBillBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPushYcRecvClaimBillBusiRspBO;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscRecvClaimMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscRecvClaimPO;
import com.tydic.fsc.util.DateUtil;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPushYcRecvClaimBillBusiServiceImpl
implements FscPushYcRecvClaimBillBusiService {
    @Autowired
    private FscPushYcRecvClaimBillService fscPushYcRecvClaimBillService;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscRecvClaimMapper fscRecvClaimMapper;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Value(value="${OPER_ORG_ID}")
    private String operationOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operationOrgName;

    @Override
    @Transactional(isolation=Isolation.READ_UNCOMMITTED)
    public FscPushYcRecvClaimBillBusiRspBO pushYcRecvClaim(FscPushYcRecvClaimBillBusiReqBO reqBO) {
        FscRecvClaimPO fscRecvClaimPo = this.fscRecvClaimMapper.queryById(reqBO.getClaimId());
        if (fscRecvClaimPo == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u76f8\u5173\u8ba4\u9886\u5355\u4fe1\u606f\uff01" + reqBO.getClaimId());
        }
        List claimDetailList = this.fscClaimDetailMapper.selectClaimInfoList(reqBO.getClaimId());
        if (CollectionUtils.isEmpty((Collection)claimDetailList)) {
            throw new FscBusinessException("190000", "\u8ba4\u9886\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscPushYcRecvClaimBillBusiRspBO rspBO = new FscPushYcRecvClaimBillBusiRspBO();
        FscPushYcRecvClaimBillReqBO pushReqBo = new FscPushYcRecvClaimBillReqBO();
        FscPushYcRecvClaimBillBO claimBillBO = new FscPushYcRecvClaimBillBO();
        claimBillBO.setORG_ID(this.operationOrgId);
        claimBillBO.setORG_NAME(this.operationOrgName);
        claimBillBO.setCHARGEMAN_ID(fscRecvClaimPo.getHandleUserId().toString());
        claimBillBO.setCHARGEMAN_NAME(fscRecvClaimPo.getHandleUserName());
        claimBillBO.setDEPT_ID(fscRecvClaimPo.getHandleDeptId().toString());
        claimBillBO.setDEPT_NAME(fscRecvClaimPo.getHandleDeptName());
        claimBillBO.setRECEIVABLE_CLAIM_NUMBER(fscRecvClaimPo.getClaimNo());
        claimBillBO.setBANK_SERIAL_NUMBER(fscRecvClaimPo.getSerialNumber());
        FscDicDictionaryExernalPO eternalPo = new FscDicDictionaryExernalPO();
        eternalPo.setPCode("RECEIVABLES_CLAIM_TYPE");
        Map<String, String> dicMap = this.getDicMap(eternalPo);
        claimBillBO.setRECEIVABLE_CLAIM_TYPE(dicMap.get(fscRecvClaimPo.getRecvType()));
        claimBillBO.setCUSTOMER_ID(fscRecvClaimPo.getCustomerNo().toString());
        claimBillBO.setCUSTOMER_NAME(fscRecvClaimPo.getCustomerName());
        claimBillBO.setCUSTOMER_SITE_ID(null);
        claimBillBO.setCUSTOMER_SITE_NAME(null);
        claimBillBO.setSUB_ACCOUNT(fscRecvClaimPo.getChildAccount());
        claimBillBO.setRECEIVABLE_AMT(fscRecvClaimPo.getRecvAmt().toString());
        claimBillBO.setRECEIVE_BANK_ID(fscRecvClaimPo.getBankId());
        claimBillBO.setRECEIVE_BANK(fscRecvClaimPo.getBankName());
        claimBillBO.setSUB_BRANCH(fscRecvClaimPo.getAccountBranch());
        claimBillBO.setBANK_ACCOUNT(fscRecvClaimPo.getBankAccount());
        claimBillBO.setRECEIVABLE_DATE(DateUtil.dateToStr((Date)fscRecvClaimPo.getRecvDate()));
        claimBillBO.setCLAIM_STATUS("Y");
        claimBillBO.setREMARKS(fscRecvClaimPo.getRemark());
        claimBillBO.setTESCO_ID(fscRecvClaimPo.getClaimId());
        LinkedList<FscPushYcRecvClaimBillLineBO> claimBillList = new LinkedList<FscPushYcRecvClaimBillLineBO>();
        for (FscClaimDetailPO fscClaimDetailBo : claimDetailList) {
            FscPushYcRecvClaimBillLineBO lineBO = new FscPushYcRecvClaimBillLineBO();
            lineBO.setCHARGEMAN_ID(fscClaimDetailBo.getHandleUserId().toString());
            lineBO.setCHARGEMAN_NAME(fscClaimDetailBo.getHandleUserName());
            lineBO.setDEPT_ID(fscClaimDetailBo.getHandleDeptId().toString());
            lineBO.setDEPT_NAME(fscClaimDetailBo.getHandleDeptName());
            FscDicDictionaryExernalPO eternal = new FscDicDictionaryExernalPO();
            eternal.setPCode("FSC_YC_CLAIM_TYPE");
            Map<String, String> dicMapE = this.getDicMap(eternal);
            lineBO.setCLAIM_TYPE(dicMapE.get(fscClaimDetailBo.getClaimType()));
            if (fscClaimDetailBo.getOrderId() != null) {
                lineBO.setCONTRACT_ID(fscClaimDetailBo.getOrderId().toString());
            }
            lineBO.setCONTRACT_NUMBER(fscClaimDetailBo.getOrderCode());
            if (!StringUtils.isEmpty((Object)fscClaimDetailBo.getFscOrderId())) {
                lineBO.setBILL_ID(fscClaimDetailBo.getFscOrderId().toString());
                lineBO.setBILL_NUMBER(fscClaimDetailBo.getFscOrderNo());
            } else {
                lineBO.setBILL_NUMBER(fscClaimDetailBo.getObjectNo());
            }
            lineBO.setCLAIM_AMT(fscClaimDetailBo.getClaimAmt());
            lineBO.setCLAIM_DATE(DateUtil.dateToStr((Date)fscClaimDetailBo.getClaimDate()));
            lineBO.setCANCEL_CLAIM_DATE(DateUtil.dateToStr((Date)fscClaimDetailBo.getCancelClaimDate()));
            lineBO.setTESCO_ID(fscClaimDetailBo.getClaimDetailId());
            claimBillList.add(lineBO);
        }
        pushReqBo.setReceivable(claimBillBO);
        pushReqBo.setReceivableClaim(claimBillList);
        FscPushYcRecvClaimBillRspBO pushRspBo = this.fscPushYcRecvClaimBillService.pushRecvClaimBill(pushReqBo);
        if (!pushRspBo.getRespCode().equals("0000")) {
            throw new FscBusinessException("190000", pushRspBo.getRespDesc());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Map<String, String> getDicMap(FscDicDictionaryExernalPO eternalPo) {
        List listByCondition = this.fscDicDictionaryExernalMapper.getListByCondition(eternalPo);
        if (CollectionUtils.isEmpty((Collection)listByCondition)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u7c7b\u578b\u5b57\u5178\uff01");
        }
        return listByCondition.stream().collect(Collectors.toMap(FscDicDictionaryExernalPO::getCode, FscDicDictionaryExernalPO::getExernalCode));
    }
}

