/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscAccountDetailQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscAccountDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountDetailQueryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscAccountDetailQueryAbilityService"})
public class FscAccountDetailQueryAbilityServiceImpl
implements FscAccountDetailQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscAccountDetailQueryAbilityServiceImpl.class);
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"queryAccountDetail"})
    public FscAccountDetailQueryAbilityRspBO queryAccountDetail(@RequestBody FscAccountDetailQueryAbilityReqBO reqBO) {
        FscAccountDetailQueryAbilityRspBO rspBO = new FscAccountDetailQueryAbilityRspBO();
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getId() && null == reqBO.getOrgIdWeb()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[id]\u548c[orgIdWeb]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a!");
        }
        FscAccountPO fscAccountPO = new FscAccountPO();
        fscAccountPO.setId(reqBO.getId());
        if (reqBO.getOrgIdWeb() != null) {
            fscAccountPO.setBusiType(FscConstants.FscBusiType.ELECTRONIC.toString());
            fscAccountPO.setOrgId(reqBO.getOrgIdWeb());
        }
        if ((fscAccountPO = this.fscAccountMapper.getModelBy(fscAccountPO)) == null) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        if (fscAccountPO.getRemainAmount().compareTo(BigDecimal.ZERO) < 0) {
            fscAccountPO.setRemainAmount(BigDecimal.ZERO);
        }
        FscAccountDetailQueryAbilityRspBO fscAccountDetailQueryAbilityRspBO = (FscAccountDetailQueryAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)fscAccountPO), FscAccountDetailQueryAbilityRspBO.class);
        Map fscAccountCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("ACCOUNT_CATEGORY");
        Map fscAccountCreateMethodMap = this.fscDictionaryBusiService.queryBypCodeBackMap("ACCOUNT_CREATE_METHOD");
        Map fscAccountStatusMap = this.fscDictionaryBusiService.queryBypCodeBackMap("ACCOUNT_STATUS");
        fscAccountDetailQueryAbilityRspBO.setAccountCategoryStr((String)fscAccountCategoryMap.get(fscAccountPO.getAccountCategory().toString()));
        fscAccountDetailQueryAbilityRspBO.setCreateMethodStr((String)fscAccountCreateMethodMap.get(fscAccountPO.getCreateMethod().toString()));
        fscAccountDetailQueryAbilityRspBO.setStatusStr((String)fscAccountStatusMap.get(fscAccountPO.getStatus().toString()));
        if (fscAccountPO.getAccountCategory() != null && fscAccountPO.getAccountCategory() == 3) {
            fscAccountDetailQueryAbilityRspBO.setOverdraftAmount(fscAccountPO.getOverdraft());
            fscAccountDetailQueryAbilityRspBO.setAvailableOverdraftAmount(fscAccountPO.getOverdraft().subtract(fscAccountPO.getOverdraftAmount()));
        } else if (reqBO.getOrgIdWeb() != null) {
            FscMerchantPO fscMerchantPo = new FscMerchantPO();
            fscMerchantPo.setOrgId(this.operationOrgId);
            fscMerchantPo.setDelFlag(FscConstants.DicDelFlag.NO);
            fscMerchantPo.setPayBusiSceneRangeLike("1");
            fscMerchantPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
            fscMerchantPo = this.fscMerchantMapper.getModelBy(fscMerchantPo);
            if (null != fscMerchantPo) {
                FscMerchantPO merchant = new FscMerchantPO();
                merchant.setPayBusiSceneRangeLike("1");
                merchant.setParentId(fscMerchantPo.getMerchantId());
                merchant.setDelFlag(FscConstants.DicDelFlag.NO);
                merchant.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PRE_STORE);
                merchant.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
                merchant.setPayObjId(reqBO.getOrgIdWeb());
                merchant = this.fscMerchantMapper.getModelBy(merchant);
                if (null != merchant) {
                    BeanUtils.copyProperties((Object)merchant, (Object)fscMerchantPo);
                }
                fscAccountDetailQueryAbilityRspBO.setOverdraftAmount(fscMerchantPo.getOverdraft() == null ? BigDecimal.ZERO : fscMerchantPo.getOverdraft());
                fscAccountDetailQueryAbilityRspBO.setAvailableOverdraftAmount(fscMerchantPo.getOverdraft().subtract(fscAccountPO.getOverdraftAmount()));
            } else {
                fscAccountDetailQueryAbilityRspBO.setOverdraftAmount(BigDecimal.ZERO);
                fscAccountDetailQueryAbilityRspBO.setAvailableOverdraftAmount(BigDecimal.ZERO);
            }
        }
        BigDecimal needReturnAmount = fscAccountDetailQueryAbilityRspBO.getAdvanceAmount().subtract(fscAccountDetailQueryAbilityRspBO.getFreezeAmount()).subtract(fscAccountDetailQueryAbilityRspBO.getUseAmount());
        needReturnAmount = needReturnAmount.compareTo(BigDecimal.ZERO) > 0 ? BigDecimal.ZERO : needReturnAmount.abs();
        fscAccountDetailQueryAbilityRspBO.setNeedRetrunAmount(needReturnAmount);
        log.info("===========fscAccountDetailQueryAbilityRspBO" + fscAccountDetailQueryAbilityRspBO);
        return fscAccountDetailQueryAbilityRspBO;
    }
}

